/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.editor.tools;

import org.eclnt.editor.tools.ProjectInfo;
import org.eclnt.editor.tools.ProjectInfoParser;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.parse.SAXParserUtil;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.ValueManager;
import org.xml.sax.helpers.DefaultHandler;

public class ProjectInfoReader {
    public static ProjectInfo readProjectInfo(String projectDirectory) {
        projectDirectory = ValueManager.encodeIntoValidFileName(projectDirectory, true);
        String key = ProjectInfoReader.class.getName() + "_" + projectDirectory;
        ProjectInfo result = (ProjectInfo)HttpSessionAccess.getCurrentDialogSession().getAttribute(key);
        if (result == null) {
            try {
                result = new ProjectInfo();
                result.setProjectdirectory(projectDirectory);
                String projectFileName = projectDirectory + ".ccproject";
                String xml = FileManager.readUTF8File(projectFileName, true);
                ProjectInfoParser pp = new ProjectInfoParser(result);
                SAXParserUtil.parse(xml, (DefaultHandler)pp);
                HttpSessionAccess.getCurrentDialogSession().setAttribute(ProjectInfoReader.class.getName() + "_" + projectDirectory, result);
            }
            catch (Throwable t) {
                throw new Error("Could not parse project in directory: " + projectDirectory, t);
            }
        }
        return result;
    }
}

