/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.bufferedcontent;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclnt.jsfserver.bufferedcontent.IUploadContent;
import org.eclnt.jsfserver.bufferedcontent.IUploadStreamContent;
import org.eclnt.jsfserver.bufferedcontent.UploadContentParser;
import org.eclnt.jsfserver.util.CCServletBaseWithContextMgmt;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.CLog;
import org.eclnt.util.log.PLog;
import org.eclnt.util.stream.CountingInputStream;
import org.eclnt.util.valuemgmt.ValueManager;

public class UploadContentServlet
extends CCServletBaseWithContextMgmt {
    static long s_observerThreadInterval = 15000L;
    static long s_tempFileTimeout = 120000L;
    TempFileObserverThreadPool m_tempFileObserverThreadPool;

    public UploadContentServlet() {
        try {
            this.m_tempFileObserverThreadPool = new TempFileObserverThreadPool();
            this.m_tempFileObserverThreadPool.start();
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_WAR, "Problem starting TempFileObserverThreadPool, " + t.toString());
        }
    }

    public static void initializeObserverThreadInterval(long value) {
        s_observerThreadInterval = value;
    }

    public static void initializeTempFileTimeout(long value) {
        s_tempFileTimeout = value;
    }

    public static void clear(HttpSession session) {
        String sessionId = null;
        try {
            sessionId = session.getId();
            String filePath = HttpSessionAccess.getServletTempDirectory() + "/ccupploadcontent/" + sessionId + "/";
            boolean exists = FileManager.checkIfFileExists(filePath);
            if (!exists) {
                return;
            }
            FileManager.deleteDirectoryContent(filePath);
            FileManager.deleteFile(filePath);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem removing upload file content for session: " + session, t);
        }
    }

    @Override
    protected boolean checkIfToAbortOnMissingHttpSession(HttpServletRequest req) {
        return true;
    }

    @Override
    protected void processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block25: {
            HttpSession session = null;
            long requestStartTime = System.currentTimeMillis();
            long requestContentSize = -1L;
            String currentTempFileName = null;
            String currentTempFileNameFinished = null;
            try {
                Serializable uploadContent;
                Object upload;
                session = req.getSession(false);
                String contentId = req.getRequestURI();
                int index = contentId.indexOf(".ccupload");
                if (index <= 0) break block25;
                contentId = contentId.substring(0, index);
                index = contentId.lastIndexOf(47);
                contentId = contentId.substring(index + 1);
                contentId = "uploadContent_" + contentId;
                int sliceIndex = contentId.indexOf("_slice_");
                if (sliceIndex >= 0) {
                    String contentAccessId = contentId.substring(0, sliceIndex);
                    Object upload2 = session.getAttribute(contentAccessId);
                    if (upload2 == null) {
                        throw new Error("No one is waiting for upload content with id: " + contentAccessId);
                    }
                    String s = req.getParameter("SLICE");
                    CLog.L.log(CLog.LL_INF, "Receiving SLICE: " + contentId + " / " + s.length());
                    requestContentSize += (long)s.length();
                    TempFileSaveResult tempFileSaveResult = this.tempStoreSlice(session.getId(), contentId, s);
                    currentTempFileName = tempFileSaveResult.getTempFileName();
                    currentTempFileNameFinished = tempFileSaveResult.getTempFileNameFinished();
                    if (!tempFileSaveResult.getWasLastOne()) {
                        try {
                            this.m_tempFileObserverThreadPool.addRunnable(new TempFileObserverRunnable(currentTempFileName, currentTempFileNameFinished));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return;
                    }
                    if (upload2 instanceof IUploadContent) {
                        this.processUploadContentFromTempFile((IUploadContent)upload2, tempFileSaveResult.getTempFileName(), tempFileSaveResult.getTempFileNameFinished());
                        return;
                    }
                    if (upload2 instanceof IUploadStreamContent) {
                        this.processUploadStreamContentFromTempFile((IUploadStreamContent)upload2, tempFileSaveResult.getTempFileName(), tempFileSaveResult.getTempFileNameFinished());
                        return;
                    }
                }
                if ((upload = session.getAttribute(contentId)) == null) {
                    throw new Error("No one is waiting for upload content with id: " + contentId);
                }
                if (upload instanceof IUploadContent) {
                    uploadContent = (IUploadContent)upload;
                    uploadContent.beginPassing();
                    if (!"embedded".equals(req.getServerName())) {
                        this.processUploadContentByteStream(req, (IUploadContent)uploadContent);
                    } else {
                        String fileName;
                        if (!"embedded".equals(req.getServerName())) {
                            throw new Exception("Stream upload is not available in embedded usage mode");
                        }
                        int fileNameCounter = 0;
                        while ((fileName = req.getParameter("FILENAME" + fileNameCounter)) != null) {
                            fileName = URLDecoder.decode(fileName, "UTF-8");
                            String fileContent = req.getParameter("CONTENT" + fileNameCounter);
                            byte[] content = ValueManager.decodeHexString(fileContent);
                            fileContent = null;
                            uploadContent.passClientFile(fileName, content);
                            ++fileNameCounter;
                        }
                    }
                    uploadContent.endPassing();
                } else {
                    uploadContent = (IUploadStreamContent)upload;
                    uploadContent.beginPassing();
                    CountingInputStream cis = new CountingInputStream((InputStream)req.getInputStream());
                    uploadContent.passClientFilesAsStream(cis);
                    requestContentSize += cis.getCount();
                    uploadContent.endPassing();
                }
            }
            catch (Throwable t) {
                if (currentTempFileName != null) {
                    FileManager.deleteFile(currentTempFileName);
                }
                if (currentTempFileNameFinished != null) {
                    FileManager.deleteFile(currentTempFileNameFinished);
                }
                CLog.L.log(CLog.LL_ERR, "Error occurred during content upload", t);
                throw new Error(t);
            }
            finally {
                long requestEndTime = System.currentTimeMillis();
                if (session != null) {
                    PLog.logFileUploadInfo(session.getId(), requestEndTime - requestStartTime, requestContentSize);
                }
            }
        }
    }

    protected void processUploadStreamContentFromTempFile(IUploadStreamContent upload, String tempFileName, String tempFileNameFinished) {
        InputStream fis = null;
        try {
            fis = FileManager.readFileInputStream(tempFileName, true);
            upload.beginPassing();
            upload.passClientFilesAsStream(fis);
            upload.endPassing();
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Error occurred during content upload", t);
            throw new Error("Problem occurred during file upload processing", t);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Throwable throwable) {}
            FileManager.deleteFile(tempFileName);
            FileManager.deleteFile(tempFileNameFinished);
        }
    }

    protected void processUploadContentFromTempFile(final IUploadContent upload, String tempFileName, String tempFileNameFinished) {
        InputStream fis = null;
        try {
            fis = FileManager.readFileInputStream(tempFileName, true);
            upload.beginPassing();
            UploadContentParser.parseUploadContent(fis, new UploadContentParser.IParserListener(){

                @Override
                public void reactOnFileRead(String fileName, byte[] content) {
                    upload.passClientFile(fileName, content);
                }
            });
            upload.endPassing();
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem occurred during file upload processing", t);
            throw new Error("Problem occurred during file upload processing", t);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Throwable throwable) {}
            FileManager.deleteFile(tempFileName);
            FileManager.deleteFile(tempFileNameFinished);
        }
    }

    protected TempFileSaveResult tempStoreSlice(String sessionId, String contentId, String s) {
        int index1 = contentId.indexOf("_slice_");
        int index2 = contentId.indexOf("_", index1 + "_slice_".length());
        int sliceIndex = ValueManager.decodeInt(contentId.substring(index1 + "_slice_".length(), index2), -1);
        int index3 = contentId.indexOf("_", index2 + 1);
        int index4 = contentId.length();
        int nofSlices = ValueManager.decodeInt(contentId.substring(index3 + 1, index4), -1);
        String uploadId = contentId.substring(0, index1);
        String fileName = HttpSessionAccess.getServletTempDirectory() + "/ccupploadcontent/" + sessionId + "/" + uploadId + ".temp";
        String fileNameFinished = fileName + "_finished";
        ValueManager.approveFileName(fileName);
        FileManager.ensureDirectoryForFileExists(fileName);
        if (sliceIndex == 0) {
            CLog.L.log(CLog.LL_INF, "Creating: " + fileName);
            FileManager.writeUTF8File(fileName, s, true);
        } else {
            CLog.L.log(CLog.LL_INF, "Appending to: " + fileName);
            FileManager.appendUTF8ToFile(fileName, s, true);
        }
        if (sliceIndex == nofSlices - 1) {
            FileManager.writeUTF8File(fileNameFinished, "finished", true);
            return new TempFileSaveResult(fileName, fileNameFinished, true);
        }
        return new TempFileSaveResult(fileName, fileNameFinished, false);
    }

    protected void processUploadContentByteStream(HttpServletRequest req, IUploadContent uploadContent) throws Exception {
        int isv;
        ServletInputStream is = req.getInputStream();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((isv = is.read()) >= 0) {
            bos.write(isv);
        }
        byte[] bytes = bos.toByteArray();
        String s = new String(bytes, "UTF-8");
        int fileNameCounter = 0;
        while (true) {
            int indexC;
            String FILENAMEstr = "FILENAME" + fileNameCounter + "=";
            if (fileNameCounter != 0) {
                FILENAMEstr = "&" + FILENAMEstr;
            }
            String CONTENTstr = "&CONTENT" + fileNameCounter + "=";
            int indexF = s.indexOf(FILENAMEstr);
            if (indexF < 0 || (indexC = s.indexOf(CONTENTstr, indexF)) < 0) break;
            int indexEnd = s.indexOf("&FILENAME" + (fileNameCounter + 1) + "=");
            int FILENAMElength = FILENAMEstr.length();
            String fileName = s.substring(indexF + FILENAMElength, indexC);
            fileName = URLDecoder.decode(fileName, "UTF-8");
            String contentString = null;
            int CONTENTlength = CONTENTstr.length();
            contentString = indexEnd > indexC ? s.substring(indexC + CONTENTlength, indexEnd) : s.substring(indexC + CONTENTlength);
            byte[] content = ValueManager.decodeHexString(contentString);
            uploadContent.passClientFile(fileName, content);
            ++fileNameCounter;
        }
    }

    class TempFileObserverRunnable
    implements Runnable {
        String i_fileName;
        String i_fileNameFinished;
        long i_startStamp = System.currentTimeMillis();
        long i_startFileStamp;

        public TempFileObserverRunnable(String fileName, String fileNameFinished) {
            this.i_fileName = fileName;
            this.i_fileNameFinished = fileNameFinished;
            this.i_startFileStamp = new File(this.i_fileName).lastModified();
        }

        @Override
        public void run() {
            try {
                CLog.L.log(CLog.LL_INF, "TempFileObserverThread: started");
                if (!FileManager.checkIfFileExists(this.i_fileName)) {
                    return;
                }
                if (!FileManager.checkIfFileExists(this.i_fileName)) {
                    return;
                }
                if (FileManager.checkIfFileExists(this.i_fileNameFinished)) {
                    return;
                }
                long nowFileStamp = new File(this.i_fileName).lastModified();
                if (this.i_startFileStamp == nowFileStamp) {
                    CLog.L.log(CLog.LL_INF, "TempFileObserverThread: no activity on file, now removing: " + this.i_fileName);
                    FileManager.deleteFile(this.i_fileName);
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                CLog.L.log(CLog.LL_INF, "TempFileObserverThread: ended");
            }
        }
    }

    class TempFileObserverThreadPool
    extends Thread {
        Vector<TempFileObserverRunnable> i_runnables = new Vector();

        TempFileObserverThreadPool() {
        }

        public void addRunnable(TempFileObserverRunnable r) {
            this.i_runnables.add(r);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    block3: while (true) {
                        Thread.sleep(s_observerThreadInterval);
                        long now = System.currentTimeMillis();
                        ArrayList<TempFileObserverRunnable> runs = new ArrayList<TempFileObserverRunnable>(this.i_runnables);
                        Iterator iterator = runs.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block3;
                            TempFileObserverRunnable run = (TempFileObserverRunnable)iterator.next();
                            if (run.i_startStamp + s_tempFileTimeout >= now) continue;
                            this.i_runnables.remove(run);
                            run.run();
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }
    }

    class TempFileSaveResult {
        String i_tempFileName;
        String i_tempFileNameFinished;
        boolean i_wasLastOne;

        public TempFileSaveResult(String tempFileName, String tempFileNameFinished, boolean wasLastOne) {
            this.i_tempFileName = tempFileName;
            this.i_tempFileNameFinished = tempFileNameFinished;
            this.i_wasLastOne = wasLastOne;
        }

        public String getTempFileNameFinished() {
            return this.i_tempFileNameFinished;
        }

        public String getTempFileName() {
            return this.i_tempFileName;
        }

        public boolean getWasLastOne() {
            return this.i_wasLastOne;
        }
    }
}

