/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.calendar;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.xml.parsers.SAXParser;
import org.eclnt.jsfserver.calendar.ExtCalendarMgr;
import org.eclnt.jsfserver.calendar.IExtCalendarMgr;
import org.eclnt.jsfserver.streamstore.StreamStore;
import org.eclnt.jsfserver.util.parse.SAXParserCreator;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ExtCalendar {
    static int UNDEFINED = Integer.MIN_VALUE;
    static int ALL = -1;
    ExtCalendarMgr m_manager;
    String m_calendarId;
    String m_extends;
    List<Definition> m_definitions = new ArrayList<Definition>();

    public ExtCalendar(String calendarId, ExtCalendarMgr manager) {
        this.m_manager = manager;
        this.m_calendarId = calendarId;
        this.init();
    }

    public IExtCalendarMgr.ExtCalendarInfo getCalendarInfoForDay(Date d, String timeZone) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(timeZone));
        cal.setTime(d);
        int calYear = cal.get(1);
        int calMonth = cal.get(2) + 1;
        int calWeek = cal.get(3);
        int calDayOfMonth = cal.get(5);
        int calDayOfWeek = cal.get(7);
        for (int i = this.m_definitions.size() - 1; i >= 0; --i) {
            Definition def = this.m_definitions.get(i);
            boolean fits = this.checkIfDefinitionFits(def, calYear, calMonth, calWeek, calDayOfMonth, calDayOfWeek);
            if (!fits) continue;
            IExtCalendarMgr.ExtCalendarInfo result = new IExtCalendarMgr.ExtCalendarInfo(d, def.i_comment, def.i_selectable, def.i_background, def.i_warningOnSelection);
            return result;
        }
        if (this.m_extends != null) {
            return this.m_manager.getExtCalendar(this.m_extends).getCalendarInfoForDay(d, timeZone);
        }
        return null;
    }

    public List<IExtCalendarMgr.ExtCalendarInfo> getCalendarInfoForMonth(Date d, String timeZone) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(timeZone));
        cal.setTime(d);
        int originalMonth = cal.get(2);
        ArrayList<IExtCalendarMgr.ExtCalendarInfo> result = new ArrayList<IExtCalendarMgr.ExtCalendarInfo>();
        for (int i = 1; i <= 31; ++i) {
            cal.set(5, i);
            int nowMonth = cal.get(2);
            if (nowMonth != originalMonth) break;
            IExtCalendarMgr.ExtCalendarInfo eci = this.getCalendarInfoForDay(cal.getTime(), timeZone);
            if (eci == null) continue;
            result.add(eci);
        }
        return result;
    }

    private void init() {
        try {
            CLog.L.log(CLog.LL_INF, "Initializing ext. calendar: " + this.m_calendarId);
            String xml = StreamStore.getInstance().readUTF8("ccextcalendar/" + this.m_calendarId + ".xml", true);
            SAXParser parser = SAXParserCreator.createSAXParser();
            InputSource is = new InputSource(new StringReader(xml));
            parser.parse(is, (DefaultHandler)new CalendarParser());
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem when initializing ext. calendar: " + this.m_calendarId, t);
        }
    }

    private boolean checkIfDefinitionFits(Definition d, int calYear, int calMonth, int calWeek, int calDayOfMonth, int calDayOfWeek) {
        return d.i_month != UNDEFINED ? !(d.i_year != ALL && calYear != d.i_year || d.i_month != ALL && calMonth != d.i_month || d.i_day != ALL && calDayOfMonth != d.i_day) : !(d.i_week == UNDEFINED || d.i_year != ALL && calYear != d.i_year || d.i_week != ALL && calWeek != d.i_week || d.i_day != ALL && calDayOfWeek != d.i_day);
    }

    class CalendarParser
    extends DefaultHandler {
        CalendarParser() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if ("extcalendar".equals(name)) {
                ExtCalendar.this.m_extends = attributes.getValue("extends");
            } else if ("noworkday".equals(name)) {
                Definition d = new Definition();
                String year = attributes.getValue("year");
                String month = attributes.getValue("month");
                String week = attributes.getValue("week");
                String day = attributes.getValue("day");
                if (year != null) {
                    d.i_year = ValueManager.decodeInt(year, ALL);
                }
                if (month != null) {
                    d.i_month = ValueManager.decodeInt(month, ALL);
                }
                if (week != null) {
                    d.i_week = ValueManager.decodeInt(week, ALL);
                }
                if (day != null) {
                    d.i_day = ValueManager.decodeInt(day, ALL);
                }
                d.i_comment = attributes.getValue("comment");
                d.i_selectable = ValueManager.decodeBoolean(attributes.getValue("selectable"), true);
                d.i_background = attributes.getValue("background");
                d.i_warningOnSelection = ValueManager.decodeBoolean(attributes.getValue("warningonselection"), true);
                ExtCalendar.this.m_definitions.add(d);
            }
        }
    }

    class Definition {
        boolean i_workday = false;
        int i_year = UNDEFINED;
        int i_month = UNDEFINED;
        int i_week = UNDEFINED;
        int i_day = UNDEFINED;
        String i_comment;
        boolean i_selectable = true;
        boolean i_warningOnSelection = true;
        String i_background = null;

        Definition() {
        }
    }
}

