/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.defaultscreens;

import java.io.Serializable;
import javax.faces.event.ActionEvent;
import org.eclnt.jsfserver.defaultscreens.DefaultPopupPersistence;
import org.eclnt.jsfserver.defaultscreens.IPopupPersistence;
import org.eclnt.jsfserver.elements.ThreadData;
import org.eclnt.jsfserver.elements.events.BaseActionEventPopupClose;
import org.eclnt.jsfserver.elements.phases.PhaseManager;
import org.eclnt.jsfserver.elements.util.Trigger;
import org.eclnt.jsfserver.session.RequestFocusManager;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;

public abstract class BasePopup
implements Serializable {
    public static final int WINDOWSTATE_NORMAL = 0;
    public static final int WINDOWSTATE_ICONIFIED = 1;
    public static final int WINDOWSTATE_MAXIMIZED = 6;
    public static String s_defaultBgpaint = "rectangle(0,0,100%,100%,#FFFFFF)";
    private static String LOOKUP_BGPAINT = BasePopup.class.getName() + ".bgpaint";
    public static int POS_CENTER = 999999;
    private static int HEIGHT_DELTA_DECORATED = 0;
    private static int s_idCounter = 100;
    private static IPopupPersistence s_popupPersistence = new DefaultPopupPersistence();
    protected int m_id;
    protected boolean m_opened;
    protected boolean m_undecorated = false;
    protected boolean m_sizeableIfUndecorated = false;
    protected String m_page;
    protected String m_title;
    protected int m_left = Integer.MIN_VALUE;
    protected int m_top = Integer.MIN_VALUE;
    protected int m_width;
    protected int m_height;
    protected int m_windowstate;
    protected String m_lefttopreference;
    protected IPopupListener m_popupListener;
    protected String m_contentReplace;
    protected String m_contentReplaceDrillDown;
    protected boolean m_isnew = true;
    protected boolean m_ismaximized = false;
    protected boolean m_closeonclickoutside = false;
    protected boolean m_closeonmouseexit = false;
    protected boolean m_closeonmouseactivity = false;
    protected boolean m_startfromrootwindow = true;
    protected BasePopup m_owner;
    protected boolean m_updateisolation = false;
    protected boolean m_openasframe = false;
    protected String m_image = null;
    private int m_index;
    protected boolean m_avoidfocussingofopener = false;
    protected boolean m_avoidfocussingofpopup = false;
    protected Integer m_opacity = null;
    protected boolean m_withanimation;
    protected String m_animationtype;
    protected String m_sizeAnimationtype;
    protected String m_bgpaint = null;
    protected String m_positionshift = null;
    protected String m_persistid = null;
    protected IUpdatePersistedPosition m_updatedPersistedPositionCallBack = null;
    protected String m_clientname = null;
    protected String m_styleseq = null;
    protected String m_styleseqdecoration = null;
    protected boolean m_skipBlockingOnClose = false;
    protected boolean m_withcloseicon = true;
    protected boolean m_withmaximizeicon = true;
    protected boolean m_ignoreroundtripvetosonclose = false;
    protected Trigger m_maxmintrigger = new Trigger();
    protected boolean m_parentHotkeysActive = false;
    private long m_requestFocus = 0L;
    private int m_desiredSizeCounter = -1;
    boolean m_topPopup = false;
    String m_popupPageBeanExpression = null;

    public BasePopup() {
        PhaseManager.runAfterRenderResponsePhase(new Runnable(){

            @Override
            public void run() {
                BasePopup.this.m_isnew = false;
            }
        });
        this.m_id = ++s_idCounter;
    }

    public static void initialize(String defaultBgpaint) {
        s_defaultBgpaint = defaultBgpaint;
        HttpSessionAccess.getCurrentHttpSession().setAttribute(LOOKUP_BGPAINT, (Object)defaultBgpaint);
    }

    public static void initializeHeightDeltaDecorated(int value) {
        HEIGHT_DELTA_DECORATED = value;
    }

    public void open(String page, String title, int width, int height, IPopupListener popupListener) {
        this.m_opened = true;
        this.m_page = page;
        this.m_title = title;
        this.m_width = width;
        this.m_height = height;
        this.m_popupListener = popupListener;
        this.m_undecorated = false;
        this.m_updateisolation = false;
        this.m_openasframe = false;
        this.m_isnew = true;
        if (page != null && !page.startsWith("/")) {
            CLog.L.log(CLog.LL_WAR, "Page was passed as relative address: " + page);
            CLog.L.log(CLog.LL_WAR, "This typically causes problems because pages are searched relative to the base popup page which is in /eclntserver/popups/");
        }
    }

    public int getId() {
        return this.m_id;
    }

    public String getPopupPageBeanExpression() {
        return this.m_popupPageBeanExpression;
    }

    public void setPopupPageBeanExpression(String popupPageBeanExpression) {
        this.m_popupPageBeanExpression = popupPageBeanExpression;
    }

    public void setAvoidfocussingofopener(boolean avoidfocussingofopener) {
        this.m_avoidfocussingofopener = avoidfocussingofopener;
    }

    public boolean getAvoidfocussingofopener() {
        return this.m_avoidfocussingofopener;
    }

    public void setAvoidfocussingofpopup(boolean value) {
        this.m_avoidfocussingofpopup = value;
    }

    public boolean getAvoidfocussingofpopup() {
        return this.m_avoidfocussingofpopup;
    }

    public void setImage(String value) {
        this.m_image = value;
    }

    public String getImage() {
        return this.m_image;
    }

    public void setContentReplace(String value) {
        this.m_contentReplace = value;
    }

    public String getContentReplace() {
        return this.m_contentReplace;
    }

    public void setContentReplaceDrillDown(String value) {
        this.m_contentReplaceDrillDown = value;
    }

    public String getContentReplaceDrillDown() {
        return this.m_contentReplaceDrillDown;
    }

    public boolean getOpened() {
        return this.m_opened;
    }

    public void setOpened(boolean opened) {
        this.m_opened = opened;
    }

    public String getPage() {
        return this.m_page;
    }

    public void setPage(String page) {
        this.m_page = page;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public void setLeft(int left) {
        this.m_left = left;
    }

    public int getLeft() {
        return this.m_left;
    }

    public void setTop(int top) {
        this.m_top = top;
    }

    public int getTop() {
        return this.m_top;
    }

    public void setWidth(int width) {
        this.m_width = width;
    }

    public int getWidth() {
        return this.m_width;
    }

    public void setWidthHeightToDesiredSize() {
        --this.m_desiredSizeCounter;
        this.m_width = this.m_desiredSizeCounter;
        this.m_height = this.m_desiredSizeCounter;
    }

    public void setWidthHeightToSizeOfReference() {
        this.m_width = -100000;
        this.m_height = -100000;
    }

    public void setHeight(int height) {
        this.m_height = height;
    }

    public int getHeight() {
        int result = this.m_height;
        if (result > 0 && !this.getUndecorated() && (result += HEIGHT_DELTA_DECORATED) < 0) {
            result = this.m_height;
        }
        return result;
    }

    public int getWindowstate() {
        return this.m_windowstate;
    }

    public Trigger getMaxmintrigger() {
        return this.m_maxmintrigger;
    }

    public BasePopup getOwner() {
        return this.m_owner;
    }

    public void setOwner(BasePopup value) {
        this.m_owner = value;
    }

    public void setStartfromrootwindow(boolean value) {
        this.m_startfromrootwindow = value;
    }

    public boolean getStartfromrootwindow() {
        return this.m_startfromrootwindow;
    }

    public void setOpacity(Integer opacity) {
        this.m_opacity = opacity;
    }

    public Integer getOpacity() {
        return this.m_opacity;
    }

    public boolean getWithanimation() {
        return this.m_withanimation;
    }

    public void setWithanimation(boolean withanimation) {
        this.m_withanimation = withanimation;
    }

    public String getAnimationtype() {
        return this.m_animationtype;
    }

    public void setAnimationtype(String animationtype) {
        this.m_animationtype = animationtype;
    }

    public String getSizeAnimationtype() {
        return this.m_sizeAnimationtype;
    }

    public void setSizeAnimationtype(String sizeAnimationtype) {
        this.m_sizeAnimationtype = sizeAnimationtype;
    }

    public void setClientname(String value) {
        this.m_clientname = value;
    }

    public String getClientname() {
        if (this.m_clientname != null) {
            return this.m_clientname;
        }
        return this.m_page;
    }

    public String getLefttopreference() {
        return this.m_lefttopreference;
    }

    @Deprecated
    public void setLefttopreference(String value) {
        this.m_lefttopreference = value;
    }

    public boolean getIgnoreroundtripvetosonclose() {
        return this.m_ignoreroundtripvetosonclose;
    }

    public String toString() {
        return "" + this.m_id;
    }

    public void setLefTopReferenceComponentId(String value) {
        this.m_lefttopreference = "id:" + value;
    }

    public void setLeftTopReferenceComponentIdRight(String value) {
        this.m_lefttopreference = "idright:" + value;
    }

    public void setLeftTopReferenceRight() {
        this.setLeftTopReferenceComponentIdRight("this");
    }

    public void setLeftTopReferenceComponentIdLeft(String value) {
        this.m_lefttopreference = "idleft:" + value;
    }

    public void setLeftTopReferenceLeft() {
        this.setLeftTopReferenceComponentIdLeft("this");
    }

    public void setLeftTopReferenceBottom() {
        this.setLefTopReferenceComponentIdBottom("this");
    }

    public void setLefTopReferenceComponentIdBottom(String value) {
        this.m_lefttopreference = "idbottom:" + value;
    }

    public void setLeftTopReferenceTop() {
        this.setLefTopReferenceComponentIdTop("this");
    }

    public void setLefTopReferenceComponentIdTop(String value) {
        this.m_lefttopreference = "idtop:" + value;
    }

    public void setLeftTopReferenceCentered() {
        this.m_lefttopreference = "centered:";
    }

    public void setLeftTopReferenceComponentIdCentered(String value) {
        this.m_lefttopreference = "idcentered:" + value;
    }

    public void setLeftTopReferenceComponentIdOver(String value) {
        this.m_lefttopreference = "idover:" + value;
    }

    private void setLeftTopScreen(String value, boolean sticky) {
        this.m_lefttopreference = value;
        if (sticky) {
            this.m_lefttopreference = this.m_lefttopreference + "sticky";
        }
    }

    public void setLeftTopScreenBottom(boolean sticky) {
        this.setLeftTopScreen("screenbottom", sticky);
    }

    public void setLeftTopScreenTop(boolean sticky) {
        this.setLeftTopScreen("screentop", sticky);
    }

    public void setLeftTopScreenLeft(boolean sticky) {
        this.setLeftTopScreen("screenleft", sticky);
    }

    public void setLeftTopScreenRight(boolean sticky) {
        this.setLeftTopScreen("screenright", sticky);
    }

    public void setLeftTopMousePosition(boolean asToolTip) {
        this.m_lefttopreference = asToolTip ? "mousepositiontooltip" : "mouseposition";
    }

    public void setUndecorated(boolean value) {
        this.m_undecorated = value;
    }

    public boolean getUndecorated() {
        return this.m_undecorated;
    }

    public void setSizeableIfUndecorated(boolean sizeableIfUndecorated) {
        this.m_sizeableIfUndecorated = sizeableIfUndecorated;
    }

    public boolean getSizeableIfUndecorated() {
        return this.m_sizeableIfUndecorated;
    }

    public boolean getUpdateIsolation() {
        return this.m_updateisolation;
    }

    public void setUpdateIsolation(boolean updateisolation) {
        this.m_updateisolation = updateisolation;
    }

    public void setCloseonclickoutside(boolean value) {
        this.m_closeonclickoutside = value;
    }

    public boolean getCloseonclickoutside() {
        return this.m_closeonclickoutside;
    }

    public boolean getCloseonmouseexit() {
        return this.m_closeonmouseexit;
    }

    public void setCloseonmouseexit(boolean closeonmouseexit) {
        this.m_closeonmouseexit = closeonmouseexit;
    }

    public boolean getCloseonmouseactivity() {
        return this.m_closeonmouseactivity;
    }

    public void setCloseonmouseactivity(boolean closeonmouseactivity) {
        this.m_closeonmouseactivity = closeonmouseactivity;
    }

    public boolean getIsnew() {
        return this.m_isnew;
    }

    public boolean getIsmaximized() {
        return this.m_ismaximized;
    }

    public boolean getOpenasframe() {
        return this.m_openasframe;
    }

    public long getRequestFocus() {
        return this.m_requestFocus;
    }

    public void requestFocus() {
        this.m_requestFocus = RequestFocusManager.getNewRequestFocusCounter();
    }

    public final int getIndex() {
        return this.m_index;
    }

    public final void setIndex(int index) {
        this.m_index = index;
    }

    public String getStyleseq() {
        return this.m_styleseq;
    }

    public void setStyleseq(String styleseq) {
        this.m_styleseq = styleseq;
    }

    public String getStyleseqdecoration() {
        return this.m_styleseqdecoration;
    }

    public void setStyleseqdecoration(String styleseqdecoration) {
        this.m_styleseqdecoration = styleseqdecoration;
    }

    public String getBgpaint() {
        if (this.m_bgpaint != null) {
            return this.m_bgpaint;
        }
        String sessionBgpaint = (String)HttpSessionAccess.getCurrentHttpSession().getAttribute(LOOKUP_BGPAINT);
        if (sessionBgpaint != null) {
            return sessionBgpaint;
        }
        return s_defaultBgpaint;
    }

    public void setBgpaint(String bgpaint) {
        this.m_bgpaint = bgpaint;
    }

    @Deprecated
    public void setPositionShift(String positionshift) {
        this.m_positionshift = positionshift;
    }

    @Deprecated
    public String getPositionShift() {
        return this.m_positionshift;
    }

    public void setUpdatedPersistedPositionCallBack(IUpdatePersistedPosition updatedPersistedPositionCallBack) {
        this.m_updatedPersistedPositionCallBack = updatedPersistedPositionCallBack;
    }

    public IUpdatePersistedPosition getUpdatedPersistedPositionCallBack() {
        return this.m_updatedPersistedPositionCallBack;
    }

    public void setSkipBlockingOnClose(boolean skipBlockingOnClose) {
        this.m_skipBlockingOnClose = skipBlockingOnClose;
    }

    public boolean getSkipBlockingOnClose() {
        return this.m_skipBlockingOnClose;
    }

    public void hideCloseIcon() {
        this.m_withcloseicon = false;
    }

    public boolean getWithcloseicon() {
        return this.m_withcloseicon;
    }

    public void setWithcloseicon(boolean withcloseicon) {
        this.m_withcloseicon = withcloseicon;
    }

    public void hideMaximizeIcon() {
        this.m_withmaximizeicon = false;
    }

    public boolean getWithmaximizeicon() {
        return this.m_withmaximizeicon;
    }

    public void setWithmaximizeicon(boolean withmaximizeicon) {
        this.m_withmaximizeicon = withmaximizeicon;
    }

    public void close() {
        this.m_opened = false;
        this.m_page = null;
        this.m_title = null;
        this.m_popupListener = null;
        this.m_ismaximized = false;
        this.m_bgpaint = null;
        ThreadData.getInstance().registerChangeUpdatingAllAreas();
    }

    public void onPopupClosedByUser(ActionEvent event) {
        if (this.m_popupListener == null) {
            return;
        }
        if (event instanceof BaseActionEventPopupClose) {
            BaseActionEventPopupClose ae = (BaseActionEventPopupClose)event;
            if (ae.checkIfNormalClosing()) {
                this.m_popupListener.reactOnPopupClosedByUser();
            } else if (ae.checkIfForcedClosing()) {
                if (this.m_popupListener instanceof IPopupListener2) {
                    ((IPopupListener2)this.m_popupListener).reactOnPopupClosedByClient();
                } else {
                    CLog.L.log(CLog.LL_INF, "Popup was closed by client - no explicit implementation of popup listener found");
                    this.m_popupListener.reactOnPopupClosedByUser();
                }
                if (this.m_opened) {
                    this.close();
                }
            }
        } else {
            this.m_popupListener.reactOnPopupClosedByUser();
        }
    }

    public void maximize(boolean value) {
        this.m_ismaximized = value;
        this.m_maxmintrigger.trigger();
    }

    public IPopupListener getPopupListener() {
        return this.m_popupListener;
    }

    public void setPopupListener(IPopupListener popupListener) {
        this.m_popupListener = popupListener;
    }

    public String getPersistid() {
        return this.m_persistid;
    }

    public void setPersistid(String persistid) {
        this.m_persistid = persistid;
    }

    public void persistPosition() {
        if (this.m_persistid != null && s_popupPersistence != null && SystemXml.getDialogsPersistenceEnabled()) {
            IPopupPersistence.PersistentInfo pi = new IPopupPersistence.PersistentInfo();
            pi.setLeft(this.m_left);
            pi.setTop(this.m_top);
            pi.setWidth(this.m_width);
            pi.setHeight(this.m_height);
            pi.setWindowstate(this.m_windowstate);
            s_popupPersistence.updatePersistentInfo(HttpSessionAccess.getCurrentFacesContext(), this, this.m_persistid, pi);
        }
    }

    public void loadPersistedPosition() {
        IPopupPersistence.PersistentInfo pi;
        if (this.m_persistid != null && s_popupPersistence != null && SystemXml.getDialogsPersistenceEnabled() && (pi = s_popupPersistence.readPersistentInfo(HttpSessionAccess.getCurrentFacesContext(), this, this.m_persistid)) != null) {
            this.m_left = pi.getLeft();
            this.m_top = pi.getTop();
            this.m_width = pi.getWidth();
            this.m_height = pi.getHeight();
            this.m_windowstate = pi.getWindowstate();
            if (HttpSessionAccess.checkIfCurrentClientTypeIsRisc()) {
                this.m_lefttopreference = "absolute";
            }
            if (this.m_updatedPersistedPositionCallBack != null) {
                this.m_updatedPersistedPositionCallBack.reactOnPeristedPositionLoaded(this);
            }
        }
    }

    public void ignoreRoundtripVetosOnClose() {
        this.m_ignoreroundtripvetosonclose = true;
    }

    public void setParentHotkeysActive(boolean parentHotkeysActive) {
        this.m_parentHotkeysActive = parentHotkeysActive;
    }

    public boolean getParentHotkeysActive() {
        return this.m_parentHotkeysActive;
    }

    public static interface IUpdatePersistedPosition {
        public void reactOnPeristedPositionLoaded(BasePopup var1);
    }

    public static interface IPopupListener2
    extends IPopupListener {
        public void reactOnPopupClosedByClient();
    }

    public static interface IPopupListener
    extends Serializable {
        public void reactOnPopupClosedByUser();
    }
}

