/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.dynamicpages;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclnt.jsfserver.configuration.CCConfigurationObjectLoader;
import org.eclnt.jsfserver.dynamicpages.IDynamicPageProvider;
import org.eclnt.jsfserver.managedbean.DefaultHotDeployListener;
import org.eclnt.jsfserver.managedbean.HotDeployNotifier;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;

public class DynamicPageMgmt {
    static final Object SYNCHER = new Object();
    static Map<String, IDynamicPageProvider> s_providers = new HashMap<String, IDynamicPageProvider>();
    static boolean s_initialized = false;

    public static String readDynamicPage(String pageName) {
        DynamicPageMgmt.initializeIfRequired();
        try {
            if (!pageName.startsWith("/")) {
                return null;
            }
            String path = DynamicPageMgmt.isolatePath(pageName);
            IDynamicPageProvider dpp = s_providers.get(path);
            if (dpp == null) {
                return null;
            }
            return dpp.readDynamicPage(pageName);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Could not read page within dynamic page management", t);
            throw new Error(t);
        }
    }

    public static boolean checkIfPageIsManagedDynamically(String pageName) {
        DynamicPageMgmt.initializeIfRequired();
        try {
            if (pageName == null) {
                return false;
            }
            if (!pageName.startsWith("/")) {
                return false;
            }
            DynamicPageMgmt.initializeIfRequired();
            if (s_providers.size() == 0) {
                return false;
            }
            String path = DynamicPageMgmt.isolatePath(pageName);
            if (path == null) {
                return false;
            }
            return s_providers.containsKey(path);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem when checking with dynamic page management: " + t.toString());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDynamicPageProvider(IDynamicPageProvider instance) {
        DynamicPageMgmt.initializeIfRequired();
        Object object = SYNCHER;
        synchronized (object) {
            s_providers.put(instance.getPath(), instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeIfRequired() {
        if (s_initialized) {
            return;
        }
        Object object = SYNCHER;
        synchronized (object) {
            if (s_initialized) {
                return;
            }
            s_initialized = true;
            s_providers.clear();
            CLog.L.log(CLog.LL_INF, "Initializing dynamic page management");
            List<SystemXml.DynamicPageInfo> dpis = SystemXml.getDynamicPageInfos();
            for (SystemXml.DynamicPageInfo dpi : dpis) {
                try {
                    CLog.L.log(CLog.LL_INF, "Initializing dynamice page manager: " + dpi.getClassname());
                    IDynamicPageProvider dpp = (IDynamicPageProvider)CCConfigurationObjectLoader.instance().loadInstance(dpi.getClassname(), true);
                    s_providers.put(dpp.getPath(), dpp);
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_ERR, "Problem when adding dynamic page provider", t);
                }
            }
        }
    }

    private static String isolatePath(String pageName) {
        int secondSlash = pageName.indexOf(47, 1);
        if (secondSlash < 0) {
            return null;
        }
        return pageName.substring(0, secondSlash);
    }

    static {
        HotDeployNotifier.addListener(new DefaultHotDeployListener(){

            @Override
            public void onClassLoaderUpdate(ClassLoader newClassLoader) {
                s_initialized = false;
            }
        });
    }
}

