/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.eclnt.jsfserver.elements.BaseActionEvent;
import org.eclnt.jsfserver.elements.BaseActionEventTooltipEnded;
import org.eclnt.jsfserver.elements.BaseActionEventTooltipStarted;
import org.eclnt.jsfserver.elements.BaseComponent;
import org.eclnt.jsfserver.elements.BaseComponentTag;
import org.eclnt.jsfserver.elements.ComponentRepository;
import org.eclnt.jsfserver.elements.EventBlockerDuringDecode;
import org.eclnt.jsfserver.elements.ThreadData;
import org.eclnt.jsfserver.elements.adapter.IComponentAdapterBinding;
import org.eclnt.jsfserver.elements.events.BaseActionEventActiveX;
import org.eclnt.jsfserver.elements.events.BaseActionEventAreaFocusGained;
import org.eclnt.jsfserver.elements.events.BaseActionEventBrowserEventMessage;
import org.eclnt.jsfserver.elements.events.BaseActionEventCameraSnap;
import org.eclnt.jsfserver.elements.events.BaseActionEventCcfeditTransfer;
import org.eclnt.jsfserver.elements.events.BaseActionEventChartClick;
import org.eclnt.jsfserver.elements.events.BaseActionEventChartDomainZoom;
import org.eclnt.jsfserver.elements.events.BaseActionEventChartJsPointSelection;
import org.eclnt.jsfserver.elements.events.BaseActionEventChartMouseClick;
import org.eclnt.jsfserver.elements.events.BaseActionEventClientDatagramReceive;
import org.eclnt.jsfserver.elements.events.BaseActionEventClientFilePoll;
import org.eclnt.jsfserver.elements.events.BaseActionEventClientFileRemovalMessage;
import org.eclnt.jsfserver.elements.events.BaseActionEventClientFocusChange;
import org.eclnt.jsfserver.elements.events.BaseActionEventClientHttpReceive;
import org.eclnt.jsfserver.elements.events.BaseActionEventClientHttpSend;
import org.eclnt.jsfserver.elements.events.BaseActionEventClientMethodReceive;
import org.eclnt.jsfserver.elements.events.BaseActionEventClientSerialReceive;
import org.eclnt.jsfserver.elements.events.BaseActionEventClientSocketReceive;
import org.eclnt.jsfserver.elements.events.BaseActionEventClientSubDevice;
import org.eclnt.jsfserver.elements.events.BaseActionEventClientUsbFileReader;
import org.eclnt.jsfserver.elements.events.BaseActionEventClipboardGet;
import org.eclnt.jsfserver.elements.events.BaseActionEventCopyClipboard;
import org.eclnt.jsfserver.elements.events.BaseActionEventDetailInvoke;
import org.eclnt.jsfserver.elements.events.BaseActionEventDownloadFinished;
import org.eclnt.jsfserver.elements.events.BaseActionEventDragStarted;
import org.eclnt.jsfserver.elements.events.BaseActionEventDrop;
import org.eclnt.jsfserver.elements.events.BaseActionEventDropCopy;
import org.eclnt.jsfserver.elements.events.BaseActionEventFXChartSelection;
import org.eclnt.jsfserver.elements.events.BaseActionEventFileCreateDirectory;
import org.eclnt.jsfserver.elements.events.BaseActionEventFinishedRendering;
import org.eclnt.jsfserver.elements.events.BaseActionEventFlipContent;
import org.eclnt.jsfserver.elements.events.BaseActionEventFlipLabel;
import org.eclnt.jsfserver.elements.events.BaseActionEventFlush;
import org.eclnt.jsfserver.elements.events.BaseActionEventFocusGained;
import org.eclnt.jsfserver.elements.events.BaseActionEventFocusLost;
import org.eclnt.jsfserver.elements.events.BaseActionEventGeoLocationUpdate;
import org.eclnt.jsfserver.elements.events.BaseActionEventGridColumnUpdate;
import org.eclnt.jsfserver.elements.events.BaseActionEventGridFirstLineUp;
import org.eclnt.jsfserver.elements.events.BaseActionEventGridLastLineDown;
import org.eclnt.jsfserver.elements.events.BaseActionEventGridMove;
import org.eclnt.jsfserver.elements.events.BaseActionEventGridRowExecute;
import org.eclnt.jsfserver.elements.events.BaseActionEventGridRowSelect;
import org.eclnt.jsfserver.elements.events.BaseActionEventGridScroll;
import org.eclnt.jsfserver.elements.events.BaseActionEventGridSearch;
import org.eclnt.jsfserver.elements.events.BaseActionEventGridSelectAll;
import org.eclnt.jsfserver.elements.events.BaseActionEventGridSelectorTitleIcon;
import org.eclnt.jsfserver.elements.events.BaseActionEventGridSort;
import org.eclnt.jsfserver.elements.events.BaseActionEventGridSync;
import org.eclnt.jsfserver.elements.events.BaseActionEventHelp;
import org.eclnt.jsfserver.elements.events.BaseActionEventIframeIncludeCallback;
import org.eclnt.jsfserver.elements.events.BaseActionEventImageMapAreaSelected;
import org.eclnt.jsfserver.elements.events.BaseActionEventInvoke;
import org.eclnt.jsfserver.elements.events.BaseActionEventJsCallResult;
import org.eclnt.jsfserver.elements.events.BaseActionEventKeySequence;
import org.eclnt.jsfserver.elements.events.BaseActionEventLazyLoading;
import org.eclnt.jsfserver.elements.events.BaseActionEventLink;
import org.eclnt.jsfserver.elements.events.BaseActionEventLoadOnDemand;
import org.eclnt.jsfserver.elements.events.BaseActionEventLongClickEnd;
import org.eclnt.jsfserver.elements.events.BaseActionEventMediaPlayer;
import org.eclnt.jsfserver.elements.events.BaseActionEventMenuLoad;
import org.eclnt.jsfserver.elements.events.BaseActionEventMessage;
import org.eclnt.jsfserver.elements.events.BaseActionEventMouseOut;
import org.eclnt.jsfserver.elements.events.BaseActionEventMouseOver;
import org.eclnt.jsfserver.elements.events.BaseActionEventMultiScan;
import org.eclnt.jsfserver.elements.events.BaseActionEventNavButtonPress;
import org.eclnt.jsfserver.elements.events.BaseActionEventObjectHeaderIconInvoke;
import org.eclnt.jsfserver.elements.events.BaseActionEventObjectHeaderIntroInvoke;
import org.eclnt.jsfserver.elements.events.BaseActionEventObjectHeaderTitleInvoke;
import org.eclnt.jsfserver.elements.events.BaseActionEventObjectHeaderTitleSelectorInvoke;
import org.eclnt.jsfserver.elements.events.BaseActionEventOsmviewerSelection;
import org.eclnt.jsfserver.elements.events.BaseActionEventPaintAreaItemMoveResize;
import org.eclnt.jsfserver.elements.events.BaseActionEventPdfprinterNotification;
import org.eclnt.jsfserver.elements.events.BaseActionEventPopupClose;
import org.eclnt.jsfserver.elements.events.BaseActionEventPopupMenuItem;
import org.eclnt.jsfserver.elements.events.BaseActionEventPopupMenuLoad;
import org.eclnt.jsfserver.elements.events.BaseActionEventQRCodeScan;
import org.eclnt.jsfserver.elements.events.BaseActionEventRGraphPointSelection;
import org.eclnt.jsfserver.elements.events.BaseActionEventRangeSelection;
import org.eclnt.jsfserver.elements.events.BaseActionEventRearrange;
import org.eclnt.jsfserver.elements.events.BaseActionEventRollingContainerIconInvoke;
import org.eclnt.jsfserver.elements.events.BaseActionEventScan;
import org.eclnt.jsfserver.elements.events.BaseActionEventScenejsCallback;
import org.eclnt.jsfserver.elements.events.BaseActionEventScheduleSizeChanged;
import org.eclnt.jsfserver.elements.events.BaseActionEventScroll;
import org.eclnt.jsfserver.elements.events.BaseActionEventSearch;
import org.eclnt.jsfserver.elements.events.BaseActionEventSelect;
import org.eclnt.jsfserver.elements.events.BaseActionEventSendImage;
import org.eclnt.jsfserver.elements.events.BaseActionEventSlideContainer;
import org.eclnt.jsfserver.elements.events.BaseActionEventSubpageClick;
import org.eclnt.jsfserver.elements.events.BaseActionEventSuggestion;
import org.eclnt.jsfserver.elements.events.BaseActionEventSvgElementSelection;
import org.eclnt.jsfserver.elements.events.BaseActionEventTabClose;
import org.eclnt.jsfserver.elements.events.BaseActionEventTextImageInvoke;
import org.eclnt.jsfserver.elements.events.BaseActionEventTileDelete;
import org.eclnt.jsfserver.elements.events.BaseActionEventTileMove;
import org.eclnt.jsfserver.elements.events.BaseActionEventToggle;
import org.eclnt.jsfserver.elements.events.BaseActionEventTokenDelete;
import org.eclnt.jsfserver.elements.events.BaseActionEventTriplePane;
import org.eclnt.jsfserver.elements.events.BaseActionEventUpload;
import org.eclnt.jsfserver.elements.events.BaseActionEventUploadAsynchronousFinished;
import org.eclnt.jsfserver.elements.events.BaseActionEventValidate;
import org.eclnt.jsfserver.elements.events.BaseActionEventValueHelp;
import org.eclnt.jsfserver.elements.events.BaseActionEventWindowSizeChanged;
import org.eclnt.jsfserver.onlinehelp.IOnlineHelpProcessor;
import org.eclnt.jsfserver.onlinehelp.IOnlineHelpProcessor2;
import org.eclnt.jsfserver.onlinehelp.OnlineHelpFactory;
import org.eclnt.jsfserver.util.CCELResolver;
import org.eclnt.jsfserver.util.ExpressionManagerM;
import org.eclnt.jsfserver.util.ExpressionManagerV;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.util.classresolver.CCClassResolver;
import org.eclnt.util.classresolver.ENUMCallerType;
import org.eclnt.util.log.CLog;
import org.eclnt.util.log.CLogConstants;
import org.eclnt.util.valuemgmt.ValueManager;

public abstract class BaseActionComponent
extends BaseComponent
implements ActionSource,
CLogConstants {
    static final String[] actionBeforeSuffixes = new String[]{"actionbefore"};
    static final String[] actionSuffixes = new String[]{"action", "action2", "action3", "action4"};
    protected ArrayList<ActionListener> m_actionListeners = new ArrayList(0);
    protected boolean m_immediate;

    @Override
    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), new Boolean(this.m_immediate), this.m_actionListeners};
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.m_immediate = (Boolean)values[1];
        this.m_actionListeners = (ArrayList)values[2];
    }

    @Override
    public void decode(FacesContext context) {
        String clientId = this.getClientId(context);
        this.decode(context, clientId, null);
    }

    public void decode(FacesContext context, String clientId, String commandSuffix) {
        super.decode(context);
        if (this.checkIfComponentIdIsPartOfRequest(clientId)) {
            String command;
            Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
            String value = (String)requestParameterMap.get(clientId + ".autotriggered");
            if (value != null && value.equals("true")) {
                HttpSessionAccess.getCurrentComponentDump(context).currentRequestIsAutoTriggered();
            }
            for (String suffix : actionBeforeSuffixes) {
                value = (String)requestParameterMap.get(clientId + "." + suffix);
                if (value == null) continue;
                command = ValueManager.decodeMethodName(value);
                if (commandSuffix != null) {
                    command = command + commandSuffix;
                }
                this.triggerActionEvent(context, command, value, true);
            }
            for (String suffix : actionSuffixes) {
                value = (String)requestParameterMap.get(clientId + "." + suffix);
                if (value == null) continue;
                command = ValueManager.decodeMethodName(value);
                if (commandSuffix != null) {
                    command = command + commandSuffix;
                }
                this.triggerActionEvent(context, command, value, false);
            }
        }
    }

    public BaseActionEvent triggerActionEvent(FacesContext context, String command, String value, boolean immediate) {
        BaseActionEvent actionEvent = this.createBaseActionEvent(command, value);
        boolean blocked = this.checkIfEventIsBlockedByComponentLogic(actionEvent);
        if (blocked) {
            CLog.L.log(CLog.LL_WAR, "Processing of event was blocked by component processing: " + command + "/" + value);
            return actionEvent;
        }
        this.processActionEventAfterCreation(actionEvent);
        if (immediate || actionEvent.isImmediate()) {
            actionEvent.setPhaseId(PhaseId.UPDATE_MODEL_VALUES);
        } else {
            actionEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
        }
        if (!(actionEvent instanceof BaseActionEventHelp)) {
            String outValue = value;
            if (outValue != null && outValue.length() > 100) {
                outValue = outValue.substring(0, 100) + "...";
            }
            CLog.L.log(LL_INF, "queueing new ActionEvent (" + outValue + ")" + actionEvent.getPhaseId());
            this.queueEvent((FacesEvent)actionEvent);
        } else {
            String helpid = ((BaseActionEventHelp)actionEvent).getHelpid();
            boolean refersToComponent = ((BaseActionEventHelp)actionEvent).getRefersToComponent();
            Object oh = OnlineHelpFactory.getProcessor();
            if (oh instanceof IOnlineHelpProcessor2) {
                ((IOnlineHelpProcessor2)oh).processOnlineHelp(helpid, HttpSessionAccess.getCurrentLocale().getLanguage(), refersToComponent);
            } else if (oh instanceof IOnlineHelpProcessor) {
                ((IOnlineHelpProcessor)oh).processOnlineHelp(helpid, HttpSessionAccess.getCurrentLocale().getLanguage());
            }
        }
        return actionEvent;
    }

    protected void processActionEventAfterCreation(BaseActionEvent actionEvent) {
    }

    protected BaseActionEvent createBaseActionEvent(String command, String value) {
        BaseActionEvent actionEvent;
        if (command.equals("drop")) {
            actionEvent = new BaseActionEventDrop((UIComponent)this, value);
        } else if (command.equals("dropcopy")) {
            actionEvent = new BaseActionEventDropCopy((UIComponent)this, value);
        } else if (command.equals("flush")) {
            actionEvent = new BaseActionEventFlush((UIComponent)this, value);
            actionEvent.setImmediate(true);
        } else {
            String[] params;
            actionEvent = command.equals("invoke") ? new BaseActionEventInvoke((UIComponent)this, value) : (command.equals("help") ? new BaseActionEventHelp((UIComponent)this, value) : (command.equals("message") ? new BaseActionEventMessage((UIComponent)this, value) : (command.equals("loadondemand") ? new BaseActionEventLoadOnDemand((UIComponent)this, value) : (command.equals("valuehelp") ? new BaseActionEventValueHelp((UIComponent)this, value) : (command.equals("upload") ? new BaseActionEventUpload((UIComponent)this, value) : (command.equals("uploadasynchronousfinished") ? new BaseActionEventUploadAsynchronousFinished((UIComponent)this, value) : (command.equals("downloadfinished") ? new BaseActionEventDownloadFinished((UIComponent)this, value) : (command.equals("select") ? new BaseActionEventSelect((UIComponent)this, value) : (command.equals("toggle") ? new BaseActionEventToggle((UIComponent)this, value) : (command.equals("scroll") ? new BaseActionEventGridScroll((UIComponent)this, value) : (command.equals("move") ? new BaseActionEventGridMove((UIComponent)this, value) : (command.equals("rowselect") ? new BaseActionEventGridRowSelect((UIComponent)this, value) : (command.equals("rowshiftselect") ? new BaseActionEventGridRowSelect((UIComponent)this, value, true, false) : (command.equals("rowcontrolselect") ? new BaseActionEventGridRowSelect((UIComponent)this, value, false, true) : (command.equals("rowexecute") ? new BaseActionEventGridRowExecute((UIComponent)this, value) : (command.equals("sort") ? new BaseActionEventGridSort((UIComponent)this, value) : (command.equals("search") ? new BaseActionEventGridSearch((UIComponent)this, value) : (command.equals("invoke_selectortitleicon") ? new BaseActionEventGridSelectorTitleIcon((UIComponent)this, value) : (command.equals("columnupdate") ? new BaseActionEventGridColumnUpdate((UIComponent)this, value) : (command.equals("gridfirstlineup") ? new BaseActionEventGridFirstLineUp((UIComponent)this, value) : (command.equals("gridlastlinedown") ? new BaseActionEventGridLastLineDown((UIComponent)this, value) : (command.equals("gridselectall") ? new BaseActionEventGridSelectAll((UIComponent)this, value) : (command.equals("gridsync") ? new BaseActionEventGridSync((UIComponent)this, value) : (command.equals("activex") ? new BaseActionEventActiveX((UIComponent)this, value) : (command.equals("schedulesizechanged") ? new BaseActionEventScheduleSizeChanged((UIComponent)this, value) : (command.equals("clipboardget") ? new BaseActionEventClipboardGet((UIComponent)this, value) : (command.equals("clienthttpreceive") ? new BaseActionEventClientHttpReceive((UIComponent)this, value) : (command.equals("clienthttpsend") ? new BaseActionEventClientHttpSend((UIComponent)this, value) : (command.equals("clientdatagramreceive") ? new BaseActionEventClientDatagramReceive((UIComponent)this, value) : (command.equals("clientmethodreceive") ? new BaseActionEventClientMethodReceive((UIComponent)this, value) : (command.equals("click") ? new BaseActionEventSubpageClick((UIComponent)this, value) : (command.equals("imagemapareaselected") ? new BaseActionEventImageMapAreaSelected((UIComponent)this, value) : (command.equals("close") ? new BaseActionEventPopupClose((UIComponent)this, value) : (command.equals("filecreatedirectory") ? new BaseActionEventFileCreateDirectory((UIComponent)this, value) : (command.equals("link") ? new BaseActionEventLink((UIComponent)this, value) : (command.equals("tabclose") ? new BaseActionEventTabClose((UIComponent)this, value) : (command.equals("clientserialreceive") ? new BaseActionEventClientSerialReceive((UIComponent)this, value) : (command.equals("pdfprinternotification") ? new BaseActionEventPdfprinterNotification((UIComponent)this, value) : (command.equals("popupmenuload") ? new BaseActionEventPopupMenuLoad((UIComponent)this, value) : (command.equals("menuload") ? new BaseActionEventMenuLoad((UIComponent)this, value) : (command.equals("osmviewerselection") ? new BaseActionEventOsmviewerSelection((UIComponent)this, value) : (command.equals("sendImage") ? new BaseActionEventSendImage((UIComponent)this, value) : (command.equals("clientSocketReceive") ? new BaseActionEventClientSocketReceive((UIComponent)this, value) : (command.equals("chartclick") ? new BaseActionEventChartClick((UIComponent)this, value) : (command.equals("chartmouseclick") ? new BaseActionEventChartMouseClick((UIComponent)this, value) : (command.equals("chartdomainzoom") ? new BaseActionEventChartDomainZoom((UIComponent)this, value) : (command.equals("ccfedittransfer") ? new BaseActionEventCcfeditTransfer((UIComponent)this, value) : (command.equals("triplepane") ? new BaseActionEventTriplePane((UIComponent)this, value) : (command.equals("svgelementselection") ? new BaseActionEventSvgElementSelection((UIComponent)this, value) : (command.equals("clientfilepoll") ? new BaseActionEventClientFilePoll((UIComponent)this, value) : (command.equals("clientusbfilereader") ? new BaseActionEventClientUsbFileReader((UIComponent)this, value) : (command.equals("clientsubdevice") ? new BaseActionEventClientSubDevice((UIComponent)this, value) : (command.equals("tooltipstarted") ? new BaseActionEventTooltipStarted((UIComponent)this, value) : (command.equals("tooltipended") ? new BaseActionEventTooltipEnded((UIComponent)this, value) : (command.equals("keysequence") ? new BaseActionEventKeySequence((UIComponent)this, value) : (command.equals("areafocusgained") ? new BaseActionEventAreaFocusGained((UIComponent)this, value) : (command.equals("validate") ? new BaseActionEventValidate((UIComponent)this, value) : (command.equals("detailinvoke") ? new BaseActionEventDetailInvoke((UIComponent)this, value) : (command.equals("navbuttonpress") ? new BaseActionEventNavButtonPress((UIComponent)this, value) : (command.equals("tiledelete") ? new BaseActionEventTileDelete((UIComponent)this, value) : (command.equals("tilemove") ? new BaseActionEventTileMove((UIComponent)this, value) : (command.equals("tokendelete") ? new BaseActionEventTokenDelete((UIComponent)this, value) : (command.equals("rangeselection") ? new BaseActionEventRangeSelection((UIComponent)this, value) : (command.equals("suggestion") ? new BaseActionEventSuggestion((UIComponent)this, value) : (command.equals("search") ? new BaseActionEventSearch((UIComponent)this, value) : (command.equals("objectheadertitleinvoke") ? new BaseActionEventObjectHeaderTitleInvoke((UIComponent)this, value) : (command.equals("objectheadertitleselectorinvoke") ? new BaseActionEventObjectHeaderTitleSelectorInvoke((UIComponent)this, value) : (command.equals("objectheaderintroinvoke") ? new BaseActionEventObjectHeaderIntroInvoke((UIComponent)this, value) : (command.equals("objectheadericoninvoke") ? new BaseActionEventObjectHeaderIconInvoke((UIComponent)this, value) : (command.equals("clientfocuschange") ? new BaseActionEventClientFocusChange((UIComponent)this, value) : (command.equals("mediaplayer") ? new BaseActionEventMediaPlayer((UIComponent)this, value) : (command.equals("fxchartselection") ? new BaseActionEventFXChartSelection((UIComponent)this, value) : (command.equals("windowsizechanged") ? new BaseActionEventWindowSizeChanged((UIComponent)this, value) : (command.equals("clientfileremovalmessage") ? new BaseActionEventClientFileRemovalMessage((UIComponent)this, value) : (command.equals("focusgained") ? new BaseActionEventFocusGained((UIComponent)this, value) : (command.equals("focuslost") ? new BaseActionEventFocusLost((UIComponent)this, value) : (command.equals("chartjspointselection") ? new BaseActionEventChartJsPointSelection((UIComponent)this, value) : (command.equals("rgraphpointselection") ? new BaseActionEventRGraphPointSelection((UIComponent)this, value) : (command.equals("clientjscallresult") ? new BaseActionEventJsCallResult((UIComponent)this, value) : (command.equals("scan") ? new BaseActionEventScan((UIComponent)this, value) : (command.equals("multiscan") ? new BaseActionEventMultiScan((UIComponent)this, value) : (command.equals("slidecontainer") ? new BaseActionEventSlideContainer((UIComponent)this, value) : (command.equals("iframeincludecallback") ? new BaseActionEventIframeIncludeCallback((UIComponent)this, value) : (command.equals("scenejscallback") ? new BaseActionEventScenejsCallback((UIComponent)this, value) : (command.equals("qrcodescan") ? new BaseActionEventQRCodeScan((UIComponent)this, value) : (command.equals("qrcodescan") ? new BaseActionEventQRCodeScan((UIComponent)this, value) : (command.equals("geolocationupdate") ? new BaseActionEventGeoLocationUpdate((UIComponent)this, value) : (command.equals("camerasnap") ? new BaseActionEventCameraSnap((UIComponent)this, value) : (command.equals("dragstarted") ? new BaseActionEventDragStarted((UIComponent)this, value) : (command.equals("rollingcontainericoninvoke") ? new BaseActionEventRollingContainerIconInvoke((UIComponent)this, value) : (command.equals("longclickend") ? new BaseActionEventLongClickEnd((UIComponent)this, value) : (command.equals("mouseover") ? new BaseActionEventMouseOver((UIComponent)this, value) : (command.equals("mouseout") ? new BaseActionEventMouseOut((UIComponent)this, value) : (command.equals("lazyloading") ? new BaseActionEventLazyLoading((UIComponent)this, value) : (command.equals("finishedrendering") ? new BaseActionEventFinishedRendering((UIComponent)this, value) : (command.equals("panescroll") ? new BaseActionEventScroll((UIComponent)this, value) : (command.equals("browsereventmessage") ? new BaseActionEventBrowserEventMessage((UIComponent)this, value) : (command.equals("rearrange") ? new BaseActionEventRearrange((UIComponent)this, value) : (command.equals("copyclipboard") ? new BaseActionEventCopyClipboard((UIComponent)this, value) : (command.equals("paintareaitemmoveresize") ? new BaseActionEventPaintAreaItemMoveResize((UIComponent)this, value) : (command.equals("paintarealineitemmoveresize") ? new BaseActionEventPaintAreaItemMoveResize((UIComponent)this, value) : (command.equals("flipcontent") ? new BaseActionEventFlipContent((UIComponent)this, value) : (command.equals("fliplabel") ? new BaseActionEventFlipLabel((UIComponent)this, value) : (command.equals("textimageinvoke") ? new BaseActionEventTextImageInvoke((UIComponent)this, value) : ((params = ValueManager.decodeMethodParams(value)).length >= 1 && params[0].equals("eclntpopupmenu") ? new BaseActionEventPopupMenuItem((UIComponent)this, value) : this.createBaseActionEventByCommandName(command, value))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))));
        }
        return actionEvent;
    }

    private BaseActionEvent createBaseActionEventByCommandName(String command, String value) {
        BaseActionEvent result = null;
        try {
            String prefix = ComponentRepository.getTagPrefixForComponentClass(this.getClass());
            ComponentRepository.TLDInfo library = ComponentRepository.getTLDInfo(prefix);
            String packageName = library.getPackageName();
            if (packageName == null) {
                throw new Exception("No pacakge name.");
            }
            String className = packageName + ".BaseActionEvent" + ValueManager.toUpperCaseId(command.substring(0, 1)) + command.substring(1);
            Class cl = CCClassResolver.resolveClass(className, ENUMCallerType.COMPONENT);
            Constructor c = cl.getConstructor(UIComponent.class, String.class);
            return (BaseActionEvent)c.newInstance(this, value);
        }
        catch (Throwable t) {
            result = new BaseActionEvent((UIComponent)this, value);
            return result;
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        ThreadData threadData = ThreadData.getInstance();
        if (event instanceof ActionEvent) {
            this.registerInnerEvent(HttpSessionAccess.getCurrentRequestId(), null);
            CLog.L.log(LL_INF, "executing ActionEvent (" + event.getClass().getName() + ") in phase " + event.getPhaseId());
            FacesContext context = this.getFacesContext();
            if (event != null && event instanceof ActionEvent) {
                IComponentAdapterBinding o;
                for (ActionListener al : this.m_actionListeners) {
                    boolean objectAvailable;
                    threadData.setCurrentInvokeExpression(al.toString());
                    if (event instanceof BaseActionEvent && ((BaseActionEvent)event).getOnlyCallIfObjectIsAvailable() && !(objectAvailable = this.checkIfObjectForActionListenerIsAvailable(al))) continue;
                    al.processAction((ActionEvent)event);
                    threadData.setCurrentInvokeExpression(null);
                }
                if (this.m_actionListeners.size() == 0 && (o = this.getComponentAdapterBinding()) != null) {
                    String adapterBindingExpression = this.getAttributeString(BaseComponentTag.ATT_ADAPTERBINDING);
                    if (adapterBindingExpression != null) {
                        String methodBindingExpression = adapterBindingExpression.replace("}", ".onAction}");
                        ActionListener med = ExpressionManagerM.createExpression(context.getApplication(), methodBindingExpression);
                        threadData.setCurrentInvokeExpression(methodBindingExpression);
                        ExpressionManagerM.invoke(context, med, new Object[]{event});
                        threadData.setCurrentInvokeExpression(null);
                    } else {
                        o.onAction((BaseActionEvent)event);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIfObjectForActionListenerIsAvailable(ActionListener al) {
        try {
            String expression = al.toString();
            int index1 = expression.lastIndexOf(".");
            int index2 = expression.indexOf("}", index1 + 1);
            String objectExpression = expression.substring(0, index1) + expression.substring(index2);
            CCELResolver.registerThreadWithErrorFalse();
            Object o = ExpressionManagerV.getValueForExpressionString(this.getFacesContext(), objectExpression, true);
            if (o == null) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Throwable t) {
            boolean bl = false;
            return bl;
        }
        finally {
            CCELResolver.unregisterThreadWithErrorFalse();
        }
        return true;
    }

    public void clearActionListeners() {
        this.m_actionListeners.clear();
    }

    public void addActionListener(ActionListener actionListener) {
        this.m_actionListeners.add(actionListener);
        this.m_actionListeners.trimToSize();
    }

    public ActionListener getFirstActionListener() {
        if (this.m_actionListeners.size() == 0) {
            return null;
        }
        return this.m_actionListeners.get(0);
    }

    public List<ActionListener> getActionListenersAsList() {
        return this.m_actionListeners;
    }

    public ActionListener[] getActionListeners() {
        ActionListener[] result = new ActionListener[this.m_actionListeners.size()];
        this.m_actionListeners.toArray(result);
        return result;
    }

    public boolean isImmediate() {
        return this.m_immediate;
    }

    public void removeActionListener(ActionListener actionListener) {
        this.m_actionListeners.remove(actionListener);
        this.m_actionListeners.trimToSize();
    }

    public MethodBinding getAction() {
        CLog.L.log(CLog.LL_ERR, "This method must not be called (no support of ACTION attribute)");
        throw new Error("This method must not be called (no support of ATCION attribute)");
    }

    public void setAction(MethodBinding methodBinding) {
        CLog.L.log(CLog.LL_ERR, "This method must not be called (no support of ACTION attribute)");
        throw new Error("This method must not be called (no support of ATCION attribute)");
    }

    @Deprecated
    public MethodBinding getActionListener() {
        CLog.L.log(CLog.LL_ERR, "This method must not be called anymore (JSF1.2)");
        CLog.L.log(CLog.LL_ERR, "Instead: call getFisrtActionListener()");
        throw new Error("This method must not be called anymore (JSF1.2)");
    }

    @Deprecated
    public void setActionListener(MethodBinding methodBinding) {
        CLog.L.log(CLog.LL_ERR, "This method must not be called anymore (JSF1.2)");
        throw new Error("This method must not be called anymore (JSF1.2)");
    }

    public void setImmediate(boolean arg0) {
        this.m_immediate = arg0;
    }

    private boolean checkIfEventIsBlockedByComponentLogic(BaseActionEvent actionEvent) {
        return EventBlockerDuringDecode.instance().checkIfEventIsBlocked(actionEvent, this);
    }
}

