/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.impl;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.eclnt.jsfserver.bufferedcontent.BufferedContentMgr;
import org.eclnt.jsfserver.bufferedcontent.DefaultBufferedContent;
import org.eclnt.jsfserver.bufferedcontent.IBufferedContent;
import org.eclnt.jsfserver.configuration.CCConfigurationObjectLoader;
import org.eclnt.jsfserver.defaultscreens.DefaultScreens;
import org.eclnt.jsfserver.defaultscreens.GridDetails;
import org.eclnt.jsfserver.defaultscreens.ModelessPopup;
import org.eclnt.jsfserver.defaultscreens.OKPopup;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.elements.BaseActionEvent;
import org.eclnt.jsfserver.elements.BaseComponentTag;
import org.eclnt.jsfserver.elements.ConfiguredByLayoutAddon;
import org.eclnt.jsfserver.elements.IConfiguredByLayoutListener;
import org.eclnt.jsfserver.elements.ThreadData;
import org.eclnt.jsfserver.elements.events.BaseActionEventDrop;
import org.eclnt.jsfserver.elements.events.BaseActionEventGridFirstLineUp;
import org.eclnt.jsfserver.elements.events.BaseActionEventGridLastLineDown;
import org.eclnt.jsfserver.elements.events.BaseActionEventGridMove;
import org.eclnt.jsfserver.elements.events.BaseActionEventGridRowExecute;
import org.eclnt.jsfserver.elements.events.BaseActionEventGridRowSelect;
import org.eclnt.jsfserver.elements.events.BaseActionEventGridScroll;
import org.eclnt.jsfserver.elements.events.BaseActionEventGridSearch;
import org.eclnt.jsfserver.elements.events.BaseActionEventGridSelectorTitleIcon;
import org.eclnt.jsfserver.elements.events.BaseActionEventGridSort;
import org.eclnt.jsfserver.elements.events.BaseActionEventPopupMenuItem;
import org.eclnt.jsfserver.elements.events.BaseActionEventPopupMenuLoad;
import org.eclnt.jsfserver.elements.impl.FIXGRIDBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDComponent;
import org.eclnt.jsfserver.elements.impl.FIXGRIDComponentDetailUtil;
import org.eclnt.jsfserver.elements.impl.FIXGRIDExportSanitizer;
import org.eclnt.jsfserver.elements.impl.FIXGRIDItem;
import org.eclnt.jsfserver.elements.impl.FIXGRIDPersistenceMgr;
import org.eclnt.jsfserver.elements.impl.FIXGRIDWITHGROUPINGComponent;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDBinding;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDComponentAbstraction;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDCsvExporter;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDExcelExporter;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDHtmlExporter;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDItem;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDOdsExporter;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDPdfExporter;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDPersistence;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDXmlExporter;
import org.eclnt.jsfserver.elements.phases.PhaseManager;
import org.eclnt.jsfserver.elements.util.ENUMExportType;
import org.eclnt.jsfserver.elements.util.FIXGRIDCsvExporter;
import org.eclnt.jsfserver.elements.util.FIXGRIDDummyExcelExporter;
import org.eclnt.jsfserver.elements.util.FIXGRIDDummyOdsExporter;
import org.eclnt.jsfserver.elements.util.FIXGRIDENUMExportType;
import org.eclnt.jsfserver.elements.util.FIXGRIDHtmlExporter;
import org.eclnt.jsfserver.elements.util.FIXGRIDPDFExporter;
import org.eclnt.jsfserver.elements.util.FIXGRIDXmlExporter;
import org.eclnt.jsfserver.i18n.I18N;
import org.eclnt.jsfserver.util.ExpressionManagerV;
import org.eclnt.jsfserver.util.ExpressionUtil;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.StackedValueKeeper;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.jsfserver.util.ThreadingSynchronization;
import org.eclnt.jsfserver.util.valuemgmt.IDynamicContentBindingObject;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.util.valuemgmt.XMLWriter;

public abstract class FIXGRIDBinding<itemClass extends FIXGRIDItem>
implements IFIXGRIDBinding<itemClass>,
IDynamicContentBindingObject,
Serializable {
    public static final String EXPORT_COLUMNHEADER_PLACEHOLDER = ".%.";
    public static final IFIXGRIDBinding.FIXGRIDSortInfo DUMMY_FIXGRIDSORTINFO = new IFIXGRIDBinding.FIXGRIDSortInfo("DUMMY").setDummy(true);
    public static String CONTENTTYPE_EXPORT_TAB = "text/plain";
    public static String CONTENTTYPE_EXPORT_CSV = "text/csv";
    public static String CONTENTTYPE_EXPORT_XML = "text/xml";
    public static String CONTENTTYPE_EXPORT_HTML = "text/html";
    public static String CONTENTTYPE_EXPORT_PDF = "application/pdf";
    public static String CONTENTTYPE_EXPORT_XLSX = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    public static String CONTENTTYPE_EXPORT_ODS = "application/vnd.oasis.opendocument.spreadsheet";
    private static boolean s_popupEditColumnDetailsUndecorated = true;
    private static boolean s_popupGridFunctionsUndecorated = true;
    private static boolean s_textSearcherShowSearchInfoPopup = true;
    protected FIXGRIDBinding<itemClass> m_this = this;
    protected int m_sbvisibleamount;
    protected int m_sbvalue = 0;
    protected int m_numberofheaderrows;
    protected int m_numberoffooterrows;
    private boolean m_changeIndexIsSupported = false;
    protected IFIXGRIDItem m_currentlyFocussedItem;
    protected IFIXGRIDItem m_previouslyFocussedItem;
    protected IFIXGRIDItem m_firstItemForShiftSelection;
    protected Set<itemClass> m_selectedItems = new HashSet<itemClass>();
    protected String m_columnsequence = null;
    protected String m_defaultColumnsequence = null;
    protected String m_modcolumnwidths = null;
    int m_clientvisibleamount = -1;
    private int m_indextobevisibleOfItems = -1;
    private itemClass m_objectobevisibleOfItems = null;
    private int m_numberOfFixColumns = 0;
    private boolean m_withFixColumnsByUserConfiguration = false;
    protected SortInfoHashMap m_sortInfo = new SortInfoHashMap();
    protected String m_objectBinding;
    protected boolean m_initialized = false;
    private transient IFIXGRIDComponentAbstraction m_fixgridComponent;
    private boolean m_persistentGridDataApplied = false;
    private ModelessPopup m_detailPopup;
    IFIXGRIDItem m_lastHighlightItem = null;
    int m_lastHighlightColumn = -1;
    boolean m_currentlyProcessingGridAction = false;
    private FIXGRIDItem m_toBeAccessedNode;
    private int m_columnIndexOfLastSelection = -1;
    private boolean m_altPressedOfLastSelection = false;
    private boolean m_ctrlPressedOfLastSelection = false;
    private boolean m_shiftPressedOfLastSelection = false;
    private int m_mouseButtonOfLastSelection = -1;
    private int m_currentHorizontalScrollPosition = -1;
    private int m_newClientHorizontalScrollPosition = -1;
    private List<Runnable> m_runnablesAfterInitialization = null;
    private ConfiguredByLayoutAddon m_configuredByLayoutAddon = new ConfiguredByLayoutAddon();
    private int m_nonShiftSelectionCounter = 0;
    private boolean m_nextScrollCanBeAutoScroll = false;
    private transient TextSearcher mm_textSearcher = null;
    private transient Exporter mm_exporter;
    private transient ScrollHelper mm_scrollHelper;
    private FIXGRIDBinding m_connectedBinding = null;

    protected Comparator createDefaultStringComparator() {
        try {
            if (HttpSessionAccess.checkIfRunningInUIThread()) {
                Locale l = HttpSessionAccess.getCurrentLocale();
                return Collator.getInstance(l);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Collator.getInstance();
    }

    public boolean getWithFixColumnsByUserConfiguration() {
        return this.m_withFixColumnsByUserConfiguration;
    }

    @Override
    public void setWithFixColumnsByUserConfiguration(boolean withFixColumnsByUserConfiguration) {
        this.m_withFixColumnsByUserConfiguration = withFixColumnsByUserConfiguration;
    }

    @Override
    public int getNewClientHorizontalScrollPosition() {
        return this.m_newClientHorizontalScrollPosition;
    }

    public void scrollHorizontallyToPosition(int value) {
        this.m_newClientHorizontalScrollPosition = value;
        PhaseManager.runAfterRenderResponsePhase(new Runnable(){

            @Override
            public void run() {
                FIXGRIDBinding.this.m_newClientHorizontalScrollPosition = -1;
            }
        });
    }

    public void scrollHorizontallyToLastClientPosition() {
        this.scrollHorizontallyToPosition(this.m_currentHorizontalScrollPosition);
    }

    public boolean isCurrentlyProcessingGridAction() {
        return this.m_currentlyProcessingGridAction;
    }

    public void setCurrentlyProcessingGridAction(boolean currentlyProcessingGridAction) {
        this.m_currentlyProcessingGridAction = currentlyProcessingGridAction;
    }

    private TextSearcher m_textSearcher() {
        if (this.mm_textSearcher == null) {
            this.mm_textSearcher = this.createTextSearcher();
        }
        return this.mm_textSearcher;
    }

    private Exporter m_exporter() {
        if (this.mm_exporter == null) {
            this.mm_exporter = this.createExporter();
        }
        return this.mm_exporter;
    }

    private ScrollHelper m_scrollHelper() {
        if (this.mm_scrollHelper == null) {
            this.mm_scrollHelper = this.createScrollHelper();
        }
        return this.mm_scrollHelper;
    }

    public FIXGRIDBinding() {
    }

    public FIXGRIDBinding(boolean changeIndexIsSupported) {
        this.m_changeIndexIsSupported = changeIndexIsSupported;
    }

    public static void initPopupEditColumnDetailsUndecorated(boolean value) {
        s_popupEditColumnDetailsUndecorated = value;
    }

    public static void initPopupGridFunctionsUndecorated(boolean value) {
        s_popupGridFunctionsUndecorated = value;
    }

    public static void initTextSearcherShowSearchInfoPopup(boolean value) {
        s_textSearcherShowSearchInfoPopup = value;
    }

    public static void init_CONTENTTYPE_EXPORT_CSV(String value) {
        CONTENTTYPE_EXPORT_CSV = value;
    }

    public static void init_CONTENTTYPE_EXPORT_XML(String value) {
        CONTENTTYPE_EXPORT_XML = value;
    }

    public static void init_CONTENTTYPE_EXPORT_PDF(String value) {
        CONTENTTYPE_EXPORT_PDF = value;
    }

    public static void init_CONTENTTYPE_EXPORT_HTML(String value) {
        CONTENTTYPE_EXPORT_HTML = value;
    }

    public static void init_CONTENTTYPE_EXPORT_XLSX(String value) {
        CONTENTTYPE_EXPORT_XLSX = value;
    }

    public void avoidLoadingOfPersistentGridData() {
        this.m_persistentGridDataApplied = true;
    }

    public void executeOnInitializedGrid(Runnable r) {
        if (this.m_initialized) {
            try {
                r.run();
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem executing Runnable on initialized grid", t);
            }
        } else {
            if (this.m_runnablesAfterInitialization == null) {
                this.m_runnablesAfterInitialization = new ArrayList<Runnable>();
            }
            this.m_runnablesAfterInitialization.add(r);
        }
    }

    public boolean isInitialized() {
        return this.m_initialized;
    }

    @Override
    public void setIndextobevisibleOfItems(int index) {
        CLog.L.log(CLog.LL_INF, "FIXGRID:setIndextobevisibleOfItems: index set to " + index);
        this.m_indextobevisibleOfItems = index;
        if (this.m_indextobevisibleOfItems < 0) {
            this.m_objectobevisibleOfItems = null;
        }
    }

    @Override
    public final int getIndextobevisibleOfItems() {
        CLog.L.log(CLog.LL_INF, "FIXGRID:getIndextobevisibleOfItems: " + this.m_indextobevisibleOfItems + " / " + this.m_objectobevisibleOfItems);
        if (this.m_indextobevisibleOfItems >= 0) {
            CLog.L.log(CLog.LL_INF, "FIXGRID:getIndextobevisibleOfItems: index was explicitly set to " + this.m_indextobevisibleOfItems);
            return this.m_indextobevisibleOfItems;
        }
        if (this.m_objectobevisibleOfItems != null) {
            List<itemClass> listOfItems = this.getListOfItems();
            int index = listOfItems.indexOf(this.m_objectobevisibleOfItems);
            CLog.L.log(CLog.LL_INF, "FIXGRID:getIndextobevisibleOfItems: index not set, determined by object position. index is " + index);
            return index;
        }
        CLog.L.log(CLog.LL_INF, "FIXGRID:getIndextobevisibleOfItems: default: no item explicitly set to be visible");
        return -1;
    }

    @Override
    public void setObjecttobevisibleOfItems(itemClass item) {
        this.m_objectobevisibleOfItems = item;
    }

    public itemClass getObjecttobevisibleOfItems() {
        return this.m_objectobevisibleOfItems;
    }

    @Override
    public FIXGRIDBinding getConnectedBinding() {
        return this.m_connectedBinding;
    }

    public void connectWithBinding(FIXGRIDBinding binding) {
        this.m_connectedBinding = binding;
        if (binding.m_connectedBinding != this) {
            binding.m_connectedBinding = this;
        }
    }

    @Override
    public int getNumberOfFixColumns() {
        return this.m_numberOfFixColumns;
    }

    public void setNumberOfFixColumns(int numberOfFixColumns) {
        this.m_numberOfFixColumns = numberOfFixColumns;
    }

    public boolean getAltPressedOfLastSelection() {
        return this.m_altPressedOfLastSelection;
    }

    public boolean getCtrlPressedOfLastSelection() {
        return this.m_ctrlPressedOfLastSelection;
    }

    public boolean getShiftPressedOfLastSelection() {
        return this.m_shiftPressedOfLastSelection;
    }

    public int getMouseButtonOfLastSelection() {
        return this.m_mouseButtonOfLastSelection;
    }

    @Override
    public void setCurrentHorizontalScrollPosition(int currentHorizontalScrollPosition) {
        this.m_currentHorizontalScrollPosition = currentHorizontalScrollPosition;
    }

    public int getCurrentHorizontalScrollPosition() {
        return this.m_currentHorizontalScrollPosition;
    }

    public int getColumnIndexOfLastSelection() {
        return this.m_columnIndexOfLastSelection;
    }

    @Override
    public void setColumnIndexOfLastSelection(int value) {
        this.setColumnIndexOfLastSelection(value, this.m_shiftPressedOfLastSelection, this.m_ctrlPressedOfLastSelection, this.m_altPressedOfLastSelection, this.m_mouseButtonOfLastSelection);
    }

    @Override
    public void setColumnIndexOfLastSelection(int value, boolean shiftPressed, boolean ctrlPressed, boolean altPressed, int mouseButton) {
        this.m_mouseButtonOfLastSelection = mouseButton;
        this.m_shiftPressedOfLastSelection = shiftPressed;
        this.m_ctrlPressedOfLastSelection = ctrlPressed;
        this.m_altPressedOfLastSelection = altPressed;
        if (this.m_fixgridComponent != null && this.m_fixgridComponent.readSelectorcolumn() != 0) {
            --value;
        }
        if (this.m_columnsequence == null) {
            this.m_columnIndexOfLastSelection = value;
        } else {
            int counter = 0;
            int renderedIndex = -1;
            for (FIXGRIDComponent.ColumnInfo ci : this.getColumnInfos()) {
                if (ci.isRendered() && ++renderedIndex == value) {
                    this.m_columnIndexOfLastSelection = counter;
                    break;
                }
                ++counter;
            }
        }
    }

    public FIXGRIDComponentDetailUtil getRowDataUI() {
        return this.m_fixgridComponent.getDetailUtil();
    }

    public FIXGRIDItem getToBeAccessedNode() {
        return this.m_toBeAccessedNode;
    }

    protected synchronized void setToBeAccessedNode(FIXGRIDItem node) {
        StackedValueKeeper.getInstance().clearStack();
        this.m_toBeAccessedNode = node;
    }

    protected synchronized String getToBeAccessedNodeExpression(String sortReference) {
        String expression = null;
        expression = sortReference != null && sortReference.length() > 0 ? (!sortReference.startsWith("#{") ? "#{" + this.parkGridForAccess() + ".toBeAccessedNode." + sortReference + "}" : sortReference) : "#{" + this.parkGridForAccess() + ".toBeAccessedNode}";
        return expression;
    }

    protected synchronized Object getToBeAccessedNodeValue(String reference) {
        if (reference == null) {
            return null;
        }
        try {
            FacesContext fc = HttpSessionAccess.getCurrentFacesContext();
            Object value = ExpressionManagerV.getValueForExpressionString(fc, this.getToBeAccessedNodeExpression(reference));
            return value;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_WAR, "Problems accessing value via sortreference: " + reference);
            return null;
        }
    }

    public synchronized FormattedValue getItemColumnFormattedValue(itemClass item, FIXGRIDComponent.ColumnInfo ci, FIXGRIDComponent.READTYPE readType) {
        if (item == null) {
            return null;
        }
        this.setToBeAccessedNode((FIXGRIDItem)item);
        return this.getToBeAccessedNodeFormattedValue(ci, readType);
    }

    public synchronized String getItemColumnClientStringValue(itemClass item, FIXGRIDComponent.ColumnInfo ci, FIXGRIDComponent.READTYPE readType) {
        if (item == null) {
            return null;
        }
        FormattedValue v = this.getItemColumnFormattedValue(item, ci, readType);
        return ValueManager.convertObject2ClientDisplayString(v.getValue(), v.getFormat(), v.getFormatmask(), v.getTimezone(), false, false);
    }

    protected FormattedValue getToBeAccessedNodeFormattedValueForExport(FIXGRIDComponent.ColumnInfo ci) {
        return this.getToBeAccessedNodeFormattedValue(ci, FIXGRIDComponent.READTYPE.EXPORT);
    }

    protected FormattedValue getToBeAccessedNodeFormattedValue(FIXGRIDComponent.ColumnInfo ci) {
        return this.getToBeAccessedNodeFormattedValue(ci, FIXGRIDComponent.READTYPE.SORTORDEFAULT);
    }

    protected FormattedValue getToBeAccessedNodeFormattedValue(FIXGRIDComponent.ColumnInfo ci, FIXGRIDComponent.READTYPE readType) {
        if (ci == null) {
            return new FormattedValue();
        }
        if (ci.getSortreference() == null) {
            return new FormattedValue();
        }
        try {
            FacesContext fc = HttpSessionAccess.getCurrentFacesContext();
            String reference = ci.getSortreference();
            if (readType == FIXGRIDComponent.READTYPE.EXPORT) {
                reference = ci.getExportReference();
            }
            String valueExpression = this.getToBeAccessedNodeExpression(reference);
            Object value = ExpressionManagerV.getValueForExpressionString(fc, valueExpression);
            FormattedValue result = new FormattedValue();
            result.i_value = value;
            String nodeExpression = "#{" + this.parkGridForAccess() + ".toBeAccessedNode}";
            if (readType != FIXGRIDComponent.READTYPE.SORTORDEFAULT) {
                result.i_format = ci.getFormatValue(nodeExpression);
                result.i_formatmask = ci.getFormatmaskValue(nodeExpression);
                result.i_timezone = ci.getTimezoneValue(nodeExpression);
            } else {
                result.i_format = ci.getFormatValue(nodeExpression, FIXGRIDComponent.READTYPE.EXPORT);
                result.i_formatmask = ci.getFormatmaskValue(nodeExpression, FIXGRIDComponent.READTYPE.EXPORT);
                result.i_timezone = ci.getTimezoneValue(nodeExpression, FIXGRIDComponent.READTYPE.EXPORT);
            }
            return result;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_WAR, "Problems accessing value via sortreference: " + ci.getSortreference());
            return new FormattedValue();
        }
    }

    protected String getToBeAccessedNodeStringValue(FIXGRIDComponent.ColumnInfo ci, FIXGRIDComponent.READTYPE readType, String nullValue, boolean asDisplayString) {
        if (ci.getSortreference() == null) {
            return nullValue;
        }
        try {
            Object value;
            FacesContext fc = HttpSessionAccess.getCurrentFacesContext();
            CLog.L.log(CLog.LL_INF, "***** FXIGRIDEXPORT: fc: " + fc);
            String reference = ci.getSortreference();
            if (readType == FIXGRIDComponent.READTYPE.EXPORT) {
                reference = ci.getExportReference();
            }
            if ((value = ExpressionManagerV.getValueForExpressionString(fc, this.getToBeAccessedNodeExpression(reference))) == null) {
                return nullValue;
            }
            if (asDisplayString) {
                String nodeExpression = "#{" + this.parkGridForAccess() + ".toBeAccessedNode}";
                String formatValue = this.getToBeAccessedNodeFormatValue(ci, nodeExpression, readType);
                String formatmaskValue = this.getToBeAccessedNodeFormatmaskValue(ci, nodeExpression, readType);
                String timeZoneValue = this.getToBeAccessedNodeTimezoneValue(ci, nodeExpression, readType);
                return ValueManager.convertObject2DisplayString(value, formatValue, formatmaskValue, timeZoneValue, true, true);
            }
            return ValueManager.convertObject2ValueString(value);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_WAR, "Problems accessing value via sortreference: " + ci.getSortreference());
            return nullValue;
        }
    }

    protected String getToBeAccessedNodeUnitValue(FIXGRIDComponent.ColumnInfo ci) {
        if (ci.getUnittext() == null) {
            return null;
        }
        try {
            FacesContext fc = HttpSessionAccess.getCurrentFacesContext();
            String reference = ci.getUnittext();
            Object value = ExpressionManagerV.getValueForExpressionString(fc, this.getToBeAccessedNodeExpression(reference));
            return ValueManager.convertObject2ValueString(value);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_WAR, "Problems accessing unit text: " + ci.getUnittext());
            return null;
        }
    }

    protected String getToBeAccessedNodeFormatValue(FIXGRIDComponent.ColumnInfo ci, String nodeExpression, FIXGRIDComponent.READTYPE readType) {
        return ci.getFormatValue(nodeExpression, readType);
    }

    protected String getToBeAccessedNodeFormatmaskValue(FIXGRIDComponent.ColumnInfo ci, String nodeExpression, FIXGRIDComponent.READTYPE readType) {
        return ci.getFormatmaskValue(nodeExpression, readType);
    }

    protected String getToBeAccessedNodeTimezoneValue(FIXGRIDComponent.ColumnInfo ci, String nodeExpression, FIXGRIDComponent.READTYPE readType) {
        return ci.getTimezoneValue(nodeExpression, readType);
    }

    public TextSearcher getTextSearcher() {
        return this.m_textSearcher();
    }

    protected TextSearcher createTextSearcher() {
        return new TextSearcher();
    }

    public Exporter getExporter() {
        return this.m_exporter();
    }

    protected Exporter createExporter() {
        return new Exporter();
    }

    public ScrollHelper getScrollHelper() {
        return this.m_scrollHelper();
    }

    protected ScrollHelper createScrollHelper() {
        return new ScrollHelper();
    }

    @Override
    public void addConfiguredByLayoutListener(IConfiguredByLayoutListener listener) {
        this.m_configuredByLayoutAddon.addListener(listener);
    }

    @Override
    public void removeConfiguredByLayoutListener(IConfiguredByLayoutListener listener) {
        this.m_configuredByLayoutAddon.removeListener(listener);
    }

    @Override
    public void passComponentData(String objectBinding, IFIXGRIDComponentAbstraction fixgridComponent) {
        this.m_objectBinding = objectBinding;
        this.m_fixgridComponent = fixgridComponent;
        if (fixgridComponent != null && !this.m_persistentGridDataApplied) {
            this.m_persistentGridDataApplied = true;
            String persistId = fixgridComponent.getAttributeValueAsString("persistid");
            if (persistId != null) {
                this.loadPersistentData(this.m_fixgridComponent.getPage(), persistId);
            }
        }
        if (!this.m_initialized) {
            if (this.m_runnablesAfterInitialization != null) {
                for (Runnable r : this.m_runnablesAfterInitialization) {
                    try {
                        r.run();
                    }
                    catch (Throwable t) {
                        CLog.L.log(CLog.LL_INF, "Problem executing runnable after initialization", t);
                    }
                }
                this.m_runnablesAfterInitialization = null;
            }
            this.m_initialized = true;
            this.initialize();
            this.m_configuredByLayoutAddon.triggerListeners();
        }
    }

    protected void loadPersistentData(String page, String persistId) {
        try {
            IFIXGRIDPersistence.PersistentInfo pi = null;
            pi = FIXGRIDPersistenceMgr.readPersistentInfo(HttpSessionAccess.getCurrentFacesContext(), this, page, persistId);
            this.applyPersistentData(pi);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problems when loading persistetn grid data", t);
        }
    }

    public void resetPersistentData() {
        try {
            String persistId = this.m_fixgridComponent.getAttributeValueAsString("persistid");
            if (persistId == null) {
                return;
            }
            String pageName = this.m_fixgridComponent.getPage();
            FacesContext context = HttpSessionAccess.getCurrentFacesContext();
            IFIXGRIDPersistence.PersistentInfo pi = FIXGRIDPersistenceMgr.removePersistentInfo(context, this, pageName, persistId);
            this.m_columnsequence = null;
            this.m_modcolumnwidths = null;
            this.applyPersistentData(pi);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problems when reset-ing persistent grid data", t);
        }
    }

    public void applyPersistentData(IFIXGRIDPersistence.PersistentInfo pi) {
        if (pi == null) {
            return;
        }
        this.m_modcolumnwidths = pi.getColumnWidths();
        this.m_columnsequence = pi.getColumnSequence();
    }

    protected void storePersistentDataImplicitly() {
        this.storePersistentData();
    }

    public void storePersistentData() {
        try {
            String persistId = this.m_fixgridComponent.getAttributeValueAsString("persistid");
            if (persistId == null) {
                return;
            }
            this.storePersistentData(this.m_fixgridComponent.getPage(), persistId);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problems when loading persistent grid data");
        }
    }

    protected void storePersistentData(String page, String persistId) {
        try {
            IFIXGRIDPersistence.PersistentInfo pi = this.getCurrentColumWdithSequenceInfo();
            FIXGRIDPersistenceMgr.updatePersistentInfo(HttpSessionAccess.getCurrentFacesContext(), this, page, persistId, pi);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problems when loading persistent grid data");
        }
    }

    public IFIXGRIDPersistence.PersistentInfo getCurrentColumWdithSequenceInfo() {
        IFIXGRIDPersistence.PersistentInfo pi = new IFIXGRIDPersistence.PersistentInfo();
        pi.setColumnSequence(this.m_columnsequence);
        pi.setColumnWidths(this.m_modcolumnwidths);
        return pi;
    }

    public void initialize() {
    }

    public Set<itemClass> getSelectedItems() {
        HashSet<itemClass> result = new HashSet<itemClass>(this.m_selectedItems);
        return result;
    }

    public itemClass getSelectedItem() {
        Set<itemClass> selItems = this.getSelectedItems();
        if (selItems.size() == 0) {
            return null;
        }
        return (itemClass)((FIXGRIDItem)selItems.iterator().next());
    }

    @Override
    public void setSbvisibleamount(int value) {
        this.m_sbvisibleamount = value;
    }

    @Override
    public int getSbvisibleamount() {
        return this.m_sbvisibleamount;
    }

    public void setSbvalue(int value) {
        this.setSbvalue(value, true);
    }

    public void setSbvalue(int value, boolean callConnectedBinding) {
        CLog.L.log(CLog.LL_INF, "FIXGRID:setSbvalue: Setting sbvalue in grid to " + value);
        if (value < 0) {
            return;
        }
        if (value == this.m_sbvalue) {
            return;
        }
        CLog.L.log(CLog.LL_INF, "FIXGRID:setSbvalue: Update of sbvalue in grid " + this.m_objectBinding);
        this.m_sbvalue = value;
        if (this.m_connectedBinding != null && callConnectedBinding) {
            this.m_connectedBinding.setSbvalue(value, false);
        }
    }

    @Override
    public void setSbvalue(String value) {
        this.setSbvalue(ValueManager.decodeInt(value, 0));
    }

    @Override
    public int getSbvalue() {
        return this.m_sbvalue;
    }

    @Override
    public void setClientvisibleamount(int value) {
        this.m_clientvisibleamount = value;
    }

    @Override
    public int getClientvisibleamount() {
        if (this.m_clientvisibleamount < 0) {
            return this.getSbvisibleamount();
        }
        return this.m_clientvisibleamount;
    }

    @Override
    public void setColumnsequence(String value) {
        this.m_columnsequence = value;
        this.storePersistentDataImplicitly();
        this.onColumnSequenceUpdated();
    }

    protected void onColumnSequenceUpdated() {
    }

    public void setDefaultColumnsequence(String value) {
        this.m_defaultColumnsequence = value;
    }

    @Override
    public String getColumnsequence() {
        return this.m_columnsequence;
    }

    public String getDefaultColumnsequence() {
        return this.m_defaultColumnsequence;
    }

    @Override
    public void setModcolumnwidths(String value) {
        this.m_modcolumnwidths = value;
        this.onColumnWidthsUpdated();
        this.storePersistentDataImplicitly();
    }

    protected void onColumnWidthsUpdated() {
    }

    @Override
    public String getModcolumnwidths() {
        return this.m_modcolumnwidths;
    }

    public String[] getModcolumnwidthsAsArray() {
        if (this.m_modcolumnwidths == null) {
            return null;
        }
        return ValueManager.decodeCSV(this.m_modcolumnwidths);
    }

    public String[] getOriginalcolumnwidthsAsArray() {
        String[] result = new String[this.getColumnInfos().size()];
        int counter = -1;
        for (FIXGRIDComponent.ColumnInfo ci : this.getColumnInfos()) {
            ++counter;
            if (ci.getWidth() >= 0) {
                result[counter] = "" + ci.getWidth();
                continue;
            }
            result[counter] = -1 * ci.getWidth() + "%";
        }
        return result;
    }

    public String getOriginalcolumnwidths() {
        return ValueManager.encodeCSV(this.getOriginalcolumnwidthsAsArray());
    }

    public void setModcolumnwidthsArray(String[] widths) {
        if (widths == null) {
            return;
        }
        String csv = ValueManager.encodeCSV(widths);
        this.setModcolumnwidths(csv);
    }

    public void setModcolumnwidth(int columnIndex, String width) {
        String[] ws = null;
        ws = this.m_modcolumnwidths != null ? this.getModcolumnwidthsAsArray() : this.getOriginalcolumnwidthsAsArray();
        if (columnIndex >= ws.length) {
            CLog.L.log(CLog.LL_ERR, "Attempt to set a column width - index is not correct: " + columnIndex + ". Maximum index is: " + (ws.length - 1));
        } else {
            ws[columnIndex] = width;
            this.setModcolumnwidthsArray(ws);
        }
    }

    public void setModcolumnwidthsList(List<String> widths) {
        if (widths == null) {
            return;
        }
        String csv = ValueManager.encodeCSV(widths);
        this.setModcolumnwidths(csv);
    }

    public void onGridAction(ActionEvent event) {
        try {
            this.onGridActionExecute(event);
        }
        catch (Throwable t) {
            boolean catchGridActionError = this.checkIfToCatchGridActionError(event, t);
            if (catchGridActionError) {
                CLog.L.log(CLog.LL_INF, "(This error was caught within FXIGRIDBinding.onGridAction. If you want that grid action errors are passed into the default IErrorAware-management, set fixgrid-catchgridactionerrors to \"never\" in system.xml)");
                CLog.L.log(CLog.LL_INF, "Error in grid event processing", t);
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new Error("Error when processing grid action: " + event.getClass().getName(), t);
        }
    }

    protected boolean checkIfToCatchGridActionError(ActionEvent event, Throwable t) {
        String s = SystemXml.getFixgridCatchGridActionErrors();
        if ("never".equals(s)) {
            return false;
        }
        if ("ifNotIErrorAware".equals(s)) {
            FacesContext context = FacesContext.getCurrentInstance();
            return !ExpressionUtil.checkIfExpressionContainsIErrorAwareImplementation(context, "#{" + this.m_objectBinding + "}");
        }
        return true;
    }

    protected void onGridActionExecute(ActionEvent event) {
        Object e;
        boolean selectionUpdate = false;
        this.m_currentlyProcessingGridAction = true;
        PhaseManager.runAfterRenderResponsePhase(new Runnable(){

            @Override
            public void run() {
                FIXGRIDBinding.this.m_currentlyProcessingGridAction = false;
            }
        });
        CLog.L.log(CLog.LL_INF, "Grid action in grid: " + this.m_objectBinding);
        BaseActionEvent bae = (BaseActionEvent)event;
        String type = bae.getCommand();
        if (type == null) {
            return;
        }
        if (event instanceof BaseActionEventGridRowSelect) {
            e = (BaseActionEventGridRowSelect)event;
            this.setColumnIndexOfLastSelection(((BaseActionEventGridRowSelect)e).getColumnIndex(), ((BaseActionEventGridRowSelect)e).isShiftKeyPressed(), ((BaseActionEventGridRowSelect)e).isCtrlKeyPressed(), ((BaseActionEventGridRowSelect)e).isAltKeyPressed(), ((BaseActionEventGridRowSelect)e).getMouseButton());
        } else if (event instanceof BaseActionEventGridRowExecute) {
            e = (BaseActionEventGridRowExecute)event;
            this.setColumnIndexOfLastSelection(((BaseActionEventGridRowExecute)e).getColumnIndex(), ((BaseActionEventGridRowExecute)e).isShiftKeyPressed(), ((BaseActionEventGridRowExecute)e).isCtrlKeyPressed(), ((BaseActionEventGridRowExecute)e).isAltKeyPressed(), ((BaseActionEventGridRowExecute)e).getMouseButton());
        }
        if (type.equals("scroll")) {
            e = (BaseActionEventGridScroll)event;
            this.setSbvalue(((BaseActionEventGridScroll)e).getNewSbValue());
            try {
                if (((BaseActionEventGridScroll)e).getIndexToBeFocussed() > 0 && ((BaseActionEventGridScroll)e).getIndexToBeFocussed() < this.getRows().size() && this.m_nextScrollCanBeAutoScroll) {
                    IFIXGRIDItem gridItem = (IFIXGRIDItem)this.getRows().get(((BaseActionEventGridScroll)e).getIndexToBeFocussed());
                    gridItem.requestFocus();
                }
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem when re-applying focus", t);
            }
            this.m_nextScrollCanBeAutoScroll = false;
            this.ensureFullLastPage();
        } else if (event instanceof BaseActionEventGridRowSelect) {
            e = (BaseActionEventGridRowSelect)event;
            boolean multiselect = this.getMultiselect();
            if (multiselect && ((BaseActionEventGridRowSelect)e).isShiftKeyPressed()) {
                this.m_nonShiftSelectionCounter = 0;
                selectionUpdate = true;
                String[] params = bae.getParams();
                int rowIndex = ValueManager.decodeInt(params[0], 1);
                if (this.m_fixgridComponent != null) {
                    this.m_fixgridComponent.updatePreviousDump(this, rowIndex);
                }
                if (rowIndex >= 0 && rowIndex < this.getRows().size()) {
                    IFIXGRIDItem selectedObject = (IFIXGRIDItem)this.getRows().get(rowIndex);
                    this.m_previouslyFocussedItem = this.m_currentlyFocussedItem;
                    this.m_currentlyFocussedItem = selectedObject;
                    if (this.m_firstItemForShiftSelection == null) {
                        this.m_firstItemForShiftSelection = selectedObject;
                    }
                    this.fillShiftSelection();
                }
            } else if (multiselect && ((BaseActionEventGridRowSelect)e).isCtrlKeyPressed()) {
                ++this.m_nonShiftSelectionCounter;
                selectionUpdate = true;
                String[] params = bae.getParams();
                int rowIndex = ValueManager.decodeInt(params[0], 1);
                if (this.m_fixgridComponent != null) {
                    this.m_fixgridComponent.updatePreviousDump(this, rowIndex);
                }
                if (rowIndex >= 0 && rowIndex < this.getRows().size()) {
                    IFIXGRIDItem selectedObject = (IFIXGRIDItem)this.getRows().get(rowIndex);
                    this.m_previouslyFocussedItem = this.m_currentlyFocussedItem;
                    this.m_currentlyFocussedItem = selectedObject;
                    this.m_firstItemForShiftSelection = selectedObject;
                    if (!selectedObject.getSelected()) {
                        this.selectItem(selectedObject);
                    } else {
                        this.deselectItem(selectedObject);
                    }
                }
            } else {
                ++this.m_nonShiftSelectionCounter;
                selectionUpdate = true;
                String[] params = bae.getParams();
                int rowIndex = ValueManager.decodeInt(params[0], 1);
                if (this.m_fixgridComponent != null) {
                    this.m_fixgridComponent.updatePreviousDump(this, rowIndex);
                }
                if (rowIndex >= 0 && rowIndex < this.getRows().size()) {
                    IFIXGRIDItem selectedObject = (IFIXGRIDItem)this.getRows().get(rowIndex);
                    this.updateHighlight(selectedObject, (BaseActionEventGridRowSelect)bae);
                    this.updateItemSelection(selectedObject);
                }
            }
        } else if (type.equals("gridselectall")) {
            for (FIXGRIDItem item : this.getListOfItems()) {
                if (item.getSelected()) continue;
                this.selectItem(item);
            }
        } else if (type.equals("rowexecute")) {
            String[] params = bae.getParams();
            int index = ValueManager.decodeInt(params[0], 1);
            if (index >= 0 && index < this.getRows().size()) {
                IFIXGRIDItem selectedObject = (IFIXGRIDItem)this.getRows().get(index);
                this.m_previouslyFocussedItem = this.m_currentlyFocussedItem;
                this.m_currentlyFocussedItem = selectedObject;
                selectedObject.onRowExecute();
            }
        } else if (type.equals("move")) {
            BaseActionEventGridMove baem = (BaseActionEventGridMove)bae;
            selectionUpdate = true;
            int diff = baem.getDelta();
            boolean withRowShiftSelect = false;
            try {
                boolean multiSelect;
                withRowShiftSelect = baem.getShiftKeyPressed();
                if (this.m_fixgridComponent != null && !(multiSelect = this.getMultiselect())) {
                    withRowShiftSelect = false;
                }
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Move event was passed without rowshiftselect");
            }
            this.moveUpDown(diff, withRowShiftSelect, baem.getScrollDelta());
            if (diff > 0) {
                this.ensureFullLastPage();
            }
        } else if (bae instanceof BaseActionEventGridSort) {
            String sortReference = ((BaseActionEventGridSort)bae).getSortReference();
            boolean ctrlPressed = ((BaseActionEventGridSort)bae).getControlKeyPressed();
            if (!ctrlPressed) {
                this.processSort(sortReference);
            } else {
                this.processMultipleSort(sortReference);
            }
            this.storePersistentDataImplicitly();
        } else if (bae instanceof BaseActionEventGridSearch) {
            String searchString = ((BaseActionEventGridSearch)bae).getSearchString();
            String sortReference = ((BaseActionEventGridSearch)bae).getSortReference();
            this.processSearch(searchString, sortReference);
        } else if (bae instanceof BaseActionEventDrop) {
            BaseActionEventDrop baed = (BaseActionEventDrop)bae;
            if (baed.getGridIndex() >= 0) {
                if (baed.getGridIndex() < this.getRows().size()) {
                    IFIXGRIDItem selectedObject = (IFIXGRIDItem)this.getRows().get(baed.getGridIndex());
                    selectedObject.onRowDrop(baed);
                }
            } else {
                this.onDrop(baed);
            }
        } else if (bae instanceof BaseActionEventPopupMenuItem) {
            e = (BaseActionEventPopupMenuItem)bae;
            if (((BaseActionEventPopupMenuItem)e).getGridIndex() >= 0) {
                if (((BaseActionEventPopupMenuItem)e).getGridSbvalue() >= 0 && ((BaseActionEventPopupMenuItem)e).getGridSbvalue() != this.m_sbvalue) {
                    this.processMenuItemExecutedOnOutdatedItem((BaseActionEventPopupMenuItem)e);
                    return;
                }
                if (((BaseActionEventPopupMenuItem)e).getGridIndex() < this.getRows().size()) {
                    IFIXGRIDItem selectedObject = (IFIXGRIDItem)this.getRows().get(((BaseActionEventPopupMenuItem)e).getGridIndex());
                    if (!this.getSelectedItems().contains(selectedObject)) {
                        this.processMenuItemExecutedOnOutdatedItem((BaseActionEventPopupMenuItem)e);
                        return;
                    }
                    selectedObject.onRowPopupMenuItem((BaseActionEventPopupMenuItem)e);
                }
            } else {
                this.onPopupMenuItem((BaseActionEventPopupMenuItem)e);
            }
        } else if (bae instanceof BaseActionEventPopupMenuLoad) {
            e = (BaseActionEventPopupMenuLoad)bae;
            if (((BaseActionEventPopupMenuLoad)e).getGridIndex() >= 0) {
                if (((BaseActionEventPopupMenuLoad)e).getGridIndex() < this.getRows().size()) {
                    IFIXGRIDItem selectedObject = (IFIXGRIDItem)this.getRows().get(((BaseActionEventPopupMenuLoad)e).getGridIndex());
                    selectedObject.onRowPopupMenuLoad((BaseActionEventPopupMenuLoad)e);
                }
            } else {
                this.onPopupMenuLoad((BaseActionEventPopupMenuLoad)e);
            }
        } else if (bae instanceof BaseActionEventGridSelectorTitleIcon) {
            e = (BaseActionEventGridSelectorTitleIcon)bae;
            this.onSelectorTitleIconInvoked((BaseActionEventGridSelectorTitleIcon)e);
        } else if (bae instanceof BaseActionEventGridLastLineDown) {
            e = (BaseActionEventGridLastLineDown)bae;
            this.onLastLineDown((BaseActionEventGridLastLineDown)e);
        } else if (bae instanceof BaseActionEventGridFirstLineUp) {
            e = (BaseActionEventGridFirstLineUp)bae;
            this.onFirstLineUp((BaseActionEventGridFirstLineUp)e);
        }
        if (selectionUpdate) {
            this.onSelectionUpdateByClientActivity();
        }
    }

    protected void processMenuItemExecutedOnOutdatedItem(BaseActionEventPopupMenuItem e) {
        String s = I18N.getString("GRID_popupmenuwrongitem");
        Statusbar.outputError(s);
    }

    public void onSelectorTitleIconInvoked(BaseActionEventGridSelectorTitleIcon event) {
    }

    protected void onLastLineDown(BaseActionEventGridLastLineDown event) {
    }

    protected void onFirstLineUp(BaseActionEventGridFirstLineUp event) {
    }

    protected void onDrop(BaseActionEventDrop dropEvent) {
    }

    protected void onPopupMenuItem(BaseActionEventPopupMenuItem popupMenuItemEvent) {
    }

    protected void onSelectionUpdateByClientActivity() {
    }

    protected void onPopupMenuLoad(BaseActionEventPopupMenuLoad popupMenuLoadEvent) {
    }

    private void ensureFullLastPage() {
        if (this.getSbvalue() + this.getClientvisibleamount() > this.getSbmaximum()) {
            int sbv = this.getSbmaximum() - this.getClientvisibleamount();
            if (sbv < 0) {
                sbv = 0;
            }
            this.setSbvalue(sbv);
        }
    }

    protected void updateHighlight(IFIXGRIDItem item, BaseActionEventGridRowSelect event) {
        if (!event.isAltKeyPressed()) {
            return;
        }
        if (event.getMouseButton() != 1) {
            return;
        }
        if (!"true".equals(this.m_fixgridComponent.getAttributeValueAsString(BaseComponentTag.ATT_cellselection))) {
            return;
        }
        IFIXGRIDItem currentHighlighItem = item;
        int currentHighlightColumn = event.getColumnIndex();
        if (this.m_fixgridComponent != null && this.m_fixgridComponent.readSelectorcolumn() != 0) {
            --currentHighlightColumn;
        }
        if (this.m_lastHighlightItem == null) {
            this.m_lastHighlightItem = currentHighlighItem;
            this.m_lastHighlightColumn = currentHighlightColumn;
        }
        List<itemClass> items = this.getListOfItems();
        Set<itemClass> highlightedRows = this.getItemsBetween(items, this.m_lastHighlightItem, currentHighlighItem);
        for (FIXGRIDItem fgi : items) {
            int i;
            fgi.unhighlightAllCells();
            if (currentHighlighItem == this.m_lastHighlightItem && currentHighlightColumn == this.m_lastHighlightColumn || !highlightedRows.contains(fgi)) continue;
            if (this.getColumnsequence() == null) {
                if (this.m_lastHighlightColumn < currentHighlightColumn) {
                    for (int i2 = this.m_lastHighlightColumn; i2 <= currentHighlightColumn; ++i2) {
                        fgi.highlightCell(i2);
                    }
                    continue;
                }
                for (int i3 = currentHighlightColumn; i3 <= this.m_lastHighlightColumn; ++i3) {
                    fgi.highlightCell(i3);
                }
                continue;
            }
            String[] columnsStr = ValueManager.decodeCSV(this.getColumnsequence());
            int[] columns = new int[columnsStr.length];
            int index1 = -1;
            int index2 = -1;
            for (i = 0; i < columns.length; ++i) {
                columns[i] = new Integer(columnsStr[i]);
                if (columns[i] != this.m_lastHighlightColumn && columns[i] != currentHighlightColumn) continue;
                if (index1 < 0) {
                    index1 = i;
                } else {
                    index2 = i;
                }
                if (this.m_lastHighlightColumn != currentHighlightColumn) continue;
                index2 = index1;
            }
            if (index1 > index2) {
                int indexTemp = index1;
                index1 = index2;
                index2 = indexTemp;
            }
            for (i = index1; i <= index2; ++i) {
                try {
                    fgi.highlightCell(columns[i]);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        this.m_lastHighlightItem = currentHighlighItem;
        this.m_lastHighlightColumn = currentHighlightColumn;
    }

    protected abstract List<itemClass> getListOfItems();

    protected List<itemClass> getListOfExportItems() {
        return this.getListOfItems();
    }

    private Set<itemClass> getItemsBetween(List<itemClass> items, IFIXGRIDItem item1, IFIXGRIDItem item2) {
        int index2;
        HashSet<itemClass> result = new HashSet<itemClass>();
        int index1 = items.indexOf(item1);
        if (index1 > (index2 = items.indexOf(item2))) {
            int indexTemp = index1;
            index1 = index2;
            index2 = indexTemp;
        }
        if (index1 == -1) {
            return result;
        }
        for (int i = index1; i <= index2; ++i) {
            result.add(items.get(i));
        }
        return result;
    }

    private void updateItemSelection(IFIXGRIDItem item) {
        CLog.L.log(CLog.LL_INF, "Update of item selection: " + this.m_objectBinding);
        this.m_previouslyFocussedItem = this.m_currentlyFocussedItem;
        this.m_currentlyFocussedItem = item;
        this.m_firstItemForShiftSelection = item;
        this.deselectCurrentSelection(false, this.m_currentlyFocussedItem);
        this.selectItem(this.m_currentlyFocussedItem);
    }

    private void deselectCurrentSelection(boolean withRemovingFocusInfo, Object currentlySelectedObject) {
        CLog.L.log(CLog.LL_INF, "Deselect current selection: " + this.m_objectBinding);
        IFIXGRIDItem[] items = new IFIXGRIDItem[this.m_selectedItems.size()];
        this.m_selectedItems.toArray(items);
        for (int i = 0; i < items.length; ++i) {
            if (currentlySelectedObject != null && items[i] == currentlySelectedObject) continue;
            this.deselectItem(items[i]);
        }
        if (withRemovingFocusInfo) {
            this.m_previouslyFocussedItem = null;
            this.m_currentlyFocussedItem = null;
            this.m_firstItemForShiftSelection = null;
        }
    }

    public void deselectCurrentSelection() {
        this.deselectCurrentSelection(true, null);
    }

    public void selectItem(IFIXGRIDItem item) {
        this.selectItemWCB(item, true);
    }

    private void selectItemWCB(IFIXGRIDItem item, boolean callConnectedBinding) {
        if (CLog.L.isLoggable(CLog.LL_DBG)) {
            CLog.L.log(CLog.LL_DBG, "GRIDSELECTION: selectItemWCB() was called");
        }
        item.setSelected(true);
        this.m_selectedItems.add((FIXGRIDItem)item);
        if (this.m_connectedBinding != null && callConnectedBinding) {
            this.m_connectedBinding.selectItemWCB(item, false);
        }
        if (callConnectedBinding) {
            item.onRowSelect();
        }
    }

    public void selectAndFocusItem(itemClass item) {
        if (CLog.L.isLoggable(CLog.LL_DBG)) {
            CLog.L.log(CLog.LL_DBG, "GRIDSELECTION: selectAndFocusItem() was called");
        }
        ((FIXGRIDItem)item).requestFocus();
        this.ensureItemToBeDisplayed(item);
        this.selectItem((IFIXGRIDItem)item);
        this.m_currentlyFocussedItem = item;
        this.m_firstItemForShiftSelection = item;
        this.m_nextScrollCanBeAutoScroll = true;
    }

    public void selectItem(IFIXGRIDItem item, boolean withSelectionProcessingInApplication) {
        if (CLog.L.isLoggable(CLog.LL_DBG)) {
            CLog.L.log(CLog.LL_DBG, "GRIDSELECTION: selectItem(item,withSelectionProcessingInApplication) was called");
        }
        item.setSelected(true);
        this.m_selectedItems.add((FIXGRIDItem)item);
        if (this.m_connectedBinding != null) {
            this.m_connectedBinding.selectItemWCB(item, false);
        }
        if (withSelectionProcessingInApplication) {
            item.onRowSelect();
        }
    }

    public void deselectItem(IFIXGRIDItem item) {
        this.deselectItemWCB(item, true, true);
    }

    public void deselectItem(IFIXGRIDItem item, boolean withSelectionProcessingInApplication) {
        this.deselectItemWCB(item, withSelectionProcessingInApplication, true);
    }

    public void deselectItemWCB(IFIXGRIDItem item, boolean withSelectionProcessingInApplication, boolean callConnectedBinding) {
        if (CLog.L.isLoggable(CLog.LL_DBG)) {
            CLog.L.log(CLog.LL_DBG, "GRIDSELECTION: deselectItemWCB() was called");
        }
        item.setSelected(false);
        item.unrequestFocus();
        this.m_selectedItems.remove(item);
        if (this.m_connectedBinding != null && callConnectedBinding) {
            this.m_connectedBinding.deselectItemWCB(item, false, false);
        }
        if (withSelectionProcessingInApplication) {
            item.onRowDeselect();
        }
    }

    @Override
    public boolean checkIfChangeIndexIsSupported() {
        return this.m_changeIndexIsSupported;
    }

    public void setChangeIndexIsSupported(boolean value) {
        this.m_changeIndexIsSupported = value;
    }

    public boolean checkIfSorted() {
        for (IFIXGRIDBinding.FIXGRIDSortInfo si : this.m_sortInfo.values()) {
            if (si.i_sortSequence < 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, IFIXGRIDBinding.FIXGRIDSortInfo> getSortInfo() {
        return this.m_sortInfo;
    }

    public void clearSortInfo() {
        this.m_sortInfo.clear();
        this.storePersistentDataImplicitly();
    }

    @Override
    public final IFIXGRIDBinding.FIXGRIDSortInfo getSortInfoForReference(String sortReference) {
        String sortreferenceHashKey = FIXGRIDComponent.updateSortReferenceAsHashkey(sortReference = FIXGRIDComponent.removeExpressionFromSortReference(sortReference));
        IFIXGRIDBinding.FIXGRIDSortInfo result = this.m_sortInfo.get(sortreferenceHashKey);
        if (result == DUMMY_FIXGRIDSORTINFO || result == null) {
            result = new IFIXGRIDBinding.FIXGRIDSortInfo(sortReference);
            this.m_sortInfo.put(sortreferenceHashKey, result);
        }
        return result;
    }

    public void sort(String sortReference, boolean ascending) {
        sortReference = FIXGRIDComponent.removeExpressionFromSortReference(sortReference);
        IFIXGRIDBinding.FIXGRIDSortInfo fsi = this.getSortInfoForReference(sortReference);
        if (ascending) {
            fsi.setSortStatus(2);
        } else {
            fsi.setSortStatus(1);
        }
        this.processSort(sortReference);
    }

    public void sort(String[] sortReferences, boolean[] ascendings) {
        this.clearSortInfo();
        int counter = 0;
        for (String sortReference : sortReferences) {
            boolean ascending = true;
            try {
                ascending = ascendings[counter];
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            IFIXGRIDBinding.FIXGRIDSortInfo fsi = this.getSortInfoForReference(sortReference);
            fsi.setSortSequence(counter);
            if (ascending) {
                fsi.setSortStatus(1);
            } else {
                fsi.setSortStatus(2);
            }
            ++counter;
        }
        this.processMultipleSort();
    }

    public void resort() {
        this.processMultipleSort();
    }

    @Override
    public void renderingBegins() {
    }

    public void onEditColumnDetails(ActionEvent ae) {
        this.openEditColumnDetailsPopup();
    }

    protected ModelessPopup openEditColumnDetailsPopup() {
        final DefaultScreens ds = DefaultScreens.getSessionAccess().getOwner();
        final GridDetails gd = DefaultScreens.getSessionAccess().getGridDetails();
        GridDetails.IGridDetailsListener gl = new GridDetails.IGridDetailsListener(){

            @Override
            public void reactOnApplied() {
                ds.closePopup(gd);
            }

            @Override
            public void reactOnClose() {
                ds.closePopup(gd);
            }
        };
        gd.prepare(this, gl, true, GridDetails.PAGENAME_COLUMNSDETAILS);
        ModelessPopup popup = ds.openModelessPopup(gd, "", 500, 400, new ModelessPopup.IModelessPopupListener(){

            @Override
            public void reactOnPopupClosedByUser() {
                ds.closePopup(gd);
            }
        });
        popup.setUndecorated(s_popupEditColumnDetailsUndecorated);
        popup.setCloseonclickoutside(true);
        popup.setStartfromrootwindow(false);
        return popup;
    }

    public void onOpenGridFunctions(ActionEvent ae) {
        this.openGridFunctionsPopup();
    }

    public void onOpenGridExportFunctions(ActionEvent ae) {
        this.openGridExportFunctionsPopup();
    }

    protected ModelessPopup openGridExportFunctionsPopup() {
        final DefaultScreens ds = DefaultScreens.getSessionAccess().getOwner();
        final GridDetails gd = DefaultScreens.getSessionAccess().getGridDetails();
        GridDetails.IGridDetailsListener gl = new GridDetails.IGridDetailsListener(){

            @Override
            public void reactOnApplied() {
                ds.closePopup(gd);
            }

            @Override
            public void reactOnClose() {
                ds.closePopup(gd);
            }
        };
        gd.prepare(this, gl, true, GridDetails.PAGENAME_EXPORTFUNCTIONS);
        ModelessPopup popup = ds.openModelessPopup(gd, "", 0, 0, new ModelessPopup.IModelessPopupListener(){

            @Override
            public void reactOnPopupClosedByUser() {
                ds.closePopup(gd);
            }
        });
        popup.setUndecorated(s_popupGridFunctionsUndecorated);
        popup.setCloseonclickoutside(true);
        popup.setStartfromrootwindow(false);
        return popup;
    }

    protected ModelessPopup openGridFunctionsPopup() {
        final DefaultScreens ds = DefaultScreens.getSessionAccess().getOwner();
        final GridDetails gd = DefaultScreens.getSessionAccess().getGridDetails();
        GridDetails.IGridDetailsListener gl = new GridDetails.IGridDetailsListener(){

            @Override
            public void reactOnApplied() {
                ds.closePopup(gd);
            }

            @Override
            public void reactOnClose() {
                ds.closePopup(gd);
            }
        };
        gd.prepare(this, gl, true, GridDetails.PAGENAME_FUNCTIONS);
        ModelessPopup popup = ds.openModelessPopup(gd, "", 0, 0, new ModelessPopup.IModelessPopupListener(){

            @Override
            public void reactOnPopupClosedByUser() {
                ds.closePopup(gd);
            }
        });
        popup.setUndecorated(s_popupGridFunctionsUndecorated);
        popup.setCloseonclickoutside(true);
        popup.setStartfromrootwindow(false);
        return popup;
    }

    public List<String> getColumnTexts() {
        if (this.m_fixgridComponent != null) {
            return this.m_fixgridComponent.getColumnTexts();
        }
        return new ArrayList<String>();
    }

    public List<FIXGRIDComponent.ColumnInfo> getColumnInfos() {
        ArrayList<FIXGRIDComponent.ColumnInfo> result = new ArrayList<FIXGRIDComponent.ColumnInfo>();
        if (this.m_fixgridComponent != null) {
            for (FIXGRIDComponent.ColumnInfo columnInfo : this.m_fixgridComponent.getColumns()) {
                result.add(columnInfo);
            }
        }
        return result;
    }

    public abstract void ensureItemToBeDisplayed(itemClass var1);

    public boolean isItemSelected() {
        return this.getSelectedItem() != null;
    }

    @Override
    public List<FIXGRIDComponent.ColumnInfo> getVisibleColumns() {
        ArrayList<FIXGRIDComponent.ColumnInfo> result = new ArrayList<FIXGRIDComponent.ColumnInfo>();
        List<FIXGRIDComponent.ColumnInfo> columns = this.m_fixgridComponent.getColumns(this.m_columnsequence);
        for (FIXGRIDComponent.ColumnInfo column : columns) {
            if (column.getSortreference() == null || column.getGridcolComponent() != null && !column.getGridcolComponent().isRendered()) continue;
            result.add(column);
        }
        if (this.m_exporter() != null && this.m_exporter().i_exportJustRunning) {
            int counter = 0;
            for (FIXGRIDComponent.ColumnInfo ci : this.m_exporter().getAdditionalExportColumnsLeft()) {
                result.add(counter, ci);
                ++counter;
            }
            for (FIXGRIDComponent.ColumnInfo ci : this.m_exporter().getAdditionalExportColumnsRight()) {
                result.add(ci);
            }
        }
        return result;
    }

    @Override
    public List<FIXGRIDComponent.ColumnInfo> getVisibleColumns(boolean includeConnectedBinding) {
        List<FIXGRIDComponent.ColumnInfo> result = this.getVisibleColumns();
        if (this.m_connectedBinding != null && includeConnectedBinding) {
            List<FIXGRIDComponent.ColumnInfo> connectedColumns = this.m_connectedBinding.getVisibleColumns();
            for (FIXGRIDComponent.ColumnInfo connectedColumn : connectedColumns) {
                result.add(connectedColumn);
            }
        }
        return result;
    }

    @Override
    public List<FIXGRIDComponent.ColumnInfo> getExportableColumns() {
        List<FIXGRIDComponent.ColumnInfo> visibleColumns = this.getVisibleColumns();
        ArrayList<FIXGRIDComponent.ColumnInfo> result = new ArrayList<FIXGRIDComponent.ColumnInfo>();
        for (FIXGRIDComponent.ColumnInfo ci : visibleColumns) {
            if (ci.getAvoidExport()) continue;
            result.add(ci);
        }
        return result;
    }

    @Override
    public List<FIXGRIDComponent.ColumnInfo> getExportableColumns(boolean includeConnectedBinding) {
        List<FIXGRIDComponent.ColumnInfo> visibleColumns = this.getVisibleColumns(includeConnectedBinding);
        ArrayList<FIXGRIDComponent.ColumnInfo> result = new ArrayList<FIXGRIDComponent.ColumnInfo>();
        for (FIXGRIDComponent.ColumnInfo ci : visibleColumns) {
            if (ci.getAvoidExport()) continue;
            result.add(ci);
        }
        return result;
    }

    public void notifyDownloadWasTriggered(FIXGRIDENUMExportType exportType, boolean fullGrid) {
        CLog.L.log(CLog.LL_INF, "Download was called: " + (Object)((Object)exportType) + ", " + fullGrid);
    }

    protected void fillShiftSelection() {
        this.selectItem(this.m_currentlyFocussedItem);
    }

    protected void moveUpDown(int diff, boolean withRowShiftSelect, int scrollDelta) {
        block9: {
            try {
                int sbValue;
                int index = this.getRows().indexOf(this.m_currentlyFocussedItem);
                if (index < 0) {
                    CLog.L.log(CLog.LL_INF, "moveUpDown: currently focussed item not available anymore (e.g. clearing of grid");
                    CLog.L.log(CLog.LL_INF, "moveUpDown: unsing selected item as currently focuessed item");
                    this.m_firstItemForShiftSelection = this.m_currentlyFocussedItem = this.getSelectedItem();
                    index = this.getRows().indexOf(this.m_currentlyFocussedItem);
                }
                if ((sbValue = this.getSbvalue() + diff) < 0) {
                    sbValue = 0;
                }
                if (diff > 0 && sbValue + this.getClientvisibleamount() > this.getSbmaximum() && (sbValue = this.getSbmaximum() - this.getClientvisibleamount()) < 0) {
                    sbValue = 0;
                }
                this.setSbvalue(sbValue);
                if ((index -= scrollDelta) < 0 || index >= this.getRows().size()) break block9;
                IFIXGRIDItem selectedObject = (IFIXGRIDItem)this.getRows().get(index);
                try {
                    this.ensureItemToBeDisplayed((FIXGRIDItem)selectedObject);
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_INF, "", t);
                }
                this.m_currentlyFocussedItem = selectedObject;
                if (withRowShiftSelect) {
                    this.fillShiftSelection();
                } else {
                    this.deselectCurrentSelection(false, null);
                    this.selectItem(selectedObject);
                    this.m_firstItemForShiftSelection = selectedObject;
                }
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Error occurred when moving grid index", t);
            }
        }
    }

    protected int findHighestSortSequence() {
        int max = -1;
        for (IFIXGRIDBinding.FIXGRIDSortInfo si : this.m_sortInfo.values()) {
            if (si.getSortSequence() <= max) continue;
            max = si.getSortSequence();
        }
        return max;
    }

    public List<IFIXGRIDBinding.FIXGRIDSortInfo> findCurrentSortInfo() {
        ArrayList<IFIXGRIDBinding.FIXGRIDSortInfo> result = new ArrayList<IFIXGRIDBinding.FIXGRIDSortInfo>();
        int max = this.findHighestSortSequence();
        boolean tripleSortingSupported = this.checkIfTripleSortingIsSupported();
        for (int i = 0; i <= max; ++i) {
            IFIXGRIDBinding.FIXGRIDSortInfo si = this.findSortInfoForSortSequence(i);
            if (si == null) continue;
            result.add(si);
        }
        return result;
    }

    protected IFIXGRIDBinding.FIXGRIDSortInfo findSortInfoForSortSequence(int sortSequence) {
        for (IFIXGRIDBinding.FIXGRIDSortInfo si : this.m_sortInfo.values()) {
            if (si.getSortSequence() != sortSequence) continue;
            return si;
        }
        return null;
    }

    protected void processSort(String sortReference) {
        CLog.L.log(CLog.LL_INF, "Grid sort, reference is " + this.m_objectBinding + "/" + sortReference);
        IFIXGRIDBinding.FIXGRIDSortInfo sortInfo = this.getSortInfoForReference(sortReference);
        boolean tripleSortingSupported = this.checkIfTripleSortingIsSupported();
        if (tripleSortingSupported && sortInfo.i_sortStatus == 2) {
            sortInfo.i_sortStatus = 0;
        } else if (sortInfo.i_sortStatus == 1) {
            sortInfo.i_sortStatus = 2;
            sortInfo.i_sortSequence = 0;
        } else {
            sortInfo.i_sortStatus = 1;
            sortInfo.i_sortSequence = 0;
        }
        Map<String, IFIXGRIDBinding.FIXGRIDSortInfo> sortInfos = this.getSortInfo();
        for (IFIXGRIDBinding.FIXGRIDSortInfo fsi : sortInfos.values()) {
            if (fsi == sortInfo) continue;
            fsi.i_sortSequence = -1;
            fsi.i_sortStatus = 0;
        }
        this.processMultipleSort();
        this.removeSortInfoFromConnectedGrid();
    }

    protected void processMultipleSort(String sortReference) {
        CLog.L.log(CLog.LL_INF, "Multiple Grid sort, reference is " + this.m_objectBinding + "/" + sortReference);
        IFIXGRIDBinding.FIXGRIDSortInfo sortInfo = this.getSortInfoForReference(sortReference);
        boolean tripleSortingSupported = this.checkIfTripleSortingIsSupported();
        sortInfo.i_sortStatus = tripleSortingSupported && sortInfo.i_sortStatus == 2 ? 0 : (sortInfo.i_sortStatus == 1 ? 2 : (sortInfo.i_sortStatus == 2 ? 1 : 1));
        if (sortInfo.i_sortSequence < 0) {
            int maxSortSequence = this.findHighestSortSequence();
            sortInfo.i_sortSequence = maxSortSequence + 1;
        }
        this.processMultipleSort();
    }

    protected void processMultipleSort() {
        CLog.L.log(CLog.LL_INF, "Starting multplie sort");
        int max = this.findHighestSortSequence();
        boolean tripleSortingSupported = this.checkIfTripleSortingIsSupported();
        for (int i = max; i >= 0; --i) {
            IFIXGRIDBinding.FIXGRIDSortInfo si = this.findSortInfoForSortSequence(i);
            if (si == null) continue;
            CLog.L.log(CLog.LL_INF, "Sorting by column: " + si.getSortReference());
            if (tripleSortingSupported && si.i_sortStatus == 0) {
                this.sortGridByOriginalIndex();
                continue;
            }
            this.sortGrid(si.getSortReference(), this.parkGridForAccess(), si.i_sortStatus == 1);
        }
        this.removeSortInfoFromConnectedGrid();
    }

    public boolean checkIfFreeColumnSequenceUpdateIsSupported() {
        return this.m_fixgridComponent == null || !(this.m_fixgridComponent instanceof FIXGRIDWITHGROUPINGComponent);
    }

    private boolean checkIfTripleSortingIsSupported() {
        if (this.m_fixgridComponent != null) {
            return this.m_fixgridComponent.getTripleSort();
        }
        CLog.L.log(CLog.LL_INF, "checkIfTripleSortingIsSupported was invoked - but no component instance yet bound to fixgrid binding");
        return false;
    }

    protected void processSearch(String searchString, String sortReference) {
    }

    protected abstract void sortGrid(String var1, String var2, boolean var3);

    protected abstract void sortGridByOriginalIndex();

    protected Comparator findSortComparatorForColumnValue(String sortReference) {
        return null;
    }

    public void onClearCellHighlight(ActionEvent event) {
        this.unhighlightAllCells();
    }

    public boolean checkIfCellsAreHighlighted() {
        List<itemClass> items = this.getListOfItems();
        for (FIXGRIDItem item : items) {
            if (item == null || !item.checkIfCellsAreHighlighted()) continue;
            return true;
        }
        return false;
    }

    public void unhighlightAllCells() {
        try {
            List<itemClass> items = this.getListOfItems();
            for (FIXGRIDItem item : items) {
                if (item == null) continue;
                item.unhighlightAllCells();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void removeSortInfoFromConnectedGrid() {
        if (this.m_connectedBinding != null) {
            this.m_connectedBinding.m_sortInfo.clear();
        }
    }

    private boolean getMultiselect() {
        try {
            String multiselectStr = this.m_fixgridComponent.getAttributeValueAsString(BaseComponentTag.ATT_multiselect);
            boolean multiselect = ValueManager.decodeBoolean(multiselectStr, false);
            return multiselect;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private int getMultiselectMode() {
        try {
            String multiselectModeStr = this.m_fixgridComponent.getAttributeValueAsString(BaseComponentTag.ATT_multiselectmode);
            int multiselectMode = ValueManager.decodeInt(multiselectModeStr, 0);
            return multiselectMode;
        }
        catch (Throwable t) {
            return 0;
        }
    }

    @Override
    public IFIXGRIDComponentAbstraction getFixgridComponent() {
        return this.m_fixgridComponent;
    }

    protected boolean checkSpecialTouchMultiSelection() {
        return this.getMultiselect() && this.getMultiselectMode() == 1;
    }

    void clearSelectedItems() {
        this.m_selectedItems.clear();
        if (this.m_connectedBinding != null) {
            this.m_connectedBinding.m_selectedItems.clear();
        }
    }

    void clearSelectedItem(itemClass item) {
        this.m_selectedItems.remove(item);
        if (this.m_connectedBinding != null) {
            this.m_connectedBinding.m_selectedItems.remove(item);
        }
    }

    void addSelectedItem(itemClass item) {
        this.m_selectedItems.add(item);
        if (this.m_connectedBinding != null) {
            this.m_connectedBinding.m_selectedItems.add(item);
        }
    }

    String parkGridForAccess() {
        DefaultScreens.getSessionAccess().setTemporary(this);
        StackedValueKeeper.getInstance().clearStack();
        return "eclntdefscr.temporary";
    }

    static /* synthetic */ boolean access$000() {
        return s_textSearcherShowSearchInfoPopup;
    }

    public class SortHelper
    implements Comparable<SortHelper>,
    Serializable {
        int i_originalIndex;
        Object i_sortValue;
        boolean i_ascending;
        Comparator i_comparator;

        SortHelper(int originalIndex, Object sortValue, boolean ascending, Comparator comparator) {
            this.i_originalIndex = originalIndex;
            this.i_sortValue = sortValue;
            this.i_ascending = ascending;
            this.i_comparator = comparator;
        }

        public Object getSortValue() {
            return this.i_sortValue;
        }

        @Override
        public int compareTo(SortHelper o2) {
            Comparator comparator = this.i_comparator;
            if (comparator == null && this.i_sortValue != null && this.i_sortValue instanceof String && o2.i_sortValue != null && o2.i_sortValue instanceof String) {
                comparator = FIXGRIDBinding.this.createDefaultStringComparator();
            }
            if (comparator != null) {
                int result = comparator.compare(this.i_sortValue, o2.i_sortValue);
                return this.i_ascending ? result : result * -1;
            }
            int result = 0;
            SortHelper o1 = this;
            if (o1.i_sortValue == null && o2.i_sortValue == null) {
                result = 0;
            } else if (o1.i_sortValue == null) {
                result = -1;
            } else if (o2.i_sortValue == null) {
                result = 1;
            } else if (o1.i_sortValue instanceof String && o2.i_sortValue instanceof String) {
                String s1 = (String)o1.i_sortValue;
                String s2 = (String)o2.i_sortValue;
                result = s1.compareToIgnoreCase(s2);
            } else if (o1.i_sortValue instanceof Comparable) {
                Comparable c1 = (Comparable)o1.i_sortValue;
                Object c2 = o2.i_sortValue;
                result = c1.compareTo(c2);
            }
            if (!this.i_ascending) {
                result *= -1;
            }
            return result;
        }
    }

    public class ScrollHelper
    implements Serializable {
        public void onScrollToTop(ActionEvent event) {
            FIXGRIDBinding.this.setSbvalue(0);
        }

        public void onScrollToBottom(ActionEvent event) {
            int newSbValue = FIXGRIDBinding.this.getSbmaximum() - FIXGRIDBinding.this.getClientvisibleamount();
            if (newSbValue < 0) {
                newSbValue = 0;
            }
            FIXGRIDBinding.this.setSbvalue(newSbValue);
        }

        public void onScrollPageUp(ActionEvent event) {
            int newSbValue = FIXGRIDBinding.this.getSbvalue() - FIXGRIDBinding.this.getClientvisibleamount();
            if (newSbValue < 0) {
                newSbValue = 0;
            }
            FIXGRIDBinding.this.setSbvalue(newSbValue);
        }

        public void onScrollPageDown(ActionEvent event) {
            int newSbValue = FIXGRIDBinding.this.getSbvalue() + FIXGRIDBinding.this.getClientvisibleamount();
            if (newSbValue > FIXGRIDBinding.this.getSbmaximum() - FIXGRIDBinding.this.getClientvisibleamount()) {
                newSbValue = FIXGRIDBinding.this.getSbmaximum() - FIXGRIDBinding.this.getClientvisibleamount();
            }
            FIXGRIDBinding.this.setSbvalue(newSbValue);
        }

        public void onScrollLineUp(ActionEvent event) {
            int newSbValue = FIXGRIDBinding.this.getSbvalue() - 1;
            if (newSbValue < 0) {
                newSbValue = 0;
            }
            FIXGRIDBinding.this.setSbvalue(newSbValue);
        }

        public void onScrollLineDown(ActionEvent event) {
            int newSbValue = FIXGRIDBinding.this.getSbvalue() + 1;
            if (newSbValue > FIXGRIDBinding.this.getSbmaximum() - FIXGRIDBinding.this.getClientvisibleamount()) {
                newSbValue = FIXGRIDBinding.this.getSbmaximum() - FIXGRIDBinding.this.getClientvisibleamount();
            }
            FIXGRIDBinding.this.setSbvalue(newSbValue);
        }

        public void onSelectLineDown(ActionEvent event) {
            if (FIXGRIDBinding.this.getSbmaximum() == 0) {
                return;
            }
            Object selectedItem = FIXGRIDBinding.this.getSelectedItem();
            if (selectedItem != null) {
                int index = FIXGRIDBinding.this.getListOfItems().indexOf(selectedItem);
                if (++index < FIXGRIDBinding.this.getSbmaximum()) {
                    FIXGRIDBinding.this.deselectCurrentSelection();
                    FIXGRIDBinding.this.selectItem((IFIXGRIDItem)FIXGRIDBinding.this.getListOfItems().get(index));
                }
            } else {
                FIXGRIDBinding.this.selectItem((IFIXGRIDItem)FIXGRIDBinding.this.getRows().get(0));
            }
            FIXGRIDBinding.this.ensureItemToBeDisplayed(FIXGRIDBinding.this.getSelectedItem());
        }

        public void onSelectLineUp(ActionEvent event) {
            if (FIXGRIDBinding.this.getSbmaximum() == 0) {
                return;
            }
            Object selectedItem = FIXGRIDBinding.this.getSelectedItem();
            if (selectedItem != null) {
                int index = FIXGRIDBinding.this.getListOfItems().indexOf(selectedItem);
                if (--index >= 0) {
                    FIXGRIDBinding.this.deselectCurrentSelection();
                    FIXGRIDBinding.this.selectItem((IFIXGRIDItem)FIXGRIDBinding.this.getListOfItems().get(index));
                }
            } else {
                FIXGRIDBinding.this.selectItem((IFIXGRIDItem)FIXGRIDBinding.this.getListOfItems().get(FIXGRIDBinding.this.getSbmaximum() - 1));
            }
            FIXGRIDBinding.this.ensureItemToBeDisplayed(FIXGRIDBinding.this.getSelectedItem());
        }

        public void onSelectPageUp(ActionEvent event) {
            if (FIXGRIDBinding.this.getSbmaximum() == 0) {
                return;
            }
            this.onScrollPageUp(event);
            Object selectedItem = FIXGRIDBinding.this.getSelectedItem();
            if (selectedItem != null) {
                int index = FIXGRIDBinding.this.getListOfItems().indexOf(selectedItem);
                if ((index -= FIXGRIDBinding.this.getClientvisibleamount()) < 0) {
                    index = 0;
                }
                FIXGRIDBinding.this.deselectCurrentSelection();
                FIXGRIDBinding.this.selectItem((IFIXGRIDItem)FIXGRIDBinding.this.getListOfItems().get(index));
            } else {
                FIXGRIDBinding.this.selectItem((IFIXGRIDItem)FIXGRIDBinding.this.getListOfItems().get(FIXGRIDBinding.this.getSbvalue()));
            }
            FIXGRIDBinding.this.ensureItemToBeDisplayed(FIXGRIDBinding.this.getSelectedItem());
        }

        public void onSelectPageDown(ActionEvent event) {
            if (FIXGRIDBinding.this.getSbmaximum() == 0) {
                return;
            }
            this.onScrollPageDown(event);
            Object selectedItem = FIXGRIDBinding.this.getSelectedItem();
            if (selectedItem != null) {
                int index = FIXGRIDBinding.this.getListOfItems().indexOf(selectedItem);
                if ((index += FIXGRIDBinding.this.getClientvisibleamount()) >= FIXGRIDBinding.this.getSbmaximum()) {
                    index = FIXGRIDBinding.this.getSbmaximum() - 1;
                }
                FIXGRIDBinding.this.deselectCurrentSelection();
                FIXGRIDBinding.this.selectItem((IFIXGRIDItem)FIXGRIDBinding.this.getListOfItems().get(index));
            } else {
                FIXGRIDBinding.this.selectItem((IFIXGRIDItem)FIXGRIDBinding.this.getListOfItems().get(FIXGRIDBinding.this.getSbvalue()));
            }
            FIXGRIDBinding.this.ensureItemToBeDisplayed(FIXGRIDBinding.this.getSelectedItem());
        }

        public void onSelectToTop(ActionEvent event) {
            if (FIXGRIDBinding.this.getSbmaximum() == 0) {
                return;
            }
            FIXGRIDBinding.this.deselectCurrentSelection();
            FIXGRIDBinding.this.selectItem((IFIXGRIDItem)FIXGRIDBinding.this.getListOfItems().get(0));
        }

        public void onSelectToBottom(ActionEvent event) {
            if (FIXGRIDBinding.this.getSbmaximum() == 0) {
                return;
            }
            FIXGRIDBinding.this.deselectCurrentSelection();
            FIXGRIDBinding.this.selectItem((IFIXGRIDItem)FIXGRIDBinding.this.getListOfItems().get(FIXGRIDBinding.this.getSbmaximum() - 1));
        }
    }

    public class Exporter
    implements Serializable {
        org.eclnt.jsfserver.elements.impl.FIXGRIDBinding$Exporter.Clearer i_clearer = new Clearer();
        ExporterCSVWholeGrid i_exporterCSVWholeGrid;
        ExporterCSVWholeGrid i_exporterCSVSelectedRows;
        ExporterCSVRange i_exporterCSVRange;
        ExporterXMLWholeGrid i_exporterXMLWholeGrid;
        ExporterXMLWholeGrid i_exporterXMLSelectedRows;
        ExporterXMLRange i_exporterXMLRange;
        ExporterPDFWholeGrid i_exporterPDFWholeGrid;
        ExporterPDFWholeGrid i_exporterPDFSelectedRows;
        ExporterHTMLWholeGrid i_exporterHTMLWholeGrid;
        ExporterHTMLWholeGrid i_exporterHTMLSelectedRows;
        ExporterXLSXWholeGrid i_exporterXLSXWholeGrid;
        ExporterXLSXWholeGrid i_exporterXLSXSelectedRows;
        ExporterODSWholeGrid i_exporterODSWholeGrid;
        ExporterODSWholeGrid i_exporterODSSelectedRows;
        IFIXGRIDPdfExporter i_pdfExporter;
        IFIXGRIDExcelExporter i_excelExporter;
        IFIXGRIDOdsExporter i_odsExporter;
        IFIXGRIDHtmlExporter i_htmlExporter;
        IFIXGRIDCsvExporter i_csvExporter;
        IFIXGRIDXmlExporter i_xmlExporter;
        boolean i_exportJustRunning = false;
        List<FIXGRIDComponent.ColumnInfo> i_additionalExportColumnsLeft = new ArrayList<FIXGRIDComponent.ColumnInfo>();
        List<FIXGRIDComponent.ColumnInfo> i_additionalExportColumnsRight = new ArrayList<FIXGRIDComponent.ColumnInfo>();
        String i_exportFilePrefix = "{temp}/grid";

        public String getExportFilePrefix() {
            return this.i_exportFilePrefix;
        }

        public void setExportFilePrefix(String exportFilePrefix) {
            this.i_exportFilePrefix = exportFilePrefix;
        }

        public List<FIXGRIDComponent.ColumnInfo> getAdditionalExportColumnsLeft() {
            return this.i_additionalExportColumnsLeft;
        }

        public List<FIXGRIDComponent.ColumnInfo> getAdditionalExportColumnsRight() {
            return this.i_additionalExportColumnsRight;
        }

        public String getExportURLCsvWholeGrid() {
            if (this.i_exporterCSVWholeGrid == null) {
                this.i_exporterCSVWholeGrid = new ExporterCSVWholeGrid(false);
            }
            BufferedContentMgr.add(this.i_exporterCSVWholeGrid);
            this.i_clearer.activate();
            CLog.L.log(CLog.LL_INF, "getExportURLCsvWholeGrid: " + this.i_exporterCSVWholeGrid.getURL());
            return this.i_exporterCSVWholeGrid.getURL();
        }

        public String getExportURLCsvSelectedRows() {
            if (this.i_exporterCSVSelectedRows == null) {
                this.i_exporterCSVSelectedRows = new ExporterCSVWholeGrid(true);
            }
            BufferedContentMgr.add(this.i_exporterCSVSelectedRows);
            this.i_clearer.activate();
            CLog.L.log(CLog.LL_INF, "getExportURLCsvSelectedRows: " + this.i_exporterCSVSelectedRows.getURL());
            return this.i_exporterCSVSelectedRows.getURL();
        }

        public String getExportURLCsvRange() {
            if (this.i_exporterCSVRange == null) {
                this.i_exporterCSVRange = new ExporterCSVRange();
            }
            BufferedContentMgr.add(this.i_exporterCSVRange);
            this.i_clearer.activate();
            CLog.L.log(CLog.LL_INF, "getExportURLCsvRange: " + this.i_exporterCSVRange.getURL());
            return this.i_exporterCSVRange.getURL();
        }

        public String getExportURLXMLWholeGrid() {
            if (this.i_exporterXMLWholeGrid == null) {
                this.i_exporterXMLWholeGrid = new ExporterXMLWholeGrid(false);
            }
            BufferedContentMgr.add(this.i_exporterXMLWholeGrid);
            this.i_clearer.activate();
            CLog.L.log(CLog.LL_INF, "getExportURLXMLWholeGrid: " + this.i_exporterXMLWholeGrid.getURL());
            return this.i_exporterXMLWholeGrid.getURL();
        }

        public String getExportURLXMLSelectedRows() {
            if (this.i_exporterXMLSelectedRows == null) {
                this.i_exporterXMLSelectedRows = new ExporterXMLWholeGrid(true);
            }
            BufferedContentMgr.add(this.i_exporterXMLSelectedRows);
            this.i_clearer.activate();
            CLog.L.log(CLog.LL_INF, "getExportURLXMLSelectedRows: " + this.i_exporterXMLSelectedRows.getURL());
            return this.i_exporterXMLSelectedRows.getURL();
        }

        public String getExportURLXMLRange() {
            if (this.i_exporterXMLRange == null) {
                this.i_exporterXMLRange = new ExporterXMLRange();
            }
            BufferedContentMgr.add(this.i_exporterXMLRange);
            this.i_clearer.activate();
            CLog.L.log(CLog.LL_INF, "getExportURLXMLRange: " + this.i_exporterXMLRange.getURL());
            return this.i_exporterXMLRange.getURL();
        }

        public String getExportURLPDFWholeGrid() {
            if (this.i_exporterPDFWholeGrid == null) {
                this.i_exporterPDFWholeGrid = new ExporterPDFWholeGrid(false);
            }
            BufferedContentMgr.add(this.i_exporterPDFWholeGrid);
            this.i_clearer.activate();
            CLog.L.log(CLog.LL_INF, "getExportURLPDFWholeGrid: " + this.i_exporterPDFWholeGrid.getURL());
            return this.i_exporterPDFWholeGrid.getURL();
        }

        public String getExportURLPDFSelectedRows() {
            if (this.i_exporterPDFSelectedRows == null) {
                this.i_exporterPDFSelectedRows = new ExporterPDFWholeGrid(true);
            }
            BufferedContentMgr.add(this.i_exporterPDFSelectedRows);
            this.i_clearer.activate();
            CLog.L.log(CLog.LL_INF, "getExportURLPDFSelectedRows: " + this.i_exporterPDFSelectedRows.getURL());
            return this.i_exporterPDFSelectedRows.getURL();
        }

        public String getExportURLHTMLWholeGrid() {
            if (this.i_exporterHTMLWholeGrid == null) {
                this.i_exporterHTMLWholeGrid = new ExporterHTMLWholeGrid(false);
            }
            BufferedContentMgr.add(this.i_exporterHTMLWholeGrid);
            this.i_clearer.activate();
            CLog.L.log(CLog.LL_INF, "getExportURLHTMLWholeGrid: " + this.i_exporterPDFWholeGrid.getURL());
            return this.i_exporterHTMLWholeGrid.getURL();
        }

        public String getExportURLHTMLSelectedRows() {
            if (this.i_exporterHTMLSelectedRows == null) {
                this.i_exporterHTMLSelectedRows = new ExporterHTMLWholeGrid(true);
            }
            BufferedContentMgr.add(this.i_exporterHTMLSelectedRows);
            this.i_clearer.activate();
            CLog.L.log(CLog.LL_INF, "getExportURLHTMLSelectedRows: " + this.i_exporterHTMLSelectedRows.getURL());
            return this.i_exporterHTMLSelectedRows.getURL();
        }

        public String getExportURLXLSXWholeGrid() {
            if (this.i_exporterXLSXWholeGrid == null) {
                this.i_exporterXLSXWholeGrid = new ExporterXLSXWholeGrid(false);
            }
            BufferedContentMgr.add(this.i_exporterXLSXWholeGrid);
            this.i_clearer.activate();
            CLog.L.log(CLog.LL_INF, "getExportURLXLSXWholeGrid: " + this.i_exporterXLSXWholeGrid.getURL());
            return this.i_exporterXLSXWholeGrid.getURL();
        }

        public String getExportURLXLSXSelectedRows() {
            if (this.i_exporterXLSXSelectedRows == null) {
                this.i_exporterXLSXSelectedRows = new ExporterXLSXWholeGrid(true);
            }
            BufferedContentMgr.add(this.i_exporterXLSXSelectedRows);
            this.i_clearer.activate();
            CLog.L.log(CLog.LL_INF, "getExportURLXLSXSelectedRows: " + this.i_exporterXLSXSelectedRows.getURL());
            return this.i_exporterXLSXSelectedRows.getURL();
        }

        public String getExportURLODSWholeGrid() {
            if (this.i_exporterODSWholeGrid == null) {
                this.i_exporterODSWholeGrid = new ExporterODSWholeGrid(false);
            }
            BufferedContentMgr.add(this.i_exporterODSWholeGrid);
            this.i_clearer.activate();
            CLog.L.log(CLog.LL_INF, "getExportURLODSWholeGrid: " + this.i_exporterODSWholeGrid.getURL());
            return this.i_exporterODSWholeGrid.getURL();
        }

        public String getExportURLODSSelectedRows() {
            if (this.i_exporterODSSelectedRows == null) {
                this.i_exporterODSSelectedRows = new ExporterODSWholeGrid(true);
            }
            BufferedContentMgr.add(this.i_exporterODSSelectedRows);
            this.i_clearer.activate();
            CLog.L.log(CLog.LL_INF, "getExportURLODSSelectedRows: " + this.i_exporterODSSelectedRows.getURL());
            return this.i_exporterODSSelectedRows.getURL();
        }

        public List<List> exportToObjectListWholeGrid(boolean selectedRowsOnly) {
            try {
                ArrayList<List> result = new ArrayList<List>();
                List items = FIXGRIDBinding.this.getListOfExportItems();
                List<FIXGRIDComponent.ColumnInfo> columns = FIXGRIDBinding.this.getExportableColumns(true);
                for (FIXGRIDItem item : items) {
                    if (selectedRowsOnly && !item.getSelected()) continue;
                    ArrayList<Object> rowResult = new ArrayList<Object>();
                    result.add(rowResult);
                    FIXGRIDBinding.this.setToBeAccessedNode(item);
                    for (FIXGRIDComponent.ColumnInfo column : columns) {
                        Object value = FIXGRIDBinding.this.getToBeAccessedNodeValue(column.getExportReference());
                        rowResult.add(value);
                    }
                }
                return result;
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Error happened during String export", t);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<List<FormattedValue>> exportToFormattedValueList(boolean selectedRowsOnly) {
            ReentrantLock syncher = this.findSyncherForCurrentDialogSession();
            try {
                syncher.lock();
                ArrayList result = new ArrayList();
                List items = FIXGRIDBinding.this.getListOfExportItems();
                List<FIXGRIDComponent.ColumnInfo> columns = FIXGRIDBinding.this.getExportableColumns(true);
                for (FIXGRIDItem item : items) {
                    if (selectedRowsOnly && !item.getSelected()) continue;
                    ArrayList<FormattedValue> rowResult = new ArrayList<FormattedValue>();
                    result.add(rowResult);
                    FIXGRIDBinding.this.setToBeAccessedNode(item);
                    for (FIXGRIDComponent.ColumnInfo column : columns) {
                        FormattedValue value = FIXGRIDBinding.this.getToBeAccessedNodeFormattedValue(column, FIXGRIDComponent.READTYPE.EXPORT);
                        rowResult.add(value);
                    }
                }
                ArrayList arrayList = result;
                syncher.unlock();
                return arrayList;
            }
            catch (Throwable throwable) {
                try {
                    syncher.unlock();
                    throw throwable;
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_ERR, "Error happened during String export", t);
                    return null;
                }
            }
        }

        private ReentrantLock findSyncherForCurrentDialogSession() {
            try {
                return ThreadingSynchronization.instance().getSynchObject(HttpSessionAccess.getCurrentDialogSession());
            }
            catch (Throwable t) {
                return new ReentrantLock(true);
            }
        }

        public List<List<String>> exportToStringListHeader() {
            if (FIXGRIDBinding.this.m_connectedBinding == null) {
                return this.getFooterHeaderRows(false);
            }
            List<List<String>> res1 = this.getFooterHeaderRows(false);
            List<List<String>> res2 = FIXGRIDBinding.this.m_connectedBinding.getExporter().getFooterHeaderRows(false);
            return this.combineStringLists(res1, res2);
        }

        public List<List<FormattedValue>> exportToValueListHeader() {
            if (FIXGRIDBinding.this.m_connectedBinding == null) {
                return this.getFooterHeaderRowValues(false);
            }
            List<List<FormattedValue>> res1 = this.getFooterHeaderRowValues(false);
            List<List<FormattedValue>> res2 = FIXGRIDBinding.this.m_connectedBinding.getExporter().getFooterHeaderRowValues(false);
            return this.combineFormattedValueLists(res1, res2);
        }

        public List<List<String>> exportToStringListFooter() {
            if (FIXGRIDBinding.this.m_connectedBinding == null) {
                return this.getFooterHeaderRows(true);
            }
            List<List<String>> res1 = this.getFooterHeaderRows(true);
            List<List<String>> res2 = FIXGRIDBinding.this.m_connectedBinding.getExporter().getFooterHeaderRows(true);
            return this.combineStringLists(res1, res2);
        }

        public List<List<FormattedValue>> exportToValueListFooter() {
            if (FIXGRIDBinding.this.m_connectedBinding == null) {
                return this.getFooterHeaderRowValues(true);
            }
            List<List<FormattedValue>> res1 = this.getFooterHeaderRowValues(true);
            List<List<FormattedValue>> res2 = FIXGRIDBinding.this.m_connectedBinding.getExporter().getFooterHeaderRowValues(true);
            return this.combineFormattedValueLists(res1, res2);
        }

        List<List<String>> combineStringLists(List<List<String>> res1, List<List<String>> res2) {
            int min = res1.size();
            if (res2.size() < min) {
                min = res2.size();
            }
            ArrayList<List<String>> result = new ArrayList<List<String>>();
            for (int i = 0; i < min; ++i) {
                ArrayList<String> r = new ArrayList<String>();
                for (String s : res1.get(i)) {
                    r.add(s);
                }
                for (String s : res2.get(i)) {
                    r.add(s);
                }
                result.add(r);
            }
            return result;
        }

        List<List<FormattedValue>> combineFormattedValueLists(List<List<FormattedValue>> res1, List<List<FormattedValue>> res2) {
            int min = res1.size();
            if (res2.size() < min) {
                min = res2.size();
            }
            ArrayList<List<FormattedValue>> result = new ArrayList<List<FormattedValue>>();
            for (int i = 0; i < min; ++i) {
                ArrayList<FormattedValue> r = new ArrayList<FormattedValue>();
                for (FormattedValue s : res1.get(i)) {
                    r.add(s);
                }
                for (FormattedValue s : res2.get(i)) {
                    r.add(s);
                }
                result.add(r);
            }
            return result;
        }

        List<List<String>> getFooterHeaderRows(boolean footer) {
            return FIXGRIDBinding.this.m_fixgridComponent.getFooterHeaderRows(footer);
        }

        public List<List<FormattedValue>> getFooterHeaderRowValues(boolean footer) {
            return FIXGRIDBinding.this.m_fixgridComponent.getFooterHeaderRowValues(footer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<List<String>> exportToStringListWholeGrid(boolean selectedRowsOnly) {
            ReentrantLock syncher = this.findSyncherForCurrentDialogSession();
            try {
                syncher.lock();
                ArrayList result = new ArrayList();
                List items = FIXGRIDBinding.this.getListOfExportItems();
                List<FIXGRIDComponent.ColumnInfo> columns = FIXGRIDBinding.this.getExportableColumns(true);
                CLog.L.log(CLog.LL_INF, "items.size() = " + items.size());
                CLog.L.log(CLog.LL_INF, "columns.size() = " + columns.size());
                int counter = 0;
                for (FIXGRIDItem item : items) {
                    if (selectedRowsOnly && !item.getSelected()) continue;
                    ArrayList<String> rowResult = new ArrayList<String>();
                    result.add(rowResult);
                    FIXGRIDBinding.this.setToBeAccessedNode(item);
                    CLog.L.log(CLog.LL_INF, "***** FXIGRIDEXPORT: ***** " + counter + " ***** setToBeAccessedNode(item): " + item);
                    for (FIXGRIDComponent.ColumnInfo column : columns) {
                        CLog.L.log(CLog.LL_INF, "***** FXIGRIDEXPORT: column: " + column.getSortreference());
                        String value = FIXGRIDBinding.this.getToBeAccessedNodeStringValue(column, FIXGRIDComponent.READTYPE.EXPORT, "", true);
                        rowResult.add(value);
                    }
                    ++counter;
                }
                ArrayList arrayList = result;
                syncher.unlock();
                return arrayList;
            }
            catch (Throwable throwable) {
                try {
                    syncher.unlock();
                    throw throwable;
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_ERR, "Error happened during String export", t);
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<List<String>> exportToStringListRange() {
            ReentrantLock syncher = this.findSyncherForCurrentDialogSession();
            try {
                syncher.lock();
                ArrayList result = new ArrayList();
                List items = FIXGRIDBinding.this.getListOfExportItems();
                List<FIXGRIDComponent.ColumnInfo> columns = FIXGRIDBinding.this.getExportableColumns(true);
                for (FIXGRIDItem item : items) {
                    if (!item.checkIfCellsAreHighlighted()) continue;
                    ArrayList<String> rowResult = new ArrayList<String>();
                    FIXGRIDBinding.this.setToBeAccessedNode(item);
                    for (FIXGRIDComponent.ColumnInfo column : columns) {
                        if (!item.checkIfCellIsHighlighted(column.getColumn())) continue;
                        String value = FIXGRIDBinding.this.getToBeAccessedNodeStringValue(column, FIXGRIDComponent.READTYPE.EXPORT, "", true);
                        rowResult.add(value);
                    }
                    if (rowResult.size() <= 0) continue;
                    result.add(rowResult);
                }
                ArrayList arrayList = result;
                syncher.unlock();
                return arrayList;
            }
            catch (Throwable throwable) {
                try {
                    syncher.unlock();
                    throw throwable;
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_ERR, "Error happened during String export", t);
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<List<Object>> exportToObjectListRange() {
            ReentrantLock syncher = this.findSyncherForCurrentDialogSession();
            try {
                syncher.lock();
                ArrayList result = new ArrayList();
                List items = FIXGRIDBinding.this.getListOfExportItems();
                List<FIXGRIDComponent.ColumnInfo> columns = FIXGRIDBinding.this.getExportableColumns(true);
                for (FIXGRIDItem item : items) {
                    if (!item.checkIfCellsAreHighlighted()) continue;
                    ArrayList<Object> rowResult = new ArrayList<Object>();
                    FIXGRIDBinding.this.setToBeAccessedNode(item);
                    for (FIXGRIDComponent.ColumnInfo column : columns) {
                        if (!item.checkIfCellIsHighlighted(column.getColumn())) continue;
                        Object value = FIXGRIDBinding.this.getToBeAccessedNodeValue(column.getExportReference());
                        rowResult.add(value);
                    }
                    if (rowResult.size() <= 0) continue;
                    result.add(rowResult);
                }
                ArrayList arrayList = result;
                syncher.unlock();
                return arrayList;
            }
            catch (Throwable throwable) {
                try {
                    syncher.unlock();
                    throw throwable;
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_ERR, "Error happened during String export", t);
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String exportToTabSeparatedStringRange() {
            try {
                this.i_exportJustRunning = true;
                StringBuffer result = new StringBuffer();
                List<List<String>> items = this.exportToStringListRange();
                FIXGRIDExportSanitizer.instance().sanitizeStringDataBeforeExport(ENUMExportType.TAB, items);
                this.appendToStringBufferTAB(result, items, false);
                String string = result.toString();
                return string;
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Error happened during TAB range export", t);
                String string = null;
                return string;
            }
            finally {
                this.i_exportJustRunning = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String exportToTabSeparatedStringWholeGrid(boolean selectedRowsOnly) {
            try {
                this.i_exportJustRunning = true;
                StringBuffer result = new StringBuffer();
                List<List<String>> headers = this.exportToStringListHeader();
                FIXGRIDExportSanitizer.instance().sanitizeStringDataBeforeExport(ENUMExportType.TAB, headers);
                this.appendToStringBufferTAB(result, headers, true);
                result.append("\r\n");
                List<List<String>> values = this.exportToStringListWholeGrid(selectedRowsOnly);
                FIXGRIDExportSanitizer.instance().sanitizeStringDataBeforeExport(ENUMExportType.TAB, values);
                this.appendToStringBufferTAB(result, values, false);
                List<List<String>> footers = this.exportToStringListFooter();
                FIXGRIDExportSanitizer.instance().sanitizeStringDataBeforeExport(ENUMExportType.TAB, footers);
                if (footers.size() > 0) {
                    result.append("\r\n");
                }
                this.appendToStringBufferTAB(result, footers, false);
                String string = result.toString();
                return string;
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Error happened during TAB export", t);
                String string = null;
                return string;
            }
            finally {
                this.i_exportJustRunning = false;
            }
        }

        private void appendToStringBufferTAB(StringBuffer result, List<List<String>> values, boolean withPlaceHolderReplacement) {
            for (List<String> row : values) {
                int colCounter = 0;
                for (String value : row) {
                    if (colCounter != 0) {
                        result.append("\t");
                    }
                    if (withPlaceHolderReplacement && FIXGRIDBinding.EXPORT_COLUMNHEADER_PLACEHOLDER.equals(value)) {
                        value = "";
                    }
                    result.append(value);
                    ++colCounter;
                }
                result.append("\r\n");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String exportToCSVStringRange() {
            try {
                this.i_exportJustRunning = true;
                StringBuffer result = new StringBuffer();
                List<List<String>> items = this.exportToStringListRange();
                FIXGRIDExportSanitizer.instance().sanitizeStringDataBeforeExport(ENUMExportType.CSV, items);
                FIXGRIDCsvExporter.appendToStringBufferCSV(result, items, false, ";");
                String string = result.toString();
                return string;
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Error happened during TAB range export", t);
                String string = null;
                return string;
            }
            finally {
                this.i_exportJustRunning = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String exportToCSVStringWholeGrid(boolean selectedRowsOnly) {
            try {
                this.i_exportJustRunning = true;
                String string = this.getCsvExporter().exportGrid(FIXGRIDBinding.this, selectedRowsOnly);
                return string;
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Error happened during CSV export", t);
                String string = null;
                return string;
            }
            finally {
                this.i_exportJustRunning = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] exportToXMLWholeGrid(boolean selectedRowsOnly) {
            try {
                this.i_exportJustRunning = true;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, SystemXml.getFixgridExportCharacterSetXML());
                String bom = SystemXml.getFixgridExportHexBomXML();
                if (bom != null && bom.length() > 0) {
                    bos.write(ValueManager.decodeHexString(bom));
                }
                String xml = this.getXmlExporter().exportGrid(FIXGRIDBinding.this.m_this, selectedRowsOnly);
                writer.write(xml);
                writer.close();
                bos.close();
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Error happened during XML export", t);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            finally {
                this.i_exportJustRunning = false;
            }
        }

        private void appendToWriterXML(Writer writer, List<List<String>> items, String rowtag, boolean withPlaceHolderReplacement) throws Exception {
            for (List<String> item : items) {
                XMLWriter.writer_startElement(writer, null, rowtag);
                XMLWriter.writer_closeStartElement(writer, null);
                for (String value : item) {
                    if (withPlaceHolderReplacement && FIXGRIDBinding.EXPORT_COLUMNHEADER_PLACEHOLDER.equals(value)) {
                        value = "";
                    }
                    XMLWriter.writer_startElement(writer, null, "cell");
                    XMLWriter.writer_closeStartElementWithoutLineFeed(writer, null);
                    XMLWriter.writer_writeText(writer, null, value);
                    XMLWriter.writer_endElement(writer, null, "cell");
                }
                XMLWriter.writer_endElement(writer, null, rowtag);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] exportToXMLRange() {
            try {
                this.i_exportJustRunning = true;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                String bom = SystemXml.getFixgridExportHexBomXML();
                if (bom != null && bom.length() > 0) {
                    bos.write(ValueManager.decodeHexString(bom));
                }
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, SystemXml.getFixgridExportCharacterSetXML());
                List<List<String>> items = this.exportToStringListRange();
                FIXGRIDExportSanitizer.instance().sanitizeStringDataBeforeExport(ENUMExportType.XML, items);
                XMLWriter.writer_startElement(writer, null, "griddata");
                XMLWriter.writer_closeStartElement(writer, null);
                this.appendToWriterXML(writer, items, "row", false);
                XMLWriter.writer_endElement(writer, null, "griddata");
                writer.close();
                bos.close();
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Error happened during XML export", t);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            finally {
                this.i_exportJustRunning = false;
            }
        }

        public IFIXGRIDHtmlExporter getHtmlExporter() {
            if (this.i_htmlExporter == null) {
                try {
                    this.i_htmlExporter = (IFIXGRIDHtmlExporter)CCConfigurationObjectLoader.instance().loadInstance(SystemXml.getFixgridHtmlExport(), true);
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_ERR, "Could not create instance of html exporter: " + SystemXml.getFixgridHtmlExport(), t);
                    CLog.L.log(CLog.LL_ERR, "Now using the default implementation");
                    this.i_htmlExporter = new FIXGRIDHtmlExporter();
                }
            }
            return this.i_htmlExporter;
        }

        public void setHtmlExporter(IFIXGRIDHtmlExporter htmlExporter) {
            this.i_htmlExporter = htmlExporter;
        }

        public IFIXGRIDPdfExporter getPDFExporter() {
            if (this.i_pdfExporter == null) {
                try {
                    this.i_pdfExporter = (IFIXGRIDPdfExporter)CCConfigurationObjectLoader.instance().loadInstance(SystemXml.getFixgridPdfExport(), true);
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_ERR, "Could not create instance of pdf exporter: " + SystemXml.getFixgridPdfExport(), t);
                    CLog.L.log(CLog.LL_ERR, "Now using the default implementation");
                    this.i_pdfExporter = new FIXGRIDPDFExporter();
                }
            }
            return this.i_pdfExporter;
        }

        public void setPDFExporter(IFIXGRIDPdfExporter pdfExporter) {
            this.i_pdfExporter = pdfExporter;
        }

        public IFIXGRIDCsvExporter getCsvExporter() {
            if (this.i_csvExporter == null) {
                try {
                    this.i_csvExporter = (IFIXGRIDCsvExporter)CCConfigurationObjectLoader.instance().loadInstance(SystemXml.getFixgridCsvExport(), true);
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_ERR, "Could not create instance of csv exporter: " + SystemXml.getFixgridCsvExport(), t);
                    CLog.L.log(CLog.LL_ERR, "Now using the default implementation");
                    this.i_csvExporter = new FIXGRIDCsvExporter();
                }
            }
            return this.i_csvExporter;
        }

        public void setCsvExporter(IFIXGRIDCsvExporter csvExporter) {
            this.i_csvExporter = csvExporter;
        }

        public IFIXGRIDXmlExporter getXmlExporter() {
            if (this.i_xmlExporter == null) {
                try {
                    this.i_xmlExporter = (IFIXGRIDXmlExporter)CCConfigurationObjectLoader.instance().loadInstance(SystemXml.getFixgridXmlExport(), true);
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_ERR, "Could not create instance of xml exporter: " + SystemXml.getFixgridXmlExport(), t);
                    CLog.L.log(CLog.LL_ERR, "Now using the default implementation");
                    this.i_xmlExporter = new FIXGRIDXmlExporter();
                }
            }
            return this.i_xmlExporter;
        }

        public void setXmlExporter(IFIXGRIDXmlExporter xmlExporter) {
            this.i_xmlExporter = xmlExporter;
        }

        public IFIXGRIDExcelExporter getExcelExporter() {
            if (this.i_excelExporter == null) {
                try {
                    this.i_excelExporter = (IFIXGRIDExcelExporter)CCConfigurationObjectLoader.instance().loadInstance(SystemXml.getFixgridExcelExport(), true);
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_ERR, "Could not create instance of excel exporter: " + SystemXml.getFixgridExcelExport(), t);
                    CLog.L.log(CLog.LL_ERR, "Now using the dummy implementation");
                    this.i_excelExporter = new FIXGRIDDummyExcelExporter();
                }
            }
            return this.i_excelExporter;
        }

        public void setExcelExporter(IFIXGRIDExcelExporter excelExporter) {
            this.i_excelExporter = excelExporter;
        }

        public IFIXGRIDOdsExporter getOdsExporter() {
            if (this.i_odsExporter == null) {
                try {
                    this.i_odsExporter = (IFIXGRIDOdsExporter)CCConfigurationObjectLoader.instance().loadInstance(SystemXml.getFixgridOdsExport(), true);
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_ERR, "Could not create instance of ods exporter: " + SystemXml.getFixgridOdsExport(), t);
                    CLog.L.log(CLog.LL_ERR, "Now using the dummy implementation");
                    this.i_odsExporter = new FIXGRIDDummyOdsExporter();
                }
            }
            return this.i_odsExporter;
        }

        public void setOdsExporter(IFIXGRIDOdsExporter odsExporter) {
            this.i_odsExporter = odsExporter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] exportToPDFWholeGrid(boolean selectedRowsOnly) {
            try {
                this.i_exportJustRunning = true;
                byte[] byArray = this.getPDFExporter().exportGridToPdf(FIXGRIDBinding.this.m_this, FIXGRIDBinding.this.getExportableColumns(true), this.exportToStringListWholeGrid(selectedRowsOnly), selectedRowsOnly);
                return byArray;
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem occurred during PDF export: " + t.toString(), t);
                byte[] byArray = null;
                return byArray;
            }
            finally {
                this.i_exportJustRunning = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] exportToHTMLWholeGrid(boolean selectedRowsOnly) {
            try {
                this.i_exportJustRunning = true;
                String result = this.getHtmlExporter().exportGridToHtml(FIXGRIDBinding.this.m_this, FIXGRIDBinding.this.getExportableColumns(true), this.exportToStringListWholeGrid(selectedRowsOnly), selectedRowsOnly);
                byte[] byArray = result.getBytes("UTF-8");
                return byArray;
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem occurred during HTML export: " + t.toString(), t);
                byte[] byArray = null;
                return byArray;
            }
            finally {
                this.i_exportJustRunning = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] exportToXLSXWholeGrid(boolean selectedRowsOnly) {
            try {
                this.i_exportJustRunning = true;
                byte[] byArray = this.getExcelExporter().exportGrid(FIXGRIDBinding.this.m_this, FIXGRIDBinding.this.getExportableColumns(true), this.exportToFormattedValueList(selectedRowsOnly), selectedRowsOnly);
                return byArray;
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem occurred during Excel export: " + t.toString(), t);
                byte[] byArray = null;
                return byArray;
            }
            finally {
                this.i_exportJustRunning = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] exportToODSWholeGrid(boolean selectedRowsOnly) {
            try {
                this.i_exportJustRunning = true;
                byte[] byArray = this.getOdsExporter().exportGrid(FIXGRIDBinding.this.m_this, FIXGRIDBinding.this.getExportableColumns(true), this.exportToFormattedValueList(selectedRowsOnly), selectedRowsOnly);
                return byArray;
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem occurred during ODS export: " + t.toString(), t);
                byte[] byArray = null;
                return byArray;
            }
            finally {
                this.i_exportJustRunning = false;
            }
        }

        class Clearer
        implements Runnable {
            boolean i_isRegisteredForNextRoundtrip = false;
            int i_clearExecuteCounter = 0;

            Clearer() {
            }

            @Override
            public void run() {
                CLog.L.log(CLog.LL_INF, "FIXGRID export: Clearer is processed now");
                this.i_isRegisteredForNextRoundtrip = false;
                --this.i_clearExecuteCounter;
                if (this.i_clearExecuteCounter <= 0) {
                    CLog.L.log(CLog.LL_INF, "FIXGRID export: Clearer is executing now");
                    BufferedContentMgr.remove(new IBufferedContent[]{Exporter.this.i_exporterCSVWholeGrid, Exporter.this.i_exporterCSVSelectedRows, Exporter.this.i_exporterCSVRange, Exporter.this.i_exporterXMLWholeGrid, Exporter.this.i_exporterXMLSelectedRows, Exporter.this.i_exporterXMLRange, Exporter.this.i_exporterPDFWholeGrid, Exporter.this.i_exporterPDFSelectedRows, Exporter.this.i_exporterHTMLWholeGrid, Exporter.this.i_exporterHTMLSelectedRows, Exporter.this.i_exporterXLSXWholeGrid, Exporter.this.i_exporterXLSXSelectedRows, Exporter.this.i_exporterODSWholeGrid, Exporter.this.i_exporterODSSelectedRows});
                } else {
                    CLog.L.log(CLog.LL_INF, "FIXGRID export: Clearer not yet executed, counter: " + this.i_clearExecuteCounter);
                    this.waitOneRoundtrip();
                }
            }

            public void activate() {
                if (!this.i_isRegisteredForNextRoundtrip) {
                    PhaseManager.runBeforeUpdatePhase((Runnable)Exporter.this.i_clearer);
                }
                this.i_isRegisteredForNextRoundtrip = true;
                this.i_clearExecuteCounter = 3;
            }

            private void waitOneRoundtrip() {
                if (!this.i_isRegisteredForNextRoundtrip) {
                    PhaseManager.runBeforeUpdatePhase(this);
                }
                this.i_isRegisteredForNextRoundtrip = true;
            }
        }
    }

    class ExporterODSWholeGrid
    extends DefaultBufferedContent {
        boolean i_selecedRowsOnly = false;

        public ExporterODSWholeGrid(boolean selecedRowsOnly) {
            this.i_selecedRowsOnly = selecedRowsOnly;
        }

        @Override
        public byte[] getContent() {
            return FIXGRIDBinding.this.m_exporter().exportToODSWholeGrid(this.i_selecedRowsOnly);
        }

        @Override
        public String getContentType() {
            return CONTENTTYPE_EXPORT_ODS;
        }
    }

    class ExporterXLSXWholeGrid
    extends DefaultBufferedContent {
        boolean i_selecedRowsOnly = false;

        public ExporterXLSXWholeGrid(boolean selecedRowsOnly) {
            this.i_selecedRowsOnly = selecedRowsOnly;
        }

        @Override
        public byte[] getContent() {
            return FIXGRIDBinding.this.m_exporter().exportToXLSXWholeGrid(this.i_selecedRowsOnly);
        }

        @Override
        public String getContentType() {
            return CONTENTTYPE_EXPORT_XLSX;
        }
    }

    class ExporterHTMLWholeGrid
    extends DefaultBufferedContent {
        boolean i_selecedRowsOnly = false;

        public ExporterHTMLWholeGrid(boolean selecedRowsOnly) {
            this.i_selecedRowsOnly = selecedRowsOnly;
        }

        @Override
        public byte[] getContent() {
            return FIXGRIDBinding.this.m_exporter().exportToHTMLWholeGrid(this.i_selecedRowsOnly);
        }

        @Override
        public String getContentType() {
            return CONTENTTYPE_EXPORT_HTML;
        }
    }

    class ExporterPDFWholeGrid
    extends DefaultBufferedContent {
        boolean i_selecedRowsOnly = false;

        public ExporterPDFWholeGrid(boolean selecedRowsOnly) {
            this.i_selecedRowsOnly = selecedRowsOnly;
        }

        @Override
        public byte[] getContent() {
            return FIXGRIDBinding.this.m_exporter().exportToPDFWholeGrid(this.i_selecedRowsOnly);
        }

        @Override
        public String getContentType() {
            return CONTENTTYPE_EXPORT_PDF;
        }
    }

    class ExporterXMLRange
    extends DefaultBufferedContent {
        ExporterXMLRange() {
        }

        @Override
        public byte[] getContent() {
            return FIXGRIDBinding.this.m_exporter().exportToXMLRange();
        }

        @Override
        public String getContentType() {
            return CONTENTTYPE_EXPORT_XML;
        }
    }

    class ExporterXMLWholeGrid
    extends DefaultBufferedContent {
        boolean i_selecedRowsOnly = false;

        public ExporterXMLWholeGrid(boolean selecedRowsOnly) {
            this.i_selecedRowsOnly = selecedRowsOnly;
        }

        @Override
        public byte[] getContent() {
            return FIXGRIDBinding.this.m_exporter().exportToXMLWholeGrid(this.i_selecedRowsOnly);
        }

        @Override
        public String getContentType() {
            return CONTENTTYPE_EXPORT_XML;
        }
    }

    class ExporterCSVRange
    extends DefaultBufferedContent {
        ExporterCSVRange() {
        }

        @Override
        public byte[] getContent() {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                String bom = SystemXml.getFixgridExportHexBomCSV();
                if (bom != null && bom.length() > 0) {
                    bos.write(ValueManager.decodeHexString(bom));
                }
                byte[] bytes = FIXGRIDBinding.this.m_exporter().exportToCSVStringRange().getBytes(SystemXml.getFixgridExportCharacterSetCSV());
                bos.write(bytes);
                bos.close();
                return bos.toByteArray();
            }
            catch (Throwable t) {
                throw new Error("Problem wehn accessing byte[] content for CSV range", t);
            }
        }

        @Override
        public String getContentType() {
            return CONTENTTYPE_EXPORT_CSV;
        }
    }

    class ExporterCSVWholeGrid
    extends DefaultBufferedContent {
        boolean i_selecedRowsOnly = false;

        public ExporterCSVWholeGrid(boolean selecedRowsOnly) {
            this.i_selecedRowsOnly = selecedRowsOnly;
        }

        @Override
        public byte[] getContent() {
            CLog.L.log(CLog.LL_INF, "exporter for whole grid - getContent[] called");
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                String bom = SystemXml.getFixgridExportHexBomCSV();
                if (bom != null && bom.length() > 0) {
                    bos.write(ValueManager.decodeHexString(bom));
                }
                byte[] bytes = FIXGRIDBinding.this.m_exporter().exportToCSVStringWholeGrid(this.i_selecedRowsOnly).getBytes(SystemXml.getFixgridExportCharacterSetCSV());
                bos.write(bytes);
                bos.close();
                return bos.toByteArray();
            }
            catch (Throwable t) {
                throw new Error("Problem wehn accessing byte[] content for CSV", t);
            }
        }

        @Override
        public String getContentType() {
            return CONTENTTYPE_EXPORT_CSV;
        }
    }

    public class SortInfoHashMap
    extends HashMap<String, IFIXGRIDBinding.FIXGRIDSortInfo> {
        @Override
        public IFIXGRIDBinding.FIXGRIDSortInfo get(Object key) {
            IFIXGRIDBinding.FIXGRIDSortInfo result = (IFIXGRIDBinding.FIXGRIDSortInfo)super.get(key);
            if (result == null) {
                result = DUMMY_FIXGRIDSORTINFO;
            }
            return result;
        }
    }

    public class TextSearcher
    implements Serializable {
        String i_text;
        boolean i_foundNextRow = false;
        String i_searchResult;
        boolean i_caseSensitive = false;
        boolean i_showSearchInfoPopup = FIXGRIDBinding.access$000();

        public void setShowSearchInfoPopup(boolean showSearchInfoPopup) {
            this.i_showSearchInfoPopup = showSearchInfoPopup;
        }

        public void onNext(ActionEvent event) {
            this.search(true);
        }

        public void onPrevious(ActionEvent event) {
            this.search(false);
        }

        public void search(boolean dirNext) {
            try {
                this.i_searchResult = null;
                if (this.i_text == null || this.i_text.trim().length() == 0) {
                    return;
                }
                Object selectedItem = FIXGRIDBinding.this.getSelectedItem();
                boolean startFromScratch = false;
                if (selectedItem == null) {
                    startFromScratch = true;
                }
                List items = FIXGRIDBinding.this.getListOfItems();
                FIXGRIDBinding.this.deselectCurrentSelection();
                SearchInfo searchInfo = this.findNextSearchInfo((FIXGRIDItem)selectedItem, dirNext);
                SearchInfo connSearchInfo = null;
                if (FIXGRIDBinding.this.m_connectedBinding != null) {
                    try {
                        TextSearcher connTextSearcher = FIXGRIDBinding.this.m_connectedBinding.getTextSearcher();
                        connTextSearcher.i_text = this.i_text;
                        connTextSearcher.i_caseSensitive = this.i_caseSensitive;
                        connSearchInfo = FIXGRIDBinding.this.m_connectedBinding.getTextSearcher().findNextSearchInfo((FIXGRIDItem)selectedItem, dirNext);
                        if (connSearchInfo != null && (searchInfo == null || searchInfo.i_distance > connSearchInfo.i_distance)) {
                            FIXGRIDBinding.this.m_connectedBinding.getTextSearcher().showSearchInfo(connSearchInfo, startFromScratch);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.showSearchInfo(searchInfo, startFromScratch);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Error during text search", t);
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        protected void showSearchInfo(SearchInfo searchInfo, boolean startFromScratch) {
            if (searchInfo != null) {
                FIXGRIDBinding.this.selectItem(searchInfo.i_item);
                FIXGRIDBinding.this.ensureItemToBeDisplayed(searchInfo.i_item);
            } else {
                this.i_foundNextRow = true;
                if (startFromScratch) {
                    this.showSearchInfoNothingFound();
                } else {
                    this.showSearchInfoNoFurtherHits();
                }
            }
            ThreadData.getInstance().registerChangeUpdatingAllAreas();
        }

        protected void showSearchInfoNothingFound() {
            this.i_searchResult = new I18N().get("GRID_searchnothingfound");
            if (this.i_showSearchInfoPopup) {
                OKPopup okp = OKPopup.createInstance("", this.i_searchResult);
                okp.getModalPopup().setStartfromrootwindow(false);
            }
        }

        protected void showSearchInfoNoFurtherHits() {
            this.i_searchResult = new I18N().get("GRID_searchnofurtherhits");
            if (this.i_showSearchInfoPopup) {
                OKPopup okp = OKPopup.createInstance("", this.i_searchResult);
                okp.getModalPopup().setStartfromrootwindow(false);
            }
        }

        protected List<itemClass> findListOfItemsForSearch() {
            return FIXGRIDBinding.this.getListOfItems();
        }

        protected org.eclnt.jsfserver.elements.impl.FIXGRIDBinding$TextSearcher.SearchInfo findNextSearchInfo(FIXGRIDItem selectedItem, boolean dirNext) {
            int startIndex;
            SearchInfo result = null;
            List items = this.findListOfItemsForSearch();
            List<FIXGRIDComponent.ColumnInfo> columns = FIXGRIDBinding.this.m_fixgridComponent.getColumns(FIXGRIDBinding.this.m_columnsequence);
            boolean foundText = false;
            int distance = 0;
            if (selectedItem != null) {
                startIndex = items.indexOf(selectedItem);
                startIndex = dirNext ? ++startIndex : --startIndex;
            } else {
                startIndex = dirNext ? 0 : items.size() - 1;
            }
            int i = startIndex;
            String compareText = this.i_text;
            if (!this.i_caseSensitive) {
                compareText = ValueManager.toLowerCaseText(compareText);
            }
            while (true) {
                ++distance;
                if (i >= items.size() || i < 0) break;
                FIXGRIDItem item = (FIXGRIDItem)items.get(i);
                FIXGRIDBinding.this.setToBeAccessedNode(item);
                StringBuffer rowSb = new StringBuffer();
                for (FIXGRIDComponent.ColumnInfo ci : columns) {
                    String unitTextValue;
                    String value = FIXGRIDBinding.this.getToBeAccessedNodeStringValue(ci, FIXGRIDComponent.READTYPE.EXPORT, null, true);
                    if (value != null && (unitTextValue = FIXGRIDBinding.this.getToBeAccessedNodeUnitValue(ci)) != null) {
                        value = value + " " + unitTextValue;
                    }
                    if (value == null) continue;
                    rowSb.append(" " + value);
                }
                String rowText = rowSb.toString();
                if (!this.i_caseSensitive) {
                    rowText = ValueManager.toLowerCaseText(rowText);
                }
                if (ValueManager.checkIfStringMatchesSearchStringAND(rowText, compareText, this.i_caseSensitive)) {
                    result = new SearchInfo(i, item, distance);
                    break;
                }
                if (dirNext) {
                    ++i;
                    continue;
                }
                --i;
            }
            return result;
        }

        public void setText(String value) {
            this.i_text = value;
        }

        public String getText() {
            return this.i_text;
        }

        public String getSearchResult() {
            return this.i_searchResult;
        }

        public void clearSearchResult() {
            this.i_searchResult = null;
            this.i_foundNextRow = false;
        }

        public boolean getCaseSensitive() {
            return this.i_caseSensitive;
        }

        public void setCaseSensitive(boolean value) {
            this.i_caseSensitive = value;
        }

        public boolean getFoundNextRow() {
            return this.i_foundNextRow;
        }

        class SearchInfo {
            int i_itemIndex;
            int i_distance;
            FIXGRIDItem i_item;

            @Deprecated
            public SearchInfo(int itemIndex, FIXGRIDItem item, FIXGRIDComponent.ColumnInfo column, int distance) {
                this.i_itemIndex = itemIndex;
                this.i_item = item;
                this.i_distance = distance;
            }

            public SearchInfo(int itemIndex, FIXGRIDItem item, int distance) {
                this.i_itemIndex = itemIndex;
                this.i_item = item;
                this.i_distance = distance;
            }
        }
    }

    public static class FormattedValue {
        Object i_value;
        String i_format;
        String i_formatmask;
        String i_timezone;
        String i_align;

        public FormattedValue() {
        }

        public FormattedValue(Object value) {
            this.i_value = value;
        }

        public FormattedValue(Object value, String format, String formatmask, String timezone, String align) {
            this.i_value = value;
            this.i_format = format;
            this.i_formatmask = formatmask;
            this.i_timezone = timezone;
            this.i_align = align;
        }

        public Object getValue() {
            return this.i_value;
        }

        public String getFormat() {
            return this.i_format;
        }

        public String getFormatmask() {
            return this.i_formatmask;
        }

        public String getTimezone() {
            return this.i_timezone;
        }

        public String getAlign() {
            return this.i_align;
        }

        public void setValue(Object value) {
            this.i_value = value;
        }

        public void setFormat(String format) {
            this.i_format = format;
        }

        public void setFormatmask(String formatmask) {
            this.i_formatmask = formatmask;
        }

        public void setTimezone(String timezone) {
            this.i_timezone = timezone;
        }

        public void setAlign(String align) {
            this.i_align = align;
        }

        public String toString() {
            return ValueManager.convertObject2ValueString(this.i_value);
        }

        public String toDisplayString() {
            return ValueManager.convertObject2DisplayString(this.i_value, this.i_format, this.i_formatmask, this.i_timezone, false, false);
        }
    }
}

