/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import org.eclnt.jsfserver.elements.BaseComponent;
import org.eclnt.jsfserver.elements.ICCComponentProperties;
import org.eclnt.jsfserver.elements.impl.FIXGRIDComponent;
import org.eclnt.jsfserver.elements.impl.GRIDCOLComponent;
import org.eclnt.jsfserver.elements.impl.GRIDCOLGROUPComponent;
import org.eclnt.jsfserver.elements.impl.GRIDHEADERComponent;
import org.eclnt.jsfserver.elements.impl.GRIDHEADERComponentTag;
import org.eclnt.jsfserver.elements.impl.GRIDHEADERLABELComponentTag;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class FIXGRIDWITHGROUPINGComponent
extends FIXGRIDComponent
implements ICCComponentProperties {
    int m_numberOfLevels = -1;
    List<List<GRIDCOLGROUPComponent>> m_gridColGroupsPerLevel = new ArrayList<List<GRIDCOLGROUPComponent>>();
    Map<String, GRIDCOLGROUPInfo> m_groupInfos = new HashMap<String, GRIDCOLGROUPInfo>();
    Map<String, String> m_gridColIdToGroupId = new HashMap<String, String>();
    List<GRIDCOLComponent> m_gridColComponents = new ArrayList<GRIDCOLComponent>();
    Map<String, List<String>> m_headerRowColGroups = new HashMap<String, List<String>>();

    @Override
    protected void prepareComponentWithinEncodeBegin() {
        super.prepareComponentWithinEncodeBegin();
        this.m_numberOfLevels = -1;
        this.m_gridColGroupsPerLevel.clear();
        this.m_gridColComponents.clear();
        this.collectGRIDCOLComponents(this, this.m_gridColComponents, 0);
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            UIComponent childComponent = this.getChild(i);
            if (!(childComponent instanceof GRIDCOLGROUPComponent)) continue;
            this.getChildren().remove(i);
        }
        for (GRIDCOLComponent gridColComponent : this.m_gridColComponents) {
            this.getChildren().add(gridColComponent);
        }
        for (int i = 0; i < this.m_numberOfLevels; ++i) {
            GRIDHEADERComponentTag ghct = new GRIDHEADERComponentTag();
            ArrayList<String> colGroups = new ArrayList<String>();
            ghct.setId(this.createSubId("LEVEL" + i));
            ghct.setBeforedefaultheader("true");
            BaseComponent ghcc = ghct.createBaseComponent();
            ((GRIDHEADERComponent)ghcc).setCreatedByGrouping(true);
            List<GRIDCOLGROUPComponent> gcgcs = this.m_gridColGroupsPerLevel.get(i);
            for (GRIDCOLGROUPComponent gcgc : gcgcs) {
                GRIDCOLGROUPInfo groupInfo = this.m_groupInfos.get(gcgc.getId());
                int colspan = groupInfo.getNumberOfContainedColumns();
                GRIDHEADERLABELComponentTag labelt = new GRIDHEADERLABELComponentTag();
                this.passGridColGroupIntoHeaderLabel(gcgc, labelt);
                labelt.setColspan("" + colspan);
                labelt.setSortenabled("false");
                labelt.setColumnresizingenabled("false");
                if ("false".equals(this.m_bufferedColumnDragDropEnabled)) {
                    labelt.setDragdropenabled("false");
                }
                BaseComponent labelc = labelt.createBaseComponent();
                ghcc.getChildren().add(labelc);
                colGroups.add(gcgc.getId());
            }
            this.getChildren().add(i, ghcc);
            this.m_headerRowColGroups.put(ghcc.getId(), colGroups);
        }
    }

    protected void passGridColGroupIntoHeaderLabel(GRIDCOLGROUPComponent gcgc, GRIDHEADERLABELComponentTag labelt) {
        labelt.setAccessiblename(gcgc.getAttributeString(ATT_accessiblename));
        labelt.setAttributemacro(gcgc.getAttributeString(ATT_attributemacro));
        labelt.setText(gcgc.getAttributeString(ATT_text));
        labelt.setTextabbreviation(gcgc.getAttributeString(ATT_textabbreviation));
        labelt.setMultiline(gcgc.getAttributeString(ATT_multiline));
        labelt.setImage(gcgc.getAttributeString(ATT_image));
        labelt.setBackground(gcgc.getAttributeString(ATT_background));
        labelt.setBgpaint(gcgc.getAttributeString(ATT_bgpaint));
        labelt.setForeground(gcgc.getAttributeString(ATT_foreground));
        labelt.setFont(gcgc.getAttributeString(ATT_font));
        labelt.setStylevariant(gcgc.getAttributeString(ATT_stylevariant));
        labelt.setAlign(gcgc.getAttributeString(ATT_align));
        labelt.setReference(gcgc.getAttributeString(ATT_REFERENCE));
        labelt.setComment(gcgc.getAttributeString(ATT_COMMENT));
        labelt.setTooltip(gcgc.getAttributeString(ATT_tooltip));
        labelt.setFocusable(gcgc.getAttributeString(ATT_focusable));
        labelt.setTextwidth(gcgc.getAttributeString(ATT_textwidth));
        labelt.setTextcutwidth(gcgc.getAttributeString(ATT_textcutwidth));
        labelt.setUsesmartlabel(gcgc.getAttributeString(ATT_usesmartlabel));
        labelt.setConfiginfo(gcgc.getAttributeString(ATT_configinfo));
        labelt.setStyleseq(gcgc.getAttributeString(ATT_styleseq));
        labelt.setPopupmenu(gcgc.getAttributeString(ATT_popupmenu));
        labelt.setClientname(gcgc.getAttributeString(ATT_clientname));
        labelt.setActionListener(gcgc.getAttributeString(ATT_ACTIONLISTENER));
        labelt.setKeepcellborder(gcgc.getAttributeString(ATT_keepcellborder));
    }

    protected void collectGRIDCOLComponents(BaseComponent parentNode, List<GRIDCOLComponent> result, int parentLevel) {
        if (parentLevel > this.m_numberOfLevels) {
            this.m_gridColGroupsPerLevel.add(new ArrayList());
            this.m_numberOfLevels = parentLevel;
        }
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            UIComponent childComponent = parentNode.getChild(i);
            if (childComponent instanceof GRIDCOLComponent) {
                result.add((GRIDCOLComponent)childComponent);
                this.m_gridColIdToGroupId.put(childComponent.getId(), childComponent.getParent().getId());
                continue;
            }
            if (!(childComponent instanceof GRIDCOLGROUPComponent)) continue;
            this.m_gridColIdToGroupId.put(childComponent.getId(), childComponent.getParent().getId());
            GRIDCOLGROUPInfo groupInfo = new GRIDCOLGROUPInfo();
            for (UIComponent groupChild : childComponent.getChildren()) {
                if (groupChild instanceof GRIDCOLComponent) {
                    groupInfo.i_columns.add((GRIDCOLComponent)groupChild);
                    ((GRIDCOLComponent)groupChild).setColGroup((GRIDCOLGROUPComponent)childComponent);
                    continue;
                }
                if (!(groupChild instanceof GRIDCOLGROUPComponent)) continue;
                groupInfo.i_groups.add((GRIDCOLGROUPComponent)groupChild);
            }
            this.m_groupInfos.put(childComponent.getId(), groupInfo);
            this.collectGRIDCOLComponents((GRIDCOLGROUPComponent)childComponent, result, parentLevel + 1);
            this.m_gridColGroupsPerLevel.get(parentLevel).add((GRIDCOLGROUPComponent)childComponent);
        }
    }

    @Override
    protected String buildDragSendForColumnHeader(BaseComponent headerRow, BaseComponent comp, int colCounter, int childPosition, int numberOfGridColumns) {
        boolean columnMovingEnabled = ValueManager.decodeBoolean(comp.getAttributeValueAsString(ATT_columnmovingenabled), true);
        if (!columnMovingEnabled) {
            return null;
        }
        if (headerRow instanceof GRIDHEADERComponent && !((GRIDHEADERComponent)headerRow).getCreatedByGrouping() && !((GRIDHEADERComponent)headerRow).getCreatedByGrid()) {
            return super.buildDragSendForColumnHeader(headerRow, comp, colCounter, childPosition, numberOfGridColumns);
        }
        if (headerRow.getChildCount() == numberOfGridColumns) {
            GRIDCOLComponent child = this.m_gridColComponents.get(childPosition);
            String groupId = this.m_gridColIdToGroupId.get(child.getId());
            return "gridcol_" + this.m_gridIdCounter + "_" + headerRow.getId() + "_" + groupId + ":" + colCounter;
        }
        try {
            List<String> colGroupIds = this.m_headerRowColGroups.get(headerRow.getId());
            String colGroupId = colGroupIds.get(childPosition);
            String groupId = this.m_gridColIdToGroupId.get(colGroupId);
            return "gridcol_" + this.m_gridIdCounter + "_" + headerRow.getId() + "_" + groupId + ":" + colCounter;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "", t);
            throw new Error(t);
        }
    }

    @Override
    protected String buildDropReceiveForColumnHeader(BaseComponent headerRow, BaseComponent comp, int colCounter, int childPosition, int numberOfGridColumns) {
        if (headerRow instanceof GRIDHEADERComponent && !((GRIDHEADERComponent)headerRow).getCreatedByGrouping() && !((GRIDHEADERComponent)headerRow).getCreatedByGrid()) {
            return super.buildDropReceiveForColumnHeader(headerRow, comp, colCounter, childPosition, numberOfGridColumns);
        }
        if (headerRow.getChildCount() == numberOfGridColumns) {
            GRIDCOLComponent child = this.m_gridColComponents.get(childPosition);
            String groupId = this.m_gridColIdToGroupId.get(child.getId());
            return "gridcol_" + this.m_gridIdCounter + "_" + headerRow.getId() + "_" + groupId + ":horizontalsplit";
        }
        try {
            List<String> colGroupIds = this.m_headerRowColGroups.get(headerRow.getId());
            String colGroupId = colGroupIds.get(childPosition);
            String groupId = this.m_gridColIdToGroupId.get(colGroupId);
            return "gridcol_" + this.m_gridIdCounter + "_" + headerRow.getId() + "_" + groupId + ":horizontalsplit";
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "", t);
            throw new Error(t);
        }
    }

    @Override
    protected String buildCSVBorderWidths() {
        String borderWidthsPerLevel = this.getAttributeValueAsString(ATT_borderwidthsperlevel);
        if (ValueManager.isEmpty(borderWidthsPerLevel)) {
            return super.buildCSVBorderColors();
        }
        int[] rootChangeLevels = this.calculateRootChangeLevels();
        String[] borderWidthsPerLevelValues = ValueManager.decodeCSV(borderWidthsPerLevel);
        List<GRIDCOLComponent> cols = this.getRenderedGridCols();
        List<String> resultList = this.buildStringListForGridColAttribute(ATT_borderwidth, "-1", true);
        int indexDelta = 0;
        if (this.m_selectorcolumn != 0) {
            indexDelta = 1;
        }
        for (int i = 0; i < cols.size(); ++i) {
            GRIDCOLComponent col = cols.get(i);
            int resultIndex = i + indexDelta;
            if (rootChangeLevels[i] < 0 || !"-1".equals(resultList.get(resultIndex)) || borderWidthsPerLevelValues.length <= rootChangeLevels[i]) continue;
            resultList.set(resultIndex, borderWidthsPerLevelValues[rootChangeLevels[i]]);
        }
        return ValueManager.encodeCSV(resultList);
    }

    @Override
    protected String buildCSVBorderColors() {
        String borderColorsPerLevel = this.getAttributeValueAsString(ATT_bordercolorsperlevel);
        if (ValueManager.isEmpty(borderColorsPerLevel)) {
            return super.buildCSVBorderColors();
        }
        int[] rootChangeLevels = this.calculateRootChangeLevels();
        String[] borderColorsPerLevelValues = ValueManager.decodeCSV(borderColorsPerLevel);
        List<GRIDCOLComponent> cols = this.getRenderedGridCols();
        List<String> resultList = this.buildStringListForGridColAttribute(ATT_bordercolor, "", true);
        int indexDelta = 0;
        if (this.m_selectorcolumn != 0) {
            indexDelta = 1;
        }
        for (int i = 0; i < cols.size(); ++i) {
            GRIDCOLComponent col = cols.get(i);
            int resultIndex = i + indexDelta;
            if (rootChangeLevels[i] < 0 || !"".equals(resultList.get(resultIndex)) || borderColorsPerLevelValues.length <= rootChangeLevels[i]) continue;
            resultList.set(resultIndex, borderColorsPerLevelValues[rootChangeLevels[i]]);
        }
        return ValueManager.encodeCSV(resultList);
    }

    private int[] calculateRootChangeLevels() {
        List<GRIDCOLComponent> cols = this.getRenderedGridCols();
        HashMap<Integer, GRIDCOLComponent> colsByVisibleIndex = new HashMap<Integer, GRIDCOLComponent>();
        for (GRIDCOLComponent col : cols) {
            colsByVisibleIndex.put(col.getVisibleIndex(), col);
        }
        int[] rootChangeLevels = new int[cols.size()];
        for (int ii = 0; ii < cols.size(); ++ii) {
            int rootChangeLevel;
            GRIDCOLComponent col = cols.get(ii);
            if (col.getVisibleIndex() >= cols.size() - 1) continue;
            GRIDCOLComponent colRight = (GRIDCOLComponent)colsByVisibleIndex.get(col.getVisibleIndex() + 1);
            rootChangeLevels[ii] = rootChangeLevel = this.calculateRootChangeLevel(colRight, col);
        }
        return rootChangeLevels;
    }

    private int calculateRootChangeLevel(GRIDCOLComponent col1, GRIDCOLComponent col2) {
        String currentCol1Id = col1.getId();
        String currentCol2Id = col2.getId();
        int differenceLevel = -1;
        int level = this.m_numberOfLevels - 1;
        while (level >= 0 && !ValueManager.checkIfStringsAreEqual(currentCol1Id = this.m_gridColIdToGroupId.get(currentCol1Id), currentCol2Id = this.m_gridColIdToGroupId.get(currentCol2Id))) {
            differenceLevel = level--;
        }
        return differenceLevel;
    }

    public class GRIDCOLGROUPInfo {
        List<GRIDCOLGROUPComponent> i_groups = new ArrayList<GRIDCOLGROUPComponent>();
        List<GRIDCOLComponent> i_columns = new ArrayList<GRIDCOLComponent>();

        public int getNumberOfContainedColumns() {
            if (this.i_groups.size() > 0) {
                int result = 0;
                for (GRIDCOLGROUPComponent group : this.i_groups) {
                    GRIDCOLGROUPInfo groupInfo = FIXGRIDWITHGROUPINGComponent.this.m_groupInfos.get(group.getId());
                    result += groupInfo.getNumberOfContainedColumns();
                }
                return result;
            }
            int result = 0;
            for (GRIDCOLComponent gcc : this.i_columns) {
                ++result;
            }
            return result;
        }
    }
}

