/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.event.ActionEvent;
import org.eclnt.jsfserver.elements.impl.FIXGRIDItem;
import org.eclnt.jsfserver.elements.impl.FIXGRIDListBinding;
import org.eclnt.jsfserver.util.valuemgmt.IDynamicContentBindingObject;

public class ROWTLCOCKPITBinding
implements IDynamicContentBindingObject {
    public static final int STATUS_GREEN = 0;
    public static final int STATUS_YELLOW = 1;
    public static final int STATUS_RED = 2;
    private static int NUM_COLUMNS = 3;
    List<CockpitItem> m_items = new ArrayList<CockpitItem>();
    CockpitItem m_selectedItem = null;
    FIXGRIDListBinding<TlgridItem> m_tlgrid = new FIXGRIDListBinding();

    public FIXGRIDListBinding<TlgridItem> getTlgrid() {
        return this.m_tlgrid;
    }

    public void setTlgrid(FIXGRIDListBinding<TlgridItem> value) {
        this.m_tlgrid = value;
    }

    public void addCockpitItem(CockpitItem ci) {
        this.m_items.add(ci);
        int shouldBeSize = this.m_items.size() / 3 + 1;
        if (shouldBeSize > this.m_tlgrid.getItems().size()) {
            TlgridItem tli = new TlgridItem();
            this.m_tlgrid.getItems().add(tli);
        }
    }

    public void clearCockpitItems() {
        this.m_items.clear();
        this.m_selectedItem = null;
        this.m_tlgrid.getItems().clear();
    }

    public void selectCockpitItem(CockpitItem ci) {
        this.m_selectedItem = ci;
        this.onCockpitItemSelect(ci);
    }

    public CockpitItem getSelectedCockpitItem() {
        return this.m_selectedItem;
    }

    public void onCockpitItemSelect(CockpitItem ci) {
    }

    public static class CockpitItem
    implements Serializable {
        int i_status;
        String i_title;
        String i_comment;

        public CockpitItem() {
        }

        public CockpitItem(int status, String title, String comment) {
            this.i_status = status;
            this.i_title = title;
            this.i_comment = comment;
        }

        public int getStatus() {
            return this.i_status;
        }

        public void setStatus(int status) {
            this.i_status = status;
        }

        public String getTitle() {
            return this.i_title;
        }

        public void setTitle(String title) {
            this.i_title = title;
        }

        public String getComment() {
            return this.i_comment;
        }

        public void setComment(String comment) {
            this.i_comment = comment;
        }
    }

    public class TlgridItem
    extends FIXGRIDItem
    implements Serializable {
        int ii_index = -1;

        private int i_index() {
            if (this.ii_index < 0) {
                this.ii_index = ROWTLCOCKPITBinding.this.m_tlgrid.getItems().indexOf(this);
            }
            return this.ii_index;
        }

        public boolean getRendered0() {
            return this.getRendered(0);
        }

        public String getTitle0() {
            return this.getTitle(0);
        }

        public String getComment0() {
            return this.getComment(0);
        }

        public String getImage0() {
            return this.getImage(0);
        }

        public String getBackground0() {
            return this.getBackground(0);
        }

        public void onInvoke0(ActionEvent event) {
            this.onInvoke(0);
        }

        public boolean getRendered1() {
            return this.getRendered(1);
        }

        public String getTitle1() {
            return this.getTitle(1);
        }

        public String getComment1() {
            return this.getComment(1);
        }

        public String getImage1() {
            return this.getImage(1);
        }

        public String getBackground1() {
            return this.getBackground(1);
        }

        public void onInvoke1(ActionEvent event) {
            this.onInvoke(1);
        }

        public boolean getRendered2() {
            return this.getRendered(2);
        }

        public String getTitle2() {
            return this.getTitle(2);
        }

        public String getComment2() {
            return this.getComment(2);
        }

        public String getImage2() {
            return this.getImage(2);
        }

        public String getBackground2() {
            return this.getBackground(2);
        }

        public void onInvoke2(ActionEvent event) {
            this.onInvoke(2);
        }

        public void onInvoke(int index) {
            CockpitItem ci = this.readCockpitItem(index);
            ROWTLCOCKPITBinding.this.selectCockpitItem(ci);
        }

        private boolean getRendered(int index) {
            CockpitItem ci = this.readCockpitItem(index);
            return ci != null;
        }

        private String getTitle(int index) {
            CockpitItem ci = this.readCockpitItem(index);
            if (ci == null) {
                return null;
            }
            return ci.getTitle();
        }

        private String getComment(int index) {
            CockpitItem ci = this.readCockpitItem(index);
            if (ci == null) {
                return null;
            }
            return ci.getComment();
        }

        private String getImage(int index) {
            CockpitItem ci = this.readCockpitItem(index);
            if (ci == null) {
                return null;
            }
            return this.readImage(ci.getStatus());
        }

        private String getBackground(int index) {
            CockpitItem ci = this.readCockpitItem(index);
            if (ci == null) {
                return null;
            }
            if (ROWTLCOCKPITBinding.this.m_selectedItem == ci) {
                switch (ci.i_status) {
                    case 0: {
                        return "#C0FFC050";
                    }
                    case 1: {
                        return "#FFFFC050";
                    }
                    case 2: {
                        return "#FFC0C050";
                    }
                }
            } else {
                switch (ci.i_status) {
                    case 0: {
                        return "#80FF8050";
                    }
                    case 1: {
                        return "#FFFF8050";
                    }
                    case 2: {
                        return "#FF808050";
                    }
                }
            }
            return null;
        }

        private String readImage(int status) {
            if (status == 0) {
                return "/eclntjsfserver/images/trafficlight_green.png";
            }
            if (status == 1) {
                return "/eclntjsfserver/images/trafficlight_yellow.png";
            }
            if (status == 2) {
                return "/eclntjsfserver/images/trafficlight_red.png";
            }
            return null;
        }

        private CockpitItem readCockpitItem(int colIndex) {
            int itemIndex = this.i_index() * NUM_COLUMNS + colIndex;
            if (ROWTLCOCKPITBinding.this.m_items.size() <= itemIndex) {
                return null;
            }
            return ROWTLCOCKPITBinding.this.m_items.get(itemIndex);
        }
    }
}

