/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.macros;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclnt.jsfserver.elements.BaseComponentTag;
import org.eclnt.jsfserver.elements.ComponentRepository;
import org.eclnt.jsfserver.elements.macros.IMacro;
import org.eclnt.jsfserver.util.parse.SAXParserUtil;
import org.eclnt.util.valuemgmt.ValueManager;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLMacro
implements IMacro,
Serializable {
    Set<String> m_applicableTags = new HashSet<String>();
    List<String> m_parameters = new ArrayList<String>();
    Map<String, AttributeInfo> m_attributeInfos = new HashMap<String, AttributeInfo>();
    String m_name;

    public XMLMacro(String name, String xml) {
        this.m_name = name;
        try {
            SAXParserUtil.parse(xml, (DefaultHandler)new MyParser());
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    @Override
    public boolean checkIfApplicable(String tagName) {
        if (this.m_applicableTags.contains(tagName)) {
            return true;
        }
        return this.m_applicableTags.contains("*");
    }

    @Override
    public void executeMacro(BaseComponentTag tag, String[] macroParams) {
        String reference = tag.getAttributeFromAttributeMap("reference");
        ComponentRepository.ComponentInfo ci = ComponentRepository.getInstance(tag.getTagPrefix()).getComponentInfo(tag.getTagName());
        List<String> attributes = ci.getAttibutesInclActions(false);
        for (int i = 0; i < attributes.size(); ++i) {
            String value;
            String attribute = attributes.get(i);
            AttributeInfo attributeInfo = this.m_attributeInfos.get(attribute);
            if (attributeInfo == null || (value = tag.getAttributeFromAttributeMap(attribute)) != null) continue;
            value = attributeInfo.i_value;
            value = this.applyParameters(macroParams, value);
            value = this.applyReference(reference, value);
            value = this.applyReplaceFunction(value);
            tag.setAttributeInAttributeMap(attribute, value);
        }
    }

    @Override
    public boolean checkIfAttributeIsAffected(String attribute) {
        return this.m_attributeInfos.containsKey(attribute);
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String[] getMacroParamNames() {
        String[] result = new String[this.m_parameters.size()];
        this.m_parameters.toArray(result);
        return result;
    }

    private String applyParameters(String[] params, String value) {
        for (int i = 0; i < params.length; ++i) {
            try {
                String paramValue = params[i];
                String paramName = "${" + this.m_parameters.get(i) + "}";
                value = value.replace(paramName, paramValue);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return value;
    }

    private String applyReference(String reference, String value) {
        if (reference == null) {
            return value;
        }
        if (value.indexOf("${ref.") < 0) {
            return value;
        }
        Map<String, String> refs = ValueManager.decodeComplexValue(reference);
        for (String key : refs.keySet()) {
            String val = refs.get(key);
            value = value.replace("${ref." + key + "}", val);
        }
        return value;
    }

    private String applyReplaceFunction(String value) {
        int indexReplace = -1;
        while ((indexReplace = value.indexOf("$replace(", indexReplace + 1)) >= 0) {
            int indexCloseReplace = value.indexOf(41, indexReplace);
            if (indexReplace > indexCloseReplace) {
                return value;
            }
            String method = value.substring(indexReplace, indexCloseReplace + 1);
            String[] params = ValueManager.decodeMethodParams(method);
            if (params.length < 3) continue;
            String from = params[0];
            String to = params[1];
            String in = params[2];
            String newIn = in.replace(from, to);
            value = value.substring(0, indexReplace) + newIn + value.substring(indexCloseReplace + 1);
        }
        return value;
    }

    public class AttributeInfo
    implements Serializable {
        String i_name;
        String i_value;
    }

    public class MyParser
    extends DefaultHandler {
        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("tag")) {
                String tagName = attributes.getValue("name");
                if (tagName.indexOf(58) < 0) {
                    tagName = "t:" + tagName;
                }
                XMLMacro.this.m_applicableTags.add(tagName);
            } else if (name.equals("parameter")) {
                String paramName = attributes.getValue("name");
                XMLMacro.this.m_parameters.add(paramName);
            } else if (name.equals("attribute")) {
                AttributeInfo ai = new AttributeInfo();
                ai.i_name = attributes.getValue("name");
                ai.i_value = attributes.getValue("value");
                XMLMacro.this.m_attributeInfos.put(ai.i_name, ai);
            }
        }
    }
}

