/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.util;

import java.util.ArrayList;
import javax.faces.component.UIComponent;
import javax.faces.event.ActionListener;
import org.eclnt.jsfserver.elements.BaseActionComponent;
import org.eclnt.jsfserver.elements.BaseComponent;
import org.eclnt.jsfserver.elements.BaseComponentTag;
import org.eclnt.jsfserver.elements.ComponentRepository;
import org.eclnt.jsfserver.elements.ICCComponentProperties;

public class ComponentCloneUtil
implements ICCComponentProperties {
    private static String[] GRID_SPECIAL_ATTRIBUTES = new String[]{ATT_gp_action, ATT_gp_actionListener, ATT_gp_rendered};

    public static BaseComponent deepClone(BaseComponent component) {
        try {
            BaseActionComponent actionComponent;
            ActionListener[] actionListeners;
            Class tagClass = ComponentRepository.createComponentTagClass(component.getTagPrefix(), component.getTagName());
            BaseComponentTag bct = (BaseComponentTag)tagClass.newInstance();
            bct.setId(component.getId());
            ArrayList<String> attributes = new ArrayList<String>(component.getPropertiesUsed());
            for (String attribute : attributes) {
                String value = component.getAttributeString(attribute, true);
                bct.setAttributeInAttributeMap(attribute, value);
            }
            for (String attribute : GRID_SPECIAL_ATTRIBUTES) {
                String value = component.getAttributeString(attribute);
                if (value == null) continue;
                bct.setAttributeInAttributeMap(attribute, value);
            }
            if (component instanceof BaseActionComponent && (actionListeners = (actionComponent = (BaseActionComponent)component).getActionListeners()) != null && actionListeners.length > 0) {
                ActionListener al = actionListeners[0];
                String s = al.toString();
                bct.setActionListener(s);
            }
            BaseComponent bc = bct.createBaseComponent();
            ArrayList children = new ArrayList(component.getChildren());
            for (UIComponent child : children) {
                BaseComponent clonedChild = ComponentCloneUtil.deepClone((BaseComponent)child);
                bc.getChildren().add(clonedChild);
            }
            return bc;
        }
        catch (Throwable t) {
            throw new Error("Problem cloning component: " + component.getTagNameWithPrefix() + "/" + component.getId(), t);
        }
    }
}

