/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.managedbean;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import org.eclnt.jsfserver.managedbean.HotDeployClassLoader;
import org.eclnt.jsfserver.managedbean.HotDeployNotifier;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.WebResourceClassloaderReader;
import org.eclnt.jsfserver.util.parse.SAXParserUtil;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.file.EclntConfigFileReader;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HotDeployManager {
    static final String LATEST = "${latest}";
    static final String HOTDEPLOYTRIGGER_NOFILE = "HOTDEPLOYTRIGGER_NOFILE";
    static ClassLoader s_currentParentClassLoader = null;
    static HotDeployManager s_instance;
    static boolean s_processedConfigFileReading;
    static boolean s_hotDeploymentIsActive;
    static List<String> s_webappdirs;
    static List<String> s_dirs;
    static boolean s_createNewHotDeplayManagerInstance;
    static String s_fileURLPrefix;
    static List<String> s_classPathDirectories;
    ClassLoader m_classLoader = null;
    static String s_lastCCTriggerContent;

    private HotDeployManager(boolean duringInitialization) {
        if (!s_hotDeploymentIsActive) {
            this.m_classLoader = HotDeployManager.findCurrentParentClassLoader();
        } else {
            this.m_classLoader = this.buildClassLoader();
            if (!duringInitialization) {
                HotDeployNotifier.notifyNewClassLoader(this.m_classLoader);
            }
        }
    }

    public static void initialize(ServletContext servletContext) {
        int nofXmlFiles = HotDeployManager.initializeExecute(servletContext, -1);
        s_processedConfigFileReading = true;
        HotDeployManager.initializeExecute(servletContext, nofXmlFiles);
    }

    private static int initializeExecute(ServletContext servletContext, int nofXmlFiles) {
        List<String> xmls = EclntConfigFileReader.readConfiguration("hotdeploy", false);
        if (xmls.size() != nofXmlFiles) {
            s_hotDeploymentIsActive = false;
            if (xmls.size() > 0) {
                CLog.L.log(CLog.LL_INF, "Hot deployment initialization: hot deployment management is used.");
            }
            for (String xml : xmls) {
                try {
                    s_hotDeploymentIsActive = true;
                    SAXParserUtil.parse(xml, (DefaultHandler)new HotDeployParser());
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_INF, "Problem when initializing hot deployment:\n" + xml);
                }
            }
            s_instance = new HotDeployManager(true);
        }
        return xmls.size();
    }

    public static void setCurrentParentClassLoader(ClassLoader value) {
        s_currentParentClassLoader = value;
    }

    public static void triggerCreationOfNewInstance() {
        s_createNewHotDeplayManagerInstance = true;
    }

    public static ClassLoader currentClassLoader() {
        try {
            if (s_processedConfigFileReading) {
                return HotDeployManager.currentInstance().m_classLoader;
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem creating new hot deployment class loader", t);
        }
        return HotDeployManager.findCurrentParentClassLoader();
    }

    public static void addClassPathDirectory(String directory) {
        s_classPathDirectories.add(directory);
    }

    public static void removeClassPathDirectory(String directory) {
        s_classPathDirectories.add(directory);
    }

    public static void removeAllClassPathDirectories() {
        s_classPathDirectories.clear();
    }

    public static boolean isHotDeploymentIsActive() {
        return s_hotDeploymentIsActive;
    }

    public static boolean checkIfProjectHotDeployClassesInTimestampedDirectory() {
        return s_webappdirs.contains("/eclnthotdeploy/${latest}/classes/");
    }

    public static boolean checkIfProjectHotDeployLibsInTimestampedDirectory() {
        return s_webappdirs.contains("/eclnthotdeploy/${latest}/lib/");
    }

    public static List<String> findAllWebAppDirs() {
        String dirName;
        String webappDirectory = HotDeployManager.findRealPathWebAppDirectory();
        ArrayList<String> allDirs = new ArrayList<String>();
        for (String webappdir : s_webappdirs) {
            dirName = webappDirectory + webappdir;
            dirName = ValueManager.encodeIntoValidFileName(dirName, false);
            allDirs.add(dirName);
        }
        for (String dir : s_dirs) {
            dirName = ValueManager.encodeIntoValidFileName(dir, false);
            allDirs.add(dirName);
        }
        for (String dir : s_classPathDirectories) {
            dirName = ValueManager.encodeIntoValidFileName(dir, false);
            allDirs.add(dirName);
        }
        return allDirs;
    }

    private ClassLoader buildClassLoader() {
        ArrayList<URL> urls = new ArrayList<URL>();
        List<String> allDirs = HotDeployManager.findAllWebAppDirs();
        HashSet<String> processedDirs = new HashSet<String>();
        Iterator<String> iterator = allDirs.iterator();
        while (iterator.hasNext()) {
            String webappdir;
            String dirName = webappdir = iterator.next();
            dirName = ValueManager.encodeIntoValidFileName(dirName, false);
            if ((dirName = HotDeployManager.replaceLatestInFileName(dirName)) == null || processedDirs.contains(dirName)) continue;
            processedDirs.add(dirName);
            String urlString = s_fileURLPrefix + dirName;
            try {
                urls.add(new URL(urlString));
                CLog.L.log(CLog.LL_INF, "Hotdeploy classloader: added " + urlString);
            }
            catch (MalformedURLException exc) {
                CLog.L.log(CLog.LL_ERR, "Hotdeploy classloader: could not add " + urlString);
            }
            List<File> containedFiles = FileManager.getFilesOfDirectory(dirName);
            for (File file : containedFiles) {
                if (!file.getName().endsWith(".jar")) continue;
                String fileName = dirName + "/" + file.getName();
                fileName = ValueManager.encodeIntoValidFileName(fileName, false);
                urlString = s_fileURLPrefix + fileName;
                try {
                    urls.add(new URL(urlString));
                    CLog.L.log(CLog.LL_INF, "Hotdeploy classloader: added " + urlString);
                }
                catch (MalformedURLException exc) {
                    CLog.L.log(CLog.LL_ERR, "Hotdeploy classloader: could not add " + urlString);
                }
            }
        }
        URL[] urlArray = new URL[urls.size()];
        urls.toArray(urlArray);
        HotDeployClassLoader result = new HotDeployClassLoader(urlArray, HotDeployManager.findCurrentParentClassLoader());
        s_lastCCTriggerContent = HotDeployManager.readContentOfTriggerFile();
        return result;
    }

    private static String findRealPathWebAppDirectory() {
        String webappDirectory = "/webappdirectorynotavailable/";
        try {
            webappDirectory = HttpSessionAccess.getServletContext().getRealPath("/");
            webappDirectory = ValueManager.encodeIntoValidFileName(webappDirectory, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return webappDirectory;
    }

    private static HotDeployManager currentInstance() {
        if (!s_hotDeploymentIsActive) {
            return s_instance;
        }
        if (s_createNewHotDeplayManagerInstance) {
            s_createNewHotDeplayManagerInstance = false;
            if (s_instance != null) {
                System.out.println("");
                String s = new ClassloaderReader(HotDeployManager.class.getClassLoader()).readUTF8File("org/eclnt/jsfserver/managedbean/resources/HOTDEPLOYMENT.txt", true);
                System.out.println(s);
                System.out.println("");
                CLog.L.log(CLog.LL_INF, "\n\n" + s + "\n\n");
            }
            s_instance = new HotDeployManager(false);
        }
        return s_instance;
    }

    public static boolean triggerHotDeployDueToFileTrigger() {
        try {
            if (!s_hotDeploymentIsActive) {
                return false;
            }
            String s = HotDeployManager.readContentOfTriggerFile();
            if (!ValueManager.checkIfStringsAreEqual(s_lastCCTriggerContent, s)) {
                CLog.L.log(CLog.LL_INF, "Hot deployment: change in file /eclnthotdeploy/.cctrigger");
                CLog.L.log(CLog.LL_INF, "Hot deployment: next session will be using new class loader");
                HotDeployManager.triggerCreationOfNewInstance();
                s_lastCCTriggerContent = s;
                return true;
            }
            CLog.L.log(CLog.LL_INF, "Hot deployment: no change in file /eclnthotdeploy/.cctrigger");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static String replaceLatestInFileName(String fileName) {
        int index = fileName.indexOf(LATEST);
        if (index < 0) {
            return fileName;
        }
        CLog.L.log(CLog.LL_INF, "Hot deployment: latest name to be resolved: " + fileName);
        String leftPart = fileName.substring(0, index);
        String rightPart = fileName.substring(index + LATEST.length());
        List<File> subDirs = FileManager.getDirectoriesOfDirectory(leftPart);
        if (subDirs.size() == 0) {
            CLog.L.log(CLog.LL_INF, "Hot deployment: could not resolve - there is not matching directory");
            return null;
        }
        ArrayList<String> subDirNames = new ArrayList<String>();
        for (File subDir : subDirs) {
            subDirNames.add(subDir.getName());
        }
        Collections.sort(subDirNames);
        String latestDirName = (String)subDirNames.get(subDirNames.size() - 1);
        String result = leftPart + latestDirName + rightPart;
        CLog.L.log(CLog.LL_INF, "Hot deployment: resolved: " + result);
        return result;
    }

    public static String testReplaceLatestInFileName(String fileName) {
        return HotDeployManager.replaceLatestInFileName(fileName);
    }

    private static ClassLoader findCurrentParentClassLoader() {
        if (s_currentParentClassLoader != null) {
            return s_currentParentClassLoader;
        }
        return HotDeployManager.class.getClassLoader();
    }

    private static String readContentOfTriggerFile() {
        String s = WebResourceClassloaderReader.readUTF8FileIntoString("/eclnthotdeploy/.cctrigger", false);
        if (s == null) {
            s = HOTDEPLOYTRIGGER_NOFILE;
        }
        return s;
    }

    static {
        s_processedConfigFileReading = false;
        s_hotDeploymentIsActive = false;
        s_webappdirs = new ArrayList<String>();
        s_dirs = new ArrayList<String>();
        s_createNewHotDeplayManagerInstance = false;
        s_fileURLPrefix = "file:///";
        s_classPathDirectories = new ArrayList<String>();
        s_lastCCTriggerContent = null;
    }

    static class HotDeployParser
    extends DefaultHandler {
        HotDeployParser() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("webappdir")) {
                String dirName = attributes.getValue("name");
                if (dirName == null) {
                    return;
                }
                if (!dirName.startsWith("/")) {
                    dirName = "/" + dirName;
                }
                dirName = ValueManager.encodeIntoValidFileName(dirName, true);
                CLog.L.log(CLog.LL_INF, "Hot deployment initialization: adding webappdir: " + dirName);
                s_webappdirs.add(dirName);
            } else if (name.equals("dir")) {
                String dirName = attributes.getValue("name");
                if (dirName == null) {
                    return;
                }
                dirName = ValueManager.replaceSystemProperties(dirName, HttpSessionAccess.getWebApplicationName(), false);
                dirName = ValueManager.encodeIntoValidFileName(dirName, true);
                CLog.L.log(CLog.LL_INF, "Hot deployment initialization: adding dir: " + dirName);
                s_dirs.add(dirName);
            } else if (name.equals("fileurlprefix")) {
                String prefixName = attributes.getValue("name");
                CLog.L.log(CLog.LL_INF, "Hot deployment initialization: using prefix: " + prefixName);
                s_fileURLPrefix = prefixName;
            }
        }
    }
}

