/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.onlinehelp.defaultimpl;

import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.eclnt.jsfserver.onlinehelp.IOnlineHelpReader;
import org.eclnt.jsfserver.onlinehelp.OnlineHelpConfiguration;
import org.eclnt.jsfserver.util.WebResourceClassloaderReader;

public class OnlineHelpReader
implements IOnlineHelpReader {
    @Override
    public IOnlineHelpReader.OnlineHelpText readOnlineHelpText(String helpId, String language) {
        if (!helpId.startsWith("/")) {
            String contentdirectory = OnlineHelpConfiguration.getContentDirectory();
            String fileName = contentdirectory + language + "/" + helpId + ".txt";
            String content = WebResourceClassloaderReader.readUTF8FileIntoString(fileName, false);
            if (content != null) {
                return new IOnlineHelpReader.OnlineHelpText("text/plain", content);
            }
            fileName = contentdirectory + language + "/" + helpId + ".html";
            content = WebResourceClassloaderReader.readUTF8FileIntoString(fileName, false);
            if (content != null) {
                content = this.updateImageReferences(content);
                return new IOnlineHelpReader.OnlineHelpText("text/html", content);
            }
            fileName = contentdirectory + language + "/" + helpId + ".rtf";
            content = WebResourceClassloaderReader.readUTF8FileIntoString(fileName, false);
            if (content != null) {
                return new IOnlineHelpReader.OnlineHelpText("text/rtf", content);
            }
            return new IOnlineHelpReader.OnlineHelpText("text/plain", "No online help available for " + helpId + "/" + language);
        }
        String fileName = helpId + "_" + language + ".html";
        String content = WebResourceClassloaderReader.readUTF8FileIntoString(fileName, false);
        if (content == null) {
            fileName = helpId + ".html";
            content = WebResourceClassloaderReader.readUTF8FileIntoString(fileName, false);
        }
        if (content != null) {
            content = this.updateImageReferences(content);
            return new IOnlineHelpReader.OnlineHelpText("text/html", content);
        }
        if (content != null) {
            return new IOnlineHelpReader.OnlineHelpText("text/rtf", content);
        }
        return new IOnlineHelpReader.OnlineHelpText("text/plain", "No online help available for " + helpId + "/" + language);
    }

    private String updateImageReferences(String html) {
        HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        String url = request.getRequestURL().toString();
        int indexFourthSlash = -1;
        indexFourthSlash = url.indexOf(47, indexFourthSlash + 1);
        indexFourthSlash = url.indexOf(47, indexFourthSlash + 1);
        indexFourthSlash = url.indexOf(47, indexFourthSlash + 1);
        indexFourthSlash = url.indexOf(47, indexFourthSlash + 1);
        String urlBase = url.substring(0, indexFourthSlash);
        html = html.replace("<img src=\"", "<img src=\"" + urlBase + OnlineHelpConfiguration.getContentDirectory());
        html = html.replace("<a href=\"", "<a href=\"" + urlBase + OnlineHelpConfiguration.getContentDirectory());
        html = html.replace("<IMG SRC=\"", "<IMG SRC=\"" + urlBase + OnlineHelpConfiguration.getContentDirectory());
        html = html.replace("<A HREF=\"", "<A HREF=\"" + urlBase + OnlineHelpConfiguration.getContentDirectory());
        return html;
    }
}

