/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.polling;

import java.io.IOException;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclnt.jsfserver.polling.DefaultLongPolling30API;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.util.log.CLog;

public class LongPollingServlet30API
extends HttpServlet {
    private FacesContextFactory m_facesContextFactory;
    private Lifecycle m_lifecycle;

    public void init() throws ServletException {
        super.init();
        try {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            this.m_facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
            this.m_lifecycle = lifecycleFactory.getLifecycle("DEFAULT");
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problems in init() of LongPollingServlet30API - only relevant if accessing FacesContext during servlet processing");
        }
    }

    public void service(ServletRequest req, final ServletResponse res) throws ServletException, IOException {
        HttpSession session = ((HttpServletRequest)req).getSession(false);
        ServletUtil.setResponseContentType((HttpServletResponse)res, "text/plain");
        if (session == null) {
            CLog.L.log(CLog.LL_INF, "No session for request found");
            res.getWriter().flush();
            res.getWriter().close();
            return;
        }
        CLog.L.log(CLog.LL_INF, "Session id: " + session.getId());
        String pollerId = this.getPollerId((HttpServletRequest)req);
        CLog.L.log(CLog.LL_INF, "Poller id: " + pollerId);
        if (pollerId == null) {
            res.getWriter().flush();
            res.getWriter().close();
            return;
        }
        try {
            final DefaultLongPolling30API poller = (DefaultLongPolling30API)session.getAttribute(pollerId);
            if (poller == null) {
                throw new Exception("No poller object found in session");
            }
            final AsyncContext ctx = req.startAsync();
            ctx.setTimeout(0L);
            ctx.addListener(new AsyncListener(){

                public void onTimeout(AsyncEvent arg0) throws IOException {
                }

                public void onStartAsync(AsyncEvent arg0) throws IOException {
                }

                public void onError(AsyncEvent arg0) throws IOException {
                }

                public void onComplete(AsyncEvent arg0) throws IOException {
                }
            });
            ctx.start(new Runnable(){

                @Override
                public void run() {
                    poller.waitForEvent(ctx, (HttpServletResponse)res);
                }
            });
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem is server side long polling", t);
            res.getWriter().flush();
            res.getWriter().close();
            return;
        }
    }

    private String getPollerId(HttpServletRequest req) {
        String pollerId = req.getRequestURI();
        int index = pollerId.indexOf(".cclongpolling30API");
        if (index > 0) {
            pollerId = pollerId.substring(0, index);
            index = pollerId.lastIndexOf(47);
            pollerId = pollerId.substring(index + 1);
            pollerId = "cclongpolling_" + pollerId;
            return pollerId;
        }
        return null;
    }
}

