/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.streamstore;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.eclnt.jsfserver.configuration.CCConfigurationObjectLoader;
import org.eclnt.jsfserver.managedbean.DefaultHotDeployListener;
import org.eclnt.jsfserver.managedbean.HotDeployClassLoader;
import org.eclnt.jsfserver.managedbean.HotDeployNotifier;
import org.eclnt.jsfserver.streamstore.IStreamStore;
import org.eclnt.jsfserver.streamstore.IStreamStoreWithBinary;
import org.eclnt.jsfserver.streamstore.StreamStoreFile;
import org.eclnt.jsfserver.streamstore.StreamStoreWithBinaryWrapper;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.jsfserver.util.useraccess.TenantAccessMgr;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class StreamStore {
    static ServletContext s_servletContext = null;
    static final Object SYNCHER = new Object();
    static Map<String, IStreamStore> s_instances = new HashMap<String, IStreamStore>();
    static String s_streamStoreDirWS = null;
    static boolean s_initialized = false;

    public static void initialize(ServletContext servletContext) {
        if (s_initialized) {
            return;
        }
        s_initialized = true;
        s_servletContext = servletContext;
        try {
            s_streamStoreDirWS = SystemXml.getStreamStoreFileRootDir();
            if (s_streamStoreDirWS == null) {
                s_streamStoreDirWS = HttpSessionAccess.getServletTempDirectory();
                s_streamStoreDirWS = ValueManager.encodeIntoValidFileName(s_streamStoreDirWS, true);
                s_streamStoreDirWS = s_streamStoreDirWS + "eclntstreamstore/";
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Initialization of stream store failed: " + t.toString());
        }
        try {
            StreamStore.getCrossTenantInstance();
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Initialization of stream store failed: " + t.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IStreamStore getInstance() {
        StreamStore.initialize(s_servletContext);
        String tenant = TenantAccessMgr.getCurrentTenant();
        IStreamStore result = s_instances.get(tenant);
        if (result == null) {
            Object object = SYNCHER;
            synchronized (object) {
                result = s_instances.get(tenant);
                if (result == null) {
                    result = StreamStore.createNewInstance();
                    s_instances.put(tenant, result);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IStreamStore getCrossTenantInstance() {
        StreamStore.initialize(s_servletContext);
        String tenant = "undefined";
        IStreamStore result = s_instances.get(tenant);
        if (result == null) {
            Object object = SYNCHER;
            synchronized (object) {
                result = s_instances.get(tenant);
                if (result == null) {
                    String nowTenant = TenantAccessMgr.getCurrentTenant();
                    if (!"undefined".equals(nowTenant)) {
                        throw new Error("The stream store must be initialized with tenant TENANT_UNDEFINED. Current tenant ist: " + nowTenant);
                    }
                    result = StreamStore.createNewInstance();
                    s_instances.put(tenant, result);
                }
            }
        }
        return result;
    }

    public static IStreamStoreWithBinary getInstanceWithBinary() {
        StreamStore.initialize(s_servletContext);
        IStreamStore directInstance = StreamStore.getInstance();
        return StreamStore.convertNormalInstanceToWithBinary(directInstance);
    }

    public static IStreamStoreWithBinary getCrossTenantInstanceWithBinary() {
        StreamStore.initialize(s_servletContext);
        IStreamStore directInstance = StreamStore.getCrossTenantInstance();
        return StreamStore.convertNormalInstanceToWithBinary(directInstance);
    }

    private static IStreamStoreWithBinary convertNormalInstanceToWithBinary(IStreamStore directInstance) {
        if (directInstance instanceof IStreamStoreWithBinary) {
            return (IStreamStoreWithBinary)directInstance;
        }
        return new StreamStoreWithBinaryWrapper(directInstance);
    }

    private static IStreamStore createNewInstance() {
        try {
            String className = SystemXml.getStreamStore();
            IStreamStore instance = (IStreamStore)CCConfigurationObjectLoader.instance().loadInstance(className, true);
            if (instance instanceof StreamStoreFile) {
                ((StreamStoreFile)instance).init(s_streamStoreDirWS);
            }
            return instance;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Initialization of stream store instance failed: " + t.toString());
            return null;
        }
    }

    static {
        HotDeployNotifier.addListener(new DefaultHotDeployListener(){

            @Override
            public void onClassLoaderUpdate(ClassLoader hotDeployClassLoader) {
                boolean fromWebAppClassloader = true;
                for (IStreamStore instance : s_instances.values()) {
                    if (!(instance.getClass().getClassLoader() instanceof HotDeployClassLoader)) continue;
                    fromWebAppClassloader = false;
                    break;
                }
                if (!fromWebAppClassloader) {
                    s_instances.clear();
                    s_initialized = false;
                }
            }
        });
    }
}

