/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclnt.jsfserver.util.IListWithChangeIndex;
import org.eclnt.jsfserver.util.IListWithChangeIndexListener;

public class ArrayListWithChangeIndex<T>
extends ArrayList<T>
implements IListWithChangeIndex<T>,
Serializable {
    int m_changeIndex = 0;
    IListWithChangeIndexListener m_listener = null;

    @Override
    public int getChangeIndex() {
        return this.m_changeIndex;
    }

    @Override
    public void updateChangeIndex() {
        this.uci();
    }

    @Override
    public void setListWithChangeIndexListener(IListWithChangeIndexListener listener) {
        this.m_listener = listener;
    }

    private void uci() {
        ++this.m_changeIndex;
    }

    private void updateFinished() {
        if (this.m_listener != null) {
            this.m_listener.listChanged(this);
        }
    }

    private void notifyRemove(Object concreteObject) {
        if (this.m_listener != null) {
            this.m_listener.listItemWasRemoved(this, concreteObject);
        }
    }

    private void notifyAdd(Object concreteObject) {
        if (this.m_listener != null) {
            this.m_listener.listItemWasAdded(this, concreteObject);
        }
    }

    @Override
    public void add(int index, T element) {
        this.uci();
        super.add(index, element);
        this.notifyAdd(element);
        this.updateFinished();
    }

    @Override
    public boolean add(T e) {
        this.uci();
        boolean result = super.add(e);
        this.notifyAdd(e);
        this.updateFinished();
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.uci();
        boolean result = super.addAll(c);
        for (T t : c) {
            this.notifyAdd(t);
        }
        this.updateFinished();
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.uci();
        boolean result = super.addAll(index, c);
        for (T t : c) {
            this.notifyAdd(t);
        }
        this.updateFinished();
        return result;
    }

    @Override
    public void clear() {
        this.uci();
        super.clear();
        this.notifyRemove(null);
        this.updateFinished();
    }

    @Override
    public T remove(int index) {
        this.uci();
        Object o = this.get(index);
        Object result = super.remove(index);
        this.notifyRemove(o);
        this.updateFinished();
        return (T)result;
    }

    @Override
    public boolean remove(Object o) {
        this.uci();
        boolean result = super.remove(o);
        this.notifyRemove(o);
        this.updateFinished();
        return result;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        this.uci();
        super.removeRange(fromIndex, toIndex);
        this.notifyRemove(null);
        this.updateFinished();
    }

    @Override
    public T set(int index, T element) {
        this.uci();
        Object removedObject = this.get(index);
        if (removedObject != null) {
            this.notifyRemove(removedObject);
        }
        T result = super.set(index, element);
        if (element != null) {
            this.notifyAdd(element);
        }
        this.updateFinished();
        return result;
    }

    @Override
    public void trimToSize() {
        this.uci();
        super.trimToSize();
        this.updateFinished();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.uci();
        boolean result = super.removeAll(c);
        this.notifyRemove(null);
        this.updateFinished();
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.uci();
        boolean result = super.retainAll(c);
        this.updateFinished();
        return result;
    }

    @Override
    public void sort(Comparator<? super T> c) {
        this.uci();
        super.sort(c);
    }

    public void reorderList(List<T> newOrder, boolean withEvent) {
        if (newOrder.size() != this.size()) {
            throw new RuntimeException("newOrder-list has different size tahn order list");
        }
        IListWithChangeIndexListener listener = this.m_listener;
        this.m_listener = null;
        this.clear();
        this.addAll((Collection<? extends T>)newOrder);
        this.m_listener = listener;
        if (withEvent) {
            this.updateFinished();
        }
    }
}

