/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclnt.util.java.JavaRecordsUtil;
import org.eclnt.util.log.ULog;
import org.eclnt.util.valuemgmt.ValueManager;

public class BeanIntrospector {
    static final Object MAPSYNCHER = new Object();
    static final Object LISTSYNCHER = new Object();
    static Map<Class, Map<String, PropertyIntrospectionInfo>> s_mapBuffer = new HashMap<Class, Map<String, PropertyIntrospectionInfo>>();
    static Map<Class, List<PropertyIntrospectionInfo>> s_listBuffer = new HashMap<Class, List<PropertyIntrospectionInfo>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetBuffers() {
        Object object = MAPSYNCHER;
        synchronized (object) {
            s_mapBuffer.clear();
        }
        object = LISTSYNCHER;
        synchronized (object) {
            s_listBuffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PropertyIntrospectionInfo> readPropertiesAsList(Class cl) {
        List<PropertyIntrospectionInfo> result = s_listBuffer.get(cl);
        if (result == null) {
            Object object = LISTSYNCHER;
            synchronized (object) {
                result = s_listBuffer.get(cl);
                if (result == null) {
                    result = new ArrayList<PropertyIntrospectionInfo>();
                    Method[] methods = cl.getMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        boolean setterMayBeAvailable = true;
                        Method m = methods[i];
                        if (m.getParameterCount() > 0) continue;
                        String mn = m.getName();
                        String propertyName = null;
                        if ("getClass".equals(mn)) continue;
                        if (mn.length() >= 4 && mn.startsWith("get") && m.getParameterTypes().length == 0) {
                            propertyName = BeanIntrospector.buildBeanPropertyNameFromPartialMethodName(mn.substring(3));
                        } else if (mn.length() >= 3 && mn.startsWith("is") && m.getParameterTypes().length == 0) {
                            propertyName = BeanIntrospector.buildBeanPropertyNameFromPartialMethodName(mn.substring(2));
                        } else if (JavaRecordsUtil.checkIfClassIsRecord(cl)) {
                            if (JavaRecordsUtil.checkIfMethodIsRecordClassMethod(mn)) continue;
                            propertyName = mn;
                            setterMayBeAvailable = false;
                        }
                        if (propertyName == null) continue;
                        PropertyIntrospectionInfo pii = new PropertyIntrospectionInfo();
                        pii.m_propertyName = propertyName;
                        pii.m_getter = m;
                        result.add(pii);
                        if (!setterMayBeAvailable) continue;
                        try {
                            Method setterMethod;
                            String setterName = null;
                            if (mn.startsWith("get")) {
                                setterName = "set" + mn.substring(3);
                            } else if (mn.startsWith("is")) {
                                setterName = "set" + mn.substring(2);
                            }
                            pii.m_setter = setterMethod = cl.getMethod(setterName, m.getReturnType());
                            continue;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    BeanIntrospector.recheckListAgainstIntrospectorInfo(cl, result);
                    s_listBuffer.put(cl, result);
                }
            }
        }
        return result;
    }

    private static void recheckListAgainstIntrospectorInfo(Class cl, List<PropertyIntrospectionInfo> result) {
        try {
            BeanInfo bi = Introspector.getBeanInfo(cl);
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            HashMap<String, PropertyDescriptor> pdsMap = new HashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor pd : pds) {
                pdsMap.put(pd.getName(), pd);
            }
            HashSet<String> processedPropertyNames = new HashSet<String>();
            for (int i = result.size() - 1; i >= 0; --i) {
                PropertyDescriptor pd;
                PropertyIntrospectionInfo pii = result.get(i);
                if (processedPropertyNames.contains(pii.getPropertyName())) {
                    result.remove(i);
                    continue;
                }
                processedPropertyNames.add(pii.getPropertyName());
                pd = (PropertyDescriptor)pdsMap.get(pii.getPropertyName());
                if (pd == null) continue;
                pii.m_getter = pd.getReadMethod();
                pii.m_setter = pd.getWriteMethod();
            }
        }
        catch (Throwable t) {
            ULog.logINF("Problem when rechecking class against introspection: " + cl.getName(), t);
        }
    }

    public static PropertyIntrospectionInfo readProperty(Class cl, String propertyName) {
        return BeanIntrospector.readProperties(cl).get(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, PropertyIntrospectionInfo> readProperties(Class cl) {
        Map<String, PropertyIntrospectionInfo> result = s_mapBuffer.get(cl);
        if (result == null) {
            Object object = MAPSYNCHER;
            synchronized (object) {
                result = s_mapBuffer.get(cl);
                if (result == null) {
                    result = new HashMap<String, PropertyIntrospectionInfo>();
                    List<PropertyIntrospectionInfo> piis = BeanIntrospector.readPropertiesAsList(cl);
                    for (PropertyIntrospectionInfo pii : piis) {
                        result.put(pii.getPropertyName(), pii);
                    }
                }
                s_mapBuffer.put(cl, result);
            }
        }
        return result;
    }

    public static boolean checkIfSimpleDataType(Class cl) {
        return ValueManager.checkIfSimpleDataType(cl);
    }

    public static String buildBeanPropertyNameFromMethodName(String methodName) {
        if (methodName == null) {
            return null;
        }
        if (methodName.startsWith("get")) {
            return BeanIntrospector.buildBeanPropertyNameFromPartialMethodName(methodName.substring(3));
        }
        if (methodName.startsWith("is")) {
            return BeanIntrospector.buildBeanPropertyNameFromPartialMethodName(methodName.substring(2));
        }
        return null;
    }

    public static String buildBeanPropertyNameFromPartialMethodName(String rawName) {
        if (rawName == null || rawName.length() == 0) {
            return rawName;
        }
        if (rawName.length() == 1) {
            return ValueManager.toLowerCaseId(rawName);
        }
        char second = rawName.charAt(1);
        if (Character.isUpperCase(second)) {
            return rawName;
        }
        return ValueManager.toLowerCaseId(rawName.substring(0, 1)) + rawName.substring(1);
    }

    public static String buildMethodNameFromPropertyName(String methodPrefix, String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            return propertyName;
        }
        return methodPrefix + ValueManager.toUpperCaseId(propertyName.substring(0, 1)) + propertyName.substring(1);
    }

    public static class PropertyIntrospectionInfo
    implements Comparable<PropertyIntrospectionInfo> {
        public String m_propertyName;
        public Method m_getter;
        public Method m_setter;

        public String getPropertyName() {
            return this.m_propertyName;
        }

        public Method getGetter() {
            return this.m_getter;
        }

        public Method getSetter() {
            return this.m_setter;
        }

        @Override
        public int compareTo(PropertyIntrospectionInfo o) {
            return this.m_propertyName.compareTo(o.m_propertyName);
        }
    }
}

