/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import org.eclnt.jsfserver.configuration.CCConfigurationObjectLoader;
import org.eclnt.jsfserver.defaultscreens.IdAttributesSelection;
import org.eclnt.jsfserver.defaultscreens.IdTextSelection;
import org.eclnt.jsfserver.defaultscreens.OKPopup;
import org.eclnt.jsfserver.defaultscreens.YESNOPopup;
import org.eclnt.jsfserver.elements.EventBlockerDuringDecode;
import org.eclnt.jsfserver.elements.impl.ROWINCLUDEComponent;
import org.eclnt.jsfserver.elements.polling.UNIFIEDPOLLINGBinding;
import org.eclnt.jsfserver.managedbean.DefaultHotDeployListener;
import org.eclnt.jsfserver.managedbean.HotDeployManager;
import org.eclnt.jsfserver.managedbean.HotDeployNotifier;
import org.eclnt.jsfserver.monitoring.servertimeout.ServerTimeOutManagerFactory;
import org.eclnt.jsfserver.polling.websocket.WebSocketPollingInit;
import org.eclnt.jsfserver.resources.ResourceManager;
import org.eclnt.jsfserver.session.SessionInfo;
import org.eclnt.jsfserver.starter.RISCStarter;
import org.eclnt.jsfserver.streamstore.StreamStore;
import org.eclnt.jsfserver.util.CCCheckServer;
import org.eclnt.jsfserver.util.CCCheckSessionConfiguration;
import org.eclnt.jsfserver.util.CCESAPI;
import org.eclnt.jsfserver.util.CCInitializeBootstrap;
import org.eclnt.jsfserver.util.CCInitializeServlets;
import org.eclnt.jsfserver.util.ClientI18NReader;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.HttpSessionListenerDelegator;
import org.eclnt.jsfserver.util.IStartUp;
import org.eclnt.jsfserver.util.IStartUpWithShutDown;
import org.eclnt.jsfserver.util.InitEclntJsfServer;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.SystemProperties;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.jsfserver.util.WebResourceClassloaderReader;
import org.eclnt.jsfserver.util.WebResourceReader;
import org.eclnt.jsfserver.util.security.ResourceSecurity;
import org.eclnt.jsfserver.util.security.impl.CCResourceSecurityChecker;
import org.eclnt.jsfserver.util.tempfile.TempFileManager;
import org.eclnt.jsfserver.util.useraccess.LanguageAccessMgr;
import org.eclnt.jsfserver.util.useraccess.TenantAccessMgr;
import org.eclnt.jsfserver.util.useraccess.UserAccessMgr;
import org.eclnt.jsfserver.util.useraccess.impl.LanguageAccessInfoProviderJsfserverImpl;
import org.eclnt.jsfserver.util.useraccess.impl.TenantAccessInfoProviderJsfserverImpl;
import org.eclnt.jsfserver.util.useraccess.impl.UserAccessInfoProviderJsfserverImpl;
import org.eclnt.jsfserver.util.webappfiles.WebappDirectoryManager;
import org.eclnt.util.classloaderaccess.ClassLoaderAccess;
import org.eclnt.util.classloaderaccess.impl.ClassLoaderAccessJsfserverImpl;
import org.eclnt.util.classresolver.CCClassResolver;
import org.eclnt.util.classresolver.ENUMCallerType;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.file.ConfigFileReader;
import org.eclnt.util.file.impl.ClassLoaderReaderInfoProviderJsfserverImpl;
import org.eclnt.util.image.FontImageCreator;
import org.eclnt.util.image.ServerImageManager;
import org.eclnt.util.log.CLog;
import org.eclnt.util.token.ITokenMgr;
import org.eclnt.util.token.TokenMgr;
import org.eclnt.util.valuemgmt.ISimpleDataTypeExtension;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.util.valuemgmt.impl.ValueManagerInfoProviderJsfserverImpl;
import org.eclnt.workplace.WorkpageContainer;

public class CCInitialize {
    static boolean s_initialized = false;
    static boolean s_registeredHotDeploymentListener = false;
    static final Object s_syncher = new Object();
    static List<String> s_applicationStartUpClassNames = new ArrayList<String>();
    static List<IStartUp> s_applicationStartUpInstances = new ArrayList<IStartUp>();
    static boolean s_initWebSocketPolling = true;

    public static void setInitWebSocketPolling(boolean value) {
        s_initWebSocketPolling = value;
    }

    public static void initializeCCEnvironment(ServletContext servletContext) {
        CCInitialize.initializeCCEnvironment(servletContext, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeCCEnvironment(ServletContext servletContext, boolean forceReset) {
        if (forceReset) {
            s_initialized = false;
        }
        if (!s_initialized) {
            Object object = s_syncher;
            synchronized (object) {
                if (!s_initialized) {
                    CCInitializeBootstrap.bootstrap(servletContext);
                    CCInitialize.initializeUtilLayer();
                    HttpSessionAccess.initialize(servletContext);
                    WebResourceReader.intialize(servletContext);
                    ConfigFileReader.initialize(servletContext);
                    WebappDirectoryManager.initialize();
                    InitEclntJsfServer.initLogging(servletContext);
                    InitEclntJsfServer.outputInitBeginStatement(servletContext);
                    HotDeployManager.initialize(servletContext);
                    SystemXml.init(servletContext);
                    SystemProperties.initialize();
                    CCInitialize.intializeWebResourceClassLoaderReaderPaths();
                    CCInitialize.initializeESAPI(servletContext);
                    try {
                        String allServletsInWebXml = servletContext.getInitParameter("org.eclnt.explicitlyManageAllServletsInWebXml");
                        if (!"true".equals(allServletsInWebXml)) {
                            CCInitializeServlets.initialize(servletContext);
                        }
                    }
                    catch (Throwable allServletsInWebXml) {
                        // empty catch block
                    }
                    ServletUtil.initialize();
                    ResourceSecurity.initialize();
                    InitEclntJsfServer.init(servletContext);
                    ResourceManager.init(servletContext);
                    StreamStore.initialize(servletContext);
                    ServerImageManager.initialize(servletContext);
                    FontImageCreator.initialize(servletContext);
                    RISCStarter.initialize(servletContext);
                    TempFileManager.initialize(servletContext);
                    try {
                        CCCheckSessionConfiguration.check(servletContext);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        CLog.L.log(CLog.LL_ERR, "Problem in session configuration", t);
                    }
                    WorkpageContainer.initialize();
                    if (s_initWebSocketPolling) {
                        WebSocketPollingInit.init(servletContext);
                    }
                    ResourceSecurity.addResourceSecurityChecker(new CCResourceSecurityChecker());
                    ServerTimeOutManagerFactory.init(servletContext);
                    CCInitialize.initializeSimpleDataTypeExtensions();
                    UNIFIEDPOLLINGBinding.initialize();
                    CCInitialize.initializeTokenMgr();
                    CCInitialize.ensureCorrectInitialization();
                    CCInitialize.processApplicationStartup();
                    SessionInfo.initialize(servletContext);
                    ClientI18NReader.init(servletContext);
                    CCInitialize.initializeDefaultPopups();
                    InitEclntJsfServer.outputInitEndStatement(servletContext);
                    CCCheckServer.check();
                    EventBlockerDuringDecode.initialize();
                    s_initialized = true;
                }
                if (!s_registeredHotDeploymentListener) {
                    s_registeredHotDeploymentListener = true;
                    HotDeployNotifier.addListener(new DefaultHotDeployListener(){

                        @Override
                        public void onClassLoaderUpdateFinished(ClassLoader newClassLoader) {
                            CCInitialize.reinitializeStartupAfterHotDeployment();
                        }
                    });
                }
            }
        }
    }

    private static void initializeTokenMgr() {
        String s = SystemXml.getTokenMgrClassName();
        try {
            if (!ValueManager.isEmpty(s)) {
                Class c = CCClassResolver.resolveClass(s, ENUMCallerType.CONFIGURATION);
                ITokenMgr tm = (ITokenMgr)c.getConstructor(new Class[0]).newInstance(new Object[0]);
                TokenMgr.initialize(tm);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem occurred initializing token manager: " + s, t);
            throw new Error("Problem occurred initializing token manager: " + s, t);
        }
    }

    private static void reinitializeStartupAfterHotDeployment() {
        int counter = -1;
        for (IStartUp startUpInstance : s_applicationStartUpInstances) {
            ++counter;
            if (startUpInstance.getClass().getClassLoader() == CCInitialize.class.getClassLoader()) continue;
            IStartUp instance = CCInitialize.processApplicationStartup(startUpInstance.getClass().getName());
            s_applicationStartUpInstances.set(counter, instance);
        }
    }

    private static void initializeSimpleDataTypeExtensions() {
        Set<String> simpleDataTypeExentsions = SystemXml.getSimpleDataTypeManagerClassNames();
        for (String s : simpleDataTypeExentsions) {
            try {
                Class c = CCClassResolver.resolveClass(s, ENUMCallerType.SIMPLEDATATYPE);
                ISimpleDataTypeExtension sdte = (ISimpleDataTypeExtension)c.getConstructor(new Class[0]).newInstance(new Object[0]);
                ValueManager.initializeAddSimpleDataTypeExtension(sdte);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Problem occurred initializing simple data type extensions: " + s, t);
                throw new Error("Problem occurred initializing simple data type extensions: " + s, t);
            }
        }
    }

    private static void initializeDefaultPopups() {
        OKPopup.initialize();
        YESNOPopup.initialize();
        IdTextSelection.initialize();
        IdAttributesSelection.initialize();
    }

    private static void initializeESAPI(ServletContext servletContext) {
        try {
            CCESAPI.initESAPI();
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem occurred when initializing ESAPI");
        }
    }

    private static void initializeUtilLayer() {
        ValueManager.initializeInfoProvider(new ValueManagerInfoProviderJsfserverImpl());
        ClassLoaderAccess.initializeClassLoaderAccess(new ClassLoaderAccessJsfserverImpl());
        ClassloaderReader.initializeInfoProvider(new ClassLoaderReaderInfoProviderJsfserverImpl());
        UserAccessMgr.initializeInfoProvider(new UserAccessInfoProviderJsfserverImpl());
        TenantAccessMgr.initializeInfoProvider(new TenantAccessInfoProviderJsfserverImpl());
        LanguageAccessMgr.initializeInfoProvider(new LanguageAccessInfoProviderJsfserverImpl());
    }

    private static void ensureCorrectInitialization() {
        HttpSessionListenerDelegator.ensureInitialized();
    }

    public static void postInitializeWebSocketPolling(ServletContext servletContext) {
        WebSocketPollingInit.init(servletContext);
    }

    private static void intializeWebResourceClassLoaderReaderPaths() {
        WebResourceClassloaderReader.registerPathToIgore("/eclntjsfserver/styles/*/riscstyle.css");
        for (SystemXml.ResourceClassLoaderAccessIgnore resourceClassLoaderAccessIgnore : SystemXml.getResourceClassLoaderAccessIgnores()) {
            WebResourceClassloaderReader.registerPathToIgore(resourceClassLoaderAccessIgnore.getPath());
        }
        WebResourceClassloaderReader.registerPathWithReadingWebResourceFirst("/eclntjsfserver/config/logging.xml");
        WebResourceClassloaderReader.registerPathWithReadingWebResourceFirst("/eclntjsfserver/config/sessiondefaults.xml");
        for (SystemXml.ResourceClassLoaderAccessWebContentFirst resourceClassLoaderAccessWebContentFirst : SystemXml.getResourceClassLoaderAccessWebContentFirsts()) {
            WebResourceClassloaderReader.registerPathWithReadingWebResourceFirst(resourceClassLoaderAccessWebContentFirst.getPath());
        }
    }

    private static void processApplicationStartup() {
        for (String className : s_applicationStartUpClassNames) {
            IStartUp instance = CCInitialize.processApplicationStartup(className);
            s_applicationStartUpInstances.add(instance);
        }
    }

    private static IStartUp processApplicationStartup(String className) {
        try {
            IStartUp instance = null;
            instance = (IStartUp)CCConfigurationObjectLoader.instance().loadInstance(className, true);
            instance.startUp();
            return instance;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem during application startup, class: " + className, t);
            throw new Error("Problem during application startup, class: " + className, t);
        }
    }

    public static void initApplicationStartUpClass(String name) {
        if (s_applicationStartUpClassNames.contains(name)) {
            return;
        }
        s_applicationStartUpClassNames.add(name);
    }

    public static void resetLayoutBuffers() {
        try {
            ClientI18NReader.reset();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            ROWINCLUDEComponent.clearLayoutBuffer();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            ServerImageManager.getInstance().clear();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void shutDownCCEnvironment() {
        CLog.L.log(CLog.LL_INF, "Receiving shutdown signal - shutting down CC environment...");
        for (IStartUp startUpInstance : s_applicationStartUpInstances) {
            try {
                if (!(startUpInstance instanceof IStartUpWithShutDown)) continue;
                ((IStartUpWithShutDown)startUpInstance).shutDown();
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Problem during shutdown of application, class: " + startUpInstance.getClass().getName(), t);
            }
        }
    }
}

