/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import javax.faces.context.FacesContext;
import org.eclnt.jsfserver.util.ExpressionManagerV;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.IValueBindingListener;
import org.eclnt.util.log.CLog;

public class CascadingValueBindingListener
implements IValueBindingListener {
    @Override
    public void reactoOnValueExpressionSet(String expressionString, Object value) {
        try {
            CLog.L.log(CLog.LL_INF, "Starting CascadingValueBindingListener processing for " + expressionString);
            FacesContext fc = HttpSessionAccess.getCurrentFacesContext();
            String[] tokens = ExpressionManagerV.buildTokens(expressionString);
            for (int i = tokens.length - 2; i >= 0; --i) {
                StringBuffer sb = new StringBuffer();
                sb.append("#{");
                for (int j = 0; j <= i; ++j) {
                    if (j != 0) {
                        sb.append(".");
                    }
                    sb.append(tokens[j]);
                }
                sb.append("}");
                Object vb = ExpressionManagerV.createExpression(fc.getApplication(), sb.toString());
                Object vbo = ExpressionManagerV.getValue(fc, vb);
                CLog.L.log(CLog.LL_INF, "........ Expression: " + sb.toString());
                if (vbo == null || !(vbo instanceof ICascadingValueBindingListener)) continue;
                CLog.L.log(CLog.LL_INF, "........ Execute expression: " + sb.toString());
                ((ICascadingValueBindingListener)vbo).reactOnSetValue(sb.toString(), expressionString, value);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem occurred in CascadingValueBindingListener processing", t);
        }
    }

    public static interface ICascadingValueBindingListener {
        public void reactOnSetValue(String var1, String var2, Object var3);
    }
}

