/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import com.veracode.annotation.XSSCleanser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;

class CompressionResponseStream
extends ServletOutputStream {
    protected ByteArrayOutputStream baos = null;
    protected GZIPOutputStream gzipstream = null;
    protected boolean closed = false;
    protected HttpServletResponse response = null;
    protected ServletOutputStream output = null;

    public CompressionResponseStream(HttpServletResponse httpservletresponse) throws IOException {
        this.response = httpservletresponse;
        this.output = httpservletresponse.getOutputStream();
        this.baos = new ByteArrayOutputStream();
        this.gzipstream = new GZIPOutputStream(this.baos);
    }

    @XSSCleanser(userComment="The output stream that is written is the zipped version of the original output stream. The responsibility for making sure that the output stream does not contain XSS must not be managed on this level, but on the level to produce the proper content before it is zipped. There is no additional information written into the zipped output stream, so there is also no chance to add XSS content on this leve.")
    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("This output stream has already been closed");
        }
        this.gzipstream.finish();
        byte[] abyte0 = this.baos.toByteArray();
        this.response.addHeader("Content-Length", Integer.toString(abyte0.length));
        this.response.addHeader("Content-Encoding", "gzip");
        this.output.write(abyte0);
        this.output.flush();
        this.output.close();
        this.closed = true;
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Cannot flush a closed output stream");
        }
        this.gzipstream.flush();
    }

    public void write(int i) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        this.gzipstream.write((byte)i);
    }

    public void write(byte[] abyte0) throws IOException {
        this.write(abyte0, 0, abyte0.length);
    }

    public void write(byte[] abyte0, int i, int j) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        this.gzipstream.write(abyte0, i, j);
    }

    public boolean closed() {
        return this.closed;
    }

    public void reset() {
    }

    public boolean isReady() {
        return true;
    }

    public void setWriteListener(WriteListener writeListener) {
    }
}

