/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclnt.jsfserver.util.CCFilterBase;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ICCServerConstants;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.SystemProperties;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.owasp.esapi.ESAPI;

public class ResponseLoggerFilter
extends CCFilterBase
implements Filter,
ICCServerConstants {
    private static final String PARAM_ORIGINALAPP = "originalApp";
    String ALLOWEDFILECHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_";
    boolean m_loggingActive = false;
    boolean m_replayActive = false;
    int m_counter = 0;
    List<RequestInfo> m_unprocessedRequestNames = new ArrayList<RequestInfo>();
    List<RequestInfo> m_processedRequestNames = new ArrayList<RequestInfo>();
    String m_replayFolder = null;
    String m_replayClientDump = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilterExecute(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (this.getResponseLoggerActive() && request instanceof HttpServletRequest) {
            block26: {
                HttpServletRequest req = (HttpServletRequest)request;
                String originalApp = req.getParameter(PARAM_ORIGINALAPP);
                String uri = req.getRequestURI();
                if (uri.contains("switchrecordon")) {
                    if (!ServletUtil.checkIfRequestIsDesignTimerRequest(req)) {
                        return;
                    }
                    this.m_loggingActive = true;
                    this.m_replayActive = false;
                    this.clearCurrentLogging();
                    response.getWriter().write("<html><br><br><br>LOGGING WAS SWITCHED: ON<br><br><br>Existing trace files were deleted.<br><br><br>1. Clear your browser cache!<br>2. Open the URL of your application<br><br><br>Trace files are created in the server directory: " + ESAPI.encoder().encodeForHTML(this.buildDir()) + "</html>");
                    return;
                }
                if (uri.contains("switchrecordoff")) {
                    if (!ServletUtil.checkIfRequestIsDesignTimerRequest(req)) {
                        return;
                    }
                    this.m_loggingActive = false;
                    this.m_replayActive = false;
                    response.getWriter().write("<html><br><br><br>LOGGING WAS SWITCHED: OFF<br><br><br>Trace files are located in the server directory: " + ESAPI.encoder().encodeForHTML(this.buildDir()) + "</html>");
                    return;
                }
                if (uri.contains("switchreplayon")) {
                    if (!ServletUtil.checkIfRequestIsDesignTimerRequest(req)) {
                        return;
                    }
                    this.m_loggingActive = false;
                    this.m_replayActive = true;
                    int index = uri.lastIndexOf("/");
                    String subFolder = uri.substring(index + 1);
                    if ("switchreplayon".equals(subFolder)) {
                        subFolder = "";
                    }
                    this.m_replayFolder = this.buildDir() + subFolder;
                    this.m_replayFolder = ValueManager.encodeIntoValidFileName(this.m_replayFolder, true);
                    this.m_replayClientDump = null;
                    this.startReplay();
                    response.getWriter().write("<html><br><br><br>REPLAY WAS SWITCHED: ON<br><br><br>Trace files are taken from server directory: " + ESAPI.encoder().encodeForHTML(this.m_replayFolder) + "</html>");
                    return;
                }
                if (uri.contains("switchreplayclientdumpon")) {
                    if (!ServletUtil.checkIfRequestIsDesignTimerRequest(req)) {
                        return;
                    }
                    this.m_loggingActive = false;
                    this.m_replayActive = true;
                    int index = uri.lastIndexOf("/");
                    String fileName = uri.substring(index + 1);
                    if ("switchreplayclientdumpon".equals(fileName)) {
                        fileName = "dump.txt";
                    }
                    this.m_replayFolder = null;
                    this.m_replayClientDump = this.buildDir() + fileName;
                    this.m_replayClientDump = ValueManager.encodeIntoValidFileName(this.m_replayClientDump, false);
                    response.getWriter().write("<html><br><br><br>REPLAYCLIENTDUMP WAS SWITCHED: ON<br><br><br>Client dump file: " + ESAPI.encoder().encodeForHTML(this.m_replayClientDump) + "</html>");
                    return;
                }
                if (uri.contains("switchreplayoff")) {
                    if (!ServletUtil.checkIfRequestIsDesignTimerRequest(req)) {
                        return;
                    }
                    this.m_loggingActive = false;
                    this.m_replayActive = false;
                    response.getWriter().write("<html><br><br><br>REPLAY WAS SWITCHED: OFF</html>");
                    return;
                }
                if (this.m_replayActive) {
                    if (this.m_replayFolder != null) {
                        try {
                            CLog.L.log(CLog.LL_INF, "REPLAYING        : ---------------------------------------------------------");
                            CLog.L.log(CLog.LL_INF, "REPLAYING uri    : " + uri);
                            String requestName = this.buildRequestName(uri);
                            CLog.L.log(CLog.LL_INF, "REPLAYING request: " + requestName);
                            boolean result = this.replayRequest(originalApp, uri, requestName, (HttpServletResponse)response);
                            if (result) {
                                return;
                            }
                            break block26;
                        }
                        catch (Throwable t) {
                            CLog.L.log(CLog.LL_INF, "REPLAYING problem: ", t);
                            String s = ValueManager.getStackstraceString(t);
                            response.getWriter().write(s);
                            return;
                        }
                    }
                    if (this.m_replayClientDump != null && uri.contains(".jsp")) {
                        try {
                            this.replayRequestDump(originalApp, (HttpServletResponse)response);
                            return;
                        }
                        catch (Throwable t) {
                            CLog.L.log(CLog.LL_INF, "REPLAYING problem: ", t);
                            String s = ValueManager.getStackstraceString(t);
                            response.getWriter().write(s);
                            return;
                        }
                    }
                }
            }
            if (this.m_loggingActive) {
                if (response.getCharacterEncoding() == null) {
                    response.setCharacterEncoding("UTF-8");
                }
                HttpServletResponseCopier responseCopier = new HttpServletResponseCopier((HttpServletResponse)response);
                try {
                    chain.doFilter(request, (ServletResponse)responseCopier);
                    responseCopier.flushBuffer();
                }
                finally {
                    this.logResponse((HttpServletRequest)request, responseCopier);
                }
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private void logResponse(HttpServletRequest request, HttpServletResponseCopier response) {
        String paramValue;
        String paramName;
        String endFileName = this.buildFileNameFromUri(request.getRequestURI());
        String fileName = this.buildDir() + endFileName + ".content";
        FileManager.ensureDirectoryForFileExists(fileName);
        byte[] bytes = response.getCopy();
        FileManager.writeFile(fileName, bytes, true);
        ArrayList<String> values = new ArrayList<String>();
        values.add("\n@@CT@@");
        values.add(response.getContentType());
        Collection headerNames = response.getHeaderNames();
        for (String headerName : headerNames) {
            values.add("\n@@HN@@");
            values.add(headerName);
            Collection headerValues = response.getHeaders(headerName);
            for (String headerValue : headerValues) {
                values.add("@@HV@@");
                values.add(headerValue);
            }
        }
        Enumeration paramNames = request.getHeaderNames();
        while (paramNames.hasMoreElements()) {
            paramName = (String)paramNames.nextElement();
            paramValue = request.getHeader(paramName);
            values.add("\n@@RHN@@");
            values.add(paramName);
            values.add("@@RHV@@");
            values.add(paramValue);
        }
        paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            paramName = (String)paramNames.nextElement();
            paramValue = request.getParameter(paramName);
            values.add("\n@@PAN@@");
            values.add(paramName);
            values.add("@@PAV@@");
            values.add(paramValue);
        }
        String csv = ValueManager.encodeCSV(values);
        fileName = this.buildDir() + endFileName + ".params";
        FileManager.writeUTF8File(fileName, csv, true);
    }

    private void clearCurrentLogging() {
        try {
            FileManager.deleteDirectoryContent(this.buildDir(), false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String buildFileNameFromUri(String uri) {
        ++this.m_counter;
        String s = this.buildRequestName(uri);
        String counter = "00000" + this.m_counter;
        counter = counter.substring(counter.length() - 5);
        return counter + "_" + s;
    }

    private String buildRequestName(String uri) {
        int index = uri.indexOf("/", 1);
        String s = uri.substring(index);
        if ((index = s.lastIndexOf(";")) > 0) {
            s = s.substring(0, index);
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            String c = s.charAt(i) + "";
            if (!this.ALLOWEDFILECHARS.contains(c)) continue;
            result.append(c);
        }
        return result.toString();
    }

    private void startReplay() {
        List<String> fileNames = FileManager.getFilesOfDirectoryByPattern(this.m_replayFolder, ".content");
        this.m_unprocessedRequestNames = new ArrayList<RequestInfo>();
        for (String fileName : fileNames) {
            fileName = ValueManager.encodeIntoValidFileName(fileName, false);
            fileName = fileName.substring(0, fileName.length() - ".content".length());
            int index = fileName.lastIndexOf("/");
            String requestName = fileName.substring(index + 1);
            requestName = requestName.substring(6);
            this.m_unprocessedRequestNames.add(new RequestInfo(requestName, fileName));
        }
        this.m_processedRequestNames = new ArrayList<RequestInfo>();
    }

    private boolean replayRequest(String originalApp, String uri, String requestName, HttpServletResponse response) throws Exception {
        int counter = -1;
        for (RequestInfo ri : this.m_unprocessedRequestNames) {
            ++counter;
            if (!requestName.equals(ri.requestName) && !requestName.equals("faces" + ri.requestName)) continue;
            this.respondViaFile(originalApp, uri, response, ri);
            this.m_unprocessedRequestNames.remove(ri);
            this.m_processedRequestNames.add(0, ri);
            return true;
        }
        counter = -1;
        for (RequestInfo ri : this.m_processedRequestNames) {
            ++counter;
            if (!requestName.equals(ri.requestName)) continue;
            this.respondViaFile(originalApp, uri, response, ri);
            return true;
        }
        return false;
    }

    private void respondViaFile(String originalApp, String uri, HttpServletResponse response, RequestInfo ri) throws Exception {
        CLog.L.log(CLog.LL_INF, "REPLAYING file:    " + ri.fileName);
        System.out.println("REPLAYING file:    " + ri.fileName);
        String paramsCSV = FileManager.readUTF8File(ri.fileName + ".params", true);
        paramsCSV = paramsCSV.replace("\n@@", "@@");
        String[] params = ValueManager.decodeCSV(paramsCSV);
        String currentHeaderName = null;
        for (int i = 0; i < params.length; i += 2) {
            try {
                String chnLC;
                String name = params[i];
                String value = params[i + 1];
                if ("@@CT@@".equals(name)) {
                    ServletUtil.setResponseContentType(response, value);
                }
                if ("@@HN@@".equals(name)) {
                    currentHeaderName = value;
                }
                if (!"@@HV@@".equals(name) || currentHeaderName == null || (chnLC = ValueManager.toLowerCaseId(currentHeaderName)).equals("content-length") || chnLC.equals("content-encoding") || chnLC.equals("transfer-encoding")) continue;
                ServletUtil.setResponseHeader(response, currentHeaderName, value);
                continue;
            }
            catch (Throwable name) {
                // empty catch block
            }
        }
        byte[] content = FileManager.readFile(ri.fileName + ".content", true);
        int semicolonIndex = uri.indexOf(";");
        if (semicolonIndex >= 0) {
            uri = uri.substring(0, semicolonIndex);
        }
        if (uri.endsWith(".jsp") || uri.endsWith(".risc") || uri.endsWith(".xml")) {
            String contentString = new String(content, "UTF-8");
            contentString = this.updateXMLContentDueToDifferentRoot(originalApp, contentString);
            content = contentString.getBytes("UTF-8");
        }
        CLog.L.log(CLog.LL_INF, "REPLAYING file:    " + content.length + " bytes");
        response.getOutputStream().write(content);
    }

    private String updateXMLContentDueToDifferentRoot(String originalApp, String contentString) {
        contentString = this.replaceFirstOccurance(contentString, "/GozoCaptainCasaUI/", "/demos/");
        contentString = this.replaceFirstOccurance(contentString, "/cars/", "/demos/");
        contentString = this.replaceFirstOccurance(contentString, "/act3_explorer/", "/demos/");
        contentString = this.replaceFirstOccurance(contentString, "/FilflaCaptainCasaUI/", "/demos/");
        contentString = this.replaceFirstOccurance(contentString, "/ANKER/", "/demos/");
        contentString = this.replaceFirstOccurance(contentString, "/ffnewoffice-visualisation/", "/demos/");
        contentString = this.replaceFirstOccurance(contentString, "/POS/", "/demos/");
        contentString = this.replaceFirstOccurance(contentString, "/prime_explorer/", "/demos/");
        contentString = this.replaceFirstOccurance(contentString, "/cognitatie2/", "/demos/");
        contentString = this.replaceFirstOccurance(contentString, "/cognitatie3/", "/demos/");
        contentString = this.replaceFirstOccurance(contentString, "/Cognitatie3/", "/demos/");
        contentString = this.replaceFirstOccurance(contentString, "/antos/", "/demos/");
        contentString = this.replaceFirstOccurance(contentString, "/ANKER_GIT/", "/demos/");
        contentString = this.replaceFirstOccurance(contentString, "/ffworkbench/", "/demos/");
        contentString = this.replaceFirstOccurance(contentString, "/ffworker/", "/demos/");
        contentString = this.replaceFirstOccurance(contentString, "/cif/", "/demos/");
        contentString = this.replaceFirstOccurance(contentString, "/MyApp/", "/demos/");
        contentString = this.replaceFirstOccurance(contentString, "/pltech/", "/demos/");
        contentString = this.replaceFirstOccurance(contentString, "/plstat/", "/demos/");
        contentString = this.replaceFirstOccurance(contentString, "/rezeptfabrik/", "/demos/");
        contentString = this.replaceFirstOccurance(contentString, "/ISA/", "/demos/");
        contentString = this.replaceFirstOccurance(contentString, "/CC/", "/demos/");
        contentString = this.replaceFirstOccurance(contentString, "/dispatch/", "/demos/");
        contentString = this.replaceFirstOccurance(contentString, "/ccaroundoutestpage/", "/demos/");
        contentString = this.replaceFirstOccurance(contentString, "/geisportal/", "/demos/");
        if (originalApp != null) {
            contentString = this.replaceFirstOccurance(contentString, originalApp, "/demos/");
        }
        return contentString;
    }

    private String buildDir() {
        String dirName = HttpSessionAccess.getServletTempDirectory() + "/ccreplaylogging/";
        dirName = ValueManager.encodeIntoValidFileName(dirName, true);
        return dirName;
    }

    private String replaceFirstOccurance(String s, String from, String to) {
        if (s == null) {
            return null;
        }
        if (from == null) {
            return s;
        }
        if (to == null) {
            return s;
        }
        int index = s.indexOf(from);
        if (index < 0) {
            return s;
        }
        String result = s.substring(0, index) + to + s.substring(index + from.length());
        return result;
    }

    private boolean getResponseLoggerActive() {
        if (SystemXml.getResponseLoggerActive()) {
            return true;
        }
        return SystemProperties.getResponseLoggerActive();
    }

    private void replayRequestDump(String originalApp, HttpServletResponse response) throws Exception {
        String xml = FileManager.readUTF8File(this.m_replayClientDump, true);
        xml = this.updateXMLContentDueToDifferentRoot(originalApp, xml);
        byte[] content = xml.getBytes("UTF-8");
        CLog.L.log(CLog.LL_INF, "REPLAYING file:    " + content.length + " bytes");
        response.getOutputStream().write(content);
    }

    public class HttpServletResponseCopier
    extends HttpServletResponseWrapper {
        private ServletOutputStream outputStream;
        private PrintWriter writer;
        private ServletOutputStreamCopier copier;

        public HttpServletResponseCopier(HttpServletResponse response) throws IOException {
            super(response);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.writer != null) {
                throw new IllegalStateException("getWriter() has already been called on this response.");
            }
            if (this.outputStream == null) {
                this.outputStream = this.getResponse().getOutputStream();
                this.copier = new ServletOutputStreamCopier((OutputStream)this.outputStream);
            }
            return this.copier;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.outputStream != null) {
                throw new IllegalStateException("getOutputStream() has already been called on this response.");
            }
            if (this.writer == null) {
                this.copier = new ServletOutputStreamCopier((OutputStream)this.getResponse().getOutputStream());
                this.writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)((Object)this.copier), this.getResponse().getCharacterEncoding()), true);
            }
            return this.writer;
        }

        public void flushBuffer() throws IOException {
            if (this.writer != null) {
                this.writer.flush();
            } else if (this.outputStream != null) {
                this.copier.flush();
            }
        }

        public byte[] getCopy() {
            if (this.copier != null) {
                return this.copier.getCopy();
            }
            return new byte[0];
        }
    }

    public class ServletOutputStreamCopier
    extends ServletOutputStream {
        private OutputStream outputStream;
        private ByteArrayOutputStream copy;

        public ServletOutputStreamCopier(OutputStream outputStream) {
            this.outputStream = outputStream;
            this.copy = new ByteArrayOutputStream(1024);
        }

        public void write(int b) throws IOException {
            this.outputStream.write(b);
            this.copy.write(b);
        }

        public byte[] getCopy() {
            return this.copy.toByteArray();
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener arg0) {
        }
    }

    class RequestInfo {
        String fileName;
        String requestName;

        public RequestInfo(String requestName, String fileName) {
            this.fileName = fileName;
            this.requestName = requestName;
        }
    }
}

