/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.io.IOException;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclnt.jsfserver.elements.ThreadData;
import org.eclnt.jsfserver.session.SessionInfo;
import org.eclnt.jsfserver.util.CCServletBase;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.SubpageContext;
import org.eclnt.jsfserver.util.TypeOfSessionMgmt;
import org.eclnt.util.log.CLog;

public class SessionInvalidationServlet
extends CCServletBase {
    private FacesContextFactory m_facesContextFactory;
    private Lifecycle m_lifecycle;

    @Override
    public void init() throws ServletException {
        super.init();
        try {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            this.m_facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
            this.m_lifecycle = lifecycleFactory.getLifecycle("DEFAULT");
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problems in init() of SessionInvalidationServlet", t);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = req.getMethod();
        if ("GET".equals(method)) {
            ServletUtil.ensureServletGetIsAllowed(((Object)((Object)this)).getClass());
        }
        CLog.L.log(CLog.LL_INF, "Invalidation of session triggered by client");
        HttpSession session = req.getSession(false);
        if (session == null) {
            CLog.L.log(CLog.LL_INF, "Session does not exist anymore - no action required.");
            return;
        }
        boolean cookiesUsed = TypeOfSessionMgmt.getSessionMgmtViaCookie(session);
        String subpageId = req.getParameter("cc_clientId");
        ThreadData threadData = ThreadData.getInstance();
        threadData.initHttpSession(session);
        threadData.initSubpageId(subpageId);
        FacesContext context = null;
        try {
            context = this.m_facesContextFactory.getFacesContext((Object)this.getServletContext(), (Object)req, (Object)resp, this.m_lifecycle);
            FacesContext facesContext = HttpSessionAccess.getCurrentFacesContext();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            CLog.L.log(CLog.LL_INF, "Invalidation, id of session: " + session.getId());
            CLog.L.log(CLog.LL_INF, "Invalidation, subpageId: " + subpageId);
            if (!cookiesUsed) {
                CLog.L.log(CLog.LL_INF, "Invalidating session...");
                session.invalidate();
            } else {
                CLog.L.log(CLog.LL_INF, "Invalidating subpage context");
                SubpageContext spc = HttpSessionAccess.getCurrentSubpageContext(session, subpageId, false);
                if (spc != null) {
                    spc.invalidate();
                }
            }
            SessionInfo.removeSessionInstance(session, subpageId);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem when invalidating session: ", t);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

