/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.xml.parsers.SAXParser;
import org.eclnt.jsfserver.elements.DefaultEventBlockerDuringDecode;
import org.eclnt.jsfserver.elements.util.DefaultFIXGRIDExportSanitizer;
import org.eclnt.jsfserver.elements.util.FIXGRIDHtmlExporter;
import org.eclnt.jsfserver.elements.util.FIXGRIDPDFExporter;
import org.eclnt.jsfserver.elements.util.FIXGRIDXmlExporter;
import org.eclnt.jsfserver.managedbean.preview.ProcessPreviewByInstanceConfigurator;
import org.eclnt.jsfserver.monitoring.servertimeout.ServerTimeOutManager;
import org.eclnt.jsfserver.util.CCDefaultConfigurationObjectLoader;
import org.eclnt.jsfserver.util.CCInitialize;
import org.eclnt.jsfserver.util.CCInitializeServlets;
import org.eclnt.jsfserver.util.fixgridpersistence.DefaultFIXGRIDPersistence;
import org.eclnt.jsfserver.util.parse.SAXParserCreator;
import org.eclnt.jsfserver.util.useraccess.DefaultLanguageAccess;
import org.eclnt.jsfserver.util.useraccess.DefaultTenantAccess;
import org.eclnt.jsfserver.util.useraccess.DefaultUserAccess;
import org.eclnt.util.file.EclntConfigFileReader;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.workplace.wfinbox.WFDummyManager;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SystemXml {
    public static final String ATT_PAGE = "page";
    public static final String ATT_WELCOMEIMAGE = "welcomeimage";
    public static final String ATT_WELCOMEWAITINGIMAGE = "welcomewaitingimage";
    public static final String ATT_WELCOMEBACKGROUNDCOLOR = "welcomebackgroundcolor";
    public static final String ATT_WELCOMEDURATION = "welcomeduration";
    public static final String NAME_RISCSTARTER = "riscstarter";
    public static final String NAME_ALLOWIFRAMEEMBEDDING = "allowiframeembedding";
    public static final String NAME_EXCLUDESTART = "excludestart";
    public static final String NAME_ALLOWSTART = "allowstart";
    public static final String FIXGRID_CATCHGRIDACTIONERRORS_ALWAYS = "always";
    public static final String FIXGRID_CATCHGRIDACTIONERRORS_NEVER = "never";
    public static final String FIXGRID_CATCHGRIDACTIONERRORS_IFNOTIERRORAWARE = "ifNotIErrorAware";
    public static final String FIXGRID_griddetailsortingofcolumns_TEXT = "text";
    public static final String FIXGRID_griddetailsortingofcolumns_GRID = "grid";
    static String s_webApplicationName = "(undefined)";
    static String s_saxparserfactory = "org.apache.xerces.jaxp.SAXParserFactoryImpl";
    static boolean s_layoutbufferActive = true;
    static boolean s_fastexpressionresolution = false;
    static String s_starttemplateCcapplet = "org/eclnt/jsfserver/starter/applettemplate.html";
    static String s_starttemplateCcwebstart = "org/eclnt/jsfserver/starter/webstarttemplate.jnlp";
    static String s_starttemplateCcwebstartFX = "org/eclnt/jsfserver/starter/webstarttemplatefx.jnlp";
    static String s_starttemplateCcRisc = "org/eclnt/jsfserver/starter/risctemplate.html";
    static String s_extcalendarmgr = "org.eclnt.jsfserver.calendar.ExtCalendarMgr";
    static String s_streamstore = "org.eclnt.jsfserver.streamstore.StreamStoreFile";
    static String s_streamstorefilerootdir = null;
    static String s_fixgridexportcharactersetcsv = "UTF-8";
    static String s_fixgridexporthexbomcsv = null;
    static String s_fixgridexportcharactersetxml = "UTF-8";
    static String s_fixgridexporthexbomxml = null;
    static String s_fixgridCatchGridActionErrors = null;
    static String s_fixgridGridDetailSortingOfColumns = "grid";
    static String s_fixgridPersistence = DefaultFIXGRIDPersistence.class.getName();
    static String s_fixgridPdfExport = FIXGRIDPDFExporter.class.getName();
    static String s_fixgridXmlExport = FIXGRIDXmlExporter.class.getName();
    static String s_fixgridHtmlExport = FIXGRIDHtmlExporter.class.getName();
    static String s_fixgridExportSanitizer = DefaultFIXGRIDExportSanitizer.class.getName();
    static String s_fixgridExcelExport = "org.eclnt.jsfserver.elements.util.FIXGRIDExcelExporter";
    static String s_fixgridCsvExport = "org.eclnt.jsfserver.elements.util.FIXGRIDCsvExporter";
    static String s_fixgridOdsExport = "org.eclnt.jsfserver.elements.util.FIXGRIDOdsExporter";
    static String s_fixgridCsvExportDelimiter = ";";
    static String s_userAccess = DefaultUserAccess.class.getName();
    static String s_tenantAccess = DefaultTenantAccess.class.getName();
    static String s_languageAccess = DefaultLanguageAccess.class.getName();
    static String s_wfmanager = WFDummyManager.class.getName();
    static List<DynamicPageInfo> s_dynamigePageInfos = new ArrayList<DynamicPageInfo>();
    static String s_encodenamejsessionid = "jsessionid";
    static boolean s_encodeenforceownencoding = false;
    static String s_rowincluderescuepage = "/eclntjsfserver/includes/rowincludenotresolved.jsp";
    static String s_jdbcConnectionProvider = null;
    static boolean s_sessionStateManagementUseContainer = false;
    static String s_ccappletccwebstartcclibs = null;
    static String s_ccappletccwebstartsplashimage = null;
    static List<ClientParam> s_ccappletccwebstartclientparams = new ArrayList<ClientParam>();
    static boolean s_nonJSFRequestsExplicitUTF8Conversion = true;
    static boolean s_storeOriginalTagAttributes = true;
    static String s_clientliteralserverloader = null;
    static String s_htsessiontimeoutpage = null;
    static boolean s_dialogsPersistenceEnabled = true;
    static boolean s_dialogsUseWorkpageIdAsPersistid = true;
    static Map<String, ServletConfiguration> s_servletConfigurations = new HashMap<String, ServletConfiguration>();
    static Map<String, FilterConfiguration> s_filterConfigurations = new HashMap<String, FilterConfiguration>();
    static List<ServletData> s_additionalServlets = new ArrayList<ServletData>();
    static List<RISCClientScript> s_RISCClientScripts = new ArrayList<RISCClientScript>();
    static List<RISCClientStyle> s_RISCClientStyles = new ArrayList<RISCClientStyle>();
    static List<RISCClientLink> s_RISCClientLinks = new ArrayList<RISCClientLink>();
    static List<RISCClientMetaTag> s_RISCClientMetaTags = new ArrayList<RISCClientMetaTag>();
    static List<RISCClientFontAccess> s_RISCClientFontAccess = new ArrayList<RISCClientFontAccess>();
    static String s_checkinboundandoutboundvalues = null;
    static RISCStarter s_riscStarter = new RISCStarter();
    static String s_securityfilterextensionclassname = null;
    static String s_securityfilterextensionclassnameGeneral = null;
    static List<FileManagerReadAccess> s_fileManagerReadAccessDirectories = new ArrayList<FileManagerReadAccess>();
    static List<FileManagerWriteAccess> s_fileManagerWriteAccessDirectories = new ArrayList<FileManagerWriteAccess>();
    static boolean s_sessionManagementAutoClose = true;
    static String s_sessionDefaultsProvider = null;
    static boolean s_sessionManagementViaCookies = false;
    static boolean s_sessionManagementSupportSwingClient = false;
    static String s_imageReaderClassName = null;
    static String s_extImageFilterClassName = null;
    static boolean s_workplaceWithHistory = false;
    static boolean s_implicitLoadingForCurrentUser = true;
    static boolean s_workplaceMultiScreen = false;
    static String s_workplaceMultiScreenDefaultWorkplaceUrl = null;
    static String s_workplaceMultiScreenDefaultWindowFeatures = "";
    static boolean s_workplaceMultiScreenStartInFunctionTree = true;
    static String s_workplaceWorkpageStartInfoExtensionAdapter = null;
    static String s_workpageStarter = null;
    static String s_workpageSelector = null;
    static List<String> s_resourceSecurityAdditionalExtensions = new ArrayList<String>();
    static List<String> s_resourceClassloaderAccessAdditionalExtensions = new ArrayList<String>();
    static List<String> s_resourceClassloaderAccessIgnoreExtensions = new ArrayList<String>();
    static List<String> s_resourceSecurityCheckers = new ArrayList<String>();
    static String s_popupCreator = null;
    static String s_valueManagerTrueString = "\u2714";
    static String s_valueManagerFalseString = "\u2716";
    static String s_valueManagerTrueStringExport = "[X]";
    static String s_valueManagerFalseStringExport = "";
    static boolean s_useJavaClientFormatter = false;
    static String s_servletContextConfigurationIntializationClass = CCInitializeServlets.class.getName();
    static boolean s_responseLoggerActive = false;
    static Set<ResourceClassLoaderAccessWebContentFirst> s_resourceClassLoaderAccessWebContentFirsts = new HashSet<ResourceClassLoaderAccessWebContentFirst>();
    static Set<ResourceClassLoaderAccessIgnore> s_resourceClassLoaderAccessIgnores = new HashSet<ResourceClassLoaderAccessIgnore>();
    static String s_clientIdManagementCookieSecure = "false";
    static boolean s_clientIdManagementCookieHttpOnly = true;
    static String s_clientIdManagementCookieSameSite = null;
    static boolean s_blockerInfoActive = true;
    static String s_invalidExpressionDetectionInvalidCharacters = "";
    static boolean s_statusbarAutoAdd = true;
    static boolean s_threadContextStoreCurrentExpression = false;
    static String s_resourceManagerResourceAccessClassName = null;
    static String s_resourceManagerResourceManagerPreProcessorClassName = null;
    static String s_esapiResourceDirectory = null;
    static long s_keepAliveDuration = -1L;
    static List<PageInfo> s_allowIFrameEmbeddings = new ArrayList<PageInfo>();
    static String s_workplaceFunctionSearchExtension = null;
    static String s_configurationObjectLoaderClass = CCDefaultConfigurationObjectLoader.class.getName();
    static String s_layoutXMLModifierAfterRead = null;
    static String s_clientLiteralsUpdateClass = null;
    static String s_clientCountriesUpdateClass = null;
    static List<PageInfo> s_allowStartPages = new ArrayList<PageInfo>();
    static List<PageInfo> s_excludeStartPages = new ArrayList<PageInfo>();
    static String s_servertimeoutmanager_class = ServerTimeOutManager.class.getName();
    static String s_httpheaderattributesforpages_xxssprotection = null;
    static String s_httpheaderattributesforpages_xcontenttypeoptions = null;
    static String s_httpheaderattributesforpages_contentsecuritypolicy = null;
    static String s_httpheaderattributesforpages_referrerpolicy = null;
    static Set<String> s_simpleDataTypeManagerClassNames = new HashSet<String>();
    static DefaultPopups s_defaultPopups = new DefaultPopups();
    static String s_previewConfigurationClassName = ProcessPreviewByInstanceConfigurator.class.getName();
    static String s_instanceconfiguratorprefix = "";
    static String s_instanceconfiguratorsuffix = "_PREV";
    static String s_instanceconfiguratorsubpackage = "preview";
    static String s_eventblockerduringdecodeName = DefaultEventBlockerDuringDecode.class.getName();
    static Set<String> s_componentClassesWithEventEnabledCheck = new HashSet<String>();
    static Set<String> s_eventClassesWithEventEnabledCheck = new HashSet<String>();
    static String s_ccembeddedcontentBridgepagesXframeoptions = null;
    static String s_ccembeddedcontentTempfilecontentXframeoptions = null;
    static String s_ccembeddedcontentBufferedcontentXframeoptions = null;
    static boolean s_popupInternalManagementUseRowInclude = false;
    static boolean s_dialogMessageBusAsynchronous = false;
    static String s_unifiedPollingPollingType = "websocket";
    static String s_clusterMessageBusQueueClassName = null;
    static String s_clusterMessageBusTopic = null;
    static boolean s_clientAddOnDataWithPageInfo = true;
    static boolean s_clientAddOnDataWithControlInfo = false;
    static String s_tokenMgrClassName = null;

    public static void init(ServletContext servletContext) {
        s_webApplicationName = servletContext.getContextPath();
        s_webApplicationName = s_webApplicationName.replace("/", "");
        SystemXml.presetMetaTags();
        List<String> systemXMLs = EclntConfigFileReader.readConfiguration("system", true);
        for (String systemXML : systemXMLs) {
            SystemXml.parseAndProcessSystemXML(systemXML);
        }
    }

    public static String getSaxparserfactory() {
        return s_saxparserfactory;
    }

    public static boolean getLayoutBufferActive() {
        return s_layoutbufferActive;
    }

    public static boolean getFastExpressionResolution() {
        return s_fastexpressionresolution;
    }

    public static String getStarttemplateCcapplet() {
        return s_starttemplateCcapplet;
    }

    public static String getStarttemplateCcwebstart() {
        return s_starttemplateCcwebstart;
    }

    public static String getStarttemplateCcwebstartFX() {
        return s_starttemplateCcwebstartFX;
    }

    public static String getStarttemplateCcRisc() {
        return s_starttemplateCcRisc;
    }

    public static String getExtCalendarMgr() {
        return s_extcalendarmgr;
    }

    public static String getStreamStore() {
        return s_streamstore;
    }

    public static String getStreamStoreFileRootDir() {
        return s_streamstorefilerootdir;
    }

    public static String getFixgridExportCharacterSetCSV() {
        return s_fixgridexportcharactersetcsv;
    }

    public static String getFixgridExportCharacterSetXML() {
        return s_fixgridexportcharactersetxml;
    }

    public static String getFixgridExportHexBomCSV() {
        return s_fixgridexporthexbomcsv;
    }

    public static String getFixgridExportHexBomXML() {
        return s_fixgridexporthexbomxml;
    }

    public static String getFixgridPersistence() {
        return s_fixgridPersistence;
    }

    public static String getUserAccess() {
        return s_userAccess;
    }

    public static String getTenantAccess() {
        return s_tenantAccess;
    }

    public static String getLanguageAccess() {
        return s_languageAccess;
    }

    public static String getWFManagerClassName() {
        return s_wfmanager;
    }

    public static List<DynamicPageInfo> getDynamicPageInfos() {
        return s_dynamigePageInfos;
    }

    public static String getEncodenamejsessionid() {
        return s_encodenamejsessionid;
    }

    public static boolean getEncodeEnforceOwnEncoding() {
        return s_encodeenforceownencoding;
    }

    public static String getRownincludeRescuePage() {
        return s_rowincluderescuepage;
    }

    public static String getJdbcConnectionProvider() {
        return s_jdbcConnectionProvider;
    }

    public static boolean getSessionStateManagementUseContainer() {
        return s_sessionStateManagementUseContainer;
    }

    public static String getCcappletccwebstartcclibs() {
        return s_ccappletccwebstartcclibs;
    }

    public static String getCcappletccwebstartsplashimage() {
        return s_ccappletccwebstartsplashimage;
    }

    public static List<ClientParam> getCcappletccwebstartclientparams() {
        return s_ccappletccwebstartclientparams;
    }

    public static boolean getStoreOriginalTagAttributes() {
        return s_storeOriginalTagAttributes;
    }

    public static String getHtsessiontimeoutpage() {
        return s_htsessiontimeoutpage;
    }

    public static boolean getDialogsPersistenceEnabled() {
        return s_dialogsPersistenceEnabled;
    }

    public static boolean getDialogsUseWorkpageIdAsPersistid() {
        return s_dialogsUseWorkpageIdAsPersistid;
    }

    public static ServletConfiguration getServletConfiguration(Class clazz) {
        return s_servletConfigurations.get(clazz.getName());
    }

    public static List<ServletData> getAdditionalServlets() {
        return s_additionalServlets;
    }

    public static FilterConfiguration getFilterConfiguration(Class clazz) {
        return s_filterConfigurations.get(clazz.getName());
    }

    public static List<RISCClientScript> getRISCClientScripts() {
        return s_RISCClientScripts;
    }

    public static List<RISCClientStyle> getRISCClientStyles() {
        return s_RISCClientStyles;
    }

    public static List<RISCClientLink> getRISCClientLinks() {
        return s_RISCClientLinks;
    }

    public static List<RISCClientMetaTag> getRISCClientMetaTags() {
        return s_RISCClientMetaTags;
    }

    public static List<RISCClientFontAccess> getRISCClientFontAccess() {
        return s_RISCClientFontAccess;
    }

    public static RISCStarter getRiscStarter() {
        return s_riscStarter;
    }

    public static String getSecurityfilterextensionclassname() {
        return s_securityfilterextensionclassname;
    }

    public static String getSecurityfilterextensionclassnameGeneral() {
        return s_securityfilterextensionclassnameGeneral;
    }

    public static List<FileManagerReadAccess> getFileManagerReadAccessDirectories() {
        return s_fileManagerReadAccessDirectories;
    }

    public static List<FileManagerWriteAccess> getFileManagerWriteAccessDirectories() {
        return s_fileManagerWriteAccessDirectories;
    }

    public static boolean getNonJSFRequestsExplicitUTF8Conversion() {
        return s_nonJSFRequestsExplicitUTF8Conversion;
    }

    public static String getClientliteralserverloader() {
        return s_clientliteralserverloader;
    }

    public static String getCheckinboundandoutboundvalues() {
        return s_checkinboundandoutboundvalues;
    }

    static boolean getSessionMgmtViaCookie_InternalUsageOnly() {
        return s_sessionManagementViaCookies;
    }

    public static boolean getSessionMgmtSupportSwingClient_InternalUsageOnly() {
        return s_sessionManagementSupportSwingClient;
    }

    public static String getImageReaderClassName() {
        return s_imageReaderClassName;
    }

    public static String getExtImageFilterClassName() {
        return s_extImageFilterClassName;
    }

    public static boolean getWorkplaceWithHistory() {
        return s_workplaceWithHistory;
    }

    public static boolean getWorkplaceImplicitLoadingForCurrentUser() {
        return s_implicitLoadingForCurrentUser;
    }

    public static List<String> getResourceClassloaderAccessAdditionalExtensions() {
        return s_resourceClassloaderAccessAdditionalExtensions;
    }

    public static List<String> getResourceClassloaderAccessIgnoreExtensions() {
        return s_resourceClassloaderAccessIgnoreExtensions;
    }

    public static String getPopupCreator() {
        return s_popupCreator;
    }

    public static String getWorkpageStarter() {
        return s_workpageStarter;
    }

    public static String getWorkpageSelector() {
        return s_workpageSelector;
    }

    public static String getValueManagerTrueString() {
        return s_valueManagerTrueString;
    }

    public static String getValueManagerFalseString() {
        return s_valueManagerFalseString;
    }

    public static String getValueManagerTrueStringExport() {
        return s_valueManagerTrueStringExport;
    }

    public static String getValueManagerFalseStringExport() {
        return s_valueManagerFalseStringExport;
    }

    public static String getServletContextConfigurationIntializationClass() {
        return s_servletContextConfigurationIntializationClass;
    }

    public static boolean getResponseLoggerActive() {
        return s_responseLoggerActive;
    }

    public static Set<ResourceClassLoaderAccessWebContentFirst> getResourceClassLoaderAccessWebContentFirsts() {
        return s_resourceClassLoaderAccessWebContentFirsts;
    }

    public static Set<ResourceClassLoaderAccessIgnore> getResourceClassLoaderAccessIgnores() {
        return s_resourceClassLoaderAccessIgnores;
    }

    public static String getClientIdManagementCookieSecure() {
        return s_clientIdManagementCookieSecure;
    }

    public static boolean getClientIdManagementCookieHttpOnly() {
        return s_clientIdManagementCookieHttpOnly;
    }

    public static String getClientIdManagementCookieSameSite() {
        return s_clientIdManagementCookieSameSite;
    }

    public static boolean getBlockerInfoActive() {
        return s_blockerInfoActive;
    }

    public static String getInvalidExpressionDetectionInvalidCharacters() {
        return s_invalidExpressionDetectionInvalidCharacters;
    }

    public static boolean getStatusbarAutoAdd() {
        return s_statusbarAutoAdd;
    }

    public static boolean getThreadContextStoreCurrentExpression() {
        return s_threadContextStoreCurrentExpression;
    }

    public static String getResourceManagerResourceAccessClassName() {
        return s_resourceManagerResourceAccessClassName;
    }

    public static String getResourceManagerResourceManagerPreProcessorClassName() {
        return s_resourceManagerResourceManagerPreProcessorClassName;
    }

    public static String getFixgridCsvExport() {
        return s_fixgridCsvExport;
    }

    public static String getFixgridCsvExportDelimiter() {
        return s_fixgridCsvExportDelimiter;
    }

    public static String getFixgridXmlExport() {
        return s_fixgridXmlExport;
    }

    public static String getFixgridPdfExport() {
        return s_fixgridPdfExport;
    }

    public static String getFixgridHtmlExport() {
        return s_fixgridHtmlExport;
    }

    public static String getFixgridExcelExport() {
        return s_fixgridExcelExport;
    }

    public static String getFixgridOdsExport() {
        return s_fixgridOdsExport;
    }

    public static String getEsapiResourceDirectory() {
        return s_esapiResourceDirectory;
    }

    public static long getKeepAliveDuration() {
        return s_keepAliveDuration;
    }

    public static List<PageInfo> getAllowIFrameEmbeddings() {
        return s_allowIFrameEmbeddings;
    }

    public static boolean getUseJavaClientFormatter() {
        return s_useJavaClientFormatter;
    }

    public static String getWorkplaceFunctionSearchExtension() {
        return s_workplaceFunctionSearchExtension;
    }

    public static String getConfigurationObjectLoaderClass() {
        return s_configurationObjectLoaderClass;
    }

    public static String getLayoutXMLModifierAfterRead() {
        return s_layoutXMLModifierAfterRead;
    }

    public static String getClientLiteralsUpdateClass() {
        return s_clientLiteralsUpdateClass;
    }

    public static String getClientCountriesUpdateClass() {
        return s_clientCountriesUpdateClass;
    }

    public static String getServertimeoutmanager_class() {
        return s_servertimeoutmanager_class;
    }

    public static List<PageInfo> getAllowStartPages() {
        return s_allowStartPages;
    }

    public static List<PageInfo> getExcludeStartPages() {
        return s_excludeStartPages;
    }

    public static boolean getSessionManagementAutoClose() {
        return s_sessionManagementAutoClose;
    }

    public static String getFixgridCatchGridActionErrors() {
        return s_fixgridCatchGridActionErrors;
    }

    public static String getSessionDefaultsProvider() {
        return s_sessionDefaultsProvider;
    }

    public static String getHttpheaderattributesforpages_xxssprotection() {
        return s_httpheaderattributesforpages_xxssprotection;
    }

    public static String getHttpheaderattributesforpages_xcontenttypeoptions() {
        return s_httpheaderattributesforpages_xcontenttypeoptions;
    }

    public static String getHttpheaderattributesforpages_contentsecuritypolicy() {
        return s_httpheaderattributesforpages_contentsecuritypolicy;
    }

    public static String getHttpheaderattributesforpages_referrerpolicy() {
        return s_httpheaderattributesforpages_referrerpolicy;
    }

    public static String getFixgridExportSanitizer() {
        return s_fixgridExportSanitizer;
    }

    public static Set<String> getSimpleDataTypeManagerClassNames() {
        return s_simpleDataTypeManagerClassNames;
    }

    public static DefaultPopups getDefaultPopups() {
        return s_defaultPopups;
    }

    public static List<String> getResourceSecurityCheckers() {
        return s_resourceSecurityCheckers;
    }

    public static String getPreviewConfigurationClassName() {
        return s_previewConfigurationClassName;
    }

    public static String getInstanceConfiguratorPrefix() {
        return s_instanceconfiguratorprefix;
    }

    public static String getInstanceConfiguratorSuffix() {
        return s_instanceconfiguratorsuffix;
    }

    public static String getInstanceConfiguratorSubpackage() {
        return s_instanceconfiguratorsubpackage;
    }

    public static String getCcembeddedcontentBridgepagesXframeoptions() {
        return s_ccembeddedcontentBridgepagesXframeoptions;
    }

    public static String getCcembeddedcontentTempfilecontentXframeoptions() {
        return s_ccembeddedcontentTempfilecontentXframeoptions;
    }

    public static String getCcembeddedcontentBufferedcontentXframeoptions() {
        return s_ccembeddedcontentBufferedcontentXframeoptions;
    }

    public static String getEventblockerduringdecodeName() {
        return s_eventblockerduringdecodeName;
    }

    public static boolean getPopupInternalManagementUseRowInclude() {
        return s_popupInternalManagementUseRowInclude;
    }

    public static boolean getDialogMessageBusAsynchronous() {
        return s_dialogMessageBusAsynchronous;
    }

    public static boolean getWorkplaceMultiScreen() {
        return s_workplaceMultiScreen;
    }

    public static String getWorkplaceMultiScreenDefaultWorkplaceUrl() {
        return s_workplaceMultiScreenDefaultWorkplaceUrl;
    }

    public static String getWorkplaceMultiScreenDefaultWindowFeatures() {
        return s_workplaceMultiScreenDefaultWindowFeatures;
    }

    public static String getWorkplaceWorkpageStartInfoExtensionAdapter() {
        return s_workplaceWorkpageStartInfoExtensionAdapter;
    }

    public static String getUnifiedPollingPollingType() {
        return s_unifiedPollingPollingType;
    }

    public static String getFixgridGridDetailSortingOfColumns() {
        return s_fixgridGridDetailSortingOfColumns;
    }

    public static String getClusterMessageBusQueueClassName() {
        return s_clusterMessageBusQueueClassName;
    }

    public static String getClusterMessageBusTopic() {
        return s_clusterMessageBusTopic;
    }

    public static boolean getClientAddOnDataWithPageInfo() {
        return s_clientAddOnDataWithPageInfo;
    }

    public static boolean getClientAddOnDataWithControlInfo() {
        return s_clientAddOnDataWithControlInfo;
    }

    public static String getTokenMgrClassName() {
        return s_tokenMgrClassName;
    }

    public static boolean getWorkplaceMultiScreenStartInFunctionTree() {
        return s_workplaceMultiScreenStartInFunctionTree;
    }

    public static Set<String> getComponentClassesWithEventEnabledCheck() {
        return s_componentClassesWithEventEnabledCheck;
    }

    public static Set<String> getEventClassesWithEventEnabledCheck() {
        return s_eventClassesWithEventEnabledCheck;
    }

    private static void presetMetaTags() {
        s_RISCClientMetaTags.add(new RISCClientMetaTag(null, "Content-Type", "text/html;charset=UTF-8"));
        s_RISCClientMetaTags.add(new RISCClientMetaTag("apple-mobile-web-app-capable", null, "yes"));
        s_RISCClientMetaTags.add(new RISCClientMetaTag("mobile-web-app-capable", null, "yes"));
        s_RISCClientMetaTags.add(new RISCClientMetaTag("viewport", null, "width=device-width,height=device-height,user-scalable=no,initial-scale=1,maximum-scale=1,minimum-scale=1"));
    }

    private static void parseAndProcessSystemXML(String systemXML) {
        if (systemXML != null) {
            try {
                systemXML = ValueManager.replaceSystemProperties(systemXML, s_webApplicationName, true);
                SAXParser parser = SAXParserCreator.createSAXParser();
                InputSource is = new InputSource(new StringReader(systemXML));
                parser.parse(is, (DefaultHandler)new MyParser());
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Error when reading /eclntjsfserver/config/system.xml", t);
            }
        }
    }

    private static RISCClientMetaTag findExistingMetaTag(String name, String httpequiv) {
        for (RISCClientMetaTag rmt : s_RISCClientMetaTags) {
            if (!ValueManager.checkIfStringsAreEqual(name, rmt.i_name) || !ValueManager.checkIfStringsAreEqual(httpequiv, rmt.i_httpequiv)) continue;
            return rmt;
        }
        return null;
    }

    public static class DefaultPopups {
        String i_okpopup = null;
        String i_yesnopopup = null;
        String i_idtextselection = null;
        String i_idtextselectionwithexplanation = null;
        String i_idvalueimageselection = null;
        String i_idattributeselection = null;

        public String getOkpopup() {
            return this.i_okpopup;
        }

        public String getYesnopopup() {
            return this.i_yesnopopup;
        }

        public String getIdtextselection() {
            return this.i_idtextselection;
        }

        public String getIdtextselectionwithexplanation() {
            return this.i_idtextselectionwithexplanation;
        }

        public String getIdvalueimageselection() {
            return this.i_idvalueimageselection;
        }

        public String getIdattributeselection() {
            return this.i_idattributeselection;
        }
    }

    public static class PageInfo {
        String i_page;

        public String getPage() {
            return this.i_page;
        }
    }

    public static class AllowIFrameEmbedding {
        String i_page;

        public String getPage() {
            return this.i_page;
        }
    }

    public static class RISCStarter {
        String i_pageicon = "eclnt/images/icon.png";
        String i_title = "CaptainCasa Enterprise Client - RISC-HTML";
        String i_versionstampclassname = null;
        String i_startpagecheckerclassname = null;
        String i_embedableasiframe = null;
        String i_alternativeextension = null;
        String i_welcomeimage = null;
        String i_welcomewaitingimage = null;
        String i_welcomebackgroundcolor = null;
        int i_welcomeduration = 0;

        public String getPageicon() {
            return this.i_pageicon;
        }

        public String getTitle() {
            return this.i_title;
        }

        public String getVersionstampclassname() {
            return this.i_versionstampclassname;
        }

        public String getEmbedableasiframe() {
            return this.i_embedableasiframe;
        }

        public String getAlternativeextension() {
            return this.i_alternativeextension;
        }

        public String getStartpagecheckerclassname() {
            return this.i_startpagecheckerclassname;
        }

        public String getWelcomeimage() {
            return this.i_welcomeimage;
        }

        public String getWelcomewaitingimage() {
            return this.i_welcomewaitingimage;
        }

        public String getWelcomebackgroundcolor() {
            return this.i_welcomebackgroundcolor;
        }

        public int getWelcomeduration() {
            return this.i_welcomeduration;
        }
    }

    public static class RISCClientFontAccess {
        String i_face;
        String i_size = "10";

        private RISCClientFontAccess(String face, String size) {
            this.i_face = face;
            if (size != null) {
                this.i_size = size;
            }
        }

        public String getFace() {
            return this.i_face;
        }

        public String getSize() {
            return this.i_size;
        }
    }

    public static class RISCClientMetaTag {
        String i_name;
        String i_httpequiv;
        String i_content;

        private RISCClientMetaTag(String name, String httpequiv, String content) {
            this.i_name = name;
            this.i_httpequiv = httpequiv;
            this.i_content = content;
        }

        public String getName() {
            return this.i_name;
        }

        public String getHttpequiv() {
            return this.i_httpequiv;
        }

        public String getContent() {
            return this.i_content;
        }
    }

    public static class RISCClientLink {
        String i_rel;
        String i_href;
        String i_hreflang;
        String i_media;
        String i_type;
        String i_crossorigin;

        public RISCClientLink(String rel, String href, String hreflang, String media, String type, String crossorigin) {
            this.i_rel = rel;
            this.i_href = href;
            this.i_hreflang = hreflang;
            this.i_media = media;
            this.i_crossorigin = crossorigin;
        }

        public String getRel() {
            return this.i_rel;
        }

        public String getHref() {
            return this.i_href;
        }

        public String getHreflang() {
            return this.i_hreflang;
        }

        public String getMedia() {
            return this.i_media;
        }

        public String getType() {
            return this.i_type;
        }

        public String getCrossorigin() {
            return this.i_crossorigin;
        }
    }

    public static class RISCClientStyle {
        String i_src;

        public RISCClientStyle(String src) {
            this.i_src = src;
        }

        public String getSrc() {
            return this.i_src;
        }
    }

    public static class RISCClientScript {
        String i_src;
        String i_type;

        public RISCClientScript(String src, String type) {
            this.i_src = src;
            this.i_type = type;
            if (this.i_type == null) {
                this.i_type = "text/javascript";
            }
        }

        public String getSrc() {
            return this.i_src;
        }

        public String getType() {
            return this.i_type;
        }
    }

    public static class ClientParam {
        String i_name;
        String i_value;

        public ClientParam(String name, String value) {
            this.i_name = name;
            this.i_value = value;
        }

        public String getName() {
            return this.i_name;
        }

        public String getValue() {
            return this.i_value;
        }
    }

    public static class DynamicPageInfo {
        String i_classname;

        public DynamicPageInfo(String classname) {
            this.i_classname = classname;
        }

        public String getClassname() {
            return this.i_classname;
        }
    }

    public static class ServletData {
        String i_classname;
        String[] i_mappings;

        public ServletData(String classname, String[] mappings) {
            this.i_classname = classname;
            this.i_mappings = mappings;
        }

        public String getClassname() {
            return this.i_classname;
        }

        public String[] getMappings() {
            return this.i_mappings;
        }
    }

    public static class ServletConfiguration {
        String i_classname;
        boolean i_blockget = false;
        String[] i_additionalMappings;
        boolean i_active = true;

        private ServletConfiguration(String classname, boolean blockget, String[] additionalMappings, boolean active) {
            this.i_classname = classname;
            this.i_blockget = blockget;
            this.i_additionalMappings = additionalMappings;
            this.i_active = active;
        }

        public String getClassname() {
            return this.i_classname;
        }

        public boolean getBlockget() {
            return this.i_blockget;
        }

        public String[] getAdditionalMappings() {
            return this.i_additionalMappings;
        }

        public boolean isActive() {
            return this.i_active;
        }
    }

    public static class FilterConfiguration {
        String i_classname;
        String[] i_additionalMappings;
        boolean i_active = true;

        private FilterConfiguration(String classname, String[] additionalMappings, boolean active) {
            this.i_classname = classname;
            this.i_additionalMappings = additionalMappings;
            this.i_active = active;
        }

        public String getClassname() {
            return this.i_classname;
        }

        public String[] getAdditionalMappings() {
            return this.i_additionalMappings;
        }

        public boolean isActive() {
            return this.i_active;
        }
    }

    public static class FileManagerWriteAccess {
        String i_directory;

        public FileManagerWriteAccess(String directory) {
            this.i_directory = directory;
        }

        public String getDirectory() {
            return this.i_directory;
        }
    }

    public static class FileManagerReadAccess {
        String i_directory;

        public FileManagerReadAccess(String directory) {
            this.i_directory = directory;
        }

        public String getDirectory() {
            return this.i_directory;
        }
    }

    public static class ResourceClassLoaderAccessIgnore {
        String i_path;

        public ResourceClassLoaderAccessIgnore(String path) {
            this.i_path = path;
        }

        public String getPath() {
            return this.i_path;
        }
    }

    public static class ResourceClassLoaderAccessWebContentFirst {
        String i_path;

        public ResourceClassLoaderAccessWebContentFirst(String path) {
            this.i_path = path;
        }

        public String getPath() {
            return this.i_path;
        }
    }

    static class MyParser
    extends DefaultHandler {
        MyParser() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            String d;
            String p;
            String v;
            String src;
            String classname;
            String c;
            String s;
            String sName;
            if (name.equals("saxparserfactory")) {
                s_saxparserfactory = attributes.getValue("name");
            }
            if (name.equals("layoutbuffer")) {
                String value = attributes.getValue("active");
                if (value == null) {
                    value = attributes.getValue("name");
                }
                s_layoutbufferActive = ValueManager.decodeBoolean(value, true);
            }
            if (name.equals("fastexpressionresolution")) {
                s_fastexpressionresolution = ValueManager.decodeBoolean(attributes.getValue("active"), false);
            }
            if (name.equals("starttemplates")) {
                String ccapplet = attributes.getValue("ccapplet");
                String ccwebstart = attributes.getValue("ccwebstart");
                String ccrisc = attributes.getValue("ccrisc");
                if (ccapplet != null) {
                    s_starttemplateCcapplet = ccapplet;
                }
                if (ccwebstart != null) {
                    s_starttemplateCcwebstart = ccwebstart;
                }
                if (ccrisc != null) {
                    s_starttemplateCcRisc = ccrisc;
                }
            }
            if (name.equals("extcalendarmgr") && (sName = attributes.getValue("name")) != null) {
                s_extcalendarmgr = sName;
            }
            if (name.equals("streamstore")) {
                sName = attributes.getValue("name");
                if (sName != null) {
                    s_streamstore = sName;
                }
                if ((sName = attributes.getValue("rootdir")) != null) {
                    s_streamstorefilerootdir = sName;
                }
            }
            if (name.equals("fixgrid")) {
                String exportSanitizer;
                String sBom;
                String sCharacterSet;
                String sCsvExport;
                String sHtmlExport;
                String sOdsExport;
                String sExcelExport;
                String sXmlExport;
                String sPdfExport;
                String sPersistence = attributes.getValue("persistence");
                if (sPersistence != null) {
                    s_fixgridPersistence = sPersistence;
                }
                if ((sPdfExport = attributes.getValue("pdfexport")) != null) {
                    s_fixgridPdfExport = sPdfExport;
                }
                if ((sXmlExport = attributes.getValue("xmlexport")) != null) {
                    s_fixgridXmlExport = sXmlExport;
                }
                if ((sExcelExport = attributes.getValue("excelexport")) != null) {
                    s_fixgridExcelExport = sExcelExport;
                }
                if ((sOdsExport = attributes.getValue("odsexport")) != null) {
                    s_fixgridOdsExport = sOdsExport;
                }
                if ((sHtmlExport = attributes.getValue("htmlexport")) != null) {
                    s_fixgridHtmlExport = sHtmlExport;
                }
                if ((sCsvExport = attributes.getValue("csvexport")) != null) {
                    s_fixgridCsvExport = sCsvExport;
                }
                if ((s = attributes.getValue("csvexportdelimiter")) != null) {
                    s_fixgridCsvExportDelimiter = s;
                }
                if ((sCharacterSet = attributes.getValue("exportcharactersetcsv")) != null) {
                    s_fixgridexportcharactersetcsv = sCharacterSet;
                }
                if ((sCharacterSet = attributes.getValue("exportcharactersetxml")) != null) {
                    s_fixgridexportcharactersetxml = sCharacterSet;
                }
                if ((s = attributes.getValue("catchgridactionerrors")) != null) {
                    s_fixgridCatchGridActionErrors = s;
                }
                if ((sBom = attributes.getValue("exporthexbomcsv")) != null) {
                    s_fixgridexporthexbomcsv = sBom.trim();
                }
                if ((sBom = attributes.getValue("exporthexbomxml")) != null) {
                    s_fixgridexporthexbomxml = sBom.trim();
                }
                if ((s = attributes.getValue("griddetailsortingofcolumns")) != null) {
                    s_fixgridGridDetailSortingOfColumns = s;
                }
                if ((exportSanitizer = attributes.getValue("exportsanitizer")) != null) {
                    s_fixgridExportSanitizer = exportSanitizer;
                }
            }
            if (name.equals("useraccess") && (s = attributes.getValue("name")) != null) {
                s_userAccess = s;
            }
            if (name.equals("tenantaccess") && (s = attributes.getValue("name")) != null) {
                s_tenantAccess = s;
            }
            if (name.equals("languageaccess") && (s = attributes.getValue("name")) != null) {
                s_languageAccess = s;
            }
            if (name.equals("clientliteralserverloader") && (s = attributes.getValue("name")) != null) {
                s_clientliteralserverloader = s;
            }
            if (name.equals("wfmanager") && (s = attributes.getValue("name")) != null) {
                s_wfmanager = s;
            }
            if (name.equals("dynamicpageprovider") && (c = attributes.getValue("name")) != null) {
                s_dynamigePageInfos.add(new DynamicPageInfo(c));
            }
            if (name.equals("layoutxmlmodifierafterread") && (c = attributes.getValue("name")) != null) {
                s_layoutXMLModifierAfterRead = c;
            }
            if (name.equals("encodenamejsessionid")) {
                s = attributes.getValue("name");
                if (s != null) {
                    s_encodenamejsessionid = s;
                }
                if ((s = attributes.getValue("enforceownencoding")) != null) {
                    s_encodeenforceownencoding = ValueManager.decodeBoolean(s, false);
                }
            }
            if (name.equals("rowinclude") && (s = attributes.getValue("rescuepage")) != null) {
                s_rowincluderescuepage = s;
            }
            if (name.equals("jdbcconnectionprovider") && (s = attributes.getValue("name")) != null) {
                s_jdbcConnectionProvider = s;
            }
            if (name.equals("sessionstatemanagement") && (s = attributes.getValue("usecontainer")) != null) {
                s_sessionStateManagementUseContainer = ValueManager.decodeBoolean(s, false);
            }
            if (name.equals("ccappletccwebstart")) {
                s = attributes.getValue("cclibs");
                if (s != null) {
                    s_ccappletccwebstartcclibs = s;
                }
                if ((s = attributes.getValue("splashimage")) != null) {
                    s_ccappletccwebstartsplashimage = s;
                }
            }
            if (name.equals("clientparam")) {
                ClientParam cp = new ClientParam(attributes.getValue("name"), attributes.getValue("value"));
                s_ccappletccwebstartclientparams.add(cp);
            }
            if (name.equals("nonjsfrequests") && (s = attributes.getValue("explicitutf8conversion")) != null) {
                s_nonJSFRequestsExplicitUTF8Conversion = ValueManager.decodeBoolean(s, true);
            }
            if (name.equals("memoryoptimization")) {
                s = attributes.getValue("storeoriginaltagattributes");
                s_storeOriginalTagAttributes = ValueManager.decodeBoolean(s, true);
            }
            if (name.equals("ht")) {
                s_htsessiontimeoutpage = attributes.getValue("sessiontimeoutpage");
            }
            if (name.equals("dialogs")) {
                s_dialogsPersistenceEnabled = ValueManager.decodeBoolean(attributes.getValue("persistenceenabled"), true);
                s_dialogsUseWorkpageIdAsPersistid = ValueManager.decodeBoolean(attributes.getValue("useworkpageidaspersistid"), true);
            }
            if (name.equals("servletconfiguration") && (classname = attributes.getValue("classname")) != null) {
                boolean active = ValueManager.decodeBoolean(attributes.getValue("active"), true);
                boolean blockget = ValueManager.decodeBoolean(attributes.getValue("blockget"), false);
                String[] additionalMappings = null;
                String amString = attributes.getValue("additionalmappings");
                if (amString != null && amString.trim().length() > 0) {
                    additionalMappings = ValueManager.decodeCSV(amString);
                }
                ServletConfiguration sc = new ServletConfiguration(classname, blockget, additionalMappings, active);
                s_servletConfigurations.put(classname, sc);
            }
            if (name.equals("addservlet") && (classname = attributes.getValue("classname")) != null) {
                String[] mappings = null;
                String m = attributes.getValue("mappings");
                if (!ValueManager.isEmpty(m)) {
                    mappings = ValueManager.decodeCSV(m);
                    ServletData sc = new ServletData(classname, mappings);
                    s_additionalServlets.add(sc);
                }
            }
            if (name.equals("filterconfiguration") && (classname = attributes.getValue("classname")) != null) {
                boolean active = ValueManager.decodeBoolean(attributes.getValue("active"), true);
                String[] additionalMappings = null;
                String amString = attributes.getValue("additionalmappings");
                if (amString != null && amString.trim().length() > 0) {
                    additionalMappings = ValueManager.decodeCSV(amString);
                }
                FilterConfiguration sc = new FilterConfiguration(classname, additionalMappings, active);
                s_filterConfigurations.put(classname, sc);
            }
            if (name.equals("riscclientscript")) {
                src = attributes.getValue("src");
                String type = attributes.getValue("type");
                RISCClientScript rsc = new RISCClientScript(src, type);
                s_RISCClientScripts.add(rsc);
            }
            if (name.equals("riscclientstyle")) {
                src = attributes.getValue("src");
                RISCClientStyle rsc = new RISCClientStyle(src);
                s_RISCClientStyles.add(rsc);
            }
            if (name.equals("riscclientlink")) {
                String rel = attributes.getValue("rel");
                String href = attributes.getValue("href");
                String hreflang = attributes.getValue("hreflang");
                String media = attributes.getValue("media");
                String type = attributes.getValue("type");
                String crossorigin = attributes.getValue("crossorigin");
                RISCClientLink rsc = new RISCClientLink(rel, href, hreflang, media, type, crossorigin);
                s_RISCClientLinks.add(rsc);
            }
            if (name.equals("riscclientmetatag")) {
                String n = attributes.getValue("name");
                String h = attributes.getValue("httpequiv");
                String c2 = attributes.getValue("content");
                RISCClientMetaTag rmt = SystemXml.findExistingMetaTag(n, h);
                if (rmt == null) {
                    if (c2 != null) {
                        rmt = new RISCClientMetaTag(n, h, c2);
                        s_RISCClientMetaTags.add(rmt);
                    }
                } else if (c2 != null) {
                    rmt.i_content = c2;
                } else {
                    s_RISCClientMetaTags.remove(rmt);
                }
            }
            if (name.equals("riscclientfontaccess")) {
                String f = attributes.getValue("face");
                String s2 = attributes.getValue("size");
                RISCClientFontAccess rfa = new RISCClientFontAccess(f, s2);
                s_RISCClientFontAccess.add(rfa);
            }
            if (name.equals(SystemXml.NAME_RISCSTARTER)) {
                v = attributes.getValue("pageicon");
                if (v != null) {
                    SystemXml.s_riscStarter.i_pageicon = v;
                }
                if ((v = attributes.getValue(SystemXml.ATT_WELCOMEIMAGE)) != null) {
                    SystemXml.s_riscStarter.i_welcomeimage = v;
                }
                if ((v = attributes.getValue(SystemXml.ATT_WELCOMEWAITINGIMAGE)) != null) {
                    SystemXml.s_riscStarter.i_welcomewaitingimage = v;
                }
                if ((v = attributes.getValue(SystemXml.ATT_WELCOMEBACKGROUNDCOLOR)) != null) {
                    SystemXml.s_riscStarter.i_welcomebackgroundcolor = v;
                }
                if ((v = attributes.getValue(SystemXml.ATT_WELCOMEDURATION)) != null) {
                    SystemXml.s_riscStarter.i_welcomeduration = ValueManager.decodeInt(v, 0);
                }
                if ((v = attributes.getValue("title")) != null) {
                    SystemXml.s_riscStarter.i_title = v;
                }
                if ((v = attributes.getValue("versionstampclassname")) != null) {
                    SystemXml.s_riscStarter.i_versionstampclassname = v;
                }
                if ((v = attributes.getValue("embedableasiframe")) != null) {
                    SystemXml.s_riscStarter.i_embedableasiframe = v;
                }
                if ((v = attributes.getValue("alternativeextension")) != null) {
                    if (!v.startsWith(".")) {
                        CLog.L.log(CLog.LL_ERR, "Alternative extension defined in system.xml is not correctly defined - must start with a \".\"");
                    }
                    SystemXml.s_riscStarter.i_alternativeextension = v;
                }
                if ((v = attributes.getValue("startpagecheckerclassname")) != null) {
                    SystemXml.s_riscStarter.i_startpagecheckerclassname = v;
                }
            }
            if (name.equals(SystemXml.NAME_ALLOWSTART) && (p = attributes.getValue(SystemXml.ATT_PAGE)) != null) {
                PageInfo aie = new PageInfo();
                aie.i_page = p;
                s_allowStartPages.add(aie);
            }
            if (name.equals(SystemXml.NAME_EXCLUDESTART) && (p = attributes.getValue(SystemXml.ATT_PAGE)) != null) {
                PageInfo aie = new PageInfo();
                aie.i_page = p;
                s_excludeStartPages.add(aie);
            }
            if (name.equals(SystemXml.NAME_ALLOWIFRAMEEMBEDDING) && (p = attributes.getValue(SystemXml.ATT_PAGE)) != null) {
                PageInfo aie = new PageInfo();
                aie.i_page = p;
                s_allowIFrameEmbeddings.add(aie);
            }
            if (name.equals("checkinboundandoutboundvalues") && (s = attributes.getValue("name")) != null) {
                s_checkinboundandoutboundvalues = s;
            }
            if (name.equals("securityfilter")) {
                v = attributes.getValue("extensionclassname");
                if (v != null) {
                    s_securityfilterextensionclassname = v;
                }
                if ((v = attributes.getValue("extensionclassnameGeneral")) != null) {
                    s_securityfilterextensionclassnameGeneral = v;
                }
            }
            if (name.equals("filemanagerreadaccess") && (d = attributes.getValue("directory")) != null) {
                FileManagerReadAccess ra = new FileManagerReadAccess(d);
                s_fileManagerReadAccessDirectories.add(ra);
            }
            if (name.equals("filemanagerwriteaccess") && (d = attributes.getValue("directory")) != null) {
                FileManagerWriteAccess wa = new FileManagerWriteAccess(d);
                s_fileManagerWriteAccessDirectories.add(wa);
            }
            if (name.equals("sessionmanagement")) {
                s = attributes.getValue("type");
                if ("cookie".equalsIgnoreCase(s)) {
                    s_sessionManagementViaCookies = true;
                }
                if ("true".equals(s = attributes.getValue("supportswingclient"))) {
                    s_sessionManagementSupportSwingClient = true;
                }
                s = attributes.getValue("autoclose");
                s_sessionManagementAutoClose = ValueManager.decodeBoolean(s, true);
                s_sessionDefaultsProvider = s = attributes.getValue("sessiondefaultsprovider");
            }
            if (name.equals("servletcontextconfiguration") && (s = attributes.getValue("initializationclass")) != null) {
                s_servletContextConfigurationIntializationClass = s;
            }
            if (name.equals("serverimagemanager")) {
                s = attributes.getValue("imagereaderclassname");
                if (s != null) {
                    s_imageReaderClassName = s;
                }
                if ((s = attributes.getValue("extimagefilterclassname")) != null) {
                    s_extImageFilterClassName = s;
                }
            }
            if (name.equals("workplace")) {
                s = attributes.getValue("withhistory");
                if (s != null) {
                    s_workplaceWithHistory = ValueManager.decodeBoolean(s, false);
                }
                if ((s = attributes.getValue("implicitloadingforcurrentuser")) != null) {
                    s_implicitLoadingForCurrentUser = ValueManager.decodeBoolean(s, true);
                }
                if ((s = attributes.getValue("workpagestarter")) != null) {
                    s_workpageStarter = s;
                }
                if ((s = attributes.getValue("workpageselector")) != null) {
                    s_workpageSelector = s;
                }
                if ((s = attributes.getValue("workplacefunctionsearchextension")) != null) {
                    s_workplaceFunctionSearchExtension = s;
                }
                if ((s = attributes.getValue("multiscreen")) != null) {
                    s_workplaceMultiScreen = ValueManager.decodeBoolean(s, false);
                }
                if ((s = attributes.getValue("multiscreendefaultworkplaceurl")) != null) {
                    s_workplaceMultiScreenDefaultWorkplaceUrl = s;
                }
                if ((s = attributes.getValue("multiscreendefaultwindowfeatures")) != null) {
                    s_workplaceMultiScreenDefaultWindowFeatures = s;
                }
                if ((s = attributes.getValue("multiscreenstartinfunctiontree")) != null) {
                    s_workplaceMultiScreenStartInFunctionTree = ValueManager.decodeBoolean(s, true);
                }
                if ((s = attributes.getValue("workpagestartinfoextensionadapter")) != null) {
                    s_workplaceWorkpageStartInfoExtensionAdapter = s;
                }
            }
            if (name.equals("resourceclassloaderaccess")) {
                s = attributes.getValue("additionalextensions");
                if (s != null) {
                    String[] extensions;
                    for (String extension : extensions = ValueManager.decodeCSV(s)) {
                        if (extension == null || extension.trim().length() == 0) continue;
                        s_resourceClassloaderAccessAdditionalExtensions.add(extension);
                    }
                }
                if ((s = attributes.getValue("ignoreextensions")) != null) {
                    String[] extensions;
                    for (String extension : extensions = ValueManager.decodeCSV(s)) {
                        if (extension == null || extension.trim().length() == 0) continue;
                        s_resourceClassloaderAccessIgnoreExtensions.add(extension);
                    }
                }
            }
            if (name.equals("resourcesecuritychecker") && (s = attributes.getValue("name")) != null) {
                s_resourceSecurityCheckers.add(s);
            }
            if (name.equals("webcontentfirst") && (s = attributes.getValue("path")) != null) {
                ResourceClassLoaderAccessWebContentFirst o = new ResourceClassLoaderAccessWebContentFirst(s);
                s_resourceClassLoaderAccessWebContentFirsts.add(o);
            }
            if (name.equals("ignore") && (s = attributes.getValue("path")) != null) {
                ResourceClassLoaderAccessIgnore o = new ResourceClassLoaderAccessIgnore(s);
                s_resourceClassLoaderAccessIgnores.add(o);
            }
            if (name.equals("startupclass") && (s = attributes.getValue("name")) != null) {
                CCInitialize.initApplicationStartUpClass(s);
            }
            if (name.equals("popupcreator") && (s = attributes.getValue("name")) != null) {
                s_popupCreator = s;
            }
            if (name.equals("valuemanager")) {
                s = attributes.getValue("truestring");
                if (s != null) {
                    s_valueManagerTrueString = s;
                }
                if ((s = attributes.getValue("falsestring")) != null) {
                    s_valueManagerFalseString = s;
                }
                if ((s = attributes.getValue("truestringexport")) != null) {
                    s_valueManagerTrueStringExport = s;
                }
                if ((s = attributes.getValue("falsestringexport")) != null) {
                    s_valueManagerFalseStringExport = s;
                }
                if ((s = attributes.getValue("usejavaclientformatter")) != null) {
                    s_useJavaClientFormatter = ValueManager.decodeBoolean(s, false);
                }
            }
            if (name.equals("simpledatatypeextension") && (s = attributes.getValue("classname")) != null) {
                s_simpleDataTypeManagerClassNames.add(s);
            }
            if (name.equals("responselogger")) {
                s = attributes.getValue("active");
                s_responseLoggerActive = ValueManager.decodeBoolean(s, false);
            }
            if (name.equals("clientidmanagement")) {
                s = attributes.getValue("cookiesecure");
                if (s != null) {
                    s_clientIdManagementCookieSecure = s;
                }
                if ((s = attributes.getValue("cookiehttponly")) != null) {
                    s_clientIdManagementCookieHttpOnly = ValueManager.decodeBoolean(s, true);
                }
                if ((s = attributes.getValue("cookiesamesite")) != null) {
                    s_clientIdManagementCookieSameSite = s;
                }
            }
            if (name.equals("blockerinfo")) {
                s = attributes.getValue("active");
                s_blockerInfoActive = ValueManager.decodeBoolean(s, true);
            }
            if (name.equals("statusbar")) {
                s = attributes.getValue("autoadd");
                s_statusbarAutoAdd = ValueManager.decodeBoolean(s, true);
            }
            if (name.equals("invalidexpressiondetection") && (s = attributes.getValue("invalidcharacters")) != null) {
                s_invalidExpressionDetectionInvalidCharacters = s;
            }
            if (name.equals("threadcontext") && (s = attributes.getValue("storecurrentexpression")) != null) {
                s_threadContextStoreCurrentExpression = ValueManager.decodeBoolean(s, false);
            }
            if (name.equals("resourcemanager")) {
                s = attributes.getValue("resourceaccessclassname");
                if (s != null) {
                    s_resourceManagerResourceAccessClassName = s;
                }
                if ((s = attributes.getValue("resourcemanagerpreprocessorclassname")) != null) {
                    s_resourceManagerResourceManagerPreProcessorClassName = s;
                }
            }
            if (name.equals("esapi") && (s = attributes.getValue("resourcedirectory")) != null) {
                s_esapiResourceDirectory = s;
            }
            if (name.equals("longpolling") && (s = attributes.getValue("keepaliveduration")) != null) {
                s_keepAliveDuration = ValueManager.decodeLong(s, -1L);
            }
            if (name.equals("configurationObjectLoader") && (s = attributes.getValue("class")) != null) {
                s_configurationObjectLoaderClass = s;
            }
            if (name.equals("clienti18n")) {
                s = attributes.getValue("clientliteralsupdateclass");
                if (s != null) {
                    s_clientLiteralsUpdateClass = s;
                }
                if ((s = attributes.getValue("clientcountriesupdateclass")) != null) {
                    s_clientCountriesUpdateClass = s;
                }
            }
            if (name.equals("servertimeoutmanager") && (s = attributes.getValue("class")) != null) {
                s_servertimeoutmanager_class = s;
            }
            if (name.equals("httpheaderattributesforpages")) {
                s_httpheaderattributesforpages_xxssprotection = attributes.getValue("x-xss-protection");
                s_httpheaderattributesforpages_xcontenttypeoptions = attributes.getValue("x-content-type-options");
                s_httpheaderattributesforpages_contentsecuritypolicy = attributes.getValue("content-security-policy");
                s_httpheaderattributesforpages_referrerpolicy = attributes.getValue("referrer-policy");
            }
            if (name.equals("defaultpopups")) {
                SystemXml.s_defaultPopups.i_okpopup = attributes.getValue("okpopup");
                SystemXml.s_defaultPopups.i_yesnopopup = attributes.getValue("yesnopopup");
                SystemXml.s_defaultPopups.i_idtextselection = attributes.getValue("idtextselection");
                SystemXml.s_defaultPopups.i_idtextselectionwithexplanation = attributes.getValue("idtextselectionwithexplanation");
                SystemXml.s_defaultPopups.i_idvalueimageselection = attributes.getValue("idvalueimageselection");
                SystemXml.s_defaultPopups.i_idattributeselection = attributes.getValue("idattributeselection");
            }
            if (name.equals("previewconfiguration")) {
                s = attributes.getValue("class");
                if (s != null) {
                    s_previewConfigurationClassName = s;
                }
                if ((s = attributes.getValue("instanceconfiguratorprefix")) != null) {
                    s_instanceconfiguratorprefix = s;
                }
                if ((s = attributes.getValue("instanceconfiguratorsuffix")) != null) {
                    s_instanceconfiguratorsuffix = s;
                }
                if ((s = attributes.getValue("instanceconfiguratorsubpackage")) != null) {
                    s_instanceconfiguratorsubpackage = s;
                }
            }
            if (name.equals("bridgepages")) {
                s_ccembeddedcontentBridgepagesXframeoptions = attributes.getValue("xframeoptions");
            }
            if (name.equals("tempfilecontent")) {
                s_ccembeddedcontentTempfilecontentXframeoptions = attributes.getValue("xframeoptions");
            }
            if (name.equals("bufferedcontent")) {
                s_ccembeddedcontentBufferedcontentXframeoptions = attributes.getValue("xframeoptions");
            }
            if (name.equals("eventblockerduringdecode") && (s = attributes.getValue("name")) != null) {
                s_eventblockerduringdecodeName = s;
            }
            if (name.equals("componentClassWithEventEnabledCheck") && (s = attributes.getValue("name")) != null) {
                String[] value;
                for (String v2 : value = ValueManager.decodeCSV(s)) {
                    s_componentClassesWithEventEnabledCheck.add(v2);
                }
            }
            if (name.equals("eventClassWithEventEnabledCheck") && (s = attributes.getValue("name")) != null) {
                String[] value;
                for (String v2 : value = ValueManager.decodeCSV(s)) {
                    s_eventClassesWithEventEnabledCheck.add(v2);
                }
            }
            if (name.equals("popupinternalmanagement") && (s = attributes.getValue("userowinclude")) != null) {
                s_popupInternalManagementUseRowInclude = ValueManager.decodeBoolean(s, false);
            }
            if (name.equals("dialogmessagebus")) {
                s = attributes.getValue("crossclient");
                if (s != null) {
                    s_dialogMessageBusAsynchronous = ValueManager.decodeBoolean(s, false);
                }
                if ((s = attributes.getValue("asynchronous")) != null) {
                    s_dialogMessageBusAsynchronous = ValueManager.decodeBoolean(s, false);
                }
            }
            if (name.equals("clustermessagebus")) {
                s = attributes.getValue("queueclassname");
                if (s != null) {
                    s_clusterMessageBusQueueClassName = s;
                }
                if ((s = attributes.getValue("topic")) != null) {
                    s_clusterMessageBusTopic = s;
                }
            }
            if (name.equals("unifiedpolling") && (s = attributes.getValue("pollingtype")) != null) {
                s_unifiedPollingPollingType = s;
            }
            if (name.equals("clientaddondata")) {
                s = attributes.getValue("withpageinfo");
                if (s != null) {
                    s_clientAddOnDataWithPageInfo = ValueManager.decodeBoolean(s, true);
                }
                if ((s = attributes.getValue("withcontrolinfo")) != null) {
                    s_clientAddOnDataWithControlInfo = ValueManager.decodeBoolean(s, false);
                }
            }
            if (name.equals("urltokens") && (s = attributes.getValue("tokenmgrclassname")) != null) {
                s_tokenMgrClassName = s;
            }
        }
    }
}

