/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.pageparsing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclnt.jsfserver.elements.ICCComponentProperties;
import org.eclnt.jsfserver.util.pageparsing.NodeAttributeValue;
import org.eclnt.jsfserver.util.pageparsing.PageParser;
import org.eclnt.util.log.CLog;
import org.xml.sax.Attributes;

public class ParsedNodeBase
implements Serializable,
ICCComponentProperties {
    String m_name;
    String m_tagPrefix;
    String m_tagName;
    String m_id;
    List<NodeAttributeValue> m_attributes = new ArrayList<NodeAttributeValue>();
    List<ParsedNodeBase> m_subNodes = new ArrayList<ParsedNodeBase>();

    public String getId() {
        return this.m_id;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        try {
            this.m_name = name;
            int columnIndex = name.indexOf(58);
            this.m_tagPrefix = name.substring(0, columnIndex);
            this.m_tagName = name.substring(columnIndex + 1);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "", t);
        }
    }

    public String getTagPrefix() {
        return this.m_tagPrefix;
    }

    public String getTagName() {
        return this.m_tagName;
    }

    public List<NodeAttributeValue> getAttributes() {
        return this.m_attributes;
    }

    public List<ParsedNodeBase> getSubNodes() {
        return this.m_subNodes;
    }

    public void passAttributesFromSAXParser(Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String qName = attributes.getQName(i);
            String value = attributes.getValue(i);
            if (PageParser.ATT_ID.equals(qName)) {
                this.m_id = value;
            }
            this.m_attributes.add(new NodeAttributeValue(qName, value));
        }
    }

    public String getAttributeValue(String attribute) {
        if (attribute == null) {
            return null;
        }
        for (NodeAttributeValue av : this.m_attributes) {
            if (!attribute.equals(av.getName())) continue;
            return av.getValue();
        }
        return null;
    }

    public void setAttributeValue(String attribute, String value) {
        if (attribute == null) {
            return;
        }
        if (ATT_ID.equals(attribute)) {
            this.m_id = value;
        }
        for (NodeAttributeValue av : this.m_attributes) {
            if (!attribute.equals(av.getName())) continue;
            av.setValue(value);
            return;
        }
        NodeAttributeValue av = new NodeAttributeValue(attribute, value);
        this.m_attributes.add(av);
    }

    public ParsedNodeBase createSubNode() {
        ParsedNodeBase result = new ParsedNodeBase();
        this.m_subNodes.add(result);
        return result;
    }

    public void dump(StringBuffer sb, int level) {
        for (int i = 0; i < level * 4; ++i) {
            sb.append(" ");
        }
        sb.append(this.m_name);
        sb.append(" ");
        int counter = 0;
        for (NodeAttributeValue nav : this.getAttributes()) {
            if (counter > 0) {
                sb.append(", ");
            }
            sb.append(nav.getName() + ":" + nav.getValue());
            ++counter;
        }
        sb.append("\n");
        for (ParsedNodeBase subNode : this.getSubNodes()) {
            subNode.dump(sb, level + 1);
        }
    }
}

