/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.style;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclnt.jsfserver.session.UsageWithoutSessionContext;
import org.eclnt.jsfserver.streamstore.IStreamStoreWithBinary;
import org.eclnt.jsfserver.streamstore.StreamStore;
import org.eclnt.jsfserver.util.WebResourceClassloaderReader;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class StyleFileAccess {
    static final String STREAMSTORE_ROOTPATH = "/ccstylereader/";

    public static List<String> findDirectories(String webPath) {
        String fullPath;
        IStreamStoreWithBinary stst;
        List<String> l;
        if (webPath == null) {
            throw new Error("webPath must be defined");
        }
        if (!webPath.startsWith("/eclntjsfserver/styles/")) {
            throw new Error("webPath not correctly defined: " + webPath);
        }
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return new ArrayList<String>();
        }
        HashSet<String> dirs = new HashSet<String>();
        List<String> l2 = WebResourceClassloaderReader.getDirectoriesInPathDirectory(webPath);
        if (l2 != null) {
            dirs.addAll(l2);
        }
        if ((l = (stst = StreamStore.getCrossTenantInstanceWithBinary()).getContainedFolders(fullPath = ValueManager.encodeIntoValidFileName(STREAMSTORE_ROOTPATH + webPath, true), false)) != null) {
            dirs.addAll(l);
        }
        ArrayList<String> result = new ArrayList<String>(dirs);
        Collections.sort(result);
        return result;
    }

    public static List<String> findFiles(String webPath, String extension) {
        String fullPath;
        IStreamStoreWithBinary stst;
        List<String> l;
        Set<String> l2;
        if (webPath == null) {
            throw new Error("webPath must be defined");
        }
        if (!webPath.startsWith("/eclntjsfserver/styles/")) {
            throw new Error("webPath not correctly defined: " + webPath);
        }
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return new ArrayList<String>();
        }
        HashSet<String> dirs = new HashSet<String>();
        if (dirs.size() == 0 && (l2 = WebResourceClassloaderReader.getFilesInPathDirectory(webPath, null)) != null) {
            dirs.addAll(l2);
        }
        if (dirs.size() == 0 && (l = (stst = StreamStore.getCrossTenantInstanceWithBinary()).getContainedStreams(fullPath = ValueManager.encodeIntoValidFileName(STREAMSTORE_ROOTPATH + webPath, true), false)) != null) {
            dirs.addAll(l);
        }
        ArrayList<String> result = new ArrayList<String>(dirs);
        if (extension != null) {
            for (int i = result.size() - 1; i >= 0; --i) {
                if (((String)result.get(i)).endsWith(extension)) continue;
                result.remove(i);
            }
        }
        Collections.sort(result);
        return result;
    }

    public static byte[] readStyleFile(String webPath) {
        if (webPath == null) {
            throw new Error("webPath must be defined");
        }
        if (!webPath.startsWith("/eclntjsfserver/styles/")) {
            throw new Error("webPath not correctly defined: " + webPath);
        }
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
            return null;
        }
        try {
            byte[] warBytes = WebResourceClassloaderReader.readFileIntoByteArray(webPath);
            if (warBytes != null && warBytes.length > 0) {
                return warBytes;
            }
        }
        catch (Throwable warBytes) {
            // empty catch block
        }
        try {
            IStreamStoreWithBinary stst = StreamStore.getCrossTenantInstanceWithBinary();
            String fullPath = STREAMSTORE_ROOTPATH + webPath;
            fullPath = ValueManager.encodeIntoValidFileName(fullPath, false);
            byte[] ststBytes = stst.readData(STREAMSTORE_ROOTPATH + webPath, true);
            return ststBytes;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String readStyleUTF8File(String webPath) {
        if (webPath == null) {
            throw new Error("webPath must be defined");
        }
        if (!webPath.startsWith("/eclntjsfserver/styles/")) {
            throw new Error("webPath not correctly defined: " + webPath);
        }
        if (UsageWithoutSessionContext.isUsedWithoutSessionContext() && UsageWithoutSessionContext.findWebcontentDirectory() == null) {
            return null;
        }
        String result = null;
        try {
            String warString = WebResourceClassloaderReader.readUTF8FileIntoString(webPath, true);
            if (warString != null && warString.length() > 0) {
                result = warString;
            }
        }
        catch (Throwable warString) {
            // empty catch block
        }
        if (result == null) {
            try {
                String ststString;
                IStreamStoreWithBinary stst = StreamStore.getCrossTenantInstanceWithBinary();
                String fullPath = STREAMSTORE_ROOTPATH + webPath;
                fullPath = ValueManager.encodeIntoValidFileName(fullPath, false);
                result = ststString = stst.readUTF8(fullPath, true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public static void writeRuntimeStyleFile(String styleName, String fileName, String content) {
        try {
            String fullPath = "/ccstylereader/eclntjsfserver/styles/" + styleName + "/" + fileName;
            fullPath = ValueManager.encodeIntoValidFileName(fullPath, false);
            StreamStore.getCrossTenantInstance().writeUTF8(fullPath, content, true);
        }
        catch (Throwable t) {
            throw new Error("Problem writing runtime style: " + styleName + ", " + fileName, t);
        }
    }

    public static String readRuntimeStyleFileUTF8(String styleName, String fileName) {
        try {
            String fullPath = "/ccstylereader/eclntjsfserver/styles/" + styleName + "/" + fileName;
            fullPath = ValueManager.encodeIntoValidFileName(fullPath, false);
            String result = StreamStore.getCrossTenantInstance().readUTF8(fullPath, true);
            return result;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem reading runtime style: " + styleName + ", " + fileName, t);
            return null;
        }
    }

    public static byte[] readRuntimeStyleFile(String styleName, String fileName) {
        try {
            String fullPath = "/ccstylereader/eclntjsfserver/styles/" + styleName + "/" + fileName;
            fullPath = ValueManager.encodeIntoValidFileName(fullPath, false);
            return StreamStore.getCrossTenantInstanceWithBinary().readData(fullPath, true);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem reading runtime style: " + styleName + ", " + fileName, t);
            return null;
        }
    }

    public static void writeRuntimeStyleFile(String styleName, String fileName, byte[] content) {
        try {
            String fullPath = "/ccstylereader/eclntjsfserver/styles/" + styleName + "/" + fileName;
            fullPath = ValueManager.encodeIntoValidFileName(fullPath, false);
            StreamStore.getCrossTenantInstanceWithBinary().writeData(fullPath, content, true);
        }
        catch (Throwable t) {
            throw new Error("Problem writing runtime style: " + styleName + ", " + fileName, t);
        }
    }
}

