/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.token;

import java.util.List;
import org.eclnt.jsfserver.streamstore.IStreamStore;
import org.eclnt.jsfserver.streamstore.StreamStore;
import org.eclnt.util.log.CLog;
import org.eclnt.util.token.Token;
import org.eclnt.util.token.TokenMgrImplInProcessMap;
import org.eclnt.util.valuemgmt.JAXBManager;

public class TokenMgrImplByStreamStore
extends TokenMgrImplInProcessMap {
    private static final String STREAMSTORE_PATH_WS = "/cctokens/";

    @Override
    protected Token readToken(String uuid) {
        try {
            String xml = StreamStore.getInstance().readUTF8(this.buildTokenPath(uuid), true);
            return (Token)JAXBManager.unmarshal(xml, Token.class);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    protected void saveToken(Token token) {
        if (token == null) {
            return;
        }
        String xml = JAXBManager.marshal(token);
        StreamStore.getInstance().writeUTF8(this.buildTokenPath(token.getUuid()), xml, true);
        CLog.L.log(CLog.LL_INF, "TokenMgr: saved token - " + token.getUuid());
    }

    @Override
    protected void deleteToken(String uuid) {
        StreamStore.getInstance().removeStream(this.buildTokenPath(uuid), true);
        CLog.L.log(CLog.LL_INF, "TokenMgr: deleted token - " + uuid);
    }

    @Override
    protected void cleanUpUnusedTokensExecute() {
        try {
            CLog.L.log(CLog.LL_INF, "TokenMgr: cleaning timed out tokens");
            IStreamStore stst = StreamStore.getInstance();
            List<String> names = stst.getContainedStreams(STREAMSTORE_PATH_WS, true);
            long now = System.currentTimeMillis();
            for (String name : names) {
                try {
                    String xml = stst.readUTF8(STREAMSTORE_PATH_WS + name, true);
                    Token token = (Token)JAXBManager.unmarshal(xml, Token.class);
                    if (!this.checkIfTokenIsTimedOut(token)) continue;
                    this.deleteToken(token.getUuid());
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String buildTokenPath(String uuid) {
        return STREAMSTORE_PATH_WS + uuid + ".xml";
    }
}

