/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.useraccess;

import java.util.Hashtable;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclnt.jsfserver.session.UsageWithoutSessionContext;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ISessionAbstraction;
import org.eclnt.jsfserver.util.useraccess.IUserAccess;

public class DefaultUserAccess
implements IUserAccess {
    private static final String KEY_USERNAME = DefaultUserAccess.class.getName() + "/userName";
    private static final Map<Thread, String> s_userPerThread = new Hashtable<Thread, String>();

    @Override
    public String getCurrentUser() {
        String userName;
        try {
            ISessionAbstraction dialogSession = HttpSessionAccess.getCurrentDialogSession();
            if (dialogSession != null && (userName = (String)dialogSession.getAttribute(KEY_USERNAME)) != null) {
                return userName;
            }
        }
        catch (Throwable dialogSession) {
            // empty catch block
        }
        try {
            HttpSession httpSession = HttpSessionAccess.getCurrentHttpSession();
            if (httpSession != null && (userName = (String)httpSession.getAttribute(KEY_USERNAME)) != null) {
                return userName;
            }
        }
        catch (Throwable httpSession) {
            // empty catch block
        }
        try {
            String userName2 = s_userPerThread.get(Thread.currentThread());
            if (userName2 != null) {
                return userName2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "undefined";
    }

    public String getCurrentUser(FacesContext context) {
        return this.getCurrentUser();
    }

    public static void associateUserWithCurrentSession(String userName) {
        HttpSession httpSession = HttpSessionAccess.getCurrentHttpSession();
        if (httpSession == null) {
            if (!UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
                throw new Error("No http session available in the current context. Not possible to store user with http session.");
            }
            return;
        }
        httpSession.setAttribute(KEY_USERNAME, (Object)userName);
        try {
            ISessionAbstraction dialogSession = HttpSessionAccess.getCurrentDialogSession(httpSession);
            dialogSession.setAttribute(KEY_USERNAME, userName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void associateUserWithCurrentSession(HttpServletRequest request, String userName) {
        HttpSession httpSession = request.getSession();
        httpSession.setAttribute(KEY_USERNAME, (Object)userName);
        String subpageId = request.getParameter("cc_subpageId");
        if (subpageId != null) {
            ISessionAbstraction dialogSession = HttpSessionAccess.getCurrentDialogSession(httpSession, subpageId);
            dialogSession.setAttribute(KEY_USERNAME, userName);
        }
    }

    public static void clearUserWithCurrentSession() {
        HttpSession httpSession = HttpSessionAccess.getCurrentHttpSession();
        if (httpSession != null) {
            httpSession.removeAttribute(KEY_USERNAME);
        }
        try {
            ISessionAbstraction dialogSession = HttpSessionAccess.getCurrentDialogSession();
            if (dialogSession != null) {
                dialogSession.removeAttribute(KEY_USERNAME);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void associateUserWithCurrentThread(String user) {
        s_userPerThread.put(Thread.currentThread(), user);
    }

    public static void clearUserWithCurrentThread() {
        s_userPerThread.remove(Thread.currentThread());
    }
}

