/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.tool;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import org.eclnt.jsfserver.util.CSSStyleManager;
import org.eclnt.jsfserver.util.parse.SAXParserCreator;
import org.eclnt.tool.CSSParser;
import org.eclnt.tool.CSSStyle;
import org.eclnt.tool.CSSStyleClass;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class BuildCSSViaXML {
    static CSSStyle s_style = new CSSStyle();
    static Map<String, String> s_variables = new HashMap<String, String>();

    public static void main(String[] args) {
        System.out.println("*************************************************************************");
        System.out.println("* Calling this generation is not required from update 20190107 on.");
        System.out.println("* Please remove this generation from your build processing.");
        System.out.println("*");
        System.out.println("* (Both .css file and .js file are generated dynamically at runtime.)");
        System.out.println("*************************************************************************");
        s_style = new CSSStyle();
        try {
            if (args == null || args.length == 0) {
                args = new String[]{"C:/bmu_jtc/git/eclnt_clientrisc/web/styles/styledefaultrisc.xml", "C:/bmu_jtc/git/eclnt_clientrisc/web/styles/", "styledefaultrisc"};
            }
            if (args == null || args.length < 3) {
                if (args == null) {
                    System.out.println("No parameter was passed!");
                } else {
                    for (String arg : args) {
                        System.out.println(">param: " + arg);
                    }
                }
                throw new Error("Please pass three parameters:\n1. RISC-stkle definition(s) - not required anymore, you may pass any value here \n2. output directory\n3. name of created file");
            }
            String fromFile = args[0];
            String toDirectory = args[1];
            String toName = args[2];
            for (int i = 3; i < args.length; ++i) {
                String arg = args[i];
                int index = arg.indexOf(61);
                if (index < 0) continue;
                String key = arg.substring(0, index);
                String value = arg.substring(index + 1);
                s_variables.put(key, value);
            }
            String[] fromFiles = ValueManager.decodeCSV(fromFile);
            boolean edged = true;
            if (toName.contains("classic")) {
                edged = true;
            }
            BuildCSSViaXML.process(fromFiles, toDirectory, toName, edged);
            System.out.println("Finished!");
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Error(t);
        }
    }

    private static void parseRiscStyleText(String xml, CSSStyle style) {
        try {
            SAXParser parser = SAXParserCreator.createSAXParser();
            InputSource is = new InputSource(new StringReader(xml));
            parser.parse(is, (DefaultHandler)new CSSParser(style));
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Error(t);
        }
    }

    private static void process(String[] fromFiles, String toDirectory, String toName, boolean edged) {
        ArrayList<String> xmlParts = new ArrayList<String>();
        for (int i = 0; i < fromFiles.length; ++i) {
            fromFiles[i] = ValueManager.convertFileNameToCanonical(fromFiles[i], false);
            if (!FileManager.checkIfFileExists(fromFiles[i])) {
                throw new Error("File does not exist: " + fromFiles[i]);
            }
            String xmlPart = FileManager.readUTF8File(fromFiles[i], true);
            xmlParts.add(xmlPart);
        }
        toDirectory = ValueManager.convertFileNameToCanonical(toDirectory, true);
        String s = "/* This file is not required anymore sice update 20190101. The corresponding information is loaded dynamically. - This file can be removed from your project. */";
        String fileName = toDirectory + toName + ".css";
        if (FileManager.checkIfFileExists(fileName)) {
            FileManager.writeUTF8File(toDirectory + toName + ".css", s, true);
        }
        if (FileManager.checkIfFileExists(fileName = toDirectory + toName + ".js")) {
            FileManager.writeUTF8File(toDirectory + toName + ".js", s, true);
        }
    }

    public static synchronized StyleGenerationResult process(String styleName, List<String> xmlParts, boolean edged) {
        s_style = new CSSStyle();
        s_variables = new HashMap<String, String>();
        if (edged) {
            s_variables.put("@edged@", "true");
            s_variables.put("@rounded@", "false");
        } else {
            s_variables.put("@edged@", "false");
            s_variables.put("@rounded@", "true");
        }
        CLog.L.log(CLog.LL_INF, "STYLEMGMT: Concatenating style XMLs");
        StringBuffer xmlSB = new StringBuffer();
        xmlSB.append("<styles>\n");
        for (String xmlPart : xmlParts) {
            xmlPart = ValueManager.removeLeadingXMLDeclaration(xmlPart);
            xmlSB.append(xmlPart);
        }
        xmlSB.append("</styles>\n");
        String xml = xmlSB.toString();
        CLog.L.log(CLog.LL_INF, "STYLEMGMT: Concatenating style XMLs - finished");
        StyleGenerationResult result = new StyleGenerationResult();
        CLog.L.log(CLog.LL_INF, "STYLEMGMT: Parsing XML");
        BuildCSSViaXML.parseRiscStyleText(xml, s_style);
        CLog.L.log(CLog.LL_INF, "STYLEMGMT: Parsing XML - finished");
        StringBuffer css = new StringBuffer();
        ArrayList<CSSStyleClass> cssStyleClasses = new ArrayList<CSSStyleClass>();
        s_style.outputCSS(css, cssStyleClasses);
        result.i_css = css.toString();
        result.i_cssStyleClasses = cssStyleClasses;
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<String> cssLinks = CSSStyleManager.findCSSFiles(styleName, true);
        map.put("cssLinks", cssLinks);
        s_style.outputJsonMap(map);
        CLog.L.log(CLog.LL_INF, "STYLEMGMT: Converting JSON map to JSON");
        Gson g = new GsonBuilder().setPrettyPrinting().create();
        String json = g.toJson(map);
        CLog.L.log(CLog.LL_INF, "STYLEMGMT: Converting JSON map to JSON - finished");
        result.i_json = json;
        result.i_css = BuildCSSViaXML.applySonderLockeCCSVG(result.i_css);
        result.i_json = BuildCSSViaXML.applySonderLockeCCSVG(result.i_json);
        return result;
    }

    public static String junit_applySonderLockeCCSVG(String s) {
        return BuildCSSViaXML.applySonderLockeCCSVG(s);
    }

    private static String applySonderLockeCCSVG(String s) {
        int nextIndex;
        if (s == null) {
            return s;
        }
        int currentIndex = 0;
        while ((nextIndex = s.indexOf(".ccsvg", currentIndex)) >= 0) {
            int prevDotIndex = s.lastIndexOf(".", nextIndex - 1);
            if (prevDotIndex > 0 && (prevDotIndex = s.lastIndexOf(".", prevDotIndex - 1)) > 0 && s.charAt(prevDotIndex + 1) == '#') {
                s = s.substring(0, prevDotIndex + 1) + "_" + s.substring(prevDotIndex + 2);
            }
            currentIndex = nextIndex + 1;
        }
        return s;
    }

    public static class StyleGenerationResult {
        private String i_css;
        private String i_json;
        private List<CSSStyleClass> i_cssStyleClasses;

        public String getCss() {
            return this.i_css;
        }

        public String getJson() {
            return this.i_json;
        }

        public List<CSSStyleClass> getCssStyleClasses() {
            return this.i_cssStyleClasses;
        }
    }
}

