/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.tool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class BuildJSDOC {
    String m_dirJS;
    String m_dirDOC;
    List<ComponentInfo> m_components = new ArrayList<ComponentInfo>();

    public static String buildSortPartialString(String name) {
        String result = name + "__________________________________________________";
        result = result.substring(0, 50);
        return result;
    }

    public static void main(String[] args) {
        String dirJS = "C:/bmu_jtc/git/eclnt_clientrisc/web";
        String dirDOC = "C:/bmu_web/docu/api_clientjs";
        new BuildJSDOC(dirJS, dirDOC);
    }

    public BuildJSDOC(String dirJS, String dirDOC) {
        this.m_dirJS = dirJS;
        this.m_dirDOC = dirDOC;
        List<String> jsFiles = FileManager.getFilesOfDirectoryByPattern(this.m_dirJS, ".js");
        for (String jsFile : jsFiles) {
            this.processJSFile(jsFile);
        }
        this.createFrameSet();
        this.createTableOfContent();
        this.createCSS();
    }

    private void createTableOfContent() {
        this.sortComponents();
        String s = new ClassloaderReader(this.getClass().getClassLoader()).readUTF8File("org/eclnt/tool/resources/BuildDOC_toctemplate.html", true);
        StringBuffer sb = new StringBuffer();
        for (ComponentInfo component : this.m_components) {
            for (int i = 0; i < component.i_level; ++i) {
                sb.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            sb.append("<a href=\"" + component.getName() + ".html\" target=\"RIGHT\">" + component.getName() + "</a><br>");
        }
        s = s.replace("@body@", sb.toString());
        FileManager.writeUTF8File(this.m_dirDOC + "/tableofcontent.html", s, true);
    }

    private void sortComponents() {
        String parent;
        HashMap<String, List<String>> hierarchy = new HashMap<String, List<String>>();
        HashMap<String, String> childParentMap = new HashMap<String, String>();
        HashMap<String, ComponentInfo> ciCrossReference = new HashMap<String, ComponentInfo>();
        for (ComponentInfo component : this.m_components) {
            ciCrossReference.put(component.getName(), component);
            parent = "root";
            if (component.getInheritFromName() != null) {
                parent = component.getInheritFromName();
            }
            String child = component.getName();
            childParentMap.put(child, parent);
            ArrayList<String> children = (ArrayList<String>)hierarchy.get(parent);
            if (children == null) {
                children = new ArrayList<String>();
                hierarchy.put(parent, children);
            }
            children.add(child);
        }
        for (ComponentInfo component : this.m_components) {
            parent = component.getInheritFromName();
            if (parent == null) continue;
            do {
                String memParent = parent;
                if ((parent = (String)childParentMap.get(parent)) == null) {
                    throw new Error("Broken inheritance of documented classes. There is no parent for: " + memParent);
                }
                ++component.i_level;
            } while (!"root".equals(parent));
        }
        ArrayList<String> dump = new ArrayList<String>();
        BuildJSDOC.dumpComponentInfosIntoList(dump, hierarchy, "root");
        this.m_components.clear();
        for (String name : dump) {
            ComponentInfo ci = (ComponentInfo)ciCrossReference.get(name);
            this.m_components.add(ci);
        }
    }

    private static void dumpComponentInfosIntoList(List<String> dump, Map<String, List<String>> hierarchy, String parent) {
        System.out.println("Dumping: " + parent);
        List<String> children = hierarchy.get(parent);
        if (children == null) {
            return;
        }
        Collections.sort(children);
        for (String child : children) {
            dump.add(child);
            BuildJSDOC.dumpComponentInfosIntoList(dump, hierarchy, child);
        }
    }

    private void createFrameSet() {
        String s = new ClassloaderReader(this.getClass().getClassLoader()).readUTF8File("org/eclnt/tool/resources/BuildDOC_frametemplate.html", true);
        FileManager.writeUTF8File(this.m_dirDOC + "/index.html", s, true);
    }

    private void createCSS() {
        String s = new ClassloaderReader(this.getClass().getClassLoader()).readUTF8File("org/eclnt/tool/resources/ccdocu.css", true);
        FileManager.writeUTF8File(this.m_dirDOC + "/ccdocu.css", s, true);
    }

    private void processJSFile(String fileName) {
        System.out.println("PARSING: " + fileName);
        String js = FileManager.readUTF8File(fileName, true);
        List<Doc> docs = this.parseJS(js);
        for (Doc doc : docs) {
            System.out.println("Found documcentation!");
            String componentName = doc.i_attributes.get("name");
            if (componentName == null) {
                throw new Error("Component name not defined!");
            }
            this.m_components.add(new ComponentInfo(componentName, doc.i_attributes.get("inheritFrom")));
            String html = this.buildHtml(doc);
            try {
                String docFileName = this.m_dirDOC + "/" + doc.i_attributes.get("name") + ".html";
                FileManager.ensureDirectoryForFileExists(docFileName);
                FileManager.writeUTF8File(docFileName, html, true);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private List<Doc> parseJS(String js) {
        int index;
        ArrayList<Doc> result = new ArrayList<Doc>();
        int currentIndex = js.length();
        while ((index = js.lastIndexOf("RISCDocuControl")) >= 0) {
            String isolatedJS = js.substring(index);
            Doc doc = this.parseIsolatedJS(isolatedJS);
            if (doc != null) {
                result.add(doc);
            }
            js = js.substring(0, index);
        }
        return result;
    }

    private Doc parseIsolatedJS(String js) {
        int index2;
        int index1;
        if (js == null) {
            return null;
        }
        int currentIndex = 0;
        ArrayList<Doc> docList = new ArrayList<Doc>();
        while ((index1 = js.indexOf("RISCDocu", currentIndex)) >= 0 && (index2 = js.indexOf(")", index1)) >= 0) {
            String dcString = js.substring(index1, index2 + 1);
            Doc d = this.isolateDoc(dcString, js, index2 + 1);
            docList.add(d);
            currentIndex = index2;
        }
        if (docList.size() == 0) {
            return null;
        }
        List<Doc> docs = this.findDocs(docList, "RISCDocuControl");
        if (docs.size() == 0) {
            return null;
        }
        Doc docResult = docs.get(0);
        System.out.println("...Name of Control: " + docResult.i_attributes.get("name"));
        docResult.i_properties = this.findDocs(docList, "RISCDocuProperty");
        docResult.i_events = this.findDocs(docList, "RISCDocuEvent");
        docResult.i_methods = this.findDocs(docList, "RISCDocuMethod");
        return docResult;
    }

    private String buildHtml(Doc doc) {
        String propertyPart;
        String s = new ClassloaderReader(this.getClass().getClassLoader()).readUTF8File("org/eclnt/tool/resources/BuildDOC_template.html", true);
        StringBuffer sb = new StringBuffer();
        String controlPart = this.buildHtmlPart(doc, doc.i_attributes.get("name"), "h1");
        sb.append(controlPart);
        String inheritFrom = doc.i_attributes.get("inheritFrom");
        if (inheritFrom != null) {
            sb.append("\n<p><table width=\"100%\">");
            sb.append("<td><div style=\"width:175px\">");
            sb.append("parent class");
            sb.append("</div></td>");
            sb.append("<td width=\"100%\"><a class=\"textlink\" href='" + inheritFrom + ".html'/>");
            sb.append(inheritFrom);
            sb.append("</a></td></tr>");
            sb.append("</table></p>");
        }
        if (doc.i_events.size() > 0) {
            sb.append("\n<h2>Events</h2>");
            sb.append("\n<p><table width=\"100%\">");
            for (Doc propDoc : doc.i_events) {
                propertyPart = this.buildEventHtmlPartAsRow(propDoc);
                sb.append(propertyPart);
            }
            sb.append("</table></p>");
        }
        if (doc.i_properties.size() > 0) {
            sb.append("\n<h2>Properties</h2>");
            sb.append("\n<p><table width=\"100%\">");
            for (Doc propDoc : doc.i_properties) {
                propertyPart = this.buildPropertyHtmlPartAsRow(propDoc);
                sb.append(propertyPart);
            }
            sb.append("</table></p>");
        }
        if (doc.i_methods.size() > 0) {
            sb.append("\n<h2>Methods</h2>");
            sb.append("\n<p><table width=\"100%\">");
            for (Doc propDoc : doc.i_methods) {
                propertyPart = this.buildMethodHtmlPartAsRow(propDoc);
                sb.append(propertyPart);
            }
            sb.append("</table></p>");
        }
        s = s.replace("@body@", sb.toString());
        return s;
    }

    private String buildHtmlPart(Doc doc, String title, String h) {
        StringBuffer result = new StringBuffer();
        result.append("\n<" + h + ">");
        result.append(title);
        result.append("</" + h + ">");
        result.append("\n<p>");
        result.append(doc.i_text);
        result.append("</p>");
        return result.toString();
    }

    private String buildEventHtmlPartAsRow(Doc doc) {
        String key;
        String subName;
        StringBuffer result = new StringBuffer();
        result.append("\n<tr>");
        result.append("<td><div style=\"width:175px\">");
        result.append(doc.i_attributes.get("name"));
        result.append("</div></td>");
        result.append("<td><div style=\"width:150px\">");
        for (int i = 0; i < 10 && (subName = doc.i_attributes.get(key = "subname" + i)) != null; ++i) {
            if (i != 0) {
                result.append("<br>");
            }
            result.append(subName);
        }
        result.append("</div></td>");
        result.append("<td width=\"100%\">");
        result.append(doc.i_text);
        result.append("</td></tr>");
        return result.toString();
    }

    private String buildMethodHtmlPartAsRow(Doc doc) {
        String key;
        String subName;
        StringBuffer result = new StringBuffer();
        result.append("\n<tr>");
        result.append("<td><div style=\"width:175px\">");
        result.append(doc.i_attributes.get("name"));
        result.append("</div></td>");
        result.append("<td><div style=\"width:150px\">");
        if (doc.i_attributes.get("param0") != null) {
            result.append("Parameters:<br>");
        }
        for (int i = 0; i < 10 && (subName = doc.i_attributes.get(key = "param" + i)) != null; ++i) {
            if (i != 0) {
                result.append("<br>");
            }
            result.append(subName);
        }
        if (doc.i_attributes.get("result") != null) {
            result.append("<br><br>Returned result:<br>");
            result.append(doc.i_attributes.get("result"));
        }
        result.append("</div></td>");
        result.append("<td width=\"100%\">");
        result.append(doc.i_text);
        result.append("</td></tr>");
        return result.toString();
    }

    private String buildPropertyHtmlPartAsRow(Doc doc) {
        StringBuffer result = new StringBuffer();
        result.append("\n<tr>");
        result.append("<td><div style=\"width:175px\">");
        result.append(doc.i_attributes.get("name"));
        result.append("</div></td><td><div style=\"width:150px\">");
        result.append(doc.i_attributes.get("values"));
        result.append("</div></td><td width=\"100%\">");
        result.append(doc.i_text);
        result.append("</td></tr>");
        return result.toString();
    }

    private List<Doc> findDocs(List<Doc> docs, String type) {
        ArrayList<Doc> result = new ArrayList<Doc>();
        for (Doc doc : docs) {
            if (!type.equals(doc.i_type)) continue;
            result.add(doc);
        }
        Collections.sort(result);
        return result;
    }

    private Doc isolateDoc(String dcString, String js, int textIndex) {
        Doc result = new Doc();
        int index1 = dcString.indexOf("(");
        int index2 = dcString.indexOf(")");
        result.i_type = ValueManager.decodeMethodName(dcString);
        String paramString = dcString.substring(index1 + 1, index2);
        paramString = paramString.replace("\r", "");
        paramString = paramString.replace("\n", "");
        result.i_attributes = ValueManager.decodeComplexValue(paramString, true);
        int indexTextEnd = js.indexOf("*/", textIndex);
        String text = js.substring(textIndex, indexTextEnd);
        if (text.startsWith(":")) {
            text = text.substring(1);
        }
        text = text.replace("\n", " ");
        text = text.replace("\r", "");
        result.i_text = text = text.trim();
        return result;
    }

    public static class ComponentInfo
    implements Comparable<ComponentInfo> {
        String i_name;
        String i_inheritFromName;
        int i_level = 0;

        public ComponentInfo(String name, String inheritFromName) {
            this.i_name = name;
            this.i_inheritFromName = inheritFromName;
        }

        public String getName() {
            return this.i_name;
        }

        public String getInheritFromName() {
            return this.i_inheritFromName;
        }

        public int getLevel() {
            return this.i_level;
        }

        @Override
        public int compareTo(ComponentInfo o) {
            return this.i_name.compareTo(o.i_name);
        }
    }

    class Doc
    implements Comparable<Doc> {
        String i_type;
        String i_text;
        Map<String, String> i_attributes;
        List<Doc> i_properties = new ArrayList<Doc>();
        List<Doc> i_events = new ArrayList<Doc>();
        List<Doc> i_methods = new ArrayList<Doc>();

        Doc() {
        }

        @Override
        public int compareTo(Doc o) {
            String s1 = this.i_attributes.get("name");
            String s2 = o.i_attributes.get("name");
            if (s1 == null) {
                s1 = "";
            }
            if (s2 == null) {
                s2 = "";
            }
            return s1.compareTo(s2);
        }
    }
}

