/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.tool;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class BuildLocalizationFormatFiles {
    static Map<String, String> s_isoDates = new HashMap<String, String>();
    static Set<String> s_countriesWithDecimalPoint = new HashSet<String>();

    public static void main(String[] args) {
        try {
            BuildLocalizationFormatFiles.readCountryWithDecimalPoint();
            BuildLocalizationFormatFiles.readDates();
            int counter = 1;
            for (String code : s_isoDates.keySet()) {
                System.out.println("Country number: " + counter);
                BuildLocalizationFormatFiles.generateFile(code);
                ++counter;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void generateFile(String code) {
        try {
            if (!s_isoDates.containsKey(code)) {
                System.out.println("=====> No date info for: " + code);
                return;
            }
            String fileName = "C:\\bmu_jtc\\git\\eclnt_clientrisc\\i18n\\country_" + code + ".xml";
            String xml = FileManager.readUTF8File(fileName, false);
            if (xml == null || xml.equals("") || xml.contains("GENERATED")) {
                System.out.println("=====> Creation of file for: " + code);
                xml = new ClassloaderReader().readUTF8File("org/eclnt/tool/countryFormatTemplate.xml", true);
                String date = s_isoDates.get(code);
                String dateSeparator = BuildLocalizationFormatFiles.parseDateSeparator(date);
                String timeSeparator = ":";
                String ymdSequence = BuildLocalizationFormatFiles.parseYmdSequence(date);
                String decimalSeparator = ",";
                String thousandsSeparator = ".";
                if (s_countriesWithDecimalPoint.contains(code)) {
                    decimalSeparator = ".";
                    thousandsSeparator = ",";
                }
                xml = xml.replace("@@dateSeparator@@", dateSeparator);
                xml = xml.replace("@@timeSeparator@@", timeSeparator);
                xml = xml.replace("@@ymdSequence@@", ymdSequence);
                xml = xml.replace("@@decimalSeparator@@", decimalSeparator);
                xml = xml.replace("@@thousandsSeparator@@", thousandsSeparator);
                System.out.println(xml);
                FileManager.writeUTF8File(fileName, xml, true);
            } else {
                System.out.println("=====> No creation of file for: " + code);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Error(t);
        }
    }

    private static void readCountryWithDecimalPoint() {
        System.out.println("***** Reading countries with decimal point");
        HashMap<String, String> countryNames = new HashMap<String, String>();
        Locale len = new Locale("en", "US");
        for (String code : Locale.getISOCountries()) {
            Locale l = new Locale("en", code);
            String name = l.getDisplayCountry(len);
            System.out.println(code + ": " + name);
            countryNames.put(name, code);
            DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance(l);
            DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
            System.out.println("GS: >" + symbols.getGroupingSeparator() + "<");
            System.out.println("DS: >" + symbols.getDecimalSeparator() + "<");
        }
        String s = FileManager.readUTF8File("C:\\bmu_jtc\\countries\\formats_by_country\\countries_likeUS_decimal.txt", true);
        List<String> lines = ValueManager.getLinesOfText(s);
        for (String line : lines) {
            String code = (String)countryNames.get(line = line.trim());
            if (code == null) {
                System.out.println("=======================> " + line);
                continue;
            }
            System.out.println(line + ": " + code);
            s_countriesWithDecimalPoint.add(code);
        }
    }

    private static String parseDateSeparator(String date) {
        for (int i = 0; i < date.length(); ++i) {
            char c = date.charAt(i);
            if (c == 'd' || c == 'm' || c == 'y') continue;
            return "" + c;
        }
        throw new Error("No separator found! " + date);
    }

    private static String parseYmdSequence(String date) {
        String s = "";
        for (int i = 0; i < date.length(); ++i) {
            char c = date.charAt(i);
            if (c != 'd' && c != 'm' && c != 'y') continue;
            s = s + c;
        }
        if (s.length() != 3) {
            throw new Error("Problems with parsing ymdSequence: " + date);
        }
        return s;
    }

    private static void readDates() {
        HashSet<String> allCodes = new HashSet<String>();
        for (String code : Locale.getISOCountries()) {
            allCodes.add(code);
        }
        System.out.println("***** Reading dates");
        String s = FileManager.readUTF8File("C:\\bmu_jtc\\countries\\formats_by_country\\country_date_formats.csv", true);
        List<String> lines = ValueManager.getLinesOfText(s);
        for (int i = 1; i < lines.size(); ++i) {
            String line = lines.get(i);
            String[] values = ValueManager.tokenize(line, ",");
            String code = values[1];
            String date = values[6];
            if (!allCodes.contains(code)) {
                System.err.println("Code does not exist: >" + code + "<");
            }
            date = date.toLowerCase();
            date = date.replace("dd", "d");
            date = date.replace("mm", "m");
            date = date.replace("yyyy", "y");
            if (!(date = date.replace(" ", "")).contains("d") || !date.contains("m") || !date.contains("y")) continue;
            System.out.println(code + ": " + date + ", " + i);
            s_isoDates.put(code, date);
        }
    }
}

