/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.tool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclnt.jsfserver.elements.ComponentRepository;
import org.eclnt.jsfserver.elements.ICCComponentProperties;
import org.eclnt.jsfserver.session.UsageWithoutSessionContext;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class CheckEclntTldConsistency
implements ICCComponentProperties {
    private static final String ECLNTTLD_FILENAME = "C:\\bmu_jtc\\git\\eclnt_jsfserver\\WebContent\\WEB-INF\\eclnt.tld";
    static String s_from = "t:button";
    static String s_to = "t:buttonpopupmenu";
    static String[] ATTGROUP_DROP = new String[]{ATT_dropreceive, ATT_droprastertext, ATT_dropshape, ATT_ACTIONLISTENER};
    static String[] ATTGROUP_DROP_EXCEPTIONS = new String[]{"rowworkpagecontainer"};
    static String[] ATTGROUP_DRAG = new String[]{ATT_dragsend, ATT_dragroundtrip};
    static String[] ATTGROUP_DRAG_EXCEPTIONS = new String[0];
    static String[] ATTGROUP_WIDTH = new String[]{ATT_width, ATT_cutwidth};
    static String[] ATTGROUP_WIDTH_EXCEPTIONS = new String[0];
    static String[] ATTGROUP_HEIGHT = new String[]{ATT_height, ATT_cutheight};
    static String[] ATTGROUP_HEIGHT_EXCEPTIONS = new String[0];
    static String[] ATTGROUP_COMBO = new String[]{ATT_image, ATT_showicononmouseoveronly};
    static String[] ATTGROUP_COMBO_EXCEPTIONS = new String[0];
    static String[] ATTGROUP_COMBO_CONTROLS = new String[]{"calendarfield", "colorfield", "combofield", "combobox"};
    static String[] ATTGROUP_FIELD_FOCUS = new String[]{ATT_requestfocus, ATT_selectallwhenfocussed, ATT_focusnexthotkey, ATT_focusprevioushotkey, ATT_focusable, ATT_focussequence, ATT_withfocusevent, ATT_requestfocushotkey, ATT_avoidremovalofcontent};
    static String[] COMPONENTGROUP_FIELD_CONTROLS = new String[]{"field", "formattedfield", "calendarfield", "colorfield", "combofield", "combobox", "spinner"};

    public static void main(String[] args) {
        UsageWithoutSessionContext.initUsageWithoutSessionContext();
        try {
            CheckEclntTldConsistency.enforceAttributeGroup(ATTGROUP_FIELD_FOCUS, COMPONENTGROUP_FIELD_CONTROLS, null, false);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void checkAttributeIsAvailable(String attribute, String tagNamePattern) {
        ComponentRepository cr = CheckEclntTldConsistency.readComponentRepository();
        for (ComponentRepository.ComponentInfo ci : cr.getComponentInfos()) {
            if (ci.getTagName().startsWith("ht") || !ValueManager.checkIfStringMatchesAsteriskExpression(ci.getTagName(), tagNamePattern) || ci.getAttributes().contains(attribute)) continue;
            System.out.println("Component: " + ci.getTagName());
        }
    }

    private static void cleanUpFormat() {
        String s = FileManager.readUTF8File(ECLNTTLD_FILENAME, true);
        s = s.replace("</attribute><attribute>", "</attribute>\r\n      <attribute>");
        FileManager.writeUTF8File(ECLNTTLD_FILENAME, s, true);
    }

    private static void compareButtonComponents() {
        ComponentRepository cr = CheckEclntTldConsistency.readComponentRepository();
        ArrayList<String> buttonTags = new ArrayList<String>();
        Collection<ComponentRepository.ComponentInfo> allCIs = cr.getComponentInfos();
        for (ComponentRepository.ComponentInfo ci : allCIs) {
            if (!ci.getTagName().contains("button") || ci.getTagName().startsWith("ht") || ci.getTagName().contains("radio")) continue;
            buttonTags.add(ci.getTagName());
        }
        Collections.sort(buttonTags);
        for (String buttonTag : buttonTags) {
            CheckEclntTldConsistency.compareFromTo("t:button", buttonTag, true, false);
        }
    }

    private static void compareFromTo(String from, String to, boolean showMissing, boolean showAdditionals) {
        ComponentRepository cr = CheckEclntTldConsistency.readComponentRepository();
        ComponentRepository.ComponentInfo fromCI = cr.getComponentInfo(from);
        ComponentRepository.ComponentInfo toCI = cr.getComponentInfo(to);
        List<String> fromAttributes = fromCI.getAttributes();
        List<String> toAttributes = toCI.getAttributes();
        ArrayList<String> missings = new ArrayList<String>();
        ArrayList<String> additionals = new ArrayList<String>();
        for (String attribute : fromAttributes) {
            if (toAttributes.contains(attribute)) continue;
            missings.add(attribute);
        }
        for (String attribute : toAttributes) {
            if (fromAttributes.contains(attribute)) continue;
            additionals.add(attribute);
        }
        Collections.sort(missings);
        Collections.sort(additionals);
        if (showMissing) {
            System.out.println("MISSING in " + to + ": --------------------");
            for (String attribute : missings) {
                System.out.println("      <attribute><name>" + attribute + "</name></attribute>");
            }
        }
        if (showAdditionals) {
            System.out.println("MISSING in " + from + ": --------------------");
            for (String attribute : additionals) {
                System.out.println("      <attribute><name>" + attribute + "</name></attribute>");
            }
            System.out.println("FINISHED!");
        }
    }

    private static void enforceAttributeGroup(String[] attributeGroup, String[] tagNames, String[] tagExceptions, boolean writeFile) {
        if (writeFile) {
            try {
                System.out.println("Press y to continue...");
                int key = System.in.read();
                System.out.println(key);
                if (key != 121) {
                    throw new Exception("User did not press y...");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        HashSet<String> tagSet = new HashSet<String>();
        if (tagNames != null) {
            for (String tagName : tagNames) {
                tagSet.add(tagName);
            }
        }
        HashSet<String> tagExceptionsSet = new HashSet<String>();
        if (tagExceptions != null) {
            for (String tag : tagExceptions) {
                tagExceptionsSet.add(tag);
            }
        }
        String triggerAttribute = attributeGroup[0];
        ComponentRepository cr = CheckEclntTldConsistency.readComponentRepository();
        List<ComponentRepository.ComponentInfo> cis = CheckEclntTldConsistency.readRISCComponentInfos(cr);
        for (ComponentRepository.ComponentInfo ci : cis) {
            if (tagExceptionsSet.contains(ci.getTagName()) || tagSet.size() != 0 && !tagSet.contains(ci.getTagName())) continue;
            System.out.println("Analyzing: " + ci.getTagName());
            List<String> ciAttributes = ci.getAttibutesInclActions(false);
            if (!ciAttributes.contains(triggerAttribute)) continue;
            boolean complete = true;
            for (int i = 1; i < attributeGroup.length; ++i) {
                if (ciAttributes.contains(attributeGroup[i])) continue;
                complete = false;
                System.out.println("...Adding: " + ci.getTagName() + ": " + attributeGroup[i]);
                if (!writeFile) continue;
                CheckEclntTldConsistency.updateEclntTldAddAttributeToTag(ci.getTagName(), attributeGroup[i]);
            }
            if (!complete) continue;
            System.out.println(" Complete: " + ci.getTagName());
        }
    }

    private static List<ComponentRepository.ComponentInfo> readRISCComponentInfos(ComponentRepository cr) {
        ArrayList<ComponentRepository.ComponentInfo> result = new ArrayList<ComponentRepository.ComponentInfo>();
        Collection<ComponentRepository.ComponentInfo> cis = cr.getComponentInfos();
        for (ComponentRepository.ComponentInfo ci : cis) {
            if (ci.getTagName().startsWith("ht")) continue;
            result.add(ci);
        }
        Collections.sort(result);
        return result;
    }

    private static ComponentRepository readComponentRepository() {
        String xml = FileManager.readUTF8File(ECLNTTLD_FILENAME, true);
        ComponentRepository cr = ComponentRepository.createComponentRepository_junit("t", xml);
        return cr;
    }

    private static void updateEclntTldAddAttributeToTag(String tagName, String attribute) {
        String xml = FileManager.readUTF8File(ECLNTTLD_FILENAME, true);
        int index = xml.indexOf("<name>" + tagName + "</name>");
        if (index < 0) {
            throw new Error("Component not found: " + tagName);
        }
        int index2 = xml.indexOf("<name>" + tagName + "</name>", index + 1);
        if (index2 >= 0) {
            throw new Error("Tag name is not a unique name: " + tagName);
        }
        int indexTagEnd = xml.indexOf("</tag>", index);
        if (indexTagEnd < 0) {
            throw new Error("</tag> not found for: " + tagName);
        }
        int indexCRBefore = xml.lastIndexOf("</attribute>", indexTagEnd) + "</attribute>".length();
        xml = xml.substring(0, indexCRBefore) + "\r\n      <attribute><name>" + attribute + "</name></attribute>" + xml.substring(indexCRBefore);
        FileManager.writeUTF8File(ECLNTTLD_FILENAME, xml, true);
    }
}

