/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.tool;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class ClaudeConversationExporterCL {
    public static void main(String[] args) {
        String conversationsFile = "conversations.json";
        String outputDir = "exported_chats";
        String namePrefix = null;
        if (args.length > 0) {
            conversationsFile = args[0];
        }
        if (args.length > 1) {
            outputDir = args[1];
        }
        if (args.length > 2) {
            namePrefix = args[2];
        }
        try {
            ClaudeConversationExporterCL.exportConversations(conversationsFile, outputDir, namePrefix);
        }
        catch (IOException e) {
            System.err.println("Error processing file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void exportConversations(String conversationsFile, String outputDir, String namePrefix) throws IOException {
        JsonArray conversations;
        Path outputPath = Paths.get(outputDir, new String[0]);
        if (!Files.exists(outputPath, new LinkOption[0])) {
            Files.createDirectories(outputPath, new FileAttribute[0]);
        }
        if (namePrefix != null && !namePrefix.trim().isEmpty()) {
            System.out.println("Filtering conversations with name prefix: '" + namePrefix + "'");
        }
        String jsonContent = Files.readString(Paths.get(conversationsFile, new String[0]));
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonElement element = JsonParser.parseString((String)jsonContent);
        if (element.isJsonArray()) {
            conversations = element.getAsJsonArray();
        } else if (element.isJsonObject() && element.getAsJsonObject().has("conversations")) {
            conversations = element.getAsJsonObject().getAsJsonArray("conversations");
        } else {
            throw new IllegalArgumentException("Unexpected JSON structure");
        }
        System.out.println("Found: " + conversations.size() + " conversation(s) total");
        int exportedCount = 0;
        for (int i = 0; i < conversations.size(); ++i) {
            JsonObject conversation = conversations.get(i).getAsJsonObject();
            String chatName = ClaudeConversationExporterCL.extractChatName(conversation, i);
            if (namePrefix != null && !namePrefix.trim().isEmpty() && !chatName.startsWith(namePrefix)) continue;
            String fileName = ClaudeConversationExporterCL.createFileName(chatName, i);
            Path outputFile = outputPath.resolve(fileName);
            String prettyJson = gson.toJson((JsonElement)conversation);
            Files.writeString(outputFile, (CharSequence)prettyJson, new OpenOption[0]);
            System.out.println("Exported: " + fileName);
            ++exportedCount;
        }
        System.out.println("\nExport completed! " + exportedCount + " file(s) saved to: " + outputDir);
    }

    private static String extractChatName(JsonObject conversation, int index) {
        String title;
        String name;
        if (conversation.has("name") && !conversation.get("name").isJsonNull() && !(name = conversation.get("name").getAsString()).trim().isEmpty()) {
            return name;
        }
        if (conversation.has("title") && !conversation.get("title").isJsonNull() && !(title = conversation.get("title").getAsString()).trim().isEmpty()) {
            return title;
        }
        if (conversation.has("uuid")) {
            return conversation.get("uuid").getAsString();
        }
        return "conversation_" + index;
    }

    private static String createFileName(String chatName, int index) {
        String truncated = chatName.length() > 100 ? chatName.substring(0, 100) : chatName;
        String sanitized = truncated.replaceAll("[\\\\/:*?\"<>|]", "_").replaceAll("\\s+", "_").replaceAll("_{2,}", "_").replaceAll("^_|_$", "");
        if (sanitized.isEmpty()) {
            sanitized = "conversation_" + index;
        }
        return sanitized + ".json";
    }
}

