/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.tool;

import java.io.File;
import java.util.List;
import org.eclnt.jsfserver.util.VersionXml;
import org.eclnt.util.file.FileManager;

public class TransferJEE9 {
    public static String updateTLDFileName(String tldFileName) {
        if (VersionXml.checkIfJakarta() && tldFileName.endsWith(".tld")) {
            tldFileName = tldFileName.substring(0, tldFileName.length() - ".tld".length()) + ".cctld";
        }
        return tldFileName;
    }

    public static void transferCodeInJavaFilesOfDirectory(String directoryName, boolean withDrillDown) {
        TransferJEE9.transferCodeInJavaFilesOfDirectory(directoryName, withDrillDown, true);
    }

    public static void transferCodeInJavaFilesOfDirectory(String directoryName, boolean withDrillDown, boolean withEnvironmentCheck) {
        if (withEnvironmentCheck && !VersionXml.checkIfJakarta()) {
            return;
        }
        List<String> javaFileNames = FileManager.getFilesOfDirectoryByPattern(directoryName, ".java");
        for (String javaFileName : javaFileNames) {
            String code = FileManager.readUTF8File(javaFileName, true);
            code = TransferJEE9.transferCode(code);
            FileManager.writeUTF8File(javaFileName, code, true);
        }
        List<File> subDirectories = FileManager.getDirectoriesOfDirectory(directoryName);
        if (withDrillDown) {
            for (File subDirectory : subDirectories) {
                TransferJEE9.transferCodeInJavaFilesOfDirectory(subDirectory.getAbsolutePath(), withDrillDown, withEnvironmentCheck);
            }
        }
    }

    public static String transferCode(String code) {
        return TransferJEE9.transferCode(code, true);
    }

    public static String transferCode(String code, boolean withEnvironmentCheck) {
        if (withEnvironmentCheck && !VersionXml.checkIfJakarta()) {
            return code;
        }
        if (code == null) {
            return null;
        }
        code = code.replace("throws JspException", "throws Exception");
        code = code.replace("import javax.servlet.jsp.JspException;", "");
        code = code.replace("javax.servlet.", "jakarta.servlet.");
        code = code.replace("javax.el.", "jakarta.el.");
        code = code.replace("javax.websocket.", "jakarta.websocket.");
        code = code.replace("javax.xml.bind.", "jakarta.xml.bind.");
        code = code.replace("javax.jms.", "jakarta.jms.");
        code = code.replace("javax.faces;", "org.eclnt.jsfserver.base.faces;");
        code = code.replace("javax.faces.", "org.eclnt.jsfserver.base.faces.");
        code = code.replace("javax.faces.event.", "org.eclnt.jsfserver.base.faces.event.");
        return code;
    }
}

