/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.file;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.ULog;

public class PropertiesFileManager {
    public static void addPropertiesToFile(String fileName, List<PropertyValue> propertyValues, boolean overwriteExisting, boolean asUTF8, boolean withError) {
        if (propertyValues == null) {
            return;
        }
        try {
            List<Object> existingPvs = FileManager.checkIfFileExists(fileName) ? PropertiesFileManager.readPropertiesFromFile(fileName, asUTF8, withError) : new ArrayList();
            HashMap<String, PropertyValue> pvsMap = new HashMap<String, PropertyValue>();
            for (PropertyValue propertyValue : existingPvs) {
                pvsMap.put(propertyValue.getProperty(), propertyValue);
            }
            for (PropertyValue propertyValue : propertyValues) {
                if (propertyValue.getProperty() == null) {
                    return;
                }
                if (overwriteExisting) {
                    pvsMap.put(propertyValue.getProperty(), propertyValue);
                    continue;
                }
                if (pvsMap.containsKey(propertyValue.getProperty())) continue;
                pvsMap.put(propertyValue.getProperty(), propertyValue);
            }
            ArrayList<PropertyValue> nows = new ArrayList<PropertyValue>(pvsMap.values());
            PropertiesFileManager.savePropertiesInFile(fileName, nows, asUTF8, withError);
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Problem adding properties to file: " + fileName, t);
            }
            ULog.logINF("Problem adding properties to file: " + fileName, t);
            return;
        }
    }

    public static void savePropertiesInFile(String fileName, List<PropertyValue> propertyValues, boolean asUTF8, boolean withError) {
        try {
            StringBuffer sb = new StringBuffer();
            Collections.sort(propertyValues);
            int counter = 0;
            for (PropertyValue propertyValue : propertyValues) {
                if (propertyValue.getProperty() == null) continue;
                String pvValue = propertyValue.getValue();
                if (pvValue == null) {
                    pvValue = "";
                }
                if (counter > 0) {
                    sb.append("\n");
                }
                sb.append(propertyValue.getProperty());
                sb.append("=");
                pvValue = pvValue.replace("\n", "\\n");
                pvValue = pvValue.replace("\r", "\\r");
                if (!asUTF8) {
                    pvValue = PropertiesFileManager.escapeString(pvValue);
                }
                sb.append(pvValue);
                ++counter;
            }
            FileManager.writeUTF8FileIfContentChanged(fileName, sb.toString(), true);
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Problem writing properties file: " + fileName, t);
            }
            return;
        }
    }

    public static List<PropertyValue> readPropertiesFromFile(String fileName, boolean asUTF8, boolean withError) {
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
        try {
            String content = FileManager.readUTF8File(fileName, true);
            return PropertiesFileManager.parsePropertiesContent(content, asUTF8);
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Problem loading properties from file: " + fileName, t);
            }
            return result;
        }
    }

    public static List<PropertyValue> readPropertiesFromResource(String resourcePath, boolean asUTF8, boolean withError) {
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
        try {
            String content = new ClassloaderReader(true).readUTF8File(resourcePath, true);
            return PropertiesFileManager.parsePropertiesContent(content, asUTF8);
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("Problem loading properties from resource path: " + resourcePath, t);
            }
            return result;
        }
    }

    public static List<PropertyValue> parsePropertiesContent(String content, boolean asUTF8) {
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
        content = content.replace("\r", "");
        StringTokenizer tokenizer = new StringTokenizer(content, "\n");
        while (tokenizer.hasMoreTokens()) {
            int index;
            String token = tokenizer.nextToken();
            if (token.trim().length() == 0 || token.startsWith("#") || (index = token.indexOf("=")) < 0) continue;
            String key = token.substring(0, index).trim();
            String value = token.substring(index + 1).trim();
            value = value.replace("\\n", "\n");
            value = value.replace("\\r", "\r");
            if (!asUTF8) {
                value = PropertiesFileManager.unescapeString(value);
            }
            PropertyValue pv = new PropertyValue(key, value);
            result.add(pv);
        }
        return result;
    }

    public static String escapeString(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (c >= '\u0080') {
                b.append("\\u").append(String.format("%04X", c));
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static String unescapeString(String s) {
        int length;
        if (s == null) {
            return null;
        }
        String working = s;
        int index = working.indexOf("\\u");
        while (index > -1 && index <= (length = working.length()) - 6) {
            int numStart = index + 2;
            int numFinish = numStart + 4;
            String substring = working.substring(numStart, numFinish);
            int number = Integer.parseInt(substring, 16);
            String stringStart = working.substring(0, index);
            String stringEnd = working.substring(numFinish);
            working = stringStart + (char)number + stringEnd;
            index = working.indexOf("\\u");
        }
        return working;
    }

    public static class PropertyValue
    implements Comparable<PropertyValue> {
        public String i_property;
        public String i_value;

        public PropertyValue(String property, String value) {
            this.i_property = property;
            this.i_value = value;
        }

        public String getProperty() {
            return this.i_property;
        }

        public String getValue() {
            return this.i_value;
        }

        @Override
        public int compareTo(PropertyValue o) {
            return this.i_property.compareTo(o.i_property);
        }
    }
}

