/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.log;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclnt.jsfserver.i18n.I18N;
import org.eclnt.util.log.IObserver;

public class Observer
implements IObserver,
Serializable {
    boolean m_isRunning = true;
    Object m_outestCaller;
    List<String> m_list = new ArrayList<String>();

    @Override
    public void start(Object caller) {
        if (this.m_outestCaller == null) {
            this.m_outestCaller = caller;
        }
    }

    @Override
    public void end(Object caller) {
        if (this.m_outestCaller == caller) {
            this.m_outestCaller = null;
            this.m_isRunning = false;
        }
    }

    @Override
    public void addMessage(String message) {
        this.m_list.add(message);
    }

    @Override
    public String getText() {
        int size = this.m_list.size();
        StringBuffer sb = new StringBuffer();
        String s = "$1$ messages:";
        try {
            s = I18N.getBundle().getString("OBSERVERPOPUP_messages");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        s = s.replace("$1$", size + "");
        sb.append(s + "\n\n");
        int counter = 0;
        for (int i = size - 1; i >= 0; --i) {
            sb.append(this.m_list.get(i) + "\n");
            if (++counter <= 25) continue;
            sb.append("...");
            break;
        }
        return sb.toString();
    }

    @Override
    public boolean checkIfRunning() {
        return this.m_isRunning;
    }
}

