/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import java.util.ArrayList;
import java.util.List;
import javax.faces.event.ActionEvent;
import org.eclnt.jsfserver.elements.BaseActionEvent;
import org.eclnt.jsfserver.elements.componentnodes.IMAGENode;
import org.eclnt.jsfserver.elements.componentnodes.LABELNode;
import org.eclnt.jsfserver.elements.componentnodes.PANENode;
import org.eclnt.jsfserver.elements.componentnodes.ROWDISTANCENode;
import org.eclnt.jsfserver.elements.componentnodes.ROWNode;
import org.eclnt.jsfserver.elements.componentnodes.SCREENGRABBERNode;
import org.eclnt.jsfserver.elements.events.BaseActionEventPopupMenuItem;
import org.eclnt.jsfserver.elements.impl.ROWDYNAMICCONTENTBinding;
import org.eclnt.jsfserver.elements.util.Trigger;
import org.eclnt.jsfserver.pagebean.PageBean;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.workplace.IWorkpage;
import org.eclnt.workplace.IWorkpageContainer;
import org.eclnt.workplace.IWorkpageContainerListener;
import org.eclnt.workplace.IWorkpageContainerRenderer;
import org.eclnt.workplace.WorkpageContainer;
import org.eclnt.workplace.WorkplaceTileInfo;

public class WorkpageContainerRendererIconSelectorRight
extends PageBean
implements IWorkpageContainerRenderer {
    public static String TEXTCOLOR_UNSELECTED = "#F0F0F0";
    public static String TEXTCOLOR_SELECTED = "#FFC080";
    public static String FONT_UNSELECTED = null;
    public static String FONT_SELECTED = null;
    ROWDYNAMICCONTENTBinding m_content = new ROWDYNAMICCONTENTBinding();
    ROWDYNAMICCONTENTBinding m_icons = new ROWDYNAMICCONTENTBinding();
    Trigger m_animationTrigger = new Trigger();
    WorkpageContainer m_wpContainer;
    MyWorkpageContainerListener m_wpContainerListener = new MyWorkpageContainerListener();
    List<PaneItemInfo> m_paneItemInfos = new ArrayList<PaneItemInfo>();
    String m_paneUid = UniqueIdCreator.createRandomId();

    @Override
    public String getPageName() {
        return "/eclntjsfserver/includes/wp_workpagecontainer_iconselectorright.jsp";
    }

    @Override
    public String getRootExpressionUsedInPage() {
        return "#{wpr}";
    }

    public ROWDYNAMICCONTENTBinding getContent() {
        return this.m_content;
    }

    public ROWDYNAMICCONTENTBinding getIcons() {
        return this.m_icons;
    }

    public Trigger getAnimationTrigger() {
        return this.m_animationTrigger;
    }

    public boolean getWorkpageAvailable() {
        List<IWorkpage> wps = this.m_wpContainer.getAllWorkpages();
        if (wps.size() == 0) {
            return false;
        }
        int showCounter = 0;
        for (IWorkpage wp : wps) {
            if (wp.getModelessPopupOfWorkpage() != null) continue;
            ++showCounter;
        }
        return showCounter != 0;
    }

    public boolean getWorkpageNotAvailable() {
        return !this.getWorkpageAvailable();
    }

    public String getEmptyPage() {
        String result = this.m_wpContainer.getEmptyPage();
        if (result == null) {
            result = "/eclntjsfserver/includes/empty.jsp";
        }
        return result;
    }

    public List<PaneItemInfo> getStackedPaneItemInfos() {
        return this.m_paneItemInfos;
    }

    @Override
    public void initWorkpageContainer(WorkpageContainer wpContainer) {
        this.m_wpContainer = wpContainer;
        this.m_wpContainer.addWorkpageContainerListener(this.m_wpContainerListener);
        this.render();
    }

    public void onSelectAction(ActionEvent event) {
        BaseActionEvent e = (BaseActionEvent)event;
        String reference = e.getSourceReference();
        IWorkpage wp = this.m_wpContainer.getWorkpageForUniqueTechnicalId(reference);
        this.m_wpContainer.switchToWorkpage(wp);
    }

    public void onIconPaneAction(ActionEvent event) {
        BaseActionEvent e = (BaseActionEvent)event;
        String reference = e.getSourceReference();
        IWorkpage wp = this.m_wpContainer.getWorkpageForUniqueTechnicalId(reference);
        if (event instanceof BaseActionEventPopupMenuItem) {
            BaseActionEventPopupMenuItem pmie = (BaseActionEventPopupMenuItem)e;
            if ("cmdCLOSEWORKPAGE".equals(pmie.getCommand())) {
                this.m_wpContainer.getRootWorkpageContainer().closeWorkpage(wp);
            }
            if ("cmdOPENASPOPUP".equals(pmie.getCommand())) {
                this.m_wpContainer.getRootWorkpageContainer().onOpenCurrentPageAsModelessPopup(null);
            }
        }
    }

    public void render() {
        this.renderContent();
        this.renderIcons();
        this.m_animationTrigger.trigger();
    }

    private void renderContent() {
        IWorkpage wp = this.m_wpContainer.getCurrentWorkpage();
        PANENode p = new PANENode();
        p.addAttribute("id", this.m_paneUid + "_p");
        p.setStylevariant("WP_WORKPAGECONTAINER");
        if (wp != null) {
            p.setWidth("100%");
            p.setHeight("100%");
            SCREENGRABBERNode sg = new SCREENGRABBERNode();
            p.addSubNode(sg);
            sg.addAttribute("id", this.m_paneUid + "_sg");
            sg.setGrabtoclientid(wp.getUniqueTechnicalId());
            sg.setGrabondestroy(true);
            sg.setGrabtype("panedirect");
            this.m_wpContainer.renderWorkpageNode(wp, p, this.m_paneUid);
        } else {
            p.setWidth("0");
            p.setHeight("0");
        }
        this.m_content.setContentNode(p);
    }

    private void renderIcons() {
        List<IWorkpage> wps = this.m_wpContainer.getAllWorkpages();
        PANENode p = new PANENode();
        p.addAttribute("id", this.m_paneUid + "_pi");
        p.setWidth("100%");
        p.setHeight("100%");
        p.setRowdistance(2);
        for (IWorkpage wp : wps) {
            IMAGENode in;
            if (wp.getModelessPopupOfWorkpage() != null) continue;
            String wpUid = wp.getUniqueTechnicalId();
            ROWNode or = new ROWNode();
            p.addSubNode(or);
            or.addAttribute("id", wpUid + "_or");
            PANENode op = new PANENode();
            or.addSubNode(op);
            op.addAttribute("id", wpUid + "_op");
            op.setWidth(100);
            op.setHeight(100);
            op.setDragsend("CCWORKPAGE:" + wp.getUniqueTechnicalId());
            op.setReference(wpUid);
            op.setActionListener(this.getRootExpressionUsedInPage().replace("}", ".onIconPaneAction}"));
            this.m_wpContainer.renderPopupMenuIntoNode(wp, op);
            ROWNode r = new ROWNode();
            op.addSubNode(r);
            r.addAttribute("id", wpUid + "_r");
            if (wp != this.m_wpContainer.getCurrentlySelectedWorkpage()) {
                op.setStylevariant("WP_WORKPAGECONTAINERMINIICON");
                op.setPadding("2");
                in = new IMAGENode();
                r.addSubNode(in);
                in.addAttribute("id", wpUid + "_im");
                in.setImage("/clientimagestore:" + wp.getUniqueTechnicalId());
                in.setWidth(96);
                in.setHeight(96);
                in.setInvokeevent("leftclick");
                in.setActionListener(this.getActualRootExpression().replace("}", ".onSelectAction}"));
                in.setReference(wp.getUniqueTechnicalId());
            } else {
                op.setStylevariant("WP_WORKPAGECONTAINERMINIICON_SELECTED");
                op.setPadding("0");
                LABELNode ln = new LABELNode();
                r.addSubNode(ln);
                ln.addAttribute("id", wpUid + "_l1");
                ln.setText(null);
                ln.setWidth("50%");
                ln.setHeight("100");
                in = new IMAGENode();
                r.addSubNode(in);
                in.addAttribute("id", wpUid + "_im");
                in.setImage("/eclntjsfserver/images/workpageactivebig.png");
                in.setRowalignmenty("center");
                LABELNode ln2 = new LABELNode();
                r.addSubNode(ln2);
                ln2.addAttribute("id", wpUid + "_l2");
                ln2.setText(null);
                ln2.setWidth("50%");
                ln2.setHeight("100");
            }
            ROWNode rt = new ROWNode();
            p.addSubNode(rt);
            rt.addAttribute("id", wpUid + "_rt");
            LABELNode l = new LABELNode();
            rt.addSubNode(l);
            l.addAttribute("id", wpUid + "l");
            l.setText(wp.getTitle());
            l.setForeground("#FFFFFF");
            l.setAlign("center");
            l.setWidth("100%");
            l.setCutwidth("true");
            if (wp != this.m_wpContainer.getCurrentlySelectedWorkpage()) {
                l.setInvokeevent("leftclick");
                l.setActionListener(this.getActualRootExpression().replace("}", ".onSelectAction}"));
                l.setReference(wp.getUniqueTechnicalId());
                l.setForeground(TEXTCOLOR_UNSELECTED);
                l.setFont(FONT_UNSELECTED);
            } else {
                l.setForeground(TEXTCOLOR_SELECTED);
                l.setFont(FONT_SELECTED);
            }
            ROWDISTANCENode rd = new ROWDISTANCENode();
            p.addSubNode(rd);
            rd.addAttribute("id", wpUid + "_rd");
            rd.setHeight(10);
        }
        this.m_icons.setContentNode(p);
    }

    @Override
    public boolean checkIfAlsoUsedForSubContainers() {
        return false;
    }

    private void switchToWorkpage(IWorkpage workpage) {
        for (PaneItemInfo spii : this.m_paneItemInfos) {
            if (spii.i_workpage != workpage) continue;
            spii.getTrigger().trigger();
            break;
        }
    }

    public class PaneItemInfo {
        IWorkpage i_workpage;
        Trigger i_trigger = new Trigger();

        public PaneItemInfo(IWorkpage workpage) {
            this.i_workpage = workpage;
        }

        public Trigger getTrigger() {
            return this.i_trigger;
        }
    }

    class MyWorkpageContainerListener
    implements IWorkpageContainerListener {
        MyWorkpageContainerListener() {
        }

        @Override
        public void reactOnWorkpageDrop(String workpageContainerId, String workpageTechId, int horizontalPercentage, int verticalPercentage) {
        }

        @Override
        public void reactOnWorkpageAdded(IWorkpage workpage) {
            WorkpageContainerRendererIconSelectorRight.this.render();
        }

        @Override
        public void reactOnWorkpageRemoved(IWorkpage workpage) {
            WorkpageContainerRendererIconSelectorRight.this.render();
        }

        @Override
        public void reactOnWorkpageSwitchedTo(IWorkpage workpage) {
            WorkpageContainerRendererIconSelectorRight.this.render();
        }

        @Override
        public void reactOnWorkpageMoved(IWorkpage workpage, IWorkpageContainer from, IWorkpageContainer to) {
            if (WorkpageContainerRendererIconSelectorRight.this.m_wpContainer == from || WorkpageContainerRendererIconSelectorRight.this.m_wpContainer == to) {
                WorkpageContainerRendererIconSelectorRight.this.render();
            }
            if (WorkpageContainerRendererIconSelectorRight.this.m_wpContainer == to) {
                WorkpageContainerRendererIconSelectorRight.this.switchToWorkpage(workpage);
            }
        }

        @Override
        public void reactOnWorkpageContainerGotEmpty(String workpageContainerId) {
        }

        @Override
        public void reactOnPerspectiveUpdate(WorkplaceTileInfo perspective) {
        }

        @Override
        public boolean reactOnSelectorUserSelection(IWorkpageContainer workpageContainer, int fromIndex, int toIndex, IWorkpage fromWorkpage, IWorkpage toWorkpage) {
            return false;
        }
    }
}

