/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import java.io.Serializable;
import org.eclnt.jsfserver.defaultscreens.OKPopup;
import org.eclnt.jsfserver.pagebean.IPageBean;
import org.eclnt.util.classresolver.CCClassResolver;
import org.eclnt.util.classresolver.ENUMCallerType;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.workplace.ICreatePageBeanInstance;
import org.eclnt.workplace.IPrepareByWorkpageStartInfo;
import org.eclnt.workplace.IWorkpage;
import org.eclnt.workplace.IWorkpageContainer;
import org.eclnt.workplace.IWorkpageDispatcher;
import org.eclnt.workplace.IWorkpageFunctionExecute;
import org.eclnt.workplace.IWorkpageStarter;
import org.eclnt.workplace.Workpage;
import org.eclnt.workplace.WorkpageByPageBean;
import org.eclnt.workplace.WorkpageStartInfo;
import org.eclnt.workplace.eximport.WorkplacePageBeanStateExtractor;

public class WorkpageDefaultStarter
implements IWorkpageStarter,
Serializable {
    @Override
    public IWorkpage startWorkpage(IWorkpageDispatcher workpageDispatcher, IWorkpageContainer workpageContainer, WorkpageStartInfo startInfo) {
        return this.startWorkpage(workpageDispatcher, workpageContainer, startInfo, null);
    }

    @Override
    public IWorkpage startWorkpage(IWorkpageDispatcher workpageDispatcher, IWorkpageContainer workpageContainer, WorkpageStartInfo startInfo, ICreatePageBeanInstance beanCreator) {
        IWorkpage wp;
        workpageDispatcher = (IWorkpageDispatcher)workpageDispatcher.getTopOwner();
        if (!startInfo.getOpenMultipleInstances() && (wp = workpageContainer.getWorkpageForId(startInfo.getId())) != null) {
            wp.setWorkpageStartInfo(startInfo);
            if (startInfo.getParamMap() != null && startInfo.getParamMap().size() > 0) {
                wp.getParamMap().clear();
                for (String key : startInfo.getParamMap().keySet()) {
                    String value = startInfo.getParam(key);
                    wp.getParamMap().put(key, value);
                }
            }
            if (startInfo.getPageBeanName() != null) {
                try {
                    Object o = wp.getDispatcher().getDispatchedBean(startInfo.getPageBeanName());
                    if (o instanceof IPrepareByWorkpageStartInfo) {
                        ((IPrepareByWorkpageStartInfo)o).prepare(startInfo);
                    }
                    if (o instanceof IPageBean) {
                        WorkplacePageBeanStateExtractor.instance().applyStateIntoPageBean((IPageBean)o, startInfo);
                    }
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_INF, "Problem during startWorkplace: " + startInfo.getPageBeanName(), t);
                }
            }
            this.switchToAlreadyOpenedWorkpage(workpageDispatcher, workpageContainer, wp);
            return wp;
        }
        String title = startInfo.getText();
        if (startInfo.getWindowTitle() != null && startInfo.getWindowTitle().length() > 0) {
            title = startInfo.getWindowTitle();
        }
        Workpage wp2 = null;
        if (startInfo.getJspPage() != null && startInfo.getJspPage().length() > 0) {
            wp2 = this.createWorkpage(workpageDispatcher, startInfo, title);
            wp2.setWorkpageStartInfo(startInfo);
            for (String paramName : startInfo.getParamMap().keySet()) {
                wp2.setParam(paramName, startInfo.getParamMap().get(paramName));
            }
        } else if (beanCreator != null) {
            wp2 = this.createWorkpageWithPageBean(workpageDispatcher, title, startInfo, beanCreator);
        } else if (startInfo.getPageBeanName() != null && startInfo.getPageBeanName().length() > 0) {
            wp2 = this.createWorkpageWithPageBean(workpageDispatcher, title, startInfo);
        } else if (startInfo.getFunctionClassName() != null && startInfo.getFunctionClassName().length() > 0) {
            IWorkpage iwp = this.startFunction(startInfo, workpageDispatcher);
            return iwp;
        }
        if (wp2 != null) {
            wp2.setPopupSupported(startInfo.isPopupSupported());
            wp2.setCloseSupported(startInfo.isCloseSupported());
            String selectorTitle = startInfo.getSelectorTitle();
            if (selectorTitle != null && selectorTitle.length() > 0 && (wp2.getSelectorTitle() == null || ValueManager.checkIfStringsAreEqual(wp2.getSelectorTitle(), wp2.getTitle()))) {
                wp2.setSelectorTitle(selectorTitle);
            }
            if (wp2.getIconURL() == null) {
                wp2.setIconURL(startInfo.getImage());
            }
            if (wp2.getSelectorBgpaint() == null) {
                wp2.setSelectorBgpaint(startInfo.getSelectorBgpaint());
            }
            if (wp2.getStartSubWorkpageContainerId() == null) {
                wp2.setStartSubWorkpageContainerId(startInfo.getStartSubWorkpageContainerId());
            }
            wp2.setExcludeFromSavePerspective(startInfo.getExcludeFromSavePerspective());
            if (wp2.getComment() == null) {
                wp2.setComment(startInfo.getComment());
            }
            if (!startInfo.getOpenAsPopupByDefault()) {
                workpageContainer.addWorkpage(wp2);
            } else {
                workpageContainer.addWorkpageAsPopup(wp2);
            }
            return wp2;
        }
        return null;
    }

    public Workpage createWorkpage(IWorkpageDispatcher workpageDispatcher, WorkpageStartInfo startInfo, String title) {
        Workpage wp = new Workpage(workpageDispatcher, startInfo.getJspPage(), startInfo.getId(), title, startInfo.getImage(), startInfo.isDecorated());
        return wp;
    }

    public Workpage createWorkpageWithPageBean(IWorkpageDispatcher workpageDispatcher, String title, WorkpageStartInfo startInfo, ICreatePageBeanInstance beanCreator) {
        try {
            WorkpageByPageBean wp = new WorkpageByPageBean(workpageDispatcher, title, startInfo, beanCreator);
            return wp;
        }
        catch (Throwable t) {
            this.reactOnProblemDuringWorkpageStart(t);
            return null;
        }
    }

    protected Workpage createWorkpageWithPageBean(IWorkpageDispatcher workpageDispatcher, String title, WorkpageStartInfo startInfo) {
        try {
            WorkpageByPageBean wp = new WorkpageByPageBean(workpageDispatcher, title, startInfo);
            return wp;
        }
        catch (Throwable t) {
            this.reactOnProblemDuringWorkpageStart(t);
            return null;
        }
    }

    protected void switchToAlreadyOpenedWorkpage(IWorkpageDispatcher workpageDispatcher, IWorkpageContainer workpageContainer, IWorkpage workpage) {
        workpageContainer.switchToWorkpage(workpage);
    }

    protected IWorkpage startFunction(WorkpageStartInfo wpsi, IWorkpageDispatcher dispatcher) {
        try {
            String className = wpsi.getFunctionClassName();
            Class clazz = CCClassResolver.resolveClass(className, ENUMCallerType.EXPRESSIONRESOLUTION);
            IWorkpageFunctionExecute wpfe = (IWorkpageFunctionExecute)clazz.newInstance();
            return wpfe.executeFunction(dispatcher, wpsi);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem when starting function in workplace starter", t);
            return null;
        }
    }

    protected void reactOnProblemDuringWorkpageStart(Throwable t) {
        CLog.L.log(CLog.LL_INF, "Problem occurred when starting workpage", t);
        while (t.getCause() != null) {
            t = t.getCause();
        }
        String message = t.getMessage();
        if (message == null || message.trim().length() == 0) {
            message = t.toString();
        }
        OKPopup.createInstance("", message);
    }
}

