/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Set;
import javax.faces.event.ActionEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclnt.jsfserver.defaultscreens.ModalPopup;
import org.eclnt.jsfserver.defaultscreens.ModelessPopup;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.managedbean.DefaultDispatcher;
import org.eclnt.jsfserver.managedbean.IDispatcher;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ISessionAbstraction;
import org.eclnt.util.log.CLog;
import org.eclnt.util.token.Token;
import org.eclnt.util.token.TokenMgr;
import org.eclnt.util.valuemgmt.JAXBManager;
import org.eclnt.workplace.IPrepareByWorkpageStartInfo;
import org.eclnt.workplace.IWorkpage;
import org.eclnt.workplace.IWorkpageAwarePageBean;
import org.eclnt.workplace.IWorkpageContainer;
import org.eclnt.workplace.IWorkpageDispatcher;
import org.eclnt.workplace.IWorkpageLifecycleListener;
import org.eclnt.workplace.MultiWorkplaceConnector;
import org.eclnt.workplace.MultiWorkplaceTokenContent;
import org.eclnt.workplace.TopWorkpage;
import org.eclnt.workplace.WorkpageContainer;
import org.eclnt.workplace.WorkpageStarterFactory;
import org.eclnt.workplace.eximport.WorkpageStartInfoExtensionAdapter;

public abstract class WorkpageDispatcher
extends DefaultDispatcher
implements IWorkpageDispatcher,
Statusbar.IStatusBarDrillDownInfoProvider,
Serializable {
    protected IWorkpageContainer m_workpageContainer;
    protected IWorkpage m_workpage;
    protected Statusbar m_statusbar;
    protected boolean m_isMaximized = false;
    private MultiWorkplaceTokenContent m_multiWorkplaceToken;

    public static IWorkpageDispatcher getDialogSessionInstance() {
        return (IWorkpageDispatcher)DefaultDispatcher.getDialogSessionInstance();
    }

    public static IWorkpageDispatcher getDialogSessionInstance(ISessionAbstraction dialogSession) {
        return (IWorkpageDispatcher)DefaultDispatcher.getDialogSessionInstance(dialogSession);
    }

    public WorkpageDispatcher() {
        this.m_multiWorkplaceToken = this.extractMultiWorkplaceTokenFromRequest();
        this.m_statusbar = new Statusbar(this);
        this.m_workpageContainer = this.createWorkpageContainer();
        this.m_workpage = new TopWorkpage(this);
        HttpSession hs = HttpSessionAccess.getCurrentHttpSession();
        if (hs != null && hs.getAttribute(WorkpageDispatcher.class.getName()) == null) {
            hs.setAttribute(WorkpageDispatcher.class.getName(), (Object)this);
        }
        this.registerWorkplaceInMultiWorkplaceScenario();
    }

    public WorkpageDispatcher(IWorkpageContainer workpageContainer) {
        this.m_statusbar = new Statusbar(this);
        this.m_workpageContainer = workpageContainer;
    }

    public static WorkpageDispatcher findSessionTopWorkpageDispatcher() {
        HttpSession hs = HttpSessionAccess.getCurrentHttpSession();
        if (hs != null) {
            return (WorkpageDispatcher)hs.getAttribute(WorkpageDispatcher.class.getName());
        }
        return null;
    }

    public static IWorkpageContainer findSessionWorkpageContainer() {
        WorkpageDispatcher d = WorkpageDispatcher.findSessionTopWorkpageDispatcher();
        if (d != null) {
            return d.getWorkpageContainer();
        }
        return null;
    }

    @Override
    public IDispatcher createSubDispatcherInstance(Class subDispatcherClass) {
        try {
            Constructor c = subDispatcherClass.getConstructor(IWorkpageContainer.class);
            IDispatcher result = (IDispatcher)c.newInstance(this.m_workpageContainer);
            this.registerSubDispatcherInstance(result);
            return result;
        }
        catch (Throwable throwable) {
            return super.createSubDispatcherInstance(subDispatcherClass);
        }
    }

    @Override
    public IWorkpageContainer getWorkpageContainer() {
        if (this.getOwner() == null) {
            return this.m_workpageContainer;
        }
        return this.getOwner().getWorkpageContainer();
    }

    @Override
    public IWorkpage getWorkpage() {
        return this.m_workpage;
    }

    @Override
    public void setWorkpage(IWorkpage workpage) {
        this.m_workpage = workpage;
    }

    @Override
    public Statusbar getStatusbar() {
        return this.m_statusbar;
    }

    @Override
    public void setOwner(IDispatcher owner) {
        super.setOwner(owner);
        if (owner instanceof IWorkpageDispatcher) {
            this.m_workpageContainer = ((IWorkpageDispatcher)owner).getWorkpageContainer();
        }
    }

    @Override
    public boolean isOpenedAsPopup() {
        return this.m_workpageContainer.checkIfWorkpageIsOpenedInPopup(this.m_workpage);
    }

    public boolean isPopupHeaderRendered() {
        if (!this.isOpenedAsPopup()) {
            return false;
        }
        if (!this.m_workpageContainer.getOpenWorkpagePopupsAsFrame()) {
            return true;
        }
        return this.m_workpage.isDecorated();
    }

    @Override
    public boolean checkIfToDrillDownToGlobalStatusbar() {
        return !this.isOpenedAsPopup();
    }

    public boolean getToNormalSizeRendered() {
        if (this.getWorkpageContainer().getOpenWorkpagePopupsAsFrame()) {
            return false;
        }
        return this.getIsMaximized();
    }

    public boolean getToMaximizedSizeRendered() {
        if (this.getWorkpageContainer().getOpenWorkpagePopupsAsFrame()) {
            return false;
        }
        return !this.getIsMaximized();
    }

    public boolean getIsMaximized() {
        return this.m_isMaximized;
    }

    public void onMoveWorkpageIntoContentArea(ActionEvent event) {
        this.m_workpageContainer.moveWorkpageIntoContentArea(this.getWorkpage());
        this.m_isMaximized = false;
    }

    public void onMaximize(ActionEvent event) {
        this.m_isMaximized = !this.m_isMaximized;
        this.m_workpageContainer.maximizeWorkpage(this.getWorkpage(), this.m_isMaximized);
    }

    @Override
    public void destroy() {
        Set<IWorkpageLifecycleListener> listeners;
        if (this.isDestroyed()) {
            return;
        }
        this.unregisterWorkplaceInMultiWorkplaceScenario();
        if (this.m_workpage != null && (listeners = this.m_workpage.getLifecycleListeners()) != null) {
            listeners = new HashSet<IWorkpageLifecycleListener>(listeners);
            for (IWorkpageLifecycleListener listener : listeners) {
                try {
                    listener.reactOnDestroyed();
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_INF, "Exception during reactOnDestroyed", t);
                }
            }
            try {
                if (this.m_workpage != null) {
                    this.m_workpage.getLifecycleListeners().clear();
                }
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Exception during reactOnDestroyed, clearing workpage life cycle listeners", t);
            }
        }
        if (this.getOwner() == null && this.m_workpageContainer != null) {
            try {
                this.m_workpageContainer.destroy();
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Exception during reactOnDestroyed, destroying workpage container", t);
            }
        }
        super.destroy();
        if (this.m_statusbar != null) {
            this.m_statusbar.destroy();
        }
        this.m_statusbar = null;
        this.m_workpage = null;
        this.m_workpageContainer = null;
    }

    @Override
    @Deprecated
    public ModalPopup createModalPopup() {
        if (this.m_workpage != null) {
            return this.m_workpage.createModalPopupInWorkpageContext();
        }
        return super.createModalPopup();
    }

    @Override
    @Deprecated
    public ModelessPopup createModelessPopup() {
        if (this.m_workpage != null) {
            return this.m_workpage.createModelessPopupInWorkpageContext();
        }
        return super.createModelessPopup();
    }

    @Override
    public IWorkpageDispatcher getTopOwner() {
        return (IWorkpageDispatcher)super.getTopOwner();
    }

    @Override
    public IWorkpageDispatcher getOwner() {
        return (IWorkpageDispatcher)super.getOwner();
    }

    @Override
    protected Object createObjectInstance(Class resultClass) throws Exception {
        Object result = super.createObjectInstance(resultClass);
        if (result != null && result instanceof IWorkpageAwarePageBean) {
            ((IWorkpageAwarePageBean)result).setWorkpageDispatcher(this);
        }
        return result;
    }

    protected IWorkpageContainer createWorkpageContainer() {
        if (this.m_multiWorkplaceToken == null) {
            return new WorkpageContainer(this);
        }
        String s = HttpSessionAccess.getCurrentRequest().getHeader("eclnt-originalurl");
        if (!s.contains("Full")) {
            return new WorkpageContainer(this, false);
        }
        WorkpageContainer result = new WorkpageContainer(this);
        result.prepareWorkplaceForCurrentUser();
        return result;
    }

    @Override
    protected Class getPreferredConstructorArguentClass() {
        return IWorkpageDispatcher.class;
    }

    @Override
    protected void prepareObject(Object o) {
        if (o instanceof IPrepareByWorkpageStartInfo) {
            ((IPrepareByWorkpageStartInfo)o).prepare(this.getWorkpage().getWorkpageStartInfo());
        }
        super.prepareObject(o);
    }

    protected void registerWorkplaceInMultiWorkplaceScenario() {
        block7: {
            MultiWorkplaceConnector mwc = MultiWorkplaceConnector.instance();
            mwc.registerWorkplace(this);
            try {
                if (this.m_multiWorkplaceToken == null) break block7;
                CLog.L.log(CLog.LL_INF, "Token management: Registering workplace in multiWokplaceScenario");
                try {
                    this.getWorkpageContainer().getMultiWorkplaceManager().setName(this.m_multiWorkplaceToken.getToName());
                    mwc.registerDependentWorkplace(this, this.m_multiWorkplaceToken.getFromId(), this.m_multiWorkplaceToken.getToName());
                }
                catch (Throwable tt) {
                    CLog.L.log(CLog.LL_INF, "Token management: registering dependent workplace failed", tt);
                }
                if (this.m_multiWorkplaceToken.getWpsi() != null) {
                    try {
                        CLog.L.log(CLog.LL_INF, "Token management: Starting workpage");
                        WorkpageStarterFactory.getWorkpageStarter().startWorkpage(this, this.getWorkpageContainer(), this.m_multiWorkplaceToken.getWpsi());
                    }
                    catch (Throwable t) {
                        CLog.L.log(CLog.LL_WAR, "Problem starting workpage: " + t, t);
                    }
                }
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem registering workplace in multi workplace scenarios", t);
            }
        }
    }

    private void unregisterWorkplaceInMultiWorkplaceScenario() {
        if (this.getOwner() != null) {
            return;
        }
        try {
            MultiWorkplaceConnector.instance().unregisterWorkplace(this);
            MultiWorkplaceConnector.instance().unregisterDependentWorkplace(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private MultiWorkplaceTokenContent extractMultiWorkplaceTokenFromRequest() {
        MultiWorkplaceTokenContent result = null;
        try {
            HttpServletRequest req = HttpSessionAccess.getCurrentRequest();
            String tokenValue = req.getParameter("ccmwpc_token");
            if (tokenValue != null) {
                CLog.L.log(CLog.LL_INF, "Token was part of URL - now pulling information: " + tokenValue);
                Token token = TokenMgr.instance().pullToken(tokenValue);
                if (token != null) {
                    CLog.L.log(CLog.LL_INF, "Token was successfully pulled from token manager");
                    CLog.L.log(CLog.LL_INF, "Token content: " + token.getContent());
                    result = (MultiWorkplaceTokenContent)JAXBManager.unmarshal(token.getContent(), MultiWorkplaceTokenContent.class);
                    CLog.L.log(CLog.LL_INF, "Token was transferred into MultiWorkplaceTokenContent instance");
                    result.m_wpsi = WorkpageStartInfoExtensionAdapter.instance().transferDefaultIntoExtension(result.m_wpsi);
                } else {
                    CLog.L.log(CLog.LL_INF, "Tolen - could not find token information: " + tokenValue);
                }
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem registering workplace in multi workplace scenarios", t);
        }
        return result;
    }
}

