/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.event.ActionEvent;
import org.eclnt.jsfserver.elements.componentnodes.BUTTONNode;
import org.eclnt.jsfserver.elements.componentnodes.CAPTUREANIMATORNode;
import org.eclnt.jsfserver.elements.componentnodes.PANENode;
import org.eclnt.jsfserver.elements.componentnodes.ROWNode;
import org.eclnt.jsfserver.elements.componentnodes.ROWWORKPLACEFUNCTIONTREENode;
import org.eclnt.jsfserver.elements.impl.ROWDYNAMICCONTENTBinding;
import org.eclnt.jsfserver.elements.util.Trigger;
import org.eclnt.workplace.IWorkpageDispatcher;
import org.eclnt.workplace.WorkpageDispatchedPageBean;
import org.eclnt.workplace.WorkplaceFunctionTree;
import org.eclnt.workplace.WorkplaceFunctionTreeFromInfoNode;
import org.eclnt.workplace.WorkplaceFunctionTreeInfoManager;
import org.eclnt.workplace.WorkplaceFunctionTreeInfoNode;

public class WorkplaceFoldableFunctionTrees
extends WorkpageDispatchedPageBean
implements Serializable {
    ROWDYNAMICCONTENTBinding m_dynContent = new ROWDYNAMICCONTENTBinding();
    List<Area> m_areas = new ArrayList<Area>();
    Trigger m_animationTrigger = new Trigger();
    WorkplaceFunctionTree.IFunctionNodeActionListener m_functionNodeActionListener = null;
    String m_functionNodeDefaultDropReceive = null;

    public WorkplaceFoldableFunctionTrees(IWorkpageDispatcher workpageDispatcher) {
        super(workpageDispatcher);
    }

    @Override
    public String getPageName() {
        return "/eclntjsfserver/includes/wp_workplacefoldablefunctiontrees.jsp";
    }

    @Override
    public String getRootExpressionUsedInPage() {
        return "#{PAGEBEAN}";
    }

    public void prepare(WorkplaceFunctionTreeInfoNode topNode) {
        this.render(topNode);
    }

    public void prepareOpenArea(int index) {
        if (index >= this.m_areas.size()) {
            return;
        }
        this.m_areas.get(index).setRendered(true);
    }

    public List<Area> getAreas() {
        return this.m_areas;
    }

    public ROWDYNAMICCONTENTBinding getDynContent() {
        return this.m_dynContent;
    }

    public Trigger getAnimationTrigger() {
        return this.m_animationTrigger;
    }

    public void setFunctionNodeActionListener(WorkplaceFunctionTree.IFunctionNodeActionListener functionNodeActionListener) {
        this.m_functionNodeActionListener = functionNodeActionListener;
        for (Area area : this.m_areas) {
            area.i_tree.setFunctionNodeActionListener(functionNodeActionListener);
        }
    }

    public WorkplaceFunctionTree.IFunctionNodeActionListener getFunctionNodeActionListener() {
        return this.m_functionNodeActionListener;
    }

    public String getFunctionNodeDefaultDropReceive() {
        return this.m_functionNodeDefaultDropReceive;
    }

    public void setFunctionNodeDefaultDropReceive(String functionNodeDefaultDropReceive) {
        this.m_functionNodeDefaultDropReceive = functionNodeDefaultDropReceive;
        for (Area area : this.m_areas) {
            area.i_tree.setFunctionNodeDefaultDropReceive(functionNodeDefaultDropReceive);
        }
    }

    private void render(WorkplaceFunctionTreeInfoNode topNode) {
        this.m_areas.clear();
        PANENode topPane = new PANENode();
        topPane.setWidth("100%");
        topPane.setHeight("100%");
        CAPTUREANIMATORNode c = new CAPTUREANIMATORNode();
        topPane.addSubNode(c);
        c.setTrigger(this.pbx("animationTrigger"));
        c.setAnimationtype("fogdark");
        List<WorkplaceFunctionTreeInfoNode> subs = topNode.getSubNodes();
        int counter = -1;
        for (WorkplaceFunctionTreeInfoNode sub : subs) {
            ++counter;
            ROWNode r = new ROWNode();
            topPane.addSubNode(r);
            BUTTONNode b = new BUTTONNode();
            r.addSubNode(b);
            b.setText(sub.getText());
            b.setWidth("100%");
            b.setActionListener(this.pbx("areas[" + counter + "].onButtonAction"));
            b.setAlign("left");
            b.setImage(this.pbx("areas[" + counter + "].image"));
            b.setStylevariant("WP_FOLDABLETOP");
            if (sub.getEmbeddedTreeName() != null) {
                sub = WorkplaceFunctionTreeInfoManager.loadFunctionTreeInfo(sub.getEmbeddedTreeName());
            }
            Area area = new Area(sub);
            this.m_areas.add(area);
            ROWWORKPLACEFUNCTIONTREENode f = new ROWWORKPLACEFUNCTIONTREENode();
            topPane.addSubNode(f);
            f.setObjectbinding(this.pbx("areas[" + counter + "].tree"));
            f.setRendered(this.pbx("areas[" + counter + "].rendered"));
        }
        this.m_dynContent.setContentNode(topPane);
    }

    public class Area {
        WorkplaceFunctionTreeInfoNode i_topNode;
        WorkplaceFunctionTree i_tree;
        boolean i_rendered = false;

        public Area(WorkplaceFunctionTreeInfoNode topNode) {
            this.i_topNode = topNode;
            this.i_tree = new WorkplaceFunctionTreeFromInfoNode(WorkplaceFoldableFunctionTrees.this.getOwningDispatcher(), this.i_topNode);
        }

        public WorkplaceFunctionTreeInfoNode getTopNode() {
            return this.i_topNode;
        }

        public WorkplaceFunctionTree getTree() {
            return this.i_tree;
        }

        public boolean getRendered() {
            return this.i_rendered;
        }

        public void setRendered(boolean value) {
            this.i_rendered = value;
        }

        public void onButtonAction(ActionEvent event) {
            this.i_rendered = !this.i_rendered;
            WorkplaceFoldableFunctionTrees.this.m_animationTrigger.trigger();
        }

        public String getImage() {
            if (!this.i_rendered) {
                return "/eclntjsfserver/images/metro_right.png";
            }
            return "/eclntjsfserver/images/metro_down.png";
        }
    }
}

