/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import org.eclnt.jsfserver.managedbean.IDispatcher;
import org.eclnt.workplace.IWorkpage;
import org.eclnt.workplace.WorkpageStartInfo;
import org.eclnt.workplace.WorkplaceFavorites;

public class WorkplaceHistory
extends WorkplaceFavorites {
    public static int NUMBER_OF_HISTORYITEMS = 20;
    public static final String WORKPLACEHISTORY_PERSISTID = "CC_WORKPLACE_HISTORY";
    int m_blockedCounter = 0;

    public WorkplaceHistory(IDispatcher dispatcher) {
        this(dispatcher, false);
    }

    public WorkplaceHistory(IDispatcher dispatcher, boolean loadFromPersistence) {
        super(dispatcher);
        this.m_defaultImage = "/eclntjsfserver/images/favorite_history.png";
        if (loadFromPersistence) {
            this.loadFromPersistence(WORKPLACEHISTORY_PERSISTID);
        }
    }

    public void addFavorite(IWorkpage workpage) {
        if (this.m_blockedCounter > 0) {
            return;
        }
        WorkpageStartInfo wpsi = this.convertWorkpageIntoWorkpageStartInfo(workpage);
        if (wpsi != null) {
            this.m_favorites.add(0, wpsi);
        }
        while (this.m_favorites.size() > NUMBER_OF_HISTORYITEMS) {
            this.m_favorites.remove(this.m_favorites.size() - 1);
        }
        this.updatePane();
        this.notifyFavoritesListeners();
    }

    public void block() {
        ++this.m_blockedCounter;
    }

    public void unblock() {
        --this.m_blockedCounter;
    }

    protected WorkpageStartInfo convertWorkpageIntoWorkpageStartInfo(IWorkpage workpage) {
        if (workpage.getWorkpageStartInfo() != null && workpage.getWorkpageStartInfo() instanceof WorkpageStartInfo) {
            return (WorkpageStartInfo)workpage.getWorkpageStartInfo();
        }
        return null;
    }

    protected boolean checkIfWorkpageStartInfoIsHistoryRelevant(WorkpageStartInfo wpsi) {
        if (wpsi == null) {
            return false;
        }
        if (wpsi.getJspPage() != null) {
            return true;
        }
        if (wpsi.getPageBeanName() != null) {
            return true;
        }
        return true;
    }
}

