/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclnt.jsfserver.elements.componentnodes.JSHOWURLNode;
import org.eclnt.jsfserver.elements.componentnodes.PANENode;
import org.eclnt.jsfserver.elements.componentnodes.ROWNode;
import org.eclnt.jsfserver.elements.componentnodes.ROWPAGEBEANINCLUDENode;
import org.eclnt.jsfserver.elements.componentnodes.ROWWORKPAGECONTAINERNode;
import org.eclnt.jsfserver.elements.componentnodes.ROWWORKPAGESELECTORNode;
import org.eclnt.jsfserver.elements.componentnodes.SESSIONCLOSERNode;
import org.eclnt.jsfserver.elements.componentnodes.SPLITPANENode;
import org.eclnt.jsfserver.elements.componentnodes.SPLITPANESPLITNode;
import org.eclnt.jsfserver.elements.componentnodes.UNIFIEDPOLLINGNode;
import org.eclnt.jsfserver.elements.impl.ROWDYNAMICCONTENTBinding;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.BeanWithParent;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.workplace.IWorkpage;
import org.eclnt.workplace.IWorkpageContainer;
import org.eclnt.workplace.IWorkpageContainerListener;
import org.eclnt.workplace.IWorkpageStarter;
import org.eclnt.workplace.WorkpageContainer;
import org.eclnt.workplace.WorkpageContainerDefaultListener;
import org.eclnt.workplace.WorkpageStartInfo;
import org.eclnt.workplace.WorkpageStarterFactory;
import org.eclnt.workplace.WorkplaceTileInfo;
import org.eclnt.workplace.WorkplaceTileInfoPageContainer;
import org.eclnt.workplace.WorkplaceTileInfoSplitPane;
import org.eclnt.workplace.WorkplaceTilePositionHint;
import org.eclnt.workplace.WorkplaceViewManager;
import org.eclnt.workplace.eximport.WorkpageStartInfoExtensionAdapter;

public class WorkplaceTileManager
implements Serializable {
    public static int DIRECTION_TOP = 0;
    public static int DIRECTION_BOTTOM = 1;
    public static int DIRECTION_LEFT = 2;
    public static int DIRECTION_RIGHT = 3;
    public static final String SELECTOR_POSITION_TOP = "top";
    public static final String SELECTOR_POSITION_BOTTOM = "bottom";
    public static final String SELECTOR_POSITION_NO = "no";
    WorkplaceTile m_topTile;
    ROWDYNAMICCONTENTBinding m_content;
    WorkpageContainer m_workpageContainer;
    String m_selectorPosition = "bottom";
    String m_animationType = "fogdark";
    int m_dividerSize = -1;
    String m_wpCloseImage = null;
    String m_wpPopupImage = null;
    boolean m_frozen = false;
    String m_wpPopupMenu = null;
    List<WorkplaceTileSplit> m_workplaceTileSplits = new ArrayList<WorkplaceTileSplit>();
    Map<String, WorkplaceTilePositionHint> m_workplaceTilePositionHints = new HashMap<String, WorkplaceTilePositionHint>();

    public WorkplaceTileManager(WorkpageContainer workpageContainer) {
        this.m_workpageContainer = workpageContainer;
        this.m_content = new ROWDYNAMICCONTENTBinding();
        this.m_topTile = new WorkplaceTileWorkpageContainer(null, null);
        this.construct();
    }

    protected void construct() {
        this.m_workpageContainer.addWorkpageContainerListener(new MyWorkpageContainerListener());
        this.renderTiles();
    }

    public List<WorkplaceTileSplit> getWorkplaceTileSplits() {
        return this.m_workplaceTileSplits;
    }

    public WorkplaceTile getTopTile() {
        return this.m_topTile;
    }

    public ROWDYNAMICCONTENTBinding getContent() {
        return this.m_content;
    }

    public String getSelectorPosition() {
        return this.m_selectorPosition;
    }

    public void setSelectorPosition(String selectorPosition) {
        if (ValueManager.checkIfStringsAreEqual(selectorPosition, this.m_selectorPosition)) {
            return;
        }
        this.m_selectorPosition = selectorPosition;
        this.renderTiles();
    }

    public String getAnimationType() {
        return this.m_animationType;
    }

    public void setAnimationType(String animationType) {
        if (ValueManager.checkIfStringsAreEqual(animationType, this.m_animationType)) {
            return;
        }
        this.m_animationType = animationType;
        this.renderTiles();
    }

    public int getDividerSize() {
        return this.m_dividerSize;
    }

    public void setDividerSize(String value) {
        this.setDividerSize(ValueManager.decodeIntWithRounding(value, -1));
    }

    public void setDividerSize(int dividerSize) {
        if (dividerSize == this.m_dividerSize) {
            return;
        }
        this.m_dividerSize = dividerSize;
        this.renderTiles();
    }

    public String getWpCloseImage() {
        return this.m_wpCloseImage;
    }

    public void setWpCloseImage(String wpCloseImage) {
        if (ValueManager.checkIfStringsAreEqual(wpCloseImage, this.m_wpCloseImage)) {
            return;
        }
        this.m_wpCloseImage = wpCloseImage;
        this.renderTiles();
    }

    public String getWpPopupImage() {
        return this.m_wpPopupImage;
    }

    public void setWpPopupImage(String wpPopupImage) {
        if (ValueManager.checkIfStringsAreEqual(wpPopupImage, this.m_wpPopupImage)) {
            return;
        }
        this.m_wpPopupImage = wpPopupImage;
        this.renderTiles();
    }

    public String getWpPopupMenu() {
        return this.m_wpPopupMenu;
    }

    public void setWpPopupMenu(String wpPopupMenu) {
        if (ValueManager.checkIfStringsAreEqual(wpPopupMenu, this.m_wpPopupMenu)) {
            return;
        }
        this.m_wpPopupMenu = wpPopupMenu;
        this.renderTiles();
    }

    public boolean setPixelWidthOfTile(String tileId, int pixelWidth) {
        WorkplaceTileWorkpageContainer tile = this.m_topTile.findTile(tileId);
        if (tile == null) {
            return false;
        }
        WorkplaceTileSplit owner = tile.getOwner();
        if (owner == null) {
            return false;
        }
        if (owner.i_split1 == tile) {
            owner.setDividerLocation(pixelWidth + "");
            return true;
        }
        return false;
    }

    public boolean setPercentageWidthOfTile(String tileId, int percWidth) {
        WorkplaceTileWorkpageContainer tile = this.m_topTile.findTile(tileId);
        if (tile == null) {
            return false;
        }
        WorkplaceTileSplit owner = tile.getOwner();
        if (owner == null) {
            return false;
        }
        if (owner.i_split1 == tile) {
            owner.setDividerLocation(percWidth + "%");
            return true;
        }
        if (owner.i_split1 == tile) {
            owner.setDividerLocation(100 - percWidth + "%");
            return true;
        }
        return false;
    }

    public String splitTile(String tileId, int direction) {
        return this.splitTile(tileId, null, direction);
    }

    public String splitTile(String tileId, String newTileId, int direction) {
        CLog.L.log(CLog.LL_INF, "splitTile was called, tile to split is: " + tileId);
        WorkplaceTileWorkpageContainer tile = this.m_topTile.findTile(tileId);
        if (tile == null) {
            CLog.L.log(CLog.LL_ERR, "The tile could not be found: " + tileId);
            return null;
        }
        boolean horizontal = true;
        if (direction == DIRECTION_TOP || direction == DIRECTION_BOTTOM) {
            horizontal = false;
        }
        CLog.L.log(CLog.LL_INF, "split direction, horizontal = " + horizontal);
        WorkplaceTileSplit owner = tile.getOwner();
        if (newTileId == null) {
            newTileId = "T" + UniqueIdCreator.createRandomId();
        }
        WorkplaceTileWorkpageContainer newContentTile = new WorkplaceTileWorkpageContainer(null, newTileId);
        WorkplaceTileSplit newSplitTile = null;
        newSplitTile = direction == DIRECTION_LEFT || direction == DIRECTION_TOP ? new WorkplaceTileSplit(horizontal, owner, tile, newContentTile) : new WorkplaceTileSplit(horizontal, owner, newContentTile, tile);
        newContentTile.setOwner(newSplitTile);
        tile.setOwner(newSplitTile);
        if (owner == null) {
            this.m_topTile = newSplitTile;
        } else if (owner instanceof WorkplaceTileSplit) {
            WorkplaceTileSplit ownerSplit = owner;
            if (ownerSplit.i_split1 == tile) {
                ownerSplit.i_split1 = newSplitTile;
            } else if (ownerSplit.i_split2 == tile) {
                ownerSplit.i_split2 = newSplitTile;
            }
        }
        this.renderTiles();
        return newTileId;
    }

    public void destroyTile(String tileId) {
        if (tileId == null) {
            return;
        }
        WorkplaceTileWorkpageContainer tile = this.m_topTile.findTile(tileId);
        if (tile == null) {
            CLog.L.log(CLog.LL_ERR, "The tile could not be found: " + tileId);
            return;
        }
        WorkplaceTileSplit owningTileSplit = tile.getOwner();
        WorkplaceTile neighbourTile = null;
        neighbourTile = owningTileSplit.i_split1 == tile ? owningTileSplit.i_split2 : owningTileSplit.i_split1;
        WorkplaceTileSplit owningOwningTileSplit = owningTileSplit.getOwner();
        if (owningOwningTileSplit != null) {
            if (owningOwningTileSplit.i_split1 == owningTileSplit) {
                owningOwningTileSplit.i_split1 = neighbourTile;
            } else {
                owningOwningTileSplit.i_split2 = neighbourTile;
            }
            neighbourTile.setOwner(owningOwningTileSplit);
        } else {
            this.m_topTile = neighbourTile;
            neighbourTile.setOwner(null);
        }
        this.renderTiles();
    }

    public void importWorkplaceTileInfo(String perspective) {
        this.importWorkplaceTileInfo(perspective, true);
    }

    public void importWorkplaceTileInfo(String perspective, boolean withClosingCurrentContent) {
        WorkplaceTileInfo wti = WorkplaceViewManager.loadTileInfo(perspective);
        if (wti == null) {
            throw new Error("The perspective " + perspective + " does not exist");
        }
        this.importWorkplaceTileInfo(wti, withClosingCurrentContent);
    }

    public void importWorkplaceTileInfo(WorkplaceTileInfo tileInfo) {
        this.importWorkplaceTileInfo(tileInfo, true);
    }

    public void importWorkplaceTileInfo(WorkplaceTileInfo tileInfo, boolean withClosingCurrentContent) {
        if (withClosingCurrentContent) {
            this.m_workpageContainer.closeAllWorkpages();
        }
        if (tileInfo.getSplit() != null) {
            WorkplaceTileInfoSplitPane splitInfo = tileInfo.getSplit();
            WorkplaceTileSplit split = new WorkplaceTileSplit();
            split.setDividerLocation(splitInfo.getDividerLocation());
            if ("vertical".equals(splitInfo.getOrientation())) {
                split.setHorizontal(false);
            } else {
                split.setHorizontal(true);
            }
            this.resolveWorkplaceTileInfoSplit(splitInfo, split);
            this.m_topTile = split;
            this.renderTiles();
        } else {
            this.m_topTile = new WorkplaceTileWorkpageContainer(null, null);
            this.renderTiles();
        }
        this.m_frozen = tileInfo.isFrozen();
        this.m_workplaceTilePositionHints.clear();
        if (tileInfo.getTilePositionHints() != null) {
            for (WorkplaceTilePositionHint ph : tileInfo.getTilePositionHints()) {
                if (ph.getId() == null) continue;
                this.m_workplaceTilePositionHints.put(ph.getId(), ph);
            }
        }
        if (!withClosingCurrentContent) {
            this.moveWorkpagesAfterTileRelayout(tileInfo);
        }
        IWorkpageStarter starter = WorkpageStarterFactory.getWorkpageStarter();
        HashMap<String, IWorkpage> firstStarted = new HashMap<String, IWorkpage>();
        for (WorkpageStartInfo wpsi : tileInfo.getStartViews()) {
            String containerId;
            WorkpageContainer wpc2;
            WorkpageContainer wpc1;
            wpsi = WorkpageStartInfoExtensionAdapter.instance().transferDefaultIntoExtension(wpsi);
            IWorkpage wp = WorkpageStarterFactory.getWorkpageStarter().startWorkpage(this.m_workpageContainer.getWorkpageDispatcher(), this.m_workpageContainer, wpsi);
            if (!withClosingCurrentContent && wpsi.getId() != null && wpsi.getStartSubWorkpageContainerId() != null && wpsi.getStartSubWorkpageContainerId().length() > 0 && (wpc1 = (WorkpageContainer)this.m_workpageContainer.getSubContainers().get(wpsi.getStartSubWorkpageContainerId())) != (wpc2 = this.m_workpageContainer.getWorkpageContainerForExisitingWorkpage(wp))) {
                this.m_workpageContainer.moveWorkpage(wp, wpc1);
            }
            if (firstStarted.containsKey(containerId = wpsi.getStartSubWorkpageContainerId() + "")) continue;
            firstStarted.put(containerId, wp);
        }
        if (tileInfo.getFunctionTreeOpenedTopNodeId() != null) {
            this.m_workpageContainer.getFunctionsManager().preselectTopNodeId(tileInfo.getFunctionTreeOpenedTopNodeId());
        }
        for (IWorkpageContainerListener wcl : this.m_workpageContainer.getWorkpageContainerListeners()) {
            try {
                wcl.reactOnPerspectiveUpdate(tileInfo);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_WAR, "Problem occurred when calling workpage-container-listener", t);
            }
        }
    }

    private void moveWorkpagesAfterTileRelayout(WorkplaceTileInfo tileInfo) {
        Map<String, WorkplaceTileInfoPageContainer> containerInfos = tileInfo.findContainers();
        Map<String, ? extends IWorkpageContainer> subContainers = this.m_workpageContainer.getSubContainers();
        for (String id : subContainers.keySet()) {
            if (containerInfos.containsKey(id)) continue;
            IWorkpageContainer subContainer = subContainers.get(id);
            List<IWorkpage> workpages = subContainer.getAllWorkpages();
            workpages = new ArrayList<IWorkpage>(workpages);
            for (IWorkpage workpage : workpages) {
                String workpageId = workpage.getUniqueTechnicalId();
                this.m_workpageContainer.moveWorkpage(workpageId, this.m_workpageContainer);
            }
        }
    }

    public WorkplaceTileInfo exportWorkplaceTileInfo() {
        WorkplaceTileInfo result = new WorkplaceTileInfo();
        if (this.m_topTile instanceof WorkplaceTileSplit) {
            result.m_split = new WorkplaceTileInfoSplitPane();
            ((WorkplaceTileSplit)this.m_topTile).export(result.m_split);
        } else {
            result.m_container = new WorkplaceTileInfoPageContainer();
            ((WorkplaceTileWorkpageContainer)this.m_topTile).export(result.m_container);
        }
        List<WorkpageStartInfo> wpsis = this.m_workpageContainer.exportCurrentWorkpages();
        for (WorkpageStartInfo wpsi : wpsis) {
            WorkpageStartInfoExtensionAdapter.instance().transferExtensionIntoDefault(wpsi);
            result.getStartViews().add(wpsi);
        }
        result.setFunctionTreeOpenedTopNodeId(this.m_workpageContainer.getFunctionsManager().getCurrentTopNodeId());
        return result;
    }

    private void resolveWorkplaceTileInfoSplit(WorkplaceTileInfoSplitPane splitInfo, WorkplaceTileSplit split) {
        WorkplaceTileSplit newSplit;
        WorkplaceTileWorkpageContainer newTile;
        BeanWithParent infoSub;
        if (splitInfo.getSubContainer1() != null) {
            infoSub = splitInfo.getSubContainer1();
            newTile = new WorkplaceTileWorkpageContainer();
            newTile.setOwner(split);
            split.i_split1 = newTile;
            newTile.setContainerId(((WorkplaceTileInfoPageContainer)infoSub).getId());
            newTile.setWithSelector(((WorkplaceTileInfoPageContainer)infoSub).getWithSelector());
            newTile.setFrozen(((WorkplaceTileInfoPageContainer)infoSub).getFrozen());
        } else if (splitInfo.getSubSplit1() != null) {
            infoSub = splitInfo.getSubSplit1();
            newSplit = new WorkplaceTileSplit();
            newSplit.setOwner(split);
            split.i_split1 = newSplit;
            newSplit.i_dividerLocation = ((WorkplaceTileInfoSplitPane)infoSub).getDividerLocation();
            newSplit.i_horizontal = !"vertical".equals(((WorkplaceTileInfoSplitPane)infoSub).getOrientation());
            this.resolveWorkplaceTileInfoSplit((WorkplaceTileInfoSplitPane)infoSub, newSplit);
        }
        if (splitInfo.getSubContainer2() != null) {
            infoSub = splitInfo.getSubContainer2();
            newTile = new WorkplaceTileWorkpageContainer();
            newTile.setOwner(split);
            split.i_split2 = newTile;
            newTile.setContainerId(((WorkplaceTileInfoPageContainer)infoSub).getId());
            newTile.setWithSelector(((WorkplaceTileInfoPageContainer)infoSub).getWithSelector());
            newTile.setFrozen(((WorkplaceTileInfoPageContainer)infoSub).getFrozen());
        } else if (splitInfo.getSubSplit2() != null) {
            infoSub = splitInfo.getSubSplit2();
            newSplit = new WorkplaceTileSplit();
            newSplit.setOwner(split);
            split.i_split2 = newSplit;
            newSplit.i_dividerLocation = ((WorkplaceTileInfoSplitPane)infoSub).getDividerLocation();
            newSplit.i_horizontal = !"vertical".equals(((WorkplaceTileInfoSplitPane)infoSub).getOrientation());
            this.resolveWorkplaceTileInfoSplit((WorkplaceTileInfoSplitPane)infoSub, newSplit);
        }
    }

    public void ensureTileForWorkpageContainerIsAvailable(String workpageContainerId) {
        WorkplaceTileWorkpageContainer tile = this.m_topTile.findTile(workpageContainerId);
        if (tile == null) {
            WorkplaceTileWorkpageContainer tile1;
            WorkplaceTilePositionHint tilePositionHint = this.m_workplaceTilePositionHints.get(workpageContainerId);
            if (tilePositionHint != null && tilePositionHint.getRelativeToTile1Id() != null && (tile1 = this.m_topTile.findTile(tilePositionHint.getRelativeToTile1Id())) != null) {
                int direction = this.convertPositionHintDirectionIntoSplitDirection(tilePositionHint.getRelativeToTile1Position());
                this.splitTile(tilePositionHint.getRelativeToTile1Id(), workpageContainerId, direction);
                return;
            }
            int direction = DIRECTION_LEFT;
            if (tilePositionHint != null) {
                direction = this.convertPositionHintDirectionIntoSplitDirection(tilePositionHint.getRelativeToNullTile());
            }
            this.splitTile(null, workpageContainerId, direction);
            this.renderTiles();
        }
    }

    private int convertPositionHintDirectionIntoSplitDirection(String positionHintDirection) {
        int result = DIRECTION_LEFT;
        if (SELECTOR_POSITION_BOTTOM.equals(positionHintDirection)) {
            result = DIRECTION_TOP;
        } else if (SELECTOR_POSITION_TOP.equals(positionHintDirection)) {
            result = DIRECTION_BOTTOM;
        } else if ("left".equals(positionHintDirection)) {
            result = DIRECTION_RIGHT;
        }
        return result;
    }

    private void renderTiles() {
        this.m_workplaceTileSplits.clear();
        PANENode result = new PANENode().setId(this.m_workpageContainer.getUniqueId() + "_TIMGRPANE").setWidth("100%").setHeight("100%").setStylevariant("WP_WORKPLACE");
        this.addMultiWorkplaceComponents(result);
        ROWDYNAMICCONTENTBinding.ComponentNode topNode = this.m_topTile.renderTile();
        result.addSubNode(topNode);
        this.m_content.setContentNode(result);
    }

    private void addMultiWorkplaceComponents(PANENode result) {
        if (SystemXml.getWorkplaceMultiScreen()) {
            String prefix = this.m_workpageContainer.getWorkpageDispatcher().getExpressionBase().replace("}", ".workpageContainer.multiWorkplaceManager.");
            this.addMultiWorkplaceComponentJshowURL(result, prefix);
            this.addMultiWorkplaceComponentSynchronization(result, prefix);
        }
    }

    private void addMultiWorkplaceComponentSynchronization(PANENode result, String prefix) {
        SESSIONCLOSERNode sc = new SESSIONCLOSERNode().setRendered(prefix + "active}");
        result.addSubNode(sc);
        UNIFIEDPOLLINGNode wp = new UNIFIEDPOLLINGNode().setRendered(prefix + "active}").setPagebeanbinding(prefix + "polling}").setActionListener(prefix + "onRefreshAction}");
        result.addSubNode(wp);
    }

    private void addMultiWorkplaceComponentJshowURL(PANENode result, String prefix) {
        JSHOWURLNode jsu = new JSHOWURLNode().setUrl(prefix + "startURL}").setTrigger(prefix + "startURLTrigger}").setWindowfeatures(prefix + "startURLFeatures}");
        result.addSubNode(jsu);
    }

    private void addWorkpageToContainer(String workpageContainerId, String workpageTechId) {
        this.m_workpageContainer.moveWorkpage(workpageTechId, workpageContainerId);
    }

    public class WorkplaceTileWorkpageContainer
    extends WorkplaceTile
    implements Serializable {
        String i_containerId;
        boolean i_withSelector;
        boolean i_frozen;
        IWorkpageContainer i_workpageContainer;

        private WorkplaceTileWorkpageContainer() {
            this.i_withSelector = true;
            this.i_frozen = false;
            this.i_workpageContainer = WorkplaceTileManager.this.m_workpageContainer;
        }

        private WorkplaceTileWorkpageContainer(WorkplaceTileSplit owner, String containerId) {
            super(owner);
            this.i_withSelector = true;
            this.i_frozen = false;
            this.i_containerId = containerId;
            this.i_workpageContainer = containerId != null ? WorkplaceTileManager.this.m_workpageContainer.getSubWorkpageContainers().get(containerId) : WorkplaceTileManager.this.m_workpageContainer;
        }

        public String getContainerId() {
            return this.i_containerId;
        }

        public void setContainerId(String containerId) {
            this.i_containerId = containerId;
        }

        public boolean getWithSelector() {
            return this.i_withSelector;
        }

        public void setWithSelector(boolean withSelector) {
            this.i_withSelector = withSelector;
        }

        public boolean isFrozen() {
            return this.i_frozen;
        }

        public void setFrozen(boolean frozen) {
            this.i_frozen = frozen;
        }

        @Override
        public ROWDYNAMICCONTENTBinding.ComponentNode renderTile() {
            String expression = null;
            String expressionBase = WorkplaceTileManager.this.m_workpageContainer.getWorkpageDispatcher().getExpressionBase();
            expression = this.i_containerId == null ? expressionBase.replace("}", ".workpageContainer}") : expressionBase.replace("}", ".workpageContainer.subContainers." + this.i_containerId + "}");
            ROWNode cnRow = new ROWNode().setId(this.i_unqueId + "_ROW");
            PANENode cnPane = new PANENode().setId(this.i_unqueId + "_PANE").setWidth("100%").setHeight("100%").setStylevariant("WP_PANEAROUNDWORKPAGECONTAINER");
            cnRow.addSubNode(cnPane);
            ROWWORKPAGECONTAINERNode cnWpc = new ROWWORKPAGECONTAINERNode().setId(this.i_unqueId + "RWPCN").setBorder("0").setPadding("0").setObjectbinding(expression).setAnimationtype(WorkplaceTileManager.this.m_animationType).setWpcloseimage(WorkplaceTileManager.this.m_wpCloseImage).setWppopupimage(WorkplaceTileManager.this.m_wpPopupImage).setWppopupmenu(WorkplaceTileManager.this.m_wpPopupMenu).setHotkeyisolation(WorkplaceTileManager.this.m_workpageContainer.getHotKeyIsolation() + "");
            if (!WorkplaceTileManager.this.m_frozen && !this.i_frozen) {
                cnWpc.setDropreceive("CCWORKPAGE:sidesandcenter");
            }
            if (WorkplaceTileManager.SELECTOR_POSITION_NO.equals(WorkplaceTileManager.this.m_selectorPosition)) {
                this.i_withSelector = false;
            }
            ROWNode cnWpsrow = new ROWNode().setId(this.i_unqueId + "_WPSROW");
            PANENode cnWpspane = new PANENode().setId(this.i_unqueId + "_CNWPSPANE").setWidth("100%").setStylevariant("WP_PANEAROUNDSELECTOR");
            cnWpsrow.addSubNode(cnWpspane);
            if (this.i_workpageContainer.getWorkpageSelector() == null) {
                ROWWORKPAGESELECTORNode cnWps = new ROWWORKPAGESELECTORNode().setId(this.i_unqueId + "_WPS").setObjectbinding(expression);
                cnWpspane.addSubNode(cnWps);
            } else {
                ROWPAGEBEANINCLUDENode rinWps = new ROWPAGEBEANINCLUDENode().setId(this.i_unqueId + "_RIN").bindPagebeanbinding(this.i_workpageContainer.getWorkpageSelector());
                cnWpspane.addSubNode(rinWps);
            }
            if (WorkplaceTileManager.SELECTOR_POSITION_TOP.equals(WorkplaceTileManager.this.m_selectorPosition)) {
                if (this.i_withSelector) {
                    cnPane.addSubNode(cnWpsrow);
                }
                cnPane.addSubNode(cnWpc);
            } else {
                cnPane.addSubNode(cnWpc);
                if (this.i_withSelector) {
                    cnPane.addSubNode(cnWpsrow);
                }
            }
            return cnRow;
        }

        @Override
        public WorkplaceTileWorkpageContainer findTile(String id) {
            if (ValueManager.checkIfStringsAreEqual(id, this.i_containerId)) {
                return this;
            }
            return null;
        }

        @Override
        public boolean containsNullTile() {
            return this.i_containerId == null;
        }

        public void export(WorkplaceTileInfoPageContainer pageContainer) {
            pageContainer.m_id = this.i_containerId;
            pageContainer.m_frozen = this.i_frozen;
            pageContainer.m_withSelector = this.i_withSelector;
        }
    }

    public class WorkplaceTileSplit
    extends WorkplaceTile
    implements Serializable {
        boolean i_horizontal;
        WorkplaceTile i_split1;
        WorkplaceTile i_split2;
        String i_dividerLocation;

        private WorkplaceTileSplit() {
            this.i_horizontal = true;
            this.i_dividerLocation = null;
        }

        private WorkplaceTileSplit(boolean horizontal, WorkplaceTileSplit owner, WorkplaceTile split1, WorkplaceTile split2) {
            super(owner);
            this.i_horizontal = true;
            this.i_dividerLocation = null;
            this.i_horizontal = horizontal;
            this.i_split1 = split1;
            this.i_split2 = split2;
        }

        public boolean isHorizontal() {
            return this.i_horizontal;
        }

        public void setHorizontal(boolean horizontal) {
            this.i_horizontal = horizontal;
        }

        public String getDividerLocation() {
            return this.i_dividerLocation;
        }

        public void setDividerLocation(String dividerLocation) {
            this.i_dividerLocation = dividerLocation;
        }

        public WorkplaceTile getSplit1() {
            return this.i_split1;
        }

        public WorkplaceTile getSplit2() {
            return this.i_split2;
        }

        @Override
        public ROWDYNAMICCONTENTBinding.ComponentNode renderTile() {
            WorkplaceTileManager.this.m_workplaceTileSplits.add(this);
            int index = WorkplaceTileManager.this.m_workplaceTileSplits.size() - 1;
            String dividerLocationExpression = WorkplaceTileManager.this.m_workpageContainer.getWorkpageDispatcher().getExpressionBase();
            dividerLocationExpression = dividerLocationExpression.replace("}", ".workpageContainer.tileManager.workplaceTileSplits[" + index + "].dividerLocation}");
            if (this.i_dividerLocation == null) {
                this.i_dividerLocation = "50%";
                if (this.i_split1.containsNullTile()) {
                    this.i_dividerLocation = "66%";
                } else if (this.i_split2.containsNullTile()) {
                    this.i_dividerLocation = "33%";
                }
            }
            ROWNode result = new ROWNode().setId(this.i_unqueId + "_ROW");
            SPLITPANENode splitpane = new SPLITPANENode().setId(this.i_unqueId + "_SPLITPANE").setHeight("100%").setWidth("100%").setDividerlocation(dividerLocationExpression).setWithwritebackdividerlocation(true).setStylevariant("WP_TILESPLITPANE");
            if (WorkplaceTileManager.this.m_dividerSize >= 0) {
                splitpane.setDividersize("" + WorkplaceTileManager.this.m_dividerSize);
            }
            if (!this.i_horizontal) {
                splitpane.setOrientation("vertical");
            } else {
                splitpane.setOrientation("horizontal");
            }
            result.addSubNode(splitpane);
            SPLITPANESPLITNode split = new SPLITPANESPLITNode().setId(this.i_unqueId + "_S1").setStylevariant("WP_TILESPLITPANESPLIT");
            splitpane.addSubNode(split);
            split.addSubNode(this.i_split1.renderTile());
            split = new SPLITPANESPLITNode().setId(this.i_unqueId + "_S2").setStylevariant("WP_TILESPLITPANESPLIT");
            splitpane.addSubNode(split);
            split.addSubNode(this.i_split2.renderTile());
            return result;
        }

        @Override
        public WorkplaceTileWorkpageContainer findTile(String id) {
            WorkplaceTileWorkpageContainer result = this.i_split1.findTile(id);
            if (result != null) {
                return result;
            }
            result = this.i_split2.findTile(id);
            return result;
        }

        @Override
        public boolean containsNullTile() {
            if (this.i_split1.containsNullTile()) {
                return true;
            }
            return this.i_split2.containsNullTile();
        }

        public void export(WorkplaceTileInfoSplitPane tileInfoSplitPane) {
            WorkplaceTileInfoSplitPane isp;
            WorkplaceTileInfoPageContainer ipc;
            tileInfoSplitPane.m_dividerLocation = this.i_dividerLocation;
            tileInfoSplitPane.m_orientation = this.i_horizontal ? "horizontal" : "vertical";
            if (this.i_split1 instanceof WorkplaceTileWorkpageContainer) {
                tileInfoSplitPane.m_subContainer1 = ipc = new WorkplaceTileInfoPageContainer();
                ((WorkplaceTileWorkpageContainer)this.i_split1).export(ipc);
            }
            if (this.i_split2 instanceof WorkplaceTileWorkpageContainer) {
                tileInfoSplitPane.m_subContainer2 = ipc = new WorkplaceTileInfoPageContainer();
                ((WorkplaceTileWorkpageContainer)this.i_split2).export(ipc);
            }
            if (this.i_split1 instanceof WorkplaceTileSplit) {
                tileInfoSplitPane.m_subSplit1 = isp = new WorkplaceTileInfoSplitPane();
                ((WorkplaceTileSplit)this.i_split1).export(isp);
            }
            if (this.i_split2 instanceof WorkplaceTileSplit) {
                tileInfoSplitPane.m_subSplit2 = isp = new WorkplaceTileInfoSplitPane();
                ((WorkplaceTileSplit)this.i_split2).export(isp);
            }
        }
    }

    public abstract class WorkplaceTile
    implements Serializable {
        WorkplaceTileSplit i_owner;
        String i_unqueId = "T" + UniqueIdCreator.createRandomId();

        private WorkplaceTile() {
        }

        private WorkplaceTile(WorkplaceTileSplit owner) {
            this.i_owner = owner;
        }

        public WorkplaceTileSplit getOwner() {
            return this.i_owner;
        }

        public void setOwner(WorkplaceTileSplit owner) {
            this.i_owner = owner;
        }

        public abstract ROWDYNAMICCONTENTBinding.ComponentNode renderTile();

        public abstract WorkplaceTileWorkpageContainer findTile(String var1);

        public abstract boolean containsNullTile();
    }

    private class MyWorkpageContainerListener
    extends WorkpageContainerDefaultListener
    implements Serializable {
        private MyWorkpageContainerListener() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void reactOnWorkpageDrop(String workpageContainerId, String workpageTechId, int horizontalPercentage, int verticalPercentage) {
            int direction = DIRECTION_RIGHT;
            if (verticalPercentage >= 25 && verticalPercentage < 75) {
                if (horizontalPercentage < 25) {
                    direction = DIRECTION_RIGHT;
                } else {
                    if (horizontalPercentage <= 75) {
                        WorkplaceTileManager.this.addWorkpageToContainer(workpageContainerId, workpageTechId);
                        return;
                    }
                    direction = DIRECTION_LEFT;
                }
            } else {
                if (verticalPercentage < 25) {
                    direction = DIRECTION_BOTTOM;
                }
                if (verticalPercentage > 75) {
                    direction = DIRECTION_TOP;
                }
            }
            String newWorkpageContainerId = WorkplaceTileManager.this.splitTile(workpageContainerId, direction);
            WorkplaceTileManager.this.m_workpageContainer.moveWorkpage(workpageTechId, newWorkpageContainerId);
        }

        @Override
        public void reactOnWorkpageContainerGotEmpty(String workpageContainerId) {
            WorkplaceTileManager.this.destroyTile(workpageContainerId);
        }

        @Override
        public void reactOnWorkpageAdded(IWorkpage workpage) {
            String workpageContainerId = workpage.getStartSubWorkpageContainerId();
            WorkplaceTileManager.this.ensureTileForWorkpageContainerIsAvailable(workpageContainerId);
        }
    }
}

