/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.defaultscreens;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.faces.event.ActionEvent;
import org.eclnt.jsfserver.bufferedcontent.BufferedContentMgr;
import org.eclnt.jsfserver.bufferedcontent.DefaultBufferedContent;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.elements.impl.FIXGRIDItem;
import org.eclnt.jsfserver.elements.impl.FIXGRIDListBinding;
import org.eclnt.jsfserver.elements.util.Trigger;
import org.eclnt.jsfserver.pagebean.PageBean;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.CLogInfo;

public class LogViewer
extends PageBean {
    List<LogLine> m_logLines = new ArrayList<LogLine>();
    protected String m_actualLogFile;
    protected String m_baseLogFile;
    protected FIXGRIDListBinding<GridItem> m_grid = new FIXGRIDListBinding(true);
    protected FIXGRIDListBinding<AllGridItem> m_all = new FIXGRIDListBinding(true);
    protected FIXGRIDListBinding<FileGridItem> m_fileGrid = new FIXGRIDListBinding(true);
    protected int m_filterLevel = 1;
    protected int m_numberOfBytesToRead = 150000;
    protected boolean m_flagShowTimestampThread = true;
    MyBufferedContent m_bufferedContent;
    Trigger m_downloadTrigger = new Trigger();

    public LogViewer() {
        this.m_baseLogFile = CLogInfo.getLogFileBaseName();
        this.m_actualLogFile = CLogInfo.getCurrentLogFile().getAbsolutePath();
        this.m_bufferedContent = new MyBufferedContent();
        BufferedContentMgr.add(this.m_bufferedContent);
        try {
            this.showLog(true);
            this.updateFileList();
        }
        catch (Throwable t) {
            Statusbar.outputAlert(t.toString());
        }
    }

    @Override
    public String getPageName() {
        return "/elcntjsfserver/includes/logviewer.jsp";
    }

    @Override
    public String getRootExpressionUsedInPage() {
        return "#{eclntdefscr.logViewer}";
    }

    public String getBaseLogFile() {
        return this.m_baseLogFile;
    }

    public String getActualLogFile() {
        return this.m_actualLogFile;
    }

    public FIXGRIDListBinding<GridItem> getGrid() {
        return this.m_grid;
    }

    public FIXGRIDListBinding<AllGridItem> getAll() {
        return this.m_all;
    }

    public FIXGRIDListBinding<FileGridItem> getFileGrid() {
        return this.m_fileGrid;
    }

    public boolean getFlagShowTimestampThread() {
        return this.m_flagShowTimestampThread;
    }

    public void setFlagShowTimestampThread(boolean value) {
        this.m_flagShowTimestampThread = value;
    }

    public String getDownloadURL() {
        return this.m_bufferedContent.getURL();
    }

    public Trigger getDownloadTrigger() {
        return this.m_downloadTrigger;
    }

    public void onShowLogFile(ActionEvent event) {
        try {
            this.showLog(true);
            this.updateFileList();
        }
        catch (Throwable t) {
            Statusbar.outputAlert(t.toString());
        }
    }

    public void onApplyFilter(ActionEvent event) {
        try {
            this.updateGrid(true);
        }
        catch (Throwable t) {
            Statusbar.outputAlert(t.toString());
        }
    }

    private void showLog(boolean withLastItemPositioning) {
        this.readAllLogItems();
        this.updateAllGrid(withLastItemPositioning);
        this.updateGrid(withLastItemPositioning);
    }

    private void readAllLogItems() {
        this.m_logLines.clear();
        this.m_actualLogFile = CLogInfo.getCurrentLogFile().getAbsolutePath();
        List<String> logItems = CLogInfo.getContentEndOfCurrentLogFile(this.m_numberOfBytesToRead);
        LogLine lastLogLine = null;
        String lastCategory = "";
        for (int i = 0; i < logItems.size(); ++i) {
            String li = logItems.get(i);
            LogLine ll = new LogLine();
            ll.setCategory(lastCategory);
            if (li.length() >= 46 && li.charAt(24) == '|') {
                ll.setTimestamp(li.substring(0, 23));
                ll.setCategory(li.substring(35, 43).trim());
                ll.setThreadInfo(li.substring(26, 32).trim());
                ll.setText(li.substring(46));
                lastCategory = ll.getCategory();
            } else {
                ll.setTimestamp("");
                ll.m_categoryContinued = true;
                ll.setText("     " + li);
            }
            this.m_logLines.add(ll);
            lastLogLine = ll;
        }
    }

    private void updateAllGrid(boolean withLastItemPositioning) {
        int gridSize;
        this.m_all.getItems().clear();
        for (LogLine ll : this.m_logLines) {
            AllGridItem gi = new AllGridItem(ll);
            this.m_all.getItems().add(gi);
        }
        if (withLastItemPositioning && (gridSize = this.m_all.getItems().size()) > 0) {
            this.m_all.ensureItemToBeDisplayed(gridSize - 1);
        }
    }

    private void showAllItem(LogLine ll) {
        for (int i = 0; i < this.m_all.getItems().size(); ++i) {
            LogLine allLl = this.m_all.getItems().get((int)i).m_ll;
            if (allLl != ll) continue;
            this.m_all.deselectCurrentSelection();
            this.m_all.selectItem(i);
            int displayIndex = i - 5;
            if (displayIndex >= this.m_all.getItems().size()) {
                displayIndex = this.m_all.getItems().size() - 1;
            }
            if (displayIndex < 0) {
                displayIndex = 0;
            }
            this.m_all.setSbvalue(displayIndex);
            return;
        }
    }

    private void updateGrid(boolean withLastItemPositioning) {
        int gridSize;
        this.m_grid.getItems().clear();
        for (LogLine ll : this.m_logLines) {
            if (ll.m_categoryContinued || this.m_filterLevel < 3 && ll.getCategory().equals("FINE") || this.m_filterLevel < 2 && ll.getCategory().equals("INFO") || this.m_filterLevel < 1 && ll.getCategory().equals("WARNING")) continue;
            GridItem gi = new GridItem(ll);
            this.m_grid.getItems().add(gi);
        }
        if (withLastItemPositioning && (gridSize = this.m_grid.getItems().size()) > 0) {
            this.m_grid.ensureItemToBeDisplayed(gridSize - 1);
        }
    }

    private void updateFileList() {
        this.m_fileGrid.getItems().clear();
        List<File> files = CLogInfo.getLogFiles();
        for (File file : files) {
            this.m_fileGrid.getItems().add(new FileGridItem(file));
        }
        Collections.sort(this.m_fileGrid.getItems());
        this.m_grid.clearSortInfo();
    }

    public class MyBufferedContent
    extends DefaultBufferedContent {
        @Override
        public byte[] getContent() {
            FileGridItem fgi = (FileGridItem)LogViewer.this.m_fileGrid.getSelectedItem();
            File f = fgi.i_file;
            return FileManager.readFile(f.getAbsolutePath(), true);
        }

        @Override
        public String getContentType() {
            return "text/plain";
        }
    }

    public class GridItem
    extends AllGridItem {
        public GridItem(LogLine ll) {
            super(ll);
        }

        @Override
        public void onRowExecute() {
            super.onRowExecute();
            LogViewer.this.showAllItem(this.m_ll);
        }
    }

    public class AllGridItem
    extends FIXGRIDItem
    implements Serializable {
        LogLine m_ll;

        public AllGridItem(LogLine ll) {
            this.m_ll = ll;
        }

        public String getThreadInfo() {
            return this.m_ll.getThreadInfo();
        }

        public String getText() {
            return this.m_ll.getText();
        }

        public String getTimestamp() {
            return this.m_ll.getTimestamp();
        }

        public String getCategory() {
            return this.m_ll.getCategory();
        }

        public String getCategoryColor() {
            return this.m_ll.getCategoryColor();
        }

        public String getTextColor() {
            return this.m_ll.getTextColor();
        }
    }

    public class FileGridItem
    extends FIXGRIDItem
    implements Serializable,
    Comparable<FileGridItem> {
        File i_file;

        public FileGridItem(File file) {
            this.i_file = file;
        }

        public String getFileName() {
            return this.i_file.getName();
        }

        public long getFileDate() {
            return this.i_file.lastModified();
        }

        @Override
        public void onRowExecute() {
            LogViewer.this.m_fileGrid.deselectCurrentSelection();
            LogViewer.this.m_fileGrid.selectItem(this);
            LogViewer.this.m_downloadTrigger.trigger();
            LogViewer.this.m_bufferedContent.setFileName(this.i_file.getName());
        }

        @Override
        public int compareTo(FileGridItem o) {
            long ol;
            long l = this.i_file.lastModified();
            if (l != (ol = o.i_file.lastModified())) {
                return (int)(-1L * (l - ol));
            }
            return this.i_file.getName().compareTo(o.i_file.getName());
        }
    }

    public class LogLine
    implements Serializable {
        boolean m_categoryContinued = false;
        protected String m_threadInfo;
        protected String m_text;
        protected String m_timestamp;
        protected String m_category;

        public String getThreadInfo() {
            return this.m_threadInfo;
        }

        public void setThreadInfo(String value) {
            this.m_threadInfo = value;
        }

        public String getText() {
            return this.m_text;
        }

        public void setText(String value) {
            this.m_text = value;
        }

        public String getTimestamp() {
            return this.m_timestamp;
        }

        public void setTimestamp(String value) {
            this.m_timestamp = value;
        }

        public String getCategory() {
            return this.m_category;
        }

        public void setCategory(String value) {
            this.m_category = value;
        }

        public String getCategoryColor() {
            if (this.m_category != null) {
                if (this.m_category.equals("INFO")) {
                    return "#00FF0020";
                }
                if (this.m_category.equals("WARNING")) {
                    return "#FFFF0020";
                }
                if (this.m_category.equals("SEVERE")) {
                    return "#FF000020";
                }
            }
            return null;
        }

        public String getTextColor() {
            if (this.m_text != null) {
                if (this.m_text.startsWith(">>>>>>>>>")) {
                    return "#0000FF30";
                }
                if (this.m_text.startsWith("<<<<<<<<<")) {
                    return "#0000FF30";
                }
            }
            return null;
        }
    }
}

