/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.defaultscreens;

import java.io.Serializable;
import javax.faces.event.ActionEvent;
import org.eclnt.jsfserver.defaultscreens.DefaultScreens;
import org.eclnt.jsfserver.defaultscreens.ModalPopup;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.i18n.I18N;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ICCServerConstants;
import org.eclnt.jsfserver.util.StyleManager;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class YESNOPopup
implements Serializable,
ModalPopup.IModalPopupListener,
ICCServerConstants {
    public static String PAGENAME_DEFAULT = "/eclntjsfserver/popups/yesno.jsp";
    public static String PAGENAME_HTML = "/eclntjsfserver/popups/yesnoht.jsp";
    ModalPopup m_modalPopup;
    IYesNoListener m_yesNoListener;
    String m_text = "No text specified.";
    boolean m_showCancel = false;
    Throwable m_stackLastCall;
    String m_icon = null;
    String m_textYes = null;
    String m_textNo = null;
    String m_textCancel = null;
    String m_headline = null;
    String m_textAlign = "center";
    String m_textContentType = "text/plain";
    String m_yesButtonImage = null;
    String m_noButtonImage = null;
    String m_cancelButtonImage = null;
    String m_requestFocusYes = "creation";
    String m_requestFocusNo = null;
    String m_requestFocusCancel = null;
    String m_backgroundColor = null;
    String m_imageBackgroundColor = null;

    public static void initialize() {
        if (SystemXml.getDefaultPopups().getYesnopopup() != null) {
            PAGENAME_DEFAULT = SystemXml.getDefaultPopups().getYesnopopup();
        }
    }

    public static YESNOPopup createInstance(String title, String text, IYesNoListener yesNoListener) {
        return YESNOPopup.createInstanceExecute(title, text, yesNoListener);
    }

    private static YESNOPopup createInstanceExecute(String title, String text, IYesNoListener yesNoListener) {
        YESNOPopup result = DefaultScreens.getSessionAccess().getYesNoPopup();
        result.m_yesButtonImage = StyleManager.getStyleValue("ccYesNoPopupYes");
        result.m_noButtonImage = StyleManager.getStyleValue("ccYesNoPopupNo");
        result.m_cancelButtonImage = StyleManager.getStyleValue("ccYesNoPopupCancel");
        if (result.m_modalPopup != null) {
            CLog.L.log(CLog.LL_ERR, "YESNO Popup can only be opened one time!");
            CLog.L.log(CLog.LL_ERR, "Runtime exception is thrown as consequence");
            CLog.L.log(CLog.LL_ERR, "Please use method checkIfAlreadyOpened() for checking of the YESNOPopup is already opened.");
            CLog.L.log(CLog.LL_ERR, "THIS IS THE STACK TRACE OF THE PREVIOUS VALL ----------- begin");
            CLog.L.log(CLog.LL_ERR, "", result.m_stackLastCall);
            CLog.L.log(CLog.LL_ERR, "THIS IS THE STACK TRACE OF THE PREVIOUS VALL ----------- end");
            throw new RuntimeException("YESNOPopup already opened, you can only use it one time.");
        }
        result.setText(text);
        result.setTextContentType("text/plain");
        result.m_showCancel = false;
        result.m_textYes = null;
        result.m_textNo = null;
        result.m_textCancel = null;
        result.m_modalPopup = ModalPopup.createInstance();
        result.m_headline = null;
        result.m_stackLastCall = new Exception("PREVIOUS USAGE of YESNO Popup:");
        result.m_imageBackgroundColor = StyleManager.getStyleValue("ccYesNoPopupImageBackground");
        result.m_backgroundColor = StyleManager.getStyleValue("ccYesNoPopupBackground");
        String pageName = PAGENAME_DEFAULT;
        if ("browser".equals(HttpSessionAccess.getCurrentClientType())) {
            pageName = PAGENAME_HTML;
        }
        result.m_modalPopup.open(pageName, title, 400, 200, result);
        result.m_modalPopup.setStartfromrootwindow(false);
        result.m_modalPopup.showAsTopPopup();
        result.m_modalPopup.setStyleseq("riscdialog_popup_decorated");
        result.m_yesNoListener = yesNoListener;
        return result;
    }

    public static boolean checkIfAlreadyOpened() {
        YESNOPopup result = DefaultScreens.getSessionAccess().getYesNoPopup();
        return result.m_modalPopup != null;
    }

    public static Throwable getLastCallStackTrace() {
        YESNOPopup result = DefaultScreens.getSessionAccess().getYesNoPopup();
        return result.m_stackLastCall;
    }

    public void setInitialFocusToYes() {
        this.m_requestFocusYes = "creation";
        this.m_requestFocusNo = null;
        this.m_requestFocusCancel = null;
    }

    public void setInitialFocusToNo() {
        this.m_requestFocusYes = null;
        this.m_requestFocusNo = "creation";
        this.m_requestFocusCancel = null;
    }

    public void setInitialFocusToCancel() {
        this.m_requestFocusYes = null;
        this.m_requestFocusNo = null;
        this.m_requestFocusCancel = "creation";
    }

    public String getRequestFocusYes() {
        return this.m_requestFocusYes;
    }

    public String getRequestFocusNo() {
        return this.m_requestFocusNo;
    }

    public String getRequestFocusCancel() {
        return this.m_requestFocusCancel;
    }

    public String getYesButtonImage() {
        return this.m_yesButtonImage;
    }

    public void setYesButtonImage(String yesButtonImage) {
        this.m_yesButtonImage = yesButtonImage;
    }

    public String getNoButtonImage() {
        return this.m_noButtonImage;
    }

    public void setNoButtonImage(String noButtonImage) {
        this.m_noButtonImage = noButtonImage;
    }

    public String getCancelButtonImage() {
        return this.m_cancelButtonImage;
    }

    public void setCancelButtonImage(String cancelButtonImage) {
        this.m_cancelButtonImage = cancelButtonImage;
    }

    public String getBackgroundColor() {
        return this.m_backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.m_backgroundColor = backgroundColor;
    }

    public String getImageBackgroundColor() {
        return this.m_imageBackgroundColor;
    }

    public void setImageBackgroundColor(String imageBackgroundColor) {
        this.m_imageBackgroundColor = imageBackgroundColor;
    }

    public void setText(String value) {
        this.m_text = value;
    }

    public String getText() {
        return this.m_text;
    }

    public void setIcon(String value) {
        this.m_icon = value;
    }

    public String getIcon() {
        return this.m_icon;
    }

    public boolean getHeadlineRendered() {
        return this.m_headline != null && this.m_headline.length() != 0;
    }

    public void setHeadline(String value) {
        this.m_headline = value;
    }

    public String getHeadline() {
        return this.m_headline;
    }

    public void setTextAlign(String value) {
        this.m_textAlign = value;
    }

    public String getTextAlign() {
        return this.m_textAlign;
    }

    public String getTextContentType() {
        return this.m_textContentType;
    }

    public void setTextContentType(String textContentType) {
        this.m_textContentType = textContentType;
    }

    public void setTextYes(String value) {
        this.m_textYes = value;
    }

    public String getTextYes() {
        if (this.m_textYes == null) {
            return new I18N().get("YESNOPopup_yes");
        }
        return this.m_textYes;
    }

    public void setTextNo(String value) {
        this.m_textNo = value;
    }

    public String getTextNo() {
        if (this.m_textNo == null) {
            return new I18N().get("YESNOPopup_no");
        }
        return this.m_textNo;
    }

    public void setTextCancel(String value) {
        this.m_textCancel = value;
    }

    public String getTextCancel() {
        if (this.m_textCancel == null) {
            return new I18N().get("YESNOPopup_cancel");
        }
        return this.m_textCancel;
    }

    public ModalPopup getModalPopup() {
        return this.m_modalPopup;
    }

    public boolean isIconRendered() {
        return this.m_icon != null;
    }

    public void setShowCancel(boolean value) {
        this.m_showCancel = value;
    }

    public boolean getShowCancel() {
        return this.m_showCancel;
    }

    public void onYes(ActionEvent ae) {
        IYesNoListener ynl = this.m_yesNoListener;
        if (this.m_modalPopup != null) {
            this.m_modalPopup.close();
            this.m_modalPopup = null;
            this.m_yesNoListener = null;
            this.m_stackLastCall = null;
            this.m_icon = null;
        }
        try {
            if (ynl != null) {
                ynl.reactOnYes();
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem when calling yes-processing", t);
            Statusbar.outputAlert(t.toString(), "Problem", ValueManager.getStackstraceString(t));
        }
    }

    public void onNo(ActionEvent ae) {
        IYesNoListener ynl = this.m_yesNoListener;
        if (this.m_modalPopup != null) {
            this.m_modalPopup.close();
            this.m_modalPopup = null;
            this.m_yesNoListener = null;
            this.m_stackLastCall = null;
            this.m_icon = null;
        }
        try {
            if (ynl != null) {
                ynl.reactOnNo();
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem when calling no-processing", t);
            Statusbar.outputAlert(t.toString(), "Problem", ValueManager.getStackstraceString(t));
        }
    }

    public void onCancel(ActionEvent ae) {
        IYesNoListener ynl = this.m_yesNoListener;
        if (this.m_modalPopup != null) {
            this.m_modalPopup.close();
            this.m_modalPopup = null;
            this.m_showCancel = false;
            this.m_yesNoListener = null;
            this.m_stackLastCall = null;
            this.m_icon = null;
        }
        if (ynl != null && ynl instanceof IYesNoCancelListener) {
            try {
                ((IYesNoCancelListener)ynl).reactOnCancel();
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Problem when calling cancel-processing", t);
                Statusbar.outputAlert(t.toString(), "Problem", ValueManager.getStackstraceString(t));
            }
        }
    }

    @Override
    public void reactOnPopupClosedByUser() {
        IYesNoListener ynl = this.m_yesNoListener;
        if (this.m_modalPopup != null) {
            this.m_modalPopup.close();
        }
        this.m_modalPopup = null;
        this.m_yesNoListener = null;
        this.m_stackLastCall = null;
        this.m_icon = null;
        if (ynl != null && ynl instanceof IYesNoCancelListener) {
            ((IYesNoCancelListener)ynl).reactOnCancel();
        }
    }

    public void setWidth(int value) {
        if (this.m_modalPopup == null) {
            return;
        }
        this.m_modalPopup.setWidth(value);
    }

    public void setHeight(int value) {
        if (this.m_modalPopup == null) {
            return;
        }
        this.m_modalPopup.setHeight(value);
    }

    public static class YesNoCancelListenerLambda
    extends YesNoListenerLambda
    implements IYesNoCancelListener {
        public Runnable i_cancelRunnable;

        public YesNoCancelListenerLambda(Runnable yesRunnable, Runnable noRunnable, Runnable cancelRunnable) {
            super(yesRunnable, noRunnable);
            this.i_cancelRunnable = cancelRunnable;
        }

        @Override
        public void reactOnCancel() {
            if (this.i_cancelRunnable != null) {
                this.i_cancelRunnable.run();
            }
        }
    }

    public static class YesNoListenerLambda
    implements IYesNoListener {
        public Runnable i_yesRunnable;
        public Runnable i_noRunnable;

        public YesNoListenerLambda(Runnable yesRunnable, Runnable noRunnable) {
            this.i_yesRunnable = yesRunnable;
            this.i_noRunnable = noRunnable;
        }

        @Override
        public void reactOnYes() {
            if (this.i_yesRunnable != null) {
                this.i_yesRunnable.run();
            }
        }

        @Override
        public void reactOnNo() {
            if (this.i_noRunnable != null) {
                this.i_noRunnable.run();
            }
        }
    }

    public static interface IYesNoCancelListener
    extends IYesNoListener {
        public void reactOnCancel();
    }

    public static interface IYesNoListener {
        public void reactOnYes();

        public void reactOnNo();
    }
}

