/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.eclnt.jsfserver.elements.BaseActionComponent;
import org.eclnt.jsfserver.elements.BaseHTMLComponent;
import org.eclnt.jsfserver.elements.ComponentDump;
import org.eclnt.jsfserver.session.RequestFocusManager;
import org.eclnt.jsfserver.session.SessionInfo;
import org.eclnt.util.log.CLog;
import org.eclnt.util.log.CLogConstants;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.util.valuemgmt.XMLWriter;

public abstract class BaseHTMLActionComponent
extends BaseActionComponent
implements ActionSource,
CLogConstants {
    public static int ACTIONTYPE_NOTNULL = 0;
    public static int ACTIONTYPE_NOTEMPTY = 1;
    public static int ACTIONTYPE_NEVER = 2;
    protected boolean m_immediate;
    protected IDelegateAction m_actionDelegator = null;
    boolean m_creationFocusApplied = false;

    @Override
    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.m_creationFocusApplied};
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.m_creationFocusApplied = (Boolean)values[1];
    }

    public IDelegateAction getActionDelegator() {
        return this.m_actionDelegator;
    }

    public void setActionDelegator(IDelegateAction actionDelegator) {
        this.m_actionDelegator = actionDelegator;
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
    }

    @Override
    public void decode(FacesContext context) {
        String command;
        super.decode(context);
        String clientId = this.getClientId(context);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestParameterMap.get(clientId);
        if (this.getActionType() != ACTIONTYPE_NEVER && (value != null && this.getActionType() == ACTIONTYPE_NOTNULL || value != null && value.length() > 0 && this.getActionType() == ACTIONTYPE_NOTEMPTY)) {
            if (this.m_actionDelegator == null) {
                command = "invoke";
                this.triggerActionEvent(context, command, command + "()", false);
            } else {
                this.m_actionDelegator.delegateTriggerActionEvent(context);
            }
        }
        if ((value = (String)requestParameterMap.get(clientId + ".FLUSH")) != null && value.length() > 0 && this.m_actionDelegator == null) {
            command = "flush";
            this.triggerActionEvent(context, command, command + "()", false);
        }
    }

    public String writeTdAroundControl(ResponseWriter writer, ComponentDump cd, boolean withStyle) throws IOException {
        String width = this.getAttributeValueAsString("width");
        String height = this.getAttributeValueAsString("height");
        String valign = this.getAttributeValueAsString("valign");
        if (valign == null) {
            valign = "center";
        }
        XMLWriter.writer_startElement((Writer)writer, cd, "td");
        String tdStyleClass = this.getCurrentTdStyleClass();
        if (tdStyleClass != null) {
            XMLWriter.writer_writeAttribute((Writer)writer, cd, "class", tdStyleClass);
        }
        StringBuffer tdstyle = new StringBuffer();
        if (withStyle) {
            BaseHTMLActionComponent.appendToStyle(tdstyle, this.getAttributeValueAsString("style"));
        }
        if (width != null && width.endsWith("%")) {
            BaseHTMLActionComponent.appendToStyle(tdstyle, "width:" + width);
            width = "100%";
        }
        if (height != null && height.endsWith("%")) {
            BaseHTMLActionComponent.appendToStyle(tdstyle, "height:" + height);
            height = "100%";
        }
        if (tdstyle.length() > 0) {
            XMLWriter.writer_writeAttribute((Writer)writer, cd, "style", tdstyle.toString());
        }
        XMLWriter.writer_writeAttribute((Writer)writer, cd, "valign", valign);
        XMLWriter.writer_writeAttribute((Writer)writer, cd, "align", this.getAttributeValueAsString("left"));
        XMLWriter.writer_closeStartElement((Writer)writer, cd);
        return width;
    }

    public boolean getCurrentEnabled() {
        String enabled = this.getAttributeValueAsString("enabled");
        String ccenabled = this.getAttributeValueAsString("ccenabled");
        if (ccenabled == null) {
            return ValueManager.decodeBoolean(enabled, true);
        }
        if ("false".equals(ccenabled)) {
            return false;
        }
        return ValueManager.decodeBoolean(enabled, true);
    }

    public String getCurrentStyleClass(String defaultStyle) {
        String ccselected;
        String style = this.getAttributeValueAsString("styleClass");
        if (style == null) {
            style = defaultStyle;
        }
        if ("true".equals(ccselected = this.getAttributeValueAsString("ccselected"))) {
            return style + "_selected";
        }
        if (!this.getCurrentEnabled()) {
            return style + "_disabled";
        }
        return style;
    }

    public String getCurrentTdStyleClass() {
        String ccselected = this.getAttributeValueAsString("ccselected");
        if ("true".equals(ccselected)) {
            return "classtd_selected";
        }
        return null;
    }

    protected UIForm getParentForm() {
        UIComponent parent = this.getParent();
        while (!(parent instanceof UIForm)) {
            parent = parent.getParent();
        }
        return (UIForm)parent;
    }

    protected int getActionType() {
        return ACTIONTYPE_NOTNULL;
    }

    protected void addCallServerHiddenField(FacesContext context, ResponseWriter writer, String postfix) {
        try {
            if (postfix == null) {
                postfix = "";
            }
            String clientId = this.getClientId(context);
            XMLWriter.writer_startElement((Writer)writer, null, "input");
            XMLWriter.writer_writeAttribute((Writer)writer, null, "type", "hidden");
            XMLWriter.writer_writeAttribute((Writer)writer, null, "name", clientId + postfix);
            XMLWriter.writer_closeStartAndEndElement((Writer)writer, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void addInvokeProcessingHiddenField(FacesContext context, ResponseWriter writer, String postfix) {
        try {
            String invokeevent;
            if (postfix == null) {
                postfix = "";
            }
            if ((invokeevent = this.getAttributeValueAsString("invokeevent")) == null) {
                return;
            }
            String clientId = this.getClientId(context);
            XMLWriter.writer_startElement((Writer)writer, null, "input");
            XMLWriter.writer_writeAttribute((Writer)writer, null, "type", "hidden");
            XMLWriter.writer_writeAttribute((Writer)writer, null, "name", clientId + postfix);
            XMLWriter.writer_closeStartAndEndElement((Writer)writer, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void addCallServerJavaScript(FacesContext context, ResponseWriter writer, String event, String postfix) {
        try {
            if (postfix == null) {
                postfix = "";
            }
            UIForm parentForm = this.getParentForm();
            String parentFormClientId = parentForm.getClientId(context);
            String clientId = this.getClientId(context);
            StringBuffer jscriptSB = new StringBuffer();
            jscriptSB.append("if (m_pageIsBuilt != true) return;");
            jscriptSB.append("document.forms['");
            jscriptSB.append(parentFormClientId);
            jscriptSB.append("']['");
            jscriptSB.append(clientId + postfix);
            jscriptSB.append("'].value='");
            jscriptSB.append(clientId);
            jscriptSB.append("';document.forms['");
            jscriptSB.append(parentFormClientId);
            jscriptSB.append("'].submit();");
            jscriptSB.append("ccOnSubmit();");
            jscriptSB.append("return false;");
            if (this.getCurrentEnabled()) {
                XMLWriter.writer_writeAttributeWithFormattedValue((Writer)writer, null, event, jscriptSB.toString());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void addInvokeProcessingEvent(FacesContext context, ResponseWriter writer) {
        try {
            String invokeevent = this.getAttributeValueAsString("invokeevent");
            if (invokeevent == null) {
                return;
            }
            UIForm parentForm = this.getParentForm();
            String parentFormClientId = parentForm.getClientId(context);
            String clientId = this.getClientId(context);
            StringBuffer jscriptSB = new StringBuffer();
            jscriptSB.append("document.forms['");
            jscriptSB.append(parentFormClientId);
            jscriptSB.append("']['");
            jscriptSB.append(clientId);
            jscriptSB.append("'].value='");
            jscriptSB.append(clientId);
            jscriptSB.append("';document.forms['");
            jscriptSB.append(parentFormClientId);
            jscriptSB.append("'].submit();");
            jscriptSB.append("ccOnSubmit();");
            jscriptSB.append("return false;");
            if (this.getCurrentEnabled()) {
                XMLWriter.writer_writeAttributeWithFormattedValue((Writer)writer, null, "onclick", jscriptSB.toString());
            }
            if (this.getCurrentEnabled()) {
                XMLWriter.writer_writeAttributeWithFormattedValue((Writer)writer, null, "ondblclick", "");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected static void appendToStyle(StringBuffer style, String styleFragment) {
        BaseHTMLComponent.appendToStyle(style, styleFragment);
    }

    protected void manageFocus(FacesContext context, String id) {
        this.manageFocus(context, id, "document.getElementById('", "').focus();");
    }

    protected void manageFocus(FacesContext context, String id, String preStatement, String postStatement) {
        try {
            ResponseWriter writer = context.getResponseWriter();
            String requestfocus = this.getAttributeValueAsString("requestfocus");
            if (requestfocus != null) {
                if (id == null) {
                    id = this.getClientId(context);
                }
                long rfCounter = 0L;
                rfCounter = "creation".equals(requestfocus) ? RequestFocusManager.getCreationRequestFocusCounter() : ValueManager.decodeLong(requestfocus, 0L);
                if (rfCounter == 0L) {
                    return;
                }
                if (!this.m_creationFocusApplied && rfCounter == RequestFocusManager.getCreationRequestFocusCounter()) {
                    this.m_creationFocusApplied = true;
                    XMLWriter.writer_writeFormattedText((Writer)writer, null, "\n<script>" + preStatement + id + postStatement + "</script>\n");
                    return;
                }
                SessionInfo sessionInfo = SessionInfo.getSessionInstance();
                if (sessionInfo.getHtHighestFocusCounter() < rfCounter) {
                    sessionInfo.setHtHighestFocusCounter(rfCounter);
                    XMLWriter.writer_writeFormattedText((Writer)writer, null, "\n<script>" + preStatement + id + postStatement + "</script>\n");
                }
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem when setting focus", t);
        }
    }

    protected boolean checkIfFocusIsRequested() {
        try {
            String requestfocus = this.getAttributeValueAsString("requestfocus");
            if (requestfocus != null) {
                long rfCounter = 0L;
                rfCounter = "creation".equals(requestfocus) ? RequestFocusManager.getCreationRequestFocusCounter() : ValueManager.decodeLong(requestfocus, 0L);
                if (rfCounter == 0L) {
                    return false;
                }
                if (!this.m_creationFocusApplied && rfCounter == RequestFocusManager.getCreationRequestFocusCounter()) {
                    return true;
                }
                SessionInfo sessionInfo = SessionInfo.getSessionInstance();
                if (sessionInfo.getHtHighestFocusCounter() < rfCounter) {
                    sessionInfo.setHtHighestFocusCounter(rfCounter);
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static interface IDelegateAction {
        public void delegateTriggerActionEvent(FacesContext var1);
    }
}

