/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.el.Expression;
import javax.faces.event.FacesEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclnt.jsfserver.elements.impl.ROWINCLUDEDump;
import org.eclnt.jsfserver.util.ClientToBeReloadedException;
import org.eclnt.jsfserver.util.ProfileLogInfo;
import org.eclnt.util.log.PLog;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.util.valuemgmt.ValueManager;

public class ThreadData
implements Serializable {
    public static boolean s_loggging_constructor_severe = false;
    private static Map<Thread, ThreadData> s_instances = new Hashtable<Thread, ThreadData>();
    String m_uuid = UniqueIdCreator.createUUID();
    private String m_subpageId;
    private HttpSession m_httpSession;
    private HttpServletRequest m_httpRequest;
    private HttpServletResponse m_httpResponse;
    private boolean m_isUIThread = false;
    boolean m_updateAll = false;
    Set<Object> m_isolatedUpdateZones = new HashSet<Object>();
    Set<Object> m_isolatedUpdateZonesEntrance = new HashSet<Object>();
    boolean m_noIsolationRegistered = false;
    private StringBuffer m_clientTestLogMessage = new StringBuffer();
    private boolean m_clientIsInTestMode = false;
    private long m_stampStartOfClientProcessing = -1L;
    private long m_stampStartOfWritingResponse = -1L;
    private long m_stampStartOfProcessing = -1L;
    private long m_stampEndOfProcessing = -1L;
    private long m_stampBeginOfInvoke = -1L;
    private long m_stampEndOfInvoke = -1L;
    private long m_consumedNanosGet = 0L;
    private String m_stampMethodExpression = null;
    private long m_callCountGet = 0L;
    private ClientToBeReloadedException m_clientToBeReloadedException = null;
    private boolean m_requestFocusMgmtBlocked = false;
    private boolean m_profileMode = false;
    List<ProfileLogInfo> m_profileLogInfos = new ArrayList<ProfileLogInfo>();
    private String m_currentInvokeExpression;
    private List<Object> m_requestEvents = new ArrayList<Object>();
    ROWINCLUDEDump m_rowincludeDump = new ROWINCLUDEDump();
    Set<String> m_componentIdsToBeDecoded = new HashSet<String>();
    Stack<Expression> m_currentlyProcessedExpression = new Stack();
    String m_newClientId = null;
    boolean m_currentRequestRebuildsContent = false;

    ThreadData() {
        if (s_loggging_constructor_severe) {
            String stackTrace = ValueManager.getStackstraceString(new Exception("NO BUG! FOR DEBUGGING ONLY!"));
            System.out.println("ThreadData created:\n" + stackTrace);
        }
    }

    public static ThreadData getInstance() {
        return ThreadData.getInstance(true);
    }

    public static ThreadData getInstance(boolean createNewOneIfMissing) {
        Thread thread = Thread.currentThread();
        return ThreadData.getInstance(thread, createNewOneIfMissing);
    }

    public static ThreadData getInstance(Thread thread, boolean createNewOneIfMissing) {
        ThreadData result = s_instances.get(thread);
        if (result == null && createNewOneIfMissing) {
            result = new ThreadData();
            s_instances.put(thread, result);
        }
        return result;
    }

    public static ExtThreadInjectionInfo extractExtThreadInjectionInfo() {
        ThreadData current = ThreadData.getInstance(false);
        if (current == null) {
            throw new Error("The current thread is not a UI thread");
        }
        ExtThreadInjectionInfo result = new ExtThreadInjectionInfo(current.m_httpSession, current.m_subpageId);
        return result;
    }

    public static void injectExtThread(Thread nonUIThread, ExtThreadInjectionInfo info) {
        ThreadData td = ThreadData.getInstance(nonUIThread, true);
        td.m_httpSession = info.i_httpSession;
        td.m_subpageId = info.i_subpageId;
    }

    public static void injectExtThread(Thread nonUIThread) {
        ThreadData current = ThreadData.getInstance(false);
        if (current == null) {
            throw new Error("The current thread is not a UI thread");
        }
        ThreadData td = ThreadData.getInstance(nonUIThread, true);
        td.m_httpSession = current.m_httpSession;
        td.m_subpageId = current.m_subpageId;
    }

    public static void clearThreadDataFromNonUIThread(Thread nonUIThread) {
        ThreadData td = ThreadData.getInstance(nonUIThread, false);
        if (td != null) {
            td.destroy();
        }
    }

    public void registerChangeUpdatingAllAreas() {
        this.m_updateAll = true;
    }

    public void unregisterChangeUpdatingAllAreas() {
        this.m_updateAll = false;
    }

    public boolean getUpdateAllAreasIsRequired() {
        return this.m_updateAll;
    }

    public void registerIsolatedUpdateZone(Object zone, boolean asEntranceZone) {
        if (this.m_noIsolationRegistered) {
            return;
        }
        this.m_isolatedUpdateZones.add(zone);
        if (asEntranceZone) {
            this.m_isolatedUpdateZonesEntrance.add(zone);
        }
    }

    public boolean checkIfContainedAsIsolatedUpdateZone(Object zone) {
        return this.m_isolatedUpdateZones.contains(zone);
    }

    public boolean checkIfContainedAsIsolatedUpdateZoneEntrance(Object zone) {
        return this.m_isolatedUpdateZonesEntrance.contains(zone);
    }

    public void initHttpRequest(HttpServletRequest httpRequest) {
        this.m_httpRequest = httpRequest;
    }

    public void initHttpResponse(HttpServletResponse httpResponse) {
        this.m_httpResponse = httpResponse;
    }

    public void initSubpageId(String subpageId) {
        this.m_subpageId = subpageId;
    }

    public void initHttpSession(HttpSession session) {
        this.m_httpSession = session;
    }

    public void initIsUIThread(boolean value) {
        this.m_isUIThread = value;
    }

    public HttpServletRequest getHttpRequest() {
        return this.m_httpRequest;
    }

    public HttpServletResponse getHttpResponse() {
        return this.m_httpResponse;
    }

    public HttpSession getHttpSession() {
        if (this.m_httpSession != null) {
            return this.m_httpSession;
        }
        if (this.m_httpRequest != null) {
            return this.m_httpRequest.getSession(false);
        }
        return null;
    }

    public String getSubpageId() {
        return this.m_subpageId;
    }

    public void registerNoIsolation() {
        this.m_isolatedUpdateZones.clear();
        this.m_isolatedUpdateZonesEntrance.clear();
        this.m_noIsolationRegistered = true;
    }

    public Set<Object> getIsolatedUpdateZones() {
        return this.m_isolatedUpdateZones;
    }

    public Set<Object> getIsolatedUpdateZonesEntrance() {
        return this.m_isolatedUpdateZonesEntrance;
    }

    public void clean() {
        this.m_subpageId = null;
        this.m_httpSession = null;
        this.m_httpRequest = null;
        this.m_httpResponse = null;
        this.m_updateAll = false;
        this.m_noIsolationRegistered = false;
        this.m_isolatedUpdateZones.clear();
        this.m_isolatedUpdateZonesEntrance.clear();
        this.m_clientTestLogMessage = new StringBuffer();
        this.m_consumedNanosGet = 0L;
        this.m_callCountGet = 0L;
        this.m_clientToBeReloadedException = null;
        this.m_requestFocusMgmtBlocked = false;
        this.m_profileLogInfos.clear();
        this.m_profileMode = false;
        this.m_requestEvents.clear();
        this.m_stampStartOfProcessing = -1L;
        this.m_stampEndOfProcessing = -1L;
        this.m_stampStartOfClientProcessing = -1L;
        this.m_stampStartOfWritingResponse = -1L;
        this.m_stampBeginOfInvoke = -1L;
        this.m_stampEndOfInvoke = -1L;
        this.m_stampMethodExpression = null;
        this.m_rowincludeDump = new ROWINCLUDEDump();
        this.m_componentIdsToBeDecoded.clear();
        this.m_newClientId = null;
    }

    public void addClientTestLogMessage(String message) {
        if (!this.m_clientIsInTestMode) {
            return;
        }
        if (message == null) {
            return;
        }
        this.m_clientTestLogMessage.append(message + "\n");
    }

    public String getClientTestLogMessage() {
        if (this.m_clientIsInTestMode) {
            return this.m_clientTestLogMessage.toString();
        }
        return null;
    }

    public boolean getClientIsInTestMode() {
        return this.m_clientIsInTestMode;
    }

    public void setClientIsInTestMode(boolean clientIsInTestMode) {
        this.m_clientIsInTestMode = clientIsInTestMode;
    }

    public void addConsumedNanosGet(String comment, long nanos) {
        if (comment != null) {
            this.m_profileLogInfos.add(new ProfileLogInfo(ProfileLogInfo.TYPE_GET, nanos, comment));
        }
        this.m_consumedNanosGet += nanos;
        ++this.m_callCountGet;
    }

    public void addConsumedNanosInvoke(String comment, long nanos) {
        if (comment != null) {
            this.m_profileLogInfos.add(new ProfileLogInfo(ProfileLogInfo.TYPE_INVOK, nanos, comment));
        }
        this.m_consumedNanosGet += nanos;
        ++this.m_callCountGet;
    }

    public void addConsumedNanosPhase(String comment, long nanos) {
        if (comment != null) {
            this.m_profileLogInfos.add(new ProfileLogInfo(ProfileLogInfo.TYPE_PHASE, nanos, comment));
        }
        this.m_consumedNanosGet += nanos;
        ++this.m_callCountGet;
    }

    public void addConsumedNanosComment(String comment, long nanos) {
        if (comment != null) {
            this.m_profileLogInfos.add(new ProfileLogInfo(ProfileLogInfo.TYPE_COMMENT, nanos, comment));
        }
        this.m_consumedNanosGet += nanos;
        ++this.m_callCountGet;
    }

    public long getConsumedNanosGet() {
        return this.m_consumedNanosGet;
    }

    public long getCallCountGet() {
        return this.m_callCountGet;
    }

    public ClientToBeReloadedException getClientToBeReloadedExceptionOccurred() {
        return this.m_clientToBeReloadedException;
    }

    public void setClientToBeReloadedExceptionOccurred(ClientToBeReloadedException exc) {
        this.m_clientToBeReloadedException = exc;
    }

    public boolean isRequestFocusMgmtBlocked() {
        return this.m_requestFocusMgmtBlocked;
    }

    public void setRequestFocusMgmtBlocked(boolean requestFocusMgmtBlocked) {
        this.m_requestFocusMgmtBlocked = requestFocusMgmtBlocked;
    }

    public boolean getProfileMode() {
        return this.m_profileMode;
    }

    public void setProfileMode(boolean profileMode) {
        this.m_profileMode = profileMode;
    }

    public List<ProfileLogInfo> getProfileLogInfos() {
        return this.m_profileLogInfos;
    }

    public String getCurrentInvokeExpression() {
        return this.m_currentInvokeExpression;
    }

    public void setCurrentInvokeExpression(String currentInvokeExpression) {
        this.m_currentInvokeExpression = currentInvokeExpression;
        if (currentInvokeExpression != null) {
            if (this.m_stampBeginOfInvoke < 0L) {
                this.m_stampBeginOfInvoke = System.currentTimeMillis();
            }
            this.m_stampMethodExpression = this.m_stampMethodExpression == null ? currentInvokeExpression : this.m_stampMethodExpression + ", " + currentInvokeExpression;
        } else {
            this.m_stampEndOfInvoke = System.currentTimeMillis();
        }
    }

    public List<FacesEvent> getRequestEvents() {
        ArrayList<FacesEvent> result = new ArrayList<FacesEvent>();
        for (Object o : this.m_requestEvents) {
            if (!(o instanceof FacesEvent)) continue;
            result.add((FacesEvent)o);
        }
        return result;
    }

    public void addRequestEvent(Object event) {
        this.m_requestEvents.add(event);
    }

    public List<Object> getRequestEventObjects() {
        return this.m_requestEvents;
    }

    public long getStampStartOfProcessing() {
        return this.m_stampStartOfProcessing;
    }

    public void setStampStartOfProcessing(long stampStartOfProcessing) {
        this.m_stampStartOfProcessing = stampStartOfProcessing;
        PLog.clearCurrentRequestApplicationInfo();
    }

    public long getStampStartOfClientProcessing() {
        return this.m_stampStartOfClientProcessing;
    }

    public void setStampStartOfClientProcessing(long stampStartOfClientProcessing) {
        this.m_stampStartOfClientProcessing = stampStartOfClientProcessing;
    }

    public long getStampStartOfWritingResponse() {
        return this.m_stampStartOfWritingResponse;
    }

    public void setStampStartOfWritingResponse(long value) {
        this.m_stampStartOfWritingResponse = value;
    }

    public long getStampEndOfProcessing() {
        return this.m_stampEndOfProcessing;
    }

    public void setStampEndOfProcessing(long stampEndOfProcessing, String requestId) {
        this.m_stampEndOfProcessing = stampEndOfProcessing;
        long total = this.m_stampEndOfProcessing - this.m_stampStartOfProcessing;
        long invoke = 0L;
        if (this.m_stampBeginOfInvoke > 0L && this.m_stampEndOfInvoke > 0L) {
            invoke = this.m_stampEndOfInvoke - this.m_stampBeginOfInvoke;
        }
        String sessionId = "<unknown>";
        if (this.m_httpSession != null) {
            sessionId = this.m_httpSession.getId();
        }
        PLog.logRequestInfo(sessionId, total, invoke, this.m_stampMethodExpression, this.m_consumedNanosGet, this.m_stampStartOfClientProcessing, this.m_stampStartOfProcessing, requestId, this.m_stampStartOfWritingResponse, PLog.getCurrentRequestApplicationInfo(), PLog.getCurrentRequestAccumulatedNumbersInfo());
    }

    public ROWINCLUDEDump getRowincludeDump() {
        return this.m_rowincludeDump;
    }

    public void destroy() {
        this.clean();
        s_instances.remove(Thread.currentThread());
    }

    public Set<String> getComponentIdsToBeDecoded() {
        return this.m_componentIdsToBeDecoded;
    }

    public void setComponentIdsToBeDecoded(Set<String> componentIdsToBeEncoded) {
        this.m_componentIdsToBeDecoded = componentIdsToBeEncoded;
    }

    public String getCurrentlyProcessedExpression() {
        if (this.m_currentlyProcessedExpression.size() > 0) {
            return this.m_currentlyProcessedExpression.peek().getExpressionString();
        }
        return null;
    }

    public void registerCurrentlyProcessedExpression(Expression currentlyProcessedExpression) {
        this.m_currentlyProcessedExpression.push(currentlyProcessedExpression);
    }

    public void unregisterCurrentlyProcessedExpression() {
        if (this.m_currentlyProcessedExpression.size() > 0) {
            this.m_currentlyProcessedExpression.pop();
        }
    }

    public String getNewClientId() {
        return this.m_newClientId;
    }

    public void setNewClientId(String newClientId) {
        this.m_newClientId = newClientId;
    }

    public boolean getCurrentRequestRebuildsContent() {
        return this.m_currentRequestRebuildsContent;
    }

    public void setCurrentRequestRebuildsContent(boolean currentRequestRebuildsContent) {
        this.m_currentRequestRebuildsContent = currentRequestRebuildsContent;
    }

    public boolean checkIfUIThread() {
        return this.m_isUIThread;
    }

    public static class ExtThreadInjectionInfo {
        HttpSession i_httpSession;
        String i_subpageId;

        private ExtThreadInjectionInfo(HttpSession session, String subpageId) {
            this.i_httpSession = session;
            this.i_subpageId = subpageId;
        }
    }
}

