/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.event.ActionEvent;
import org.eclnt.jsfserver.elements.BaseActionEvent;
import org.eclnt.jsfserver.elements.events.BaseActionEventToggle;
import org.eclnt.jsfserver.elements.impl.FIXGRIDComponent;
import org.eclnt.jsfserver.elements.impl.FIXGRIDItem;
import org.eclnt.jsfserver.elements.impl.FIXGRIDTreeBinding;
import org.eclnt.jsfserver.elements.phases.PhaseManager;
import org.eclnt.jsfserver.session.RequestFocusManager;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.util.log.CLog;

public class FIXGRIDTreeItem
extends FIXGRIDItem
implements Serializable,
Comparable {
    public static final int STATUS_OPENED = 0;
    public static final int STATUS_CLOSED = 1;
    public static final int STATUS_ENDNODE = 2;
    int m_level = 0;
    String m_text = "default";
    String m_image = null;
    int m_status;
    long m_requestfocus = 0L;
    FIXGRIDTreeItem m_parentNode;
    List<FIXGRIDTreeItem> m_childNodes = new ArrayList<FIXGRIDTreeItem>();

    public FIXGRIDTreeItem(FIXGRIDTreeItem parentNode) {
        this(parentNode, false);
    }

    public FIXGRIDTreeItem(FIXGRIDTreeItem parentNode, boolean asFirst) {
        this.m_parentNode = parentNode;
        if (this.m_parentNode != null) {
            if (asFirst) {
                this.m_parentNode.m_childNodes.add(0, this);
            } else {
                this.m_parentNode.m_childNodes.add(this);
            }
            this.m_level = this.m_parentNode.m_level + 1;
        }
    }

    public void setLevel(int value) {
        this.m_level = value;
        this.getChangeIndex().indicateChange();
    }

    public int getLevelInt() {
        return this.m_level;
    }

    public String getLevel() {
        return "" + this.m_level;
    }

    public void setText(String value) {
        this.m_text = value;
        this.getChangeIndex().indicateChange();
    }

    public String getText() {
        return this.m_text;
    }

    public String getTextForExport() {
        String perLevel = "\u00a0\u00a0\u00a0\u00a0";
        String result = "";
        for (int i = 0; i < this.m_level; ++i) {
            result = result + perLevel;
        }
        if (this.m_status == 1) {
            result = result + " + ";
        } else if (this.m_status == 0) {
            result = result + " - ";
        }
        result = result + this.getText();
        return result;
    }

    public void setImage(String value) {
        this.m_image = value;
        this.getChangeIndex().indicateChange();
    }

    public String getImage() {
        return this.m_image;
    }

    public void setStatus(int value) {
        this.m_status = value;
        this.getChangeIndex().indicateChange();
    }

    public int getStatusInt() {
        return this.m_status;
    }

    public String getStatus() {
        return "" + this.m_status;
    }

    public String getRequestfocus() {
        return this.m_requestfocus + "";
    }

    @Override
    public void requestFocus() {
        this.m_requestfocus = RequestFocusManager.getNewRequestFocusCounter();
    }

    public FIXGRIDTreeItem getParentNode() {
        return this.m_parentNode;
    }

    public List<FIXGRIDTreeItem> getChildNodes() {
        return this.m_childNodes;
    }

    public Set<FIXGRIDTreeItem> getAllContainedNodes() {
        HashSet<FIXGRIDTreeItem> result = new HashSet<FIXGRIDTreeItem>();
        this.addContainedNodes(result);
        return result;
    }

    private void addContainedNodes(Set<FIXGRIDTreeItem> result) {
        result.add(this);
        for (FIXGRIDTreeItem child : this.m_childNodes) {
            child.addContainedNodes(result);
        }
    }

    public void appendVisibleSubNodes(List<FIXGRIDTreeItem> list, int counter, int maxCounter) {
        if (maxCounter >= 0 && counter > maxCounter) {
            return;
        }
        if (this.m_status == 0) {
            for (FIXGRIDTreeItem childNode : this.m_childNodes) {
                list.add(childNode);
                childNode.appendVisibleSubNodes(list, ++counter, maxCounter);
            }
        }
    }

    public void processTREENDOEAction(ActionEvent event) {
        BaseActionEvent bae = (BaseActionEvent)event;
        if (bae.getCommand().equals("toggle")) {
            BaseActionEventToggle baet = (BaseActionEventToggle)event;
            if ("left".equals(baet.getKeyCommand())) {
                if (this.getStatusInt() == 0) {
                    this.toggleNodeAndScroll(event);
                } else if (this.getLevelInt() > 0) {
                    try {
                        UIComponent treenodeComponent = event.getComponent();
                        UIComponent gridcolComponent = treenodeComponent.getParent();
                        FIXGRIDComponent fixgridComponent = (FIXGRIDComponent)gridcolComponent.getParent();
                        FIXGRIDTreeBinding treeBinding = (FIXGRIDTreeBinding)fixgridComponent.readBindingObject(HttpSessionAccess.getCurrentFacesContext());
                        treeBinding.deselectCurrentSelection();
                        treeBinding.selectItem(this.getParentNode());
                        treeBinding.ensureItemToBeDisplayed(this.getParentNode());
                        this.getParentNode().requestFocus();
                    }
                    catch (Throwable t) {
                        CLog.L.log(CLog.LL_WAR, "Problem in tree processing", t);
                    }
                }
            } else if ("right".equals(baet.getKeyCommand())) {
                if (this.getStatusInt() == 1) {
                    this.toggleNodeAndScroll(event);
                } else {
                    try {
                        FIXGRIDTreeItem firstChildNode = this.getChildNodes().get(0);
                        FIXGRIDTreeBinding treeBinding = this.findOwningTreeList(event);
                        treeBinding.deselectCurrentSelection();
                        treeBinding.selectItem(firstChildNode);
                        treeBinding.ensureItemToBeDisplayed(firstChildNode);
                        firstChildNode.requestFocus();
                    }
                    catch (Throwable throwable) {}
                }
            } else {
                this.toggleNodeAndScroll(event);
            }
        }
    }

    private FIXGRIDTreeBinding findOwningTreeList(ActionEvent event) {
        try {
            UIComponent currentComponent;
            for (currentComponent = event.getComponent(); !(currentComponent instanceof FIXGRIDComponent) && currentComponent != null; currentComponent = currentComponent.getParent()) {
            }
            if (currentComponent == null) {
                return null;
            }
            FIXGRIDComponent fixgridComponent = (FIXGRIDComponent)currentComponent;
            FIXGRIDTreeBinding treeBinding = (FIXGRIDTreeBinding)fixgridComponent.readBindingObject(HttpSessionAccess.getCurrentFacesContext());
            return treeBinding;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem when finding owning tree list", t);
            return null;
        }
    }

    public void removeAllChildNodes() {
        this.removeAllChildNodes(true);
    }

    public void removeAllChildNodes(boolean withDrillDown) {
        Iterator<FIXGRIDTreeItem> iter = this.m_childNodes.iterator();
        if (withDrillDown) {
            while (iter.hasNext()) {
                FIXGRIDTreeItem childNode = iter.next();
                childNode.m_parentNode = null;
                childNode.removeAllChildNodes(withDrillDown);
            }
        }
        this.m_childNodes.clear();
        this.getChangeIndex().indicateChange();
    }

    public void removeNode() {
        if (this.getParentNode() == null) {
            return;
        }
        this.getParentNode().m_childNodes.remove(this);
        this.m_parentNode = null;
    }

    public void addSubNode(FIXGRIDTreeItem subNode, boolean asFirst) {
        if (asFirst) {
            this.m_childNodes.add(0, subNode);
        } else {
            this.m_childNodes.add(subNode);
        }
        subNode.m_parentNode = this;
        subNode.recalculateLevel();
        this.getChangeIndex().indicateChange();
    }

    public void addSubNode(FIXGRIDTreeItem subNode, int index) {
        this.m_childNodes.add(index, subNode);
        subNode.m_parentNode = this;
        subNode.recalculateLevel();
        this.getChangeIndex().indicateChange();
    }

    public void closeAllNodes() {
        if (this.m_status != 2) {
            this.m_status = 1;
        }
        for (int i = 0; i < this.m_childNodes.size(); ++i) {
            this.m_childNodes.get(i).closeAllNodes();
        }
        this.getChangeIndex().indicateChange();
    }

    public void openAllParentNodes() {
        FIXGRIDTreeItem parentNode;
        FIXGRIDTreeItem currentNode = this;
        while ((parentNode = currentNode.getParentNode()) != null) {
            parentNode.setStatus(0);
            currentNode = parentNode;
        }
        this.getChangeIndex().indicateChange();
    }

    public void moveSubNodeToFirst(FIXGRIDTreeItem subNode) {
        int index = this.m_childNodes.indexOf(subNode);
        if (index <= 0) {
            return;
        }
        this.m_childNodes.remove(index);
        this.m_childNodes.add(0, subNode);
    }

    public void moveSubNodeToLast(FIXGRIDTreeItem subNode) {
        int index = this.m_childNodes.indexOf(subNode);
        if (index < 0) {
            return;
        }
        this.m_childNodes.remove(index);
        this.m_childNodes.add(subNode);
    }

    public void moveSubNodeOneUp(FIXGRIDTreeItem subNode) {
        int index = this.m_childNodes.indexOf(subNode);
        if (index <= 0) {
            return;
        }
        this.m_childNodes.remove(index);
        this.m_childNodes.add(index - 1, subNode);
    }

    public void moveSubNodesOneUp(Set<FIXGRIDTreeItem> subNodes) {
        for (int i = 0; i < this.m_childNodes.size(); ++i) {
            FIXGRIDTreeItem childNode = this.m_childNodes.get(i);
            if (!subNodes.contains(childNode)) continue;
            if (i == 0) {
                return;
            }
            this.m_childNodes.remove(i);
            this.m_childNodes.add(i - 1, childNode);
        }
    }

    public void moveSubNodeOneDown(FIXGRIDTreeItem subNode) {
        int index = this.m_childNodes.indexOf(subNode);
        if (index >= this.m_childNodes.size()) {
            return;
        }
        this.m_childNodes.remove(index);
        this.m_childNodes.add(index + 1, subNode);
    }

    public void moveSubNodesOneDown(Set<FIXGRIDTreeItem> subNodes) {
        for (int i = this.m_childNodes.size() - 1; i >= 0; --i) {
            FIXGRIDTreeItem childNode = this.m_childNodes.get(i);
            if (!subNodes.contains(childNode)) continue;
            if (i == this.m_childNodes.size() - 1) {
                return;
            }
            this.m_childNodes.remove(i);
            this.m_childNodes.add(i + 1, childNode);
        }
    }

    public void moveSubNodeInFront(FIXGRIDTreeItem subNode, FIXGRIDTreeItem refSubNode) {
        int index1 = this.m_childNodes.indexOf(subNode);
        int index2 = this.m_childNodes.indexOf(refSubNode);
        if (index1 < 0 || index2 < 0) {
            return;
        }
        this.m_childNodes.remove(index1);
        index2 = this.m_childNodes.indexOf(refSubNode);
        this.m_childNodes.add(index2, subNode);
    }

    public void moveSubNodeBehind(FIXGRIDTreeItem subNode, FIXGRIDTreeItem refSubNode) {
        int index1 = this.m_childNodes.indexOf(subNode);
        int index2 = this.m_childNodes.indexOf(refSubNode);
        if (index1 < 0 || index2 < 0) {
            return;
        }
        this.m_childNodes.remove(index1);
        index2 = this.m_childNodes.indexOf(refSubNode);
        this.m_childNodes.add(index2 + 1, subNode);
    }

    public boolean checkIfNodeHasAsParent(FIXGRIDTreeItem potentialParent) {
        FIXGRIDTreeItem currentNode = this;
        while (currentNode != potentialParent) {
            if (currentNode.getParentNode() == null) {
                return false;
            }
            currentNode = currentNode.getParentNode();
        }
        return true;
    }

    public void expandNodeAndSubNodes() {
        if (this.m_status == 2) {
            return;
        }
        if (this.m_status == 1) {
            this.toggleNode();
        }
        List<FIXGRIDTreeItem> childNodes = this.getChildNodes();
        for (FIXGRIDTreeItem childNode : childNodes) {
            childNode.expandNodeAndSubNodes();
        }
    }

    public void expandNode() {
        if (this.m_status == 1) {
            this.toggleNode();
        }
    }

    public void collapseNode() {
        if (this.m_status == 0) {
            this.toggleNode();
        }
    }

    public void collapseNodeAndSubNodes() {
        if (this.m_status == 2) {
            return;
        }
        if (this.m_status == 0) {
            this.toggleNode();
        }
        List<FIXGRIDTreeItem> childNodes = this.getChildNodes();
        for (FIXGRIDTreeItem childNode : childNodes) {
            childNode.collapseNodeAndSubNodes();
        }
    }

    public void onToggle() {
    }

    public int compareTo(Object o) {
        if (o instanceof FIXGRIDTreeItem) {
            String myText = this.getText();
            String oText = ((FIXGRIDTreeItem)o).getText();
            if (myText == null) {
                myText = "";
            }
            if (oText == null) {
                oText = "";
            }
            return myText.compareTo(oText);
        }
        return 0;
    }

    public String getLineDrawing() {
        String result = "";
        FIXGRIDTreeItem currentNode = this.getParentNode();
        while (currentNode.m_level >= 0) {
            result = currentNode.checkIfSameLevelElementIsFollowing() ? "X" + result : " " + result;
            currentNode = currentNode.getParentNode();
        }
        return result;
    }

    private boolean checkIfSameLevelElementIsFollowing() {
        FIXGRIDTreeItem parent = this.getParentNode();
        if (parent == null) {
            return false;
        }
        int indexInParent = parent.getChildNodes().indexOf(this);
        return indexInParent != parent.getChildNodes().size() - 1;
    }

    protected void toggleNodeAndScroll(ActionEvent event) {
        if (FIXGRIDTreeBinding.s_supportAutoScrollOnToggle) {
            FIXGRIDTreeBinding tree = null;
            int sbValue = -1;
            if (this.m_status == 1) {
                try {
                    tree = this.findOwningTreeList(event);
                    sbValue = tree.getSbvalue();
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_INF, "", t);
                }
            }
            this.toggleNode();
            if (this.m_status == 0 && tree != null && tree.getSbvalue() == sbValue) {
                final FIXGRIDTreeBinding finalTree = tree;
                final int finalSbValue = sbValue;
                PhaseManager.runBeforeRenderResponsePhase(new Runnable(){

                    @Override
                    public void run() {
                        FIXGRIDTreeItem.this.updateTreePositionAfterToggleToOpen(finalTree, finalSbValue);
                    }
                });
            }
        } else {
            this.toggleNode();
        }
    }

    private void updateTreePositionAfterToggleToOpen(FIXGRIDTreeBinding tree, int sbValue) {
        try {
            if (tree.getSbvalue() != sbValue) {
                return;
            }
            int numberOfChildren = this.getChildNodes().size();
            int thisIndex = tree.getVisibleItems().indexOf(this);
            int toScroll = thisIndex + numberOfChildren + 1 - tree.getSbvalue() - tree.getClientvisibleamount();
            if (toScroll > 0) {
                if (thisIndex - tree.getSbvalue() < toScroll) {
                    toScroll = thisIndex - tree.getSbvalue();
                }
                int newSbvalue = sbValue + toScroll;
                tree.setSbvalue(newSbvalue);
            }
            if (this.getSelected() && tree.getSelectedItems().size() == 1) {
                this.requestFocus();
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "", t);
        }
    }

    public void toggleNode() {
        if (this.m_status == 1) {
            this.m_status = 0;
        } else if (this.m_status == 0) {
            this.m_status = 1;
        }
        this.getChangeIndex().indicateChange();
        this.onToggle();
    }

    private void recalculateLevel() {
        this.m_level = this.m_parentNode == null ? 0 : this.m_parentNode.m_level + 1;
        for (int i = 0; i < this.m_childNodes.size(); ++i) {
            this.m_childNodes.get(i).recalculateLevel();
        }
    }
}

