/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.polling;

import java.io.Serializable;
import javax.faces.event.ActionEvent;
import org.eclnt.editor.annotations.CCGenClass;
import org.eclnt.jsfserver.elements.polling.ENUMPollingType;
import org.eclnt.jsfserver.elements.util.Trigger;
import org.eclnt.jsfserver.pagebean.componentascontrol.PageBeanComponentAsControlWithAction;
import org.eclnt.jsfserver.pagebean.componentascontrol.attributeReference;
import org.eclnt.jsfserver.pagebean.componentascontrol.valuemgmt.AttributeReferenceBoolean;
import org.eclnt.jsfserver.pagebean.componentascontrol.valuemgmt.AttributeReferenceInteger;
import org.eclnt.jsfserver.pagebean.componentascontrol.valuemgmt.AttributeReferenceString;
import org.eclnt.jsfserver.pagebean.componentascontrol.valuemgmt.AttributeReferenceTrigger;
import org.eclnt.jsfserver.polling.DefaultLongPolling;
import org.eclnt.jsfserver.polling.LongPollingMgr;
import org.eclnt.jsfserver.polling.websocket.DefaultLongPollingWebSocket;
import org.eclnt.jsfserver.util.SystemXml;

@CCGenClass(expressionBase="#{d.UNIFIEDPOLLINGBinding}")
public class UNIFIEDPOLLINGBinding
extends PageBeanComponentAsControlWithAction
implements Serializable {
    private static ENUMPollingType s_pollingType = ENUMPollingType.WEBSOCKET;
    @attributeReference
    AttributeReferenceBoolean m_statusbarneutralRef = new AttributeReferenceBoolean(false);
    @attributeReference
    AttributeReferenceBoolean m_avoidvalidationsRef = new AttributeReferenceBoolean(false);
    @attributeReference
    AttributeReferenceInteger m_durationRef = new AttributeReferenceInteger();
    @attributeReference
    AttributeReferenceTrigger m_restarttriggerRef = new AttributeReferenceTrigger();
    @attributeReference
    AttributeReferenceString m_pollingtypeRef = new AttributeReferenceString();
    private MyLongPolling m_longPolling;
    private MyLongPollingWebSocket m_longPollingWebSocket;
    private boolean m_requiresInitialization = true;
    ENUMPollingType m_lastCurrentPollingType = null;

    public static void initialize() {
        String pollingType = SystemXml.getUnifiedPollingPollingType();
        if ("URL".equals(pollingType)) {
            s_pollingType = ENUMPollingType.URL;
        }
    }

    public static void initializePollingType(ENUMPollingType pollingType) {
        s_pollingType = pollingType;
    }

    @Override
    public String getRootExpressionUsedInPage() {
        return "#{d.UNIFIEDPOLLINGBinding}";
    }

    @Override
    public void onBeforeRendering() {
        this.findCurrentPollingType();
    }

    public boolean getAvailableLongPollingURL() {
        return this.m_longPolling != null;
    }

    public boolean getAvailableLongPollingWebSocket() {
        return this.m_longPollingWebSocket != null;
    }

    public Boolean getStatusbarneutral() {
        return (Boolean)this.m_statusbarneutralRef.getValue();
    }

    public Integer getDuration() {
        return (Integer)this.m_durationRef.getValue();
    }

    public Trigger getRestarttrigger() {
        return (Trigger)this.m_restarttriggerRef.getValue();
    }

    public Boolean getAvoidvalidations() {
        return (Boolean)this.m_avoidvalidationsRef.getValue();
    }

    public String getLongPollingURL() {
        switch (this.findCurrentPollingType()) {
            case WEBSOCKET: {
                return this.m_longPollingWebSocket.getURL();
            }
            case URL: {
                return this.m_longPolling.getURL();
            }
        }
        return null;
    }

    public void wakeup(boolean continuePolling) {
        switch (this.findCurrentPollingType()) {
            case WEBSOCKET: {
                this.m_longPollingWebSocket.wakeup(continuePolling);
                break;
            }
            case URL: {
                this.m_longPolling.wakeup(continuePolling);
            }
        }
    }

    public void close() {
        try {
            if (this.m_longPollingWebSocket != null) {
                LongPollingMgr.remove(this.m_longPollingWebSocket);
                this.m_longPollingWebSocket.abortThreadWithoutContinuingPolling();
                this.m_longPollingWebSocket = null;
            }
            if (this.m_longPolling != null) {
                LongPollingMgr.remove(this.m_longPolling);
                this.m_longPolling.abortThreadWithoutContinuingPolling();
                this.m_longPolling = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onAction(ActionEvent event) {
        this.delegateActionEvent("invoke()");
    }

    protected ENUMPollingType findCurrentPollingType() {
        ENUMPollingType result = null;
        try {
            String pollingtypeRefValue = (String)this.m_pollingtypeRef.getValue();
            if (pollingtypeRefValue != null) {
                result = ENUMPollingType.valueOf(pollingtypeRefValue);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (result == null) {
            result = s_pollingType;
        }
        this.initializePolling(result);
        return result;
    }

    protected void initializePolling(ENUMPollingType pollingType) {
        if (this.m_lastCurrentPollingType != pollingType) {
            this.m_requiresInitialization = true;
            this.m_lastCurrentPollingType = pollingType;
        }
        if (!this.m_requiresInitialization) {
            return;
        }
        this.close();
        switch (pollingType) {
            case WEBSOCKET: {
                this.m_longPollingWebSocket = new MyLongPollingWebSocket();
                LongPollingMgr.add(this.m_longPollingWebSocket);
                break;
            }
            case URL: {
                this.m_longPolling = new MyLongPolling();
                LongPollingMgr.add(this.m_longPolling);
                break;
            }
            default: {
                throw new Error("Unknown polling type: " + (Object)((Object)this.findCurrentPollingType()));
            }
        }
        this.m_requiresInitialization = false;
    }

    public class MyLongPollingWebSocket
    extends DefaultLongPollingWebSocket {
    }

    public class MyLongPolling
    extends DefaultLongPolling {
    }
}

