/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.util;

import java.util.ArrayList;
import java.util.List;
import org.eclnt.jsfserver.elements.impl.FIXGRIDBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDExportSanitizer;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDCsvExporter;
import org.eclnt.jsfserver.elements.util.ENUMExportType;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class FIXGRIDCsvExporter
implements IFIXGRIDCsvExporter {
    FIXGRIDBinding m_fixgid;
    boolean m_selectedItemsOnly = false;
    String m_delimiter = this.findDelimiter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String exportGrid(FIXGRIDBinding fixgrid, boolean selectedItemsOnly) {
        try {
            this.m_fixgid = fixgrid;
            this.m_selectedItemsOnly = selectedItemsOnly;
            FIXGRIDBinding.Exporter fgExporter = fixgrid.getExporter();
            StringBuffer result = new StringBuffer();
            this.exportHeaderlines(result);
            this.exportBody(result);
            this.epxortFooterLines(result);
            String string = result.toString();
            return string;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Error happened during CSV export", t);
            String string = null;
            return string;
        }
    }

    public static void appendToStringBufferCSV(StringBuffer sb, List<List<String>> rows, boolean withPlaceHolderConversion, String delimiter) {
        for (List<String> row : rows) {
            ArrayList<String> csvValues = new ArrayList<String>();
            for (String value : row) {
                if (withPlaceHolderConversion && ".%.".equals(value)) {
                    value = "";
                }
                csvValues.add(value);
            }
            sb.append(ValueManager.encodeCSVWithQuotes(csvValues, delimiter));
            sb.append("\r\n");
        }
    }

    protected String findDelimiter() {
        String result = SystemXml.getFixgridCsvExportDelimiter();
        if (!ValueManager.isEmpty(result)) {
            return result;
        }
        return ";";
    }

    protected void epxortFooterLines(StringBuffer result) {
        CLog.L.log(CLog.LL_INF, "exporting footer");
        List<List<String>> footers = this.readFooterLinesFromGrid();
        this.sanitizeCSVLine(footers);
        if (footers.size() > 0) {
            result.append("\r\n");
        }
        this.appendToStringBuffer(result, footers, false);
    }

    protected void exportBody(StringBuffer result) {
        CLog.L.log(CLog.LL_INF, "exporting body");
        List<List<String>> values = this.readBodyLinesFromGrid();
        this.sanitizeCSVLine(values);
        this.appendToStringBuffer(result, values, false);
    }

    protected void exportHeaderlines(StringBuffer result) {
        CLog.L.log(CLog.LL_INF, "exporting headlines");
        List<List<String>> headers = this.readHeaderLinesFromGrid();
        this.sanitizeCSVLine(headers);
        this.appendToStringBuffer(result, headers, true);
        result.append("\r\n");
    }

    protected void sanitizeCSVLine(List<List<String>> data) {
        FIXGRIDExportSanitizer.instance().sanitizeStringDataBeforeExport(ENUMExportType.CSV, data);
    }

    protected List<List<String>> readHeaderLinesFromGrid() {
        List<List<String>> headers = this.m_fixgid.getExporter().exportToStringListHeader();
        return headers;
    }

    protected List<List<String>> readBodyLinesFromGrid() {
        List<List<String>> values = this.m_fixgid.getExporter().exportToStringListWholeGrid(this.m_selectedItemsOnly);
        return values;
    }

    protected List<List<String>> readFooterLinesFromGrid() {
        List<List<String>> footers = this.m_fixgid.getExporter().exportToStringListFooter();
        return footers;
    }

    protected void appendToStringBuffer(StringBuffer sb, List<List<String>> rows, boolean withPlaceHolderConversion) {
        FIXGRIDCsvExporter.appendToStringBufferCSV(sb, rows, withPlaceHolderConversion, this.m_delimiter);
    }
}

