/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.util;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclnt.jsfserver.elements.impl.FIXGRIDBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDComponent;
import org.eclnt.jsfserver.elements.impl.FIXGRIDExportSanitizer;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDExcelExporter;
import org.eclnt.jsfserver.elements.util.DefaultFIXGRIDExportInfoProvider;
import org.eclnt.jsfserver.elements.util.ENUMExportType;
import org.eclnt.jsfserver.elements.util.FIXGRIDExcelExporter_POI5;
import org.eclnt.jsfserver.elements.util.IFIXGRIDExportInfoProvider;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class FIXGRIDExcelExporter
implements Serializable,
IFIXGRIDExcelExporter {
    String m_gridTitle = "Automatically generated Excel Sheet";
    IFIXGRIDExportInfoProvider m_exportInfoProvider = new DefaultFIXGRIDExportInfoProvider();
    float m_columnSizeFactor = 1.0f;
    int m_maxNumberOfGridRows = -1;
    int m_excelRowCounter = 0;
    List<FIXGRIDComponent.ColumnInfo> m_columns = null;

    @Override
    public void setGridTitle(String title) {
        this.m_gridTitle = title;
    }

    public String getGridTitle() {
        return this.m_gridTitle;
    }

    @Override
    public float getColumnSizeFactor() {
        return this.m_columnSizeFactor;
    }

    @Override
    public void setColumnSizeFactor(float columnSizeFactor) {
        this.m_columnSizeFactor = columnSizeFactor;
    }

    @Override
    public int getMaxNumberOfGridRows() {
        return this.m_maxNumberOfGridRows;
    }

    @Override
    public void setMaxNumberOfGridRows(int maxNumberOfGridRows) {
        this.m_maxNumberOfGridRows = maxNumberOfGridRows;
    }

    @Override
    public void setExportInfoProvider(IFIXGRIDExportInfoProvider exportInfoProvider) {
        this.m_exportInfoProvider = exportInfoProvider;
    }

    @Override
    public byte[] exportGrid(FIXGRIDBinding fixgrid, List<FIXGRIDComponent.ColumnInfo> columns, List<List<FIXGRIDBinding.FormattedValue>> data, boolean selctedItemsOnly) {
        FIXGRIDExportSanitizer.instance().sanitizeValueDataBeforeExport(ENUMExportType.XLSX, data);
        this.m_columns = columns;
        HashMap<String, XSSFCellStyle> bufferCellStyles = new HashMap<String, XSSFCellStyle>();
        try {
            XSSFWorkbook wb = this.createXSSFWorkbook();
            XSSFCreationHelper creationHelper = wb.getCreationHelper();
            Sheet sheet = this.createSheet(wb);
            List<CellStyle> columnTitleCellStyles = this.createColumnTitleCellStyles(wb, sheet, columns, data);
            this.m_excelRowCounter = 0;
            CLog.L.log(CLog.LL_INF, "Excel export: processing header rows");
            List<List<FIXGRIDBinding.FormattedValue>> headerRows = fixgrid.getExporter().exportToValueListHeader();
            FIXGRIDExportSanitizer.instance().sanitizeValueDataBeforeExport(ENUMExportType.XLSX, headerRows);
            if (this.m_exportInfoProvider != null) {
                headerRows = this.m_exportInfoProvider.updateHeaderRowValues(headerRows);
            }
            this.createBeforeHeader(wb, sheet, fixgrid);
            this.createHeaderRows(wb, sheet, columnTitleCellStyles, headerRows);
            this.createAfterHeader(wb, sheet, fixgrid);
            CLog.L.log(CLog.LL_INF, "Excel export: processing content rows");
            this.createDataRows(wb, sheet, data, columns, bufferCellStyles);
            CLog.L.log(CLog.LL_INF, "Excel export: processing footer rows");
            this.createBeforeFooter(wb, sheet, fixgrid);
            List<List<FIXGRIDBinding.FormattedValue>> footerRows = fixgrid.getExporter().exportToValueListFooter();
            FIXGRIDExportSanitizer.instance().sanitizeValueDataBeforeExport(ENUMExportType.XLSX, footerRows);
            if (this.m_exportInfoProvider != null) {
                footerRows = this.m_exportInfoProvider.updateFooterRowValues(footerRows);
            }
            this.createFooterRows(wb, sheet, columnTitleCellStyles, footerRows);
            this.createAfterFooter(wb, sheet, fixgrid);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            wb.write((OutputStream)bos);
            bos.close();
            return bos.toByteArray();
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Error happened during XML export", t);
            return null;
        }
    }

    protected List<CellStyle> createColumnTitleCellStyles(XSSFWorkbook wb, Sheet sheet, List<FIXGRIDComponent.ColumnInfo> columns, List<List<FIXGRIDBinding.FormattedValue>> data) {
        ArrayList<CellStyle> columnTitleCellStyles = new ArrayList<CellStyle>();
        XSSFFont headerFont = this.createHeaderFont(wb);
        int colCounter = 0;
        for (FIXGRIDComponent.ColumnInfo column : columns) {
            int pseudoWidth = this.calculateColumnWidth(column);
            sheet.setColumnWidth(colCounter, pseudoWidth * 50);
            XSSFCellStyle cellStyle = wb.createCellStyle();
            this.defineCellFormat((Workbook)wb, (CellStyle)cellStyle, column);
            this.feedCellAlignment((CellStyle)cellStyle, column.getAlignment());
            this.applyTitleStyle((CellStyle)cellStyle, column);
            cellStyle.setFont((Font)headerFont);
            columnTitleCellStyles.add((CellStyle)cellStyle);
            ++colCounter;
        }
        return columnTitleCellStyles;
    }

    protected void createBeforeHeader(XSSFWorkbook wb, Sheet sheet, FIXGRIDBinding fixgrid) {
    }

    protected void createAfterHeader(XSSFWorkbook wb, Sheet sheet, FIXGRIDBinding fixgrid) {
    }

    protected void createBeforeFooter(XSSFWorkbook wb, Sheet sheet, FIXGRIDBinding fixgrid) {
    }

    protected void createAfterFooter(XSSFWorkbook wb, Sheet sheet, FIXGRIDBinding fixgrid) {
    }

    protected void createFooterRows(XSSFWorkbook wb, Sheet sheet, List<CellStyle> columnTitleCellStyles, List<List<FIXGRIDBinding.FormattedValue>> footerRows) {
        for (List<FIXGRIDBinding.FormattedValue> row : footerRows) {
            Row sheetRow = this.createRow(sheet);
            int colCounter = 0;
            for (FIXGRIDBinding.FormattedValue value : row) {
                Cell cell = sheetRow.createCell(colCounter);
                cell.setCellStyle(columnTitleCellStyles.get(colCounter));
                this.feedCell((Workbook)wb, cell, value, this.m_columns.get(colCounter));
                ++colCounter;
            }
        }
    }

    protected Row createRow(Sheet sheet) {
        Row sheetRow = sheet.createRow(this.m_excelRowCounter);
        this.rowFeed();
        return sheetRow;
    }

    protected void createDataRows(XSSFWorkbook wb, Sheet sheet, List<List<FIXGRIDBinding.FormattedValue>> data, List<FIXGRIDComponent.ColumnInfo> columns, Map<String, XSSFCellStyle> bufferCellStyles) {
        int dataRowIndex = -1;
        XSSFCreationHelper creationHelper = wb.getCreationHelper();
        for (List<FIXGRIDBinding.FormattedValue> row : data) {
            if (++dataRowIndex % 100 == 0) {
                CLog.L.log(CLog.LL_INF, "Excel export: processing content rows, " + this.m_excelRowCounter + " rows created");
            }
            Row sheetRow = this.createRow(sheet);
            this.buildRow(bufferCellStyles, columns, wb, (CreationHelper)creationHelper, sheetRow, dataRowIndex, row);
            if (this.m_maxNumberOfGridRows <= 0 || dataRowIndex < this.m_maxNumberOfGridRows) continue;
            CLog.L.log(CLog.LL_INF, "Reached max number of items during Excel export processing.");
            this.createMaxNumberReachedRow(wb, sheet, row.size());
            break;
        }
    }

    protected void createMaxNumberReachedRow(XSSFWorkbook wb, Sheet sheet, int rowSize) {
        for (int j = 0; j < 5; ++j) {
            Row limitRow = this.createRow(sheet);
            for (int i = 0; i < rowSize; ++i) {
                Cell cell = limitRow.createCell(i);
                cell.setCellValue("...");
            }
        }
    }

    protected void rowFeed() {
        ++this.m_excelRowCounter;
    }

    protected void createHeaderRows(XSSFWorkbook wb, Sheet sheet, List<CellStyle> columnTitleCellStyles, List<List<FIXGRIDBinding.FormattedValue>> headerRows) {
        for (List<FIXGRIDBinding.FormattedValue> row : headerRows) {
            this.createHeaderRow(wb, sheet, columnTitleCellStyles, row);
        }
    }

    protected void createHeaderRow(XSSFWorkbook wb, Sheet sheet, List<CellStyle> columnTitleCellStyles, List<FIXGRIDBinding.FormattedValue> row) {
        Row sheetRow = this.createRow(sheet);
        int colCounter = 0;
        ArrayList<Integer> dataColumns = new ArrayList<Integer>();
        for (FIXGRIDBinding.FormattedValue value : row) {
            Cell cell = sheetRow.createCell(colCounter);
            if (!".%.".equals(value.getValue())) {
                this.feedCell((Workbook)wb, cell, value, this.m_columns.get(colCounter));
            }
            XSSFCellStyle cellStyle = wb.createCellStyle();
            this.feedCellAlignment((CellStyle)cellStyle, value.getAlign());
            this.applyTitleStyle((CellStyle)cellStyle, null);
            cellStyle.setFont((Font)this.createHeaderFont(wb));
            cell.setCellStyle((CellStyle)cellStyle);
            if (!".%.".equals(value.getValue())) {
                dataColumns.add(colCounter);
            }
            ++colCounter;
        }
        if (dataColumns.size() < row.size()) {
            for (int i = 0; i < dataColumns.size(); ++i) {
                int diff;
                int index1 = (Integer)dataColumns.get(i);
                int index2 = row.size();
                if (i < dataColumns.size() - 1) {
                    index2 = (Integer)dataColumns.get(i + 1);
                }
                if ((diff = index2 - index1) <= 1) continue;
                sheet.addMergedRegion(new CellRangeAddress(sheetRow.getRowNum(), sheetRow.getRowNum(), index1, index2 - 1));
            }
        }
    }

    protected void applyTitleStyle(CellStyle titleStyle, FIXGRIDComponent.ColumnInfo columnInfo) {
        try {
            FIXGRIDExcelExporter_POI5.applyTitleStyle(titleStyle, columnInfo);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    protected XSSFFont createHeaderFont(XSSFWorkbook wb) {
        XSSFFont result = wb.createFont();
        result.setBold(true);
        return result;
    }

    protected XSSFWorkbook createXSSFWorkbook() {
        XSSFWorkbook wb = new XSSFWorkbook();
        return wb;
    }

    protected Sheet createSheet(XSSFWorkbook wb) {
        XSSFSheet sheet = wb.createSheet();
        return sheet;
    }

    protected void buildRow(Map<String, XSSFCellStyle> bufferCellStyles, List<FIXGRIDComponent.ColumnInfo> columns, XSSFWorkbook wb, CreationHelper creationHelper, Row sheetRow, int dataRowIndex, List<FIXGRIDBinding.FormattedValue> row) {
        int colCounter = 0;
        PseudoFont defaultFont = new PseudoFont();
        for (FIXGRIDBinding.FormattedValue value : row) {
            String align;
            PseudoCellStyle cellStyle = new PseudoCellStyle();
            cellStyle.i_font = defaultFont;
            try {
                String dataFormat = this.convertNumericFormatMaskToExcelFormat(value.getFormat(), value.getFormatmask());
                if (dataFormat != null) {
                    cellStyle.i_dataFormat = dataFormat;
                }
            }
            catch (Throwable dataFormat) {
                // empty catch block
            }
            String rowColorString = this.findBackgroundColorForDataCell(dataRowIndex, value, columns.get(colCounter));
            Color rowColor = ValueManager.decodeColor(rowColorString);
            if (rowColor != null) {
                cellStyle.i_rowColor = rowColor;
            }
            Color textColor = null;
            String textColorString = this.findTextColorForDataCell(dataRowIndex, value, columns.get(colCounter));
            textColor = ValueManager.decodeColor(textColorString);
            String fontStr = this.findFontForDataCell(dataRowIndex, value, columns.get(colCounter));
            if (textColor != null || fontStr != null) {
                PseudoFont f = new PseudoFont();
                if (textColor != null) {
                    f.i_textColor = textColor;
                }
                if (fontStr != null) {
                    String sizeStr;
                    int size;
                    Map<String, String> fontValues = ValueManager.decodeComplexValue(fontStr);
                    String weight = fontValues.get("weight");
                    if ("bold".equals(weight)) {
                        f.i_bold = true;
                    }
                    if ((size = ValueManager.decodeIntWithRounding(sizeStr = fontValues.get("size"), -1)) > 0) {
                        f.i_fontSizeInPoints = (short)size;
                    }
                }
                cellStyle.i_font = f;
            }
            if ("right".equals(align = this.findAlignmentForDataCell(dataRowIndex, value, columns.get(colCounter))) || "right!".equals(align)) {
                cellStyle.i_alignment = HorizontalAlignment.RIGHT;
            } else if ("center".equals(align)) {
                cellStyle.i_alignment = HorizontalAlignment.CENTER;
            }
            Cell cell = sheetRow.createCell(colCounter);
            if (cellStyle != null) {
                XSSFCellStyle xcs = cellStyle.createXSSFCellStyle(bufferCellStyles, wb, creationHelper);
                cell.setCellStyle((CellStyle)xcs);
            }
            this.feedCell((Workbook)wb, cell, value, columns.get(colCounter));
            ++colCounter;
        }
    }

    protected String findAlignmentForDataCell(int rowIndex, Object dataCellValue, FIXGRIDComponent.ColumnInfo column) {
        String value = null;
        if (dataCellValue != null) {
            value = dataCellValue.toString();
        }
        if (this.m_exportInfoProvider != null) {
            try {
                return this.m_exportInfoProvider.findAlignmentForDataCell(rowIndex, value, column);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return column.getAlignment();
    }

    protected String findBackgroundColorForDataCell(int rowIndex, Object dataCellValue, FIXGRIDComponent.ColumnInfo column) {
        String value = null;
        if (dataCellValue != null) {
            value = dataCellValue.toString();
        }
        if (this.m_exportInfoProvider != null) {
            try {
                return this.m_exportInfoProvider.findBackgroundColorForDataCell(rowIndex, value, column);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected String findTextColorForDataCell(int rowIndex, Object dataCellValue, FIXGRIDComponent.ColumnInfo column) {
        String value = null;
        if (dataCellValue != null) {
            value = dataCellValue.toString();
        }
        if (this.m_exportInfoProvider != null) {
            try {
                return this.m_exportInfoProvider.findTextColorForDataCell(rowIndex, value, column);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected String findFontForDataCell(int rowIndex, Object dataCellValue, FIXGRIDComponent.ColumnInfo column) {
        String value = null;
        if (dataCellValue != null) {
            value = dataCellValue.toString();
        }
        if (this.m_exportInfoProvider != null) {
            try {
                return this.m_exportInfoProvider.findFontForDataCell(rowIndex, value, column);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected void feedCellAlignment(CellStyle cellStyle, String alignment) {
        if (alignment != null) {
            try {
                FIXGRIDExcelExporter_POI5.feedCellAlignment(cellStyle, alignment);
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void feedCell(Workbook wb, Cell cell, FIXGRIDBinding.FormattedValue value, FIXGRIDComponent.ColumnInfo columnInfo) {
        CreationHelper creationHelper = wb.getCreationHelper();
        String valueText = ValueManager.convertObject2DisplayString(value.getValue(), value.getFormat(), value.getFormatmask(), value.getTimezone(), true);
        this.passCellValue(cell, value.getValue(), valueText, columnInfo.getExportFormat());
    }

    protected void defineCellFormat(Workbook wb, CellStyle cellStyle, FIXGRIDComponent.ColumnInfo columnInfo) {
        CreationHelper creationHelper = wb.getCreationHelper();
        String formatMask = this.convertNumericFormatMaskToExcelFormat(columnInfo.getExportFormat(), columnInfo.getExportformatmask());
        if (formatMask != null) {
            cellStyle.setDataFormat(creationHelper.createDataFormat().getFormat(formatMask));
        }
    }

    protected String convertNumericFormatMaskToExcelFormat(String format, String formatMask) {
        if (format == null) {
            return null;
        }
        if ("date".equals(format)) {
            return null;
        }
        if ("time".equals(format)) {
            return null;
        }
        if ("datetime".equals(format)) {
            return null;
        }
        if ("password".equals(format)) {
            return null;
        }
        if ("boolean".equals(format)) {
            return null;
        }
        if (formatMask == null) {
            if ("int".equals(format)) {
                return "#,##0";
            }
            if ("long".equals(format)) {
                return "#,##0";
            }
            if ("short".equals(format)) {
                return "#,##0";
            }
            if ("biginteger".equals(format)) {
                return "#,##0";
            }
            return "#,##0.##########";
        }
        if ("dec1".equals(formatMask)) {
            return "#,##0.0";
        }
        if ("dec2".equals(formatMask)) {
            return "#,##0.00";
        }
        if ("dec3".equals(formatMask)) {
            return "#,##0.000";
        }
        if ("dec4".equals(formatMask)) {
            return "#,##0.0000";
        }
        if ("dec5".equals(formatMask)) {
            return "#,##0.00000";
        }
        if ("dec6".equals(formatMask)) {
            return "#,##0.000000";
        }
        if ("dec7".equals(formatMask)) {
            return "#,##0.0000000";
        }
        if ("dec8".equals(formatMask)) {
            return "#,##0.00000000";
        }
        if ("dec9".equals(formatMask)) {
            return "#,##0.000000000";
        }
        if ("dec10".equals(formatMask)) {
            return "#,##0.0000000000";
        }
        if ("decmax1".equals(formatMask)) {
            return "#,##0.0";
        }
        if ("decmax2".equals(formatMask)) {
            return "#,##0.0#";
        }
        if ("decmax3".equals(formatMask)) {
            return "#,##0.0##";
        }
        if ("decmax4".equals(formatMask)) {
            return "#,##0.0###";
        }
        if ("decmax5".equals(formatMask)) {
            return "#,##0.0####";
        }
        if ("decmax6".equals(formatMask)) {
            return "#,##0.0#####";
        }
        if ("decmax7".equals(formatMask)) {
            return "#,##0.0######";
        }
        if ("decmax8".equals(formatMask)) {
            return "#,##0.0#######";
        }
        if ("decmax9".equals(formatMask)) {
            return "#,##0.0########";
        }
        if ("decmax10".equals(formatMask)) {
            return "#,##0.0#########";
        }
        if (formatMask.contains(".0") || formatMask.contains(".#")) {
            int index = formatMask.indexOf(".");
            return "#,##0" + formatMask.substring(index);
        }
        return formatMask;
    }

    protected void passCellValue(Cell cell, Object value, String valueText, String format) {
        if (ValueManager.checkIfFormatIsNumeric(format)) {
            if (value instanceof BigDecimal) {
                cell.setCellValue(((BigDecimal)value).doubleValue());
            } else if (value instanceof Float) {
                cell.setCellValue(((Float)value).doubleValue());
            } else if (value instanceof Double) {
                cell.setCellValue(((Double)value).doubleValue());
            } else if (value instanceof Integer) {
                cell.setCellValue(((Integer)value).doubleValue());
            } else if (value instanceof BigInteger) {
                cell.setCellValue(((BigInteger)value).doubleValue());
            } else if (value instanceof Short) {
                cell.setCellValue(((Short)value).doubleValue());
            } else if (value instanceof Long) {
                cell.setCellValue(((Long)value).doubleValue());
            } else {
                cell.setCellValue(valueText);
            }
        } else if (ValueManager.checkIfFormatIsBoolean(format)) {
            if (value instanceof Boolean) {
                cell.setCellValue(((Boolean)value).booleanValue());
            } else {
                cell.setCellValue(valueText);
            }
        } else {
            cell.setCellValue(valueText);
        }
    }

    protected int calculateColumnWidth(FIXGRIDComponent.ColumnInfo ci) {
        int w = ci.getExportWidth();
        if (w < 0) {
            w = ci.getWidth();
        }
        if (w < 0) {
            w = Math.round(-300.0f * (float)w / 100.0f);
            if (ci.getMinWidth() > 0 && w < ci.getMinWidth()) {
                w = ci.getMinWidth();
            }
        }
        if (this.m_columnSizeFactor != 1.0f) {
            w = Math.round((float)w * this.m_columnSizeFactor);
        }
        if (this.m_exportInfoProvider != null) {
            w = this.m_exportInfoProvider.findColumnWidthForPDFColumn(ci, w);
        }
        return w;
    }

    protected String objectToString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    protected XSSFColor createXSSFColor(Color awtColor) {
        byte[] rgb = new byte[]{(byte)awtColor.getRed(), (byte)awtColor.getGreen(), (byte)awtColor.getBlue()};
        return new XSSFColor(rgb);
    }

    class PseudoCellStyle {
        PseudoFont i_font;
        String i_dataFormat;
        String i_formatMask;
        Color i_rowColor;
        HorizontalAlignment i_alignment;

        PseudoCellStyle() {
        }

        public XSSFCellStyle createXSSFCellStyle(Map<String, XSSFCellStyle> buffer, XSSFWorkbook wb, CreationHelper creationHelper) {
            String key = this.toString();
            XSSFCellStyle result = buffer.get(key);
            if (result == null) {
                result = wb.createCellStyle();
                try {
                    if (this.i_font != null) {
                        XSSFFont xfont = wb.createFont();
                        if (this.i_font.i_bold) {
                            xfont.setBold(true);
                        }
                        if (this.i_font.i_fontSizeInPoints > 0) {
                            xfont.setFontHeightInPoints(this.i_font.i_fontSizeInPoints);
                        }
                        if (this.i_font.i_textColor != null) {
                            xfont.setColor(FIXGRIDExcelExporter.this.createXSSFColor(this.i_font.i_textColor));
                        }
                        result.setFont((Font)xfont);
                    }
                    if (this.i_dataFormat != null) {
                        result.setDataFormat(creationHelper.createDataFormat().getFormat(this.i_dataFormat));
                    }
                    if (this.i_rowColor != null) {
                        result.setFillBackgroundColor(FIXGRIDExcelExporter.this.createXSSFColor(this.i_rowColor));
                        result.setFillForegroundColor(FIXGRIDExcelExporter.this.createXSSFColor(this.i_rowColor));
                        result.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    }
                    if (this.i_alignment != null) {
                        result.setAlignment(this.i_alignment);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                buffer.put(key, result);
            }
            return result;
        }

        public String toString() {
            try {
                StringBuffer result = new StringBuffer();
                result.append(this.i_font.toString());
                if (this.i_dataFormat != null) {
                    result.append(this.i_dataFormat);
                }
                if (this.i_rowColor != null) {
                    result.append(this.i_rowColor.getRGB());
                }
                if (this.i_alignment != null) {
                    result.append(this.i_alignment);
                }
                return result.toString();
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "", t);
                return "Harry";
            }
        }
    }

    class PseudoFont {
        boolean i_bold;
        Color i_textColor;
        short i_fontSizeInPoints;

        PseudoFont() {
        }

        public String toString() {
            return this.i_bold + "/" + this.i_textColor + "/" + this.i_fontSizeInPoints;
        }
    }
}

