/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.messages;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclnt.util.valuemgmt.ValueManager;

@XmlRootElement
public final class CrossDialogMessage {
    @XmlAttribute(name="sendingNodeId")
    String m_sendingNodeId;
    @XmlAttribute(name="sendingHttpSessionId")
    private String m_sendingHttpSessionId;
    @XmlAttribute(name="sendingDialogSessionId")
    private String m_sendingDialogSessionId;
    @XmlAttribute(name="sendingClientId")
    private String m_sendingClientId;
    @XmlAttribute(name="messageType")
    private String m_messageType;
    @XmlAttribute(name="messageContent")
    private String m_messageContent;

    CrossDialogMessage() {
    }

    public CrossDialogMessage(String messageType, String messageContent) {
        this.m_messageType = messageType;
        this.m_messageContent = messageContent;
    }

    public String getMessageType() {
        return this.m_messageType;
    }

    public String getMessageContent() {
        return this.m_messageContent;
    }

    public static boolean checkIfMessageMatches(Object message, String messageType) {
        return message instanceof CrossDialogMessage && ValueManager.checkIfStringsAreEqual(messageType, ((CrossDialogMessage)message).getMessageType());
    }

    public static String getMessageContentOnMatch(Object message, String messageType) {
        if (!CrossDialogMessage.checkIfMessageMatches(message, messageType)) {
            return null;
        }
        return ((CrossDialogMessage)message).getMessageContent();
    }

    public String toString() {
        return this.m_messageType + ":" + this.m_messageContent;
    }

    public String getSendingNodeId() {
        return this.m_sendingNodeId;
    }

    public String getSendingHttpSessionId() {
        return this.m_sendingHttpSessionId;
    }

    public String getSendingDialogSessionId() {
        return this.m_sendingDialogSessionId;
    }

    public String getSendingClientId() {
        return this.m_sendingClientId;
    }

    public void junit_initializeForPublishing(String nodeId, String clientId, String dialogSessionId, String httpSessionId) {
        this.initializeForPublishing(nodeId, clientId, dialogSessionId, httpSessionId);
    }

    void initializeForPublishing(String nodeId, String clientId, String dialogSessionId, String httpSessionId) {
        this.m_sendingNodeId = nodeId;
        this.m_sendingClientId = clientId;
        this.m_sendingDialogSessionId = dialogSessionId;
        this.m_sendingHttpSessionId = httpSessionId;
    }
}

